/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlEvent;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import controlP5.ControllerGroup;
import controlP5.ControllerPlug;
import controlP5.Label;
import controlP5.Toggle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import processing.core.PImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioButton
extends ControlGroup<RadioButton> {
    protected List<Toggle> _myRadioToggles;
    protected int spacingRow = 1;
    protected int spacingColumn = 1;
    protected int itemsPerRow = -1;
    protected boolean isMultipleChoice;
    protected int itemHeight = 9;
    protected int itemWidth = 9;
    protected boolean[] availableImages = new boolean[3];
    protected PImage[] images = new PImage[3];
    protected boolean noneSelectedAllowed = true;
    private Object _myPlug;
    private String _myPlugName;
    protected int alignX = 11;
    protected int alignY = 3;
    protected int _myPaddingX = Label.paddingX;
    protected int _myPaddingY = 0;

    public RadioButton(ControlP5 controlP5, String string) {
        this(controlP5, (ControllerGroup<?>)controlP5.getDefaultTab(), string, 0, 0);
        controlP5.register(controlP5.papplet, string, this);
    }

    public RadioButton(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, int n, int n2) {
        super(controlP5, controllerGroup, string, n, n2, 99, 9);
        this.isBarVisible = false;
        this.isCollapse = false;
        this._myRadioToggles = new ArrayList<Toggle>();
        this.setItemsPerRow(1);
        this._myPlug = this.cp5.papplet;
        this._myPlugName = this.getName();
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{Integer.TYPE})) {
            this._myPlug = null;
        }
    }

    public RadioButton addItem(String string, float f) {
        Toggle toggle = this.cp5.addToggle(string, 0.0f, 0.0f, this.itemWidth, this.itemHeight);
        toggle.getCaptionLabel().align(this.alignX, this.alignY).setPadding(this._myPaddingX, this._myPaddingY);
        toggle.setMode(0);
        toggle.setImages(this.images[0], this.images[1], this.images[2]);
        toggle.setSize(this.images[0]);
        this.addItem(toggle, f);
        return this;
    }

    public RadioButton addItem(Toggle toggle, float f) {
        toggle.setGroup(this);
        toggle.isMoveable = false;
        toggle.setInternalValue(f);
        toggle.isBroadcast = false;
        this._myRadioToggles.add(toggle);
        this.updateLayout();
        this.getColor().copyTo(toggle);
        toggle.addListener(this);
        this.updateValues(false);
        this.cp5.removeProperty(toggle);
        return this;
    }

    public RadioButton removeItem(String string) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            if (!this._myRadioToggles.get(i).getName().equals(string)) continue;
            this._myRadioToggles.get(i).removeListener(this);
            this._myRadioToggles.remove(i);
        }
        this.updateValues(false);
        return this;
    }

    private void updateAlign() {
        for (Toggle toggle : this._myRadioToggles) {
            toggle.getCaptionLabel().align(this.alignX, this.alignY);
        }
    }

    public RadioButton align(int[] nArray) {
        return this.align(nArray[0], nArray[1]);
    }

    public RadioButton align(int n, int n2) {
        this.alignX = n;
        this.alignY = n2;
        this.updateAlign();
        return this;
    }

    public RadioButton alignX(int n) {
        return this.align(n, this.alignY);
    }

    public RadioButton alignY(int n) {
        return this.align(this.alignX, n);
    }

    public int[] getAlign() {
        return new int[]{this.alignX, this.alignY};
    }

    public RadioButton setLabelPadding(int n, int n2) {
        this._myPaddingX = n;
        this._myPaddingY = n2;
        for (Toggle toggle : this._myRadioToggles) {
            toggle.getCaptionLabel().setPadding(n, n2);
        }
        return this;
    }

    public RadioButton setImages(PImage pImage, PImage pImage2, PImage pImage3) {
        this.setImage(pImage, 0);
        this.setImage(pImage2, 1);
        this.setImage(pImage3, 2);
        return this;
    }

    public RadioButton setImage(PImage pImage) {
        return this.setImage(pImage, 0);
    }

    public RadioButton setImage(PImage pImage, int n) {
        if (pImage != null) {
            this.images[n] = pImage;
            this.availableImages[n] = true;
            for (int i = 0; i < this._myRadioToggles.size(); ++i) {
                this._myRadioToggles.get(i).setImage(pImage, n);
            }
        }
        return this;
    }

    public RadioButton setSize(PImage pImage) {
        return this.setSize(pImage.width, pImage.height);
    }

    @Override
    public RadioButton setSize(int n, int n2) {
        this.setItemWidth(n);
        this.setItemHeight(n2);
        return this;
    }

    public RadioButton setItemHeight(int n) {
        this.itemHeight = n;
        for (Toggle toggle : this._myRadioToggles) {
            toggle.setHeight(n);
        }
        this.updateLayout();
        return this;
    }

    public RadioButton setItemWidth(int n) {
        this.itemWidth = n;
        for (Toggle toggle : this._myRadioToggles) {
            toggle.setWidth(n);
        }
        this.updateLayout();
        return this;
    }

    public Toggle getItem(int n) {
        return this._myRadioToggles.get(n);
    }

    public Toggle getItem(String string) {
        for (Toggle toggle : this._myRadioToggles) {
            if (!string.equals(toggle.getName())) continue;
            return toggle;
        }
        return null;
    }

    public List<Toggle> getItems() {
        return this._myRadioToggles;
    }

    public boolean getState(int n) {
        if (n < this._myRadioToggles.size() && n >= 0) {
            return this._myRadioToggles.get(n).getState();
        }
        return false;
    }

    public boolean getState(String string) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle toggle = this._myRadioToggles.get(i);
            if (!string.equals(toggle.getName())) continue;
            return toggle.getState();
        }
        return false;
    }

    public void updateLayout() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this._myRadioToggles.size();
        for (int i = 0; i < n4; ++i) {
            Toggle toggle = this._myRadioToggles.get(i);
            toggle.position.y = n3;
            toggle.position.x = n2;
            n2 += toggle.width + this.spacingColumn;
            if (++n == this.itemsPerRow) {
                n = 0;
                this._myWidth = n2;
                n3 += toggle.height + this.spacingRow;
                n2 = 0;
                continue;
            }
            this._myWidth = n2;
        }
    }

    public RadioButton setItemsPerRow(int n) {
        this.itemsPerRow = n;
        this.updateLayout();
        return this;
    }

    public RadioButton setSpacingColumn(int n) {
        this.spacingColumn = n;
        this.updateLayout();
        return this;
    }

    public RadioButton setSpacingRow(int n) {
        this.spacingRow = n;
        this.updateLayout();
        return this;
    }

    public RadioButton deactivateAll() {
        if (!this.isMultipleChoice && !this.noneSelectedAllowed) {
            return this;
        }
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            this._myRadioToggles.get(i).deactivate();
        }
        this._myValue = -1.0f;
        this.updateValues(true);
        return this;
    }

    public RadioButton activate(int n) {
        int n2 = this._myRadioToggles.size();
        if (n < n2) {
            for (int i = 0; i < n2; ++i) {
                this._myRadioToggles.get(i).deactivate();
            }
            this._myRadioToggles.get(n).activate();
            this._myValue = this._myRadioToggles.get(n).internalValue();
            this.updateValues(true);
        }
        return this;
    }

    public RadioButton deactivate(int n) {
        if (!this.isMultipleChoice && !this.noneSelectedAllowed) {
            return this;
        }
        if (n < this._myRadioToggles.size()) {
            Toggle toggle = this._myRadioToggles.get(n);
            if (toggle.isActive) {
                toggle.deactivate();
                this._myValue = -1.0f;
                this.updateValues(true);
            }
        }
        return this;
    }

    public RadioButton activate(String string) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle toggle = this._myRadioToggles.get(i);
            if (!string.equals(toggle.getName())) continue;
            this.activate(i);
            return this;
        }
        return this;
    }

    public RadioButton deactivate(String string) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle toggle = this._myRadioToggles.get(i);
            if (!string.equals(toggle.getName())) continue;
            toggle.deactivate();
            this._myValue = -1.0f;
            this.updateValues(true);
            return this;
        }
        return this;
    }

    public RadioButton toggle(int n) {
        ControlP5.logger().info("toggle() not yet implemented, working on it.");
        return this;
    }

    @Override
    @ControlP5.Invisible
    public void controlEvent(ControlEvent controlEvent) {
        if (!this.isMultipleChoice) {
            if (!this.noneSelectedAllowed && controlEvent.getController().getValue() < 1.0f && controlEvent.getController() instanceof Toggle) {
                Toggle toggle = (Toggle)controlEvent.getController();
                boolean bl = toggle.isBroadcast();
                toggle.setBroadcast(false);
                toggle.setState(true);
                toggle.setBroadcast(bl);
                return;
            }
            this._myValue = -1.0f;
            int n = this._myRadioToggles.size();
            for (int i = 0; i < n; ++i) {
                Toggle toggle = this._myRadioToggles.get(i);
                if (!toggle.equals(controlEvent.getController())) {
                    toggle.deactivate();
                    continue;
                }
                if (!toggle.isOn) continue;
                this._myValue = toggle.internalValue();
            }
        }
        if (this._myPlug != null) {
            try {
                Method method = this._myPlug.getClass().getMethod(this._myPlugName, Integer.TYPE);
                method.invoke(this._myPlug, (int)this._myValue);
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        this.updateValues(true);
    }

    public RadioButton plugTo(Object object) {
        this._myPlug = object;
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{Integer.TYPE})) {
            this._myPlug = null;
        }
        return this;
    }

    public RadioButton plugTo(Object object, String string) {
        this._myPlug = object;
        this._myPlugName = string;
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{Integer.TYPE})) {
            this._myPlug = null;
        }
        return this;
    }

    protected void updateValues(boolean bl) {
        int n = this._myRadioToggles.size();
        this._myArrayValue = new float[n];
        for (int i = 0; i < n; ++i) {
            Toggle toggle = this._myRadioToggles.get(i);
            this._myArrayValue[i] = toggle.getValue();
        }
        if (bl) {
            ControlEvent controlEvent = new ControlEvent(this);
            this.cp5.getControlBroadcaster().broadcast(controlEvent, 2);
        }
    }

    public RadioButton setNoneSelectedAllowed(boolean bl) {
        this.noneSelectedAllowed = bl;
        return this;
    }

    @Override
    public RadioButton setArrayValue(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            if (this._myArrayValue[i] == fArray[i]) continue;
            if (fArray[i] == 0.0f) {
                this.deactivate(i);
                continue;
            }
            this.activate(i);
        }
        super.setArrayValue(fArray);
        return this;
    }

    public RadioButton setColorLabels(int n) {
        for (Toggle toggle : this._myRadioToggles) {
            toggle.getCaptionLabel().setColor(n);
        }
        return this;
    }

    public RadioButton hideLabels() {
        for (Toggle toggle : this._myRadioToggles) {
            toggle.getCaptionLabel().setVisible(false);
        }
        return this;
    }

    public RadioButton showLabels() {
        for (Toggle toggle : this._myRadioToggles) {
            toggle.getCaptionLabel().setVisible(true);
        }
        return this;
    }

    public RadioButton toUpperCase(boolean bl) {
        for (Toggle toggle : this._myRadioToggles) {
            toggle.getCaptionLabel().toUpperCase(bl);
        }
        return this;
    }

    @Override
    public String getInfo() {
        return "type:\tRadioButton\n" + super.getInfo();
    }

    @Deprecated
    public RadioButton add(String string, float f) {
        return this.addItem(string, f);
    }
}

