/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlKey;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.ControlWindow;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ControlWindowKeyHandler
implements ControlP5Constants {
    private ControlWindow _myMasterControlWindow;
    public boolean isShiftDown = false;
    public boolean isKeyDown = false;
    boolean isAltDown = false;
    public boolean isCommandDown = false;
    protected char key = (char)32;
    protected int keyCode = -1;
    private Map<KeyCode, List<ControlKey>> keymap = new HashMap<KeyCode, List<ControlKey>>();
    private boolean[] keys = new boolean[525];
    private int numOfActiveKeys = 0;

    public ControlWindowKeyHandler(ControlP5 controlP5) {
        this._myMasterControlWindow = controlP5.controlWindow;
    }

    public void update(ControlWindow controlWindow) {
        this._myMasterControlWindow = controlWindow;
    }

    public boolean isAltDown() {
        return this.isAltDown;
    }

    public void clear() {
        this.keys = new boolean[525];
        this.numOfActiveKeys = 0;
    }

    public void keyEvent(KeyEvent keyEvent, ControlWindow controlWindow, boolean bl) {
        if (keyEvent.getID() == 401) {
            if (this.keys[keyEvent.getKeyCode()] && keyEvent.getKeyCode() != 8 && keyEvent.getKeyCode() != 37 && keyEvent.getKeyCode() != 39) {
                return;
            }
            this.keys[keyEvent.getKeyCode()] = true;
            ++this.numOfActiveKeys;
            switch (keyEvent.getKeyCode()) {
                case 16: {
                    if (this._myMasterControlWindow.controlP5.isShortcuts()) {
                        this.isShiftDown = true;
                        break;
                    }
                    this.isShiftDown = false;
                    break;
                }
                case 18: {
                    if (this._myMasterControlWindow.controlP5.isShortcuts()) {
                        this.isAltDown = true;
                        break;
                    }
                    this.isAltDown = false;
                    break;
                }
                case 157: {
                    this.isCommandDown = this._myMasterControlWindow.controlP5.isShortcuts();
                }
            }
            this.key = keyEvent.getKeyChar();
            this.keyCode = keyEvent.getKeyCode();
            this.isKeyDown = true;
        }
        if (keyEvent.getID() == 402) {
            this.keys[keyEvent.getKeyCode()] = false;
            --this.numOfActiveKeys;
            switch (keyEvent.getKeyCode()) {
                case 16: {
                    this.isShiftDown = false;
                    break;
                }
                case 18: {
                    this.isAltDown = false;
                    break;
                }
                case 157: {
                    this.isCommandDown = false;
                }
            }
            this.isKeyDown = false;
        }
        if (keyEvent.getID() == 401 && this._myMasterControlWindow.controlP5.isShortcuts()) {
            int n = 0;
            boolean[] objectArray = this.keys;
            int keyCode = objectArray.length;
            for (int i = 0; i < keyCode; ++i) {
                boolean controlKey = objectArray[i];
                n += controlKey ? 1 : 0;
            }
            char[] cArray = new char[n];
            n = 0;
            for (keyCode = 0; keyCode < this.keys.length; ++keyCode) {
                if (!this.keys[keyCode]) continue;
                cArray[n++] = (char)keyCode;
            }
            KeyCode keyCode2 = new KeyCode(cArray);
            if (this.keymap.containsKey(keyCode2)) {
                for (ControlKey controlKey : this.keymap.get(keyCode2)) {
                    controlKey.keyEvent();
                }
            }
        }
        if (controlWindow != null) {
            controlWindow.keyEvent(keyEvent);
        }
    }

    public void reset() {
        this.isShiftDown = false;
        this.isKeyDown = false;
        this.isAltDown = false;
        this.isCommandDown = false;
    }

    public void mapKeyFor(ControlKey controlKey, char ... cArray) {
        KeyCode keyCode = new KeyCode(cArray);
        if (!this.keymap.containsKey(keyCode)) {
            this.keymap.put(keyCode, new ArrayList());
        }
        this.keymap.get(keyCode).add(controlKey);
    }

    public void removeKeyFor(ControlKey controlKey, char ... cArray) {
        List<ControlKey> list = this.keymap.get(new KeyCode(cArray));
        if (list != null) {
            list.remove(controlKey);
        }
    }

    public void removeKeysFor(char ... cArray) {
        this.keymap.remove(new KeyCode(cArray));
    }

    class KeyCode {
        final char[] chars;

        KeyCode(char ... cArray) {
            this.chars = cArray;
            Arrays.sort(this.chars);
        }

        public int size() {
            return this.chars.length;
        }

        public char[] getChars() {
            return this.chars;
        }

        public char get(int n) {
            if (n >= 0 && n < this.size()) {
                return this.chars[n];
            }
            return '\u0000';
        }

        public boolean equals(Object object) {
            if (!(object instanceof KeyCode)) {
                return false;
            }
            KeyCode keyCode = (KeyCode)object;
            if (keyCode.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == keyCode.get(i)) continue;
                return false;
            }
            return true;
        }

        boolean contains(char c) {
            for (char c2 : this.chars) {
                if (c != c2) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            int n = 0;
            int n2 = 1;
            for (char c : this.chars) {
                n = (int)((double)n + ((double)c + Math.pow(c, n2++)));
            }
            return n;
        }
    }
}

