/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.type;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.NumericUtils;
import org.mtzky.lucene.descriptor.LucenePropertyConfig;
import org.mtzky.lucene.type.LuceneFieldStrategy;
import org.mtzky.lucene.type.LuceneFieldStrategyType;

@LuceneFieldStrategyType(value=Float.class)
public class LuceneFloatStrategy
implements LuceneFieldStrategy {
    private final String name;
    private final Field.Store store;
    private final Field.Index index;
    private final boolean original;
    private final String format;

    public LuceneFloatStrategy(LucenePropertyConfig config) {
        this.name = config.getName();
        this.store = config.getStore();
        this.index = config.getIndex();
        this.format = config.getFormat();
        this.original = this.format.isEmpty();
    }

    @Override
    public Fieldable getField(Object value) {
        if (this.original) {
            boolean index = this.index != Field.Index.NO;
            NumericField f = new NumericField(this.name, this.store, index);
            f.setFloatValue(this.toFloat(value));
            return f;
        }
        DecimalFormat format = new DecimalFormat(this.format);
        return new Field(this.name, format.format(this.toFloat(value)), this.store, this.index);
    }

    @Override
    public <T> T getValue(Fieldable field) {
        String v = field.stringValue();
        if (this.original) {
            return (T)Float.valueOf(v);
        }
        DecimalFormat format = new DecimalFormat(this.format);
        format.setParseBigDecimal(true);
        BigDecimal d = (BigDecimal)format.parse(v, new ParsePosition(0));
        return (T)Float.valueOf(d != null ? d.floatValue() : 0.0f);
    }

    @Override
    public Term getTerm(Object value) {
        if (this.original) {
            return new Term(this.name, NumericUtils.floatToPrefixCoded((float)this.toFloat(value)));
        }
        return new Term(this.name, new DecimalFormat(this.format).format(this.toFloat(value)));
    }

    protected float toFloat(Object value) {
        return value != null ? ((Float)value).floatValue() : 0.0f;
    }
}

