/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.type;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.NumericUtils;
import org.mtzky.lucene.descriptor.LucenePropertyConfig;
import org.mtzky.lucene.type.LuceneFieldStrategy;
import org.mtzky.lucene.type.LuceneFieldStrategyType;

@LuceneFieldStrategyType(value=Date.class)
public class LuceneDateStrategy
implements LuceneFieldStrategy {
    private final String name;
    private final Field.Store store;
    private final Field.Index index;
    private final boolean original;
    private final String format;

    public LuceneDateStrategy(LucenePropertyConfig config) {
        this.name = config.getName();
        this.store = config.getStore();
        this.index = config.getIndex();
        this.format = config.getFormat();
        this.original = this.format.isEmpty();
    }

    @Override
    public Fieldable getField(Object value) {
        if (this.original) {
            boolean index = this.index != Field.Index.NO;
            NumericField field = new NumericField(this.name, this.store, index);
            field.setLongValue(this.toLong(value));
            return field;
        }
        return new Field(this.name, this.toString(value), this.store, this.index);
    }

    @Override
    public <T> T getValue(Fieldable field) {
        String v = field.stringValue();
        if (this.original) {
            return (T)new Date(Long.parseLong(v));
        }
        SimpleDateFormat format = new SimpleDateFormat(this.format);
        return (T)((DateFormat)format).parse(v, new ParsePosition(0));
    }

    @Override
    public Term getTerm(Object value) {
        if (this.original) {
            return new Term(this.name, NumericUtils.longToPrefixCoded((long)this.toLong(value)));
        }
        return new Term(this.name, this.toString(value));
    }

    protected long toLong(Object value) {
        return value != null ? ((Date)value).getTime() : 0L;
    }

    protected String toString(Object value) {
        Date v = value instanceof Date ? (Date)value : new Date(0L);
        return new SimpleDateFormat(this.format).format(v);
    }
}

