/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.type;

import org.apache.lucene.document.Fieldable;
import org.mtzky.lucene.descriptor.LucenePropertyConfig;
import org.mtzky.lucene.type.LuceneFieldStrategyType;
import org.mtzky.lucene.type.LuceneStringStrategy;

@LuceneFieldStrategyType(value=Boolean.class)
public class LuceneBooleanStrategy
extends LuceneStringStrategy {
    private static final String FALSE = "0";
    private static final String TRUE = "1";

    public LuceneBooleanStrategy(LucenePropertyConfig config) {
        super(config);
    }

    @Override
    public Fieldable getField(Object value) {
        Fieldable f = super.getField(value);
        f.setOmitNorms(true);
        return f;
    }

    @Override
    public <T> T getValue(Fieldable field) {
        return (T)Boolean.valueOf(TRUE.equals(field.stringValue()));
    }

    @Override
    protected String toString(Object value) {
        return value != null && (Boolean)value != false ? TRUE : FALSE;
    }
}

