/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import org.apache.lucene.document.Fieldable;
import org.mtzky.lucene.descriptor.LucenePropertyConfig;
import org.mtzky.lucene.type.LuceneFieldStrategyType;
import org.mtzky.lucene.type.LuceneStringStrategy;

@LuceneFieldStrategyType(value=BigInteger.class)
public class LuceneBigIntegerStrategy
extends LuceneStringStrategy {
    private final boolean original;
    private final String format;

    public LuceneBigIntegerStrategy(LucenePropertyConfig config) {
        super(config);
        this.format = config.getFormat();
        this.original = this.format.isEmpty();
    }

    @Override
    public <T> T getValue(Fieldable field) {
        String v = field.stringValue();
        if (this.original) {
            return (T)new BigDecimal(v).toBigInteger();
        }
        DecimalFormat format = new DecimalFormat(this.format);
        format.setParseBigDecimal(true);
        BigDecimal d = (BigDecimal)format.parse(v, new ParsePosition(0));
        return (T)d.toBigInteger();
    }

    @Override
    protected String toString(Object value) {
        BigInteger v;
        BigInteger bigInteger = v = value != null ? (BigInteger)value : BigInteger.ZERO;
        if (this.original) {
            return v.toString();
        }
        return new DecimalFormat(this.format).format(v);
    }
}

