/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.type;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import org.apache.lucene.document.Fieldable;
import org.mtzky.lucene.descriptor.LucenePropertyConfig;
import org.mtzky.lucene.descriptor.LucenePropertyDesc;
import org.mtzky.lucene.type.LuceneFieldStrategyType;
import org.mtzky.lucene.type.LuceneStringStrategy;

@LuceneFieldStrategyType(value=BigDecimal.class)
public class LuceneBigDecimalStrategy
extends LuceneStringStrategy {
    private final boolean original;
    private final String format;

    public LuceneBigDecimalStrategy(LucenePropertyDesc<?> config) {
        super(config);
        this.format = config.getFormat();
        this.original = this.format.isEmpty();
    }

    public LuceneBigDecimalStrategy(LucenePropertyConfig config) {
        super(config);
        this.format = config.getFormat();
        this.original = this.format.isEmpty();
    }

    @Override
    public <T> T getValue(Fieldable field) {
        if (this.original) {
            return (T)new BigDecimal(field.stringValue());
        }
        DecimalFormat format = new DecimalFormat(this.format);
        format.setParseBigDecimal(true);
        return (T)format.parse(field.stringValue(), new ParsePosition(0));
    }

    @Override
    protected String toString(Object value) {
        BigDecimal v = value instanceof Number ? new BigDecimal(value.toString()) : BigDecimal.ZERO;
        if (this.original) {
            return v.toString();
        }
        return new DecimalFormat(this.format).format(v);
    }
}

