/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.tokenizer;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.mtzky.io.IOUtils;

public class UnicodeBlockTokenizer
extends Tokenizer {
    private final CharTermAttribute termAtt;
    private final OffsetAttribute offsetAtt;
    private final TypeAttribute typeAttribute;
    private final PushbackReader in;
    private int pos = 0;

    public UnicodeBlockTokenizer(Reader in) {
        this(IOUtils.toPushbackReader((Reader)in));
    }

    public UnicodeBlockTokenizer(PushbackReader in) {
        super((Reader)in);
        this.in = in;
        this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.typeAttribute = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        char[] token = this.readToken();
        if (token == null || token.length < 1) {
            return false;
        }
        int nextPos = this.pos + token.length;
        this.termAtt.copyBuffer(token, 0, token.length);
        this.offsetAtt.setOffset(this.correctOffset(this.pos), this.correctOffset(nextPos));
        this.pos = nextPos;
        return true;
    }

    protected char[] readToken() throws IOException {
        int cp = this.read();
        if (cp < 0) {
            return null;
        }
        this.typeAttribute.setType(Character.UnicodeBlock.of(cp).toString());
        return Character.toChars(cp);
    }

    protected final int read() throws IOException {
        int c = this.in.read();
        if (c < 0) {
            return c;
        }
        if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.HIGH_SURROGATES) {
            int low = this.in.read();
            if (low < 0) {
                return c;
            }
            if (Character.UnicodeBlock.of(low) == Character.UnicodeBlock.LOW_SURROGATES) {
                return Character.toCodePoint((char)c, (char)low);
            }
            this.in.unread(low);
        }
        return c;
    }

    protected final void unread(int codePoint) throws IOException {
        this.in.unread(Character.toChars(codePoint));
    }

    public void end() {
        int finalOffset = this.correctOffset(this.pos);
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    public void reset(Reader input) throws IOException {
        super.reset(input);
        this.reset();
    }

    public void reset() throws IOException {
        super.reset();
        this.pos = 0;
    }
}

