/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.query;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class MatchNoDocsQuery
extends Query {
    private static final long serialVersionUID = 1663886185814770816L;
    private static final String NAME = MatchNoDocsQuery.class.getSimpleName();

    public Weight createWeight(Searcher searcher) throws IOException {
        return new MatchNoDocsWeight();
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("*: ").append(NAME);
        sb.append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }

    private class MatchNoDocsWeight
    extends Weight {
        private static final long serialVersionUID = 5882359148073188883L;

        private MatchNoDocsWeight() {
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new ComplexExplanation(false, this.getValue(), NAME);
        }

        public Query getQuery() {
            return MatchNoDocsQuery.this;
        }

        public float getValue() {
            return 0.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return null;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 0.0f;
        }

        public String toString() {
            return "weight(" + (Object)((Object)MatchNoDocsQuery.this) + ")";
        }
    }
}

