/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.query;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.ToStringUtils;

public class LongTermQuery
extends TermQuery {
    private static final long serialVersionUID = 8605882884062871880L;
    private final long value;

    public LongTermQuery(String field, long value) {
        super(new Term(field, NumericUtils.longToPrefixCoded((long)value)));
        this.value = value;
    }

    public String toString(String field) {
        Term term = this.getTerm();
        StringBuilder sb = new StringBuilder();
        if (!term.field().equals(field)) {
            sb.append(term.field()).append(':');
        }
        sb.append("<longToPrefixCoded ").append(this.value).append('>');
        sb.append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }
}

