/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.query;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.ToStringUtils;

public class FloatTermQuery
extends TermQuery {
    private static final long serialVersionUID = 6108618005976613866L;
    private final float value;

    public FloatTermQuery(String field, float value) {
        super(new Term(field, NumericUtils.floatToPrefixCoded((float)value)));
        this.value = value;
    }

    public String toString(String field) {
        Term term = this.getTerm();
        StringBuilder sb = new StringBuilder();
        if (!term.field().equals(field)) {
            sb.append(term.field()).append(':');
        }
        sb.append("<floatToPrefixCoded ").append(this.value).append('>');
        sb.append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }
}

