/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.query;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.ToStringUtils;

public class DoubleTermQuery
extends TermQuery {
    private static final long serialVersionUID = -6547765424751833742L;
    private final double value;

    public DoubleTermQuery(String field, double value) {
        super(new Term(field, NumericUtils.doubleToPrefixCoded((double)value)));
        this.value = value;
    }

    public String toString(String field) {
        Term term = this.getTerm();
        StringBuilder sb = new StringBuilder();
        if (!term.field().equals(field)) {
            sb.append(term.field()).append(':');
        }
        sb.append("<doubleToPrefixCoded ").append(this.value).append('>');
        sb.append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }
}

