/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.normalizer;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mtzky.io.Closable;
import org.mtzky.io.ClosingGuardian;

public abstract class CharToStringMappingNormalizer
extends Reader
implements Closable {
    private final Object guardian = new ClosingGuardian((Closable)this);
    private boolean close = false;
    private final Lock lock = new ReentrantLock();
    private final Queue<Character> buf = new LinkedList<Character>();
    private final Reader in;

    public CharToStringMappingNormalizer(Reader in) {
        super((Object)in);
        this.in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int limit = off + len;
        int read = 0;
        try {
            this.lock.lock();
            for (int i = off; i < limit; ++i) {
                if (!this.buf.isEmpty()) {
                    cbuf[i] = this.buf.poll().charValue();
                    ++read;
                    continue;
                }
                int r = this.in.read();
                if (r < 0) {
                    break;
                }
                String str = this.convert(r);
                if (str == null) {
                    cbuf[i] = (char)r;
                    ++read;
                    continue;
                }
                for (char c : str.toCharArray()) {
                    this.buf.add(Character.valueOf(c));
                }
                if (this.buf.isEmpty()) {
                    --i;
                    continue;
                }
                cbuf[i] = this.buf.poll().charValue();
                ++read;
            }
        }
        finally {
            this.lock.unlock();
        }
        return read == 0 ? -1 : read;
    }

    protected abstract String convert(int var1);

    public boolean isClosed() {
        return this.close;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.close = true;
    }
}

