/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.filter;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

public abstract class StopTermFilter
extends TokenFilter {
    private final CharTermAttribute termAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posAttr = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

    public StopTermFilter(TokenStream in) {
        super(in);
    }

    public boolean incrementToken() throws IOException {
        int skippedPos = 0;
        while (this.input.incrementToken()) {
            switch (this.contains(this.termAttr.buffer(), this.termAttr.length())) {
                case KEEP: {
                    int newPos = this.posAttr.getPositionIncrement() + skippedPos;
                    this.posAttr.setPositionIncrement(newPos);
                    return true;
                }
                case IGNORE: {
                    skippedPos += this.posAttr.getPositionIncrement();
                }
            }
        }
        return false;
    }

    protected abstract TokenProcess contains(char[] var1, int var2);

    protected static enum TokenProcess {
        IGNORE,
        IGNORE_KEEP_POSITION,
        KEEP;

    }
}

