/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.descriptor;

import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.util.Version;
import org.mtzky.lucene.descriptor.LucenePropertyConfig;
import org.mtzky.lucene.type.LuceneFieldStrategy;
import org.mtzky.lucene.type.LuceneFieldStrategyType;
import org.mtzky.lucene.type.LuceneStringStrategy;
import org.mtzky.reflect.InvocationTargetRuntimeException;
import org.mtzky.reflect.IterableUtils;

public class SimplePropertyConfig
implements LucenePropertyConfig {
    private static final String EMPTY = "";
    private final String name;
    private boolean id = false;
    private Field.Store store;
    private Field.Index index;
    private Field.TermVector termVector;
    private int maxTokenCount = 0;
    private String format;
    private Class<? extends LuceneFieldStrategy> strategy;
    private Class<? extends Analyzer> analyzer;
    private Class<? extends Reader>[] normalizers;
    private Class<? extends TokenFilter>[] filters;
    private static final IterableUtils.Wrap<Class<? extends Reader>, Constructor<? extends Reader>> WRAP_NORMALIZER_CTOR = new IterableUtils.Wrap<Class<? extends Reader>, Constructor<? extends Reader>>(){

        public Constructor<? extends Reader> call(Class<? extends Reader> normalizer) {
            return SimplePropertyConfig.createCtor(normalizer, new Class[]{Reader.class});
        }
    };
    private static final IterableUtils.Wrap<Class<? extends TokenFilter>, Constructor<? extends TokenFilter>> WRAP_FILTER_CTOR = new IterableUtils.Wrap<Class<? extends TokenFilter>, Constructor<? extends TokenFilter>>(){

        public Constructor<? extends TokenFilter> call(Class<? extends TokenFilter> filter) {
            return SimplePropertyConfig.createCtor(filter, new Class[]{TokenStream.class});
        }
    };

    public SimplePropertyConfig(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }

    public <T extends SimplePropertyConfig> T id() {
        return this.id(true);
    }

    public <T extends SimplePropertyConfig> T id(boolean id) {
        this.id = id;
        return (T)this;
    }

    public <T extends SimplePropertyConfig> T store(Field.Store store) {
        this.store = store;
        return (T)this;
    }

    public <T extends SimplePropertyConfig> T index(Field.Index index) {
        this.index = index;
        return (T)this;
    }

    public <T extends SimplePropertyConfig> T termVector(Field.TermVector termVector) {
        this.termVector = termVector;
        return (T)this;
    }

    public <T extends SimplePropertyConfig> T maxTokenCount(int maxTokenCount) {
        this.maxTokenCount = maxTokenCount;
        return (T)this;
    }

    public <T extends SimplePropertyConfig> T format(String format) {
        this.format = format;
        return (T)this;
    }

    public <T extends SimplePropertyConfig> T luceneFieldStrategy(Class<? extends LuceneFieldStrategy> strategy) {
        this.strategy = strategy;
        return (T)this;
    }

    public <T extends SimplePropertyConfig> T analyzer(Class<? extends Analyzer> analyzer) {
        this.analyzer = analyzer;
        return (T)this;
    }

    public <T extends SimplePropertyConfig> T normalizers(Class<? extends Reader> ... normalizers) {
        this.normalizers = normalizers;
        return (T)this;
    }

    public <T extends SimplePropertyConfig> T filters(Class<? extends TokenFilter> ... filters) {
        this.filters = filters;
        return (T)this;
    }

    @Override
    public boolean isId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Field.Store getStore() {
        return this.store != null ? this.store : Field.Store.YES;
    }

    @Override
    public Field.Index getIndex() {
        return this.index != null ? this.index : Field.Index.ANALYZED;
    }

    @Override
    public Field.TermVector getTermVector() {
        return this.termVector != null ? this.termVector : Field.TermVector.NO;
    }

    @Override
    public int getMaxTokenCount() {
        return this.maxTokenCount;
    }

    @Override
    public String getFormat() {
        return this.format != null ? this.format : EMPTY;
    }

    public boolean hasLuceneFieldStrategy() {
        return this.strategy != null && this.strategy.getAnnotation(LuceneFieldStrategyType.class) != null;
    }

    @Override
    public LuceneFieldStrategy getLuceneFieldStrategy() {
        if (this.strategy == null) {
            return new LuceneStringStrategy(this);
        }
        try {
            return SimplePropertyConfig.createCtor(this.strategy, LucenePropertyConfig.class).newInstance(this);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(e.getCause());
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Unsupported LuceneFieldStrategy: " + this.strategy.getName(), e);
        }
    }

    @Override
    public Analyzer getAnalyzer() {
        if (this.analyzer == null) {
            return new KeywordAnalyzer();
        }
        try {
            return SimplePropertyConfig.createCtor(this.analyzer, Version.class).newInstance(Version.LUCENE_31);
        }
        catch (Exception e) {
            try {
                return SimplePropertyConfig.createCtor(this.analyzer, new Class[0]).newInstance(new Object[0]);
            }
            catch (InvocationTargetException e2) {
                throw new InvocationTargetRuntimeException(e2.getCause());
            }
            catch (Exception e3) {
                throw new UnsupportedOperationException("Unsupported Analyzer: " + this.analyzer.getName(), e3);
            }
        }
    }

    @Override
    public Constructor<? extends Reader>[] getNormalizers() {
        if (this.normalizers == null) {
            return new Constructor[0];
        }
        return (Constructor[])IterableUtils.each((Object[])this.normalizers, WRAP_NORMALIZER_CTOR, (Object[])new Constructor[0]);
    }

    @Override
    public Constructor<? extends TokenFilter>[] getFilters() {
        if (this.filters == null) {
            return new Constructor[0];
        }
        return (Constructor[])IterableUtils.each((Object[])this.filters, WRAP_FILTER_CTOR, (Object[])new Constructor[0]);
    }

    private static <T> Constructor<? extends T> createCtor(Class<? extends T> targetClass, Class<?> ... parameterTypes) {
        try {
            return targetClass.getConstructor(parameterTypes);
        }
        catch (Exception e) {
            String fmt = "Failed to get the constructor %s(%s)";
            Object[] args = new Object[]{targetClass.getName(), Arrays.toString(parameterTypes)};
            throw new UnsupportedOperationException(String.format("Failed to get the constructor %s(%s)", args), e);
        }
    }
}

