/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.descriptor;

import java.lang.reflect.Constructor;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.mtzky.lucene.descriptor.AbstractLuceneDocumentDesc;
import org.mtzky.lucene.descriptor.BeanLuceneField;
import org.mtzky.lucene.descriptor.BeanPropertyConfig;
import org.mtzky.lucene.descriptor.BeanPropertyDesc;
import org.mtzky.lucene.descriptor.LucenePropertyDesc;
import org.mtzky.lucene.descriptor.SimplePropertyConfig;
import org.mtzky.lucene.type.LuceneFieldStrategyFactory;
import org.mtzky.reflect.InvocationTargetRuntimeException;
import org.mtzky.reflect.IterableUtils;
import org.mtzky.reflect.PropDesc;
import org.mtzky.reflect.PropsDesc;

public class BeanDocumentDesc<E>
extends AbstractLuceneDocumentDesc<E> {
    protected static final LuceneFieldStrategyFactory DEFAULT_STRATEGY_FACTORY = new LuceneFieldStrategyFactory();
    private final Constructor<E> ctor;
    private final LucenePropertyDesc<E>[] descs;

    public BeanDocumentDesc(Class<E> beanClass) {
        this(beanClass, DEFAULT_STRATEGY_FACTORY);
    }

    public BeanDocumentDesc(Class<E> beanClass, LuceneFieldStrategyFactory strategyFactory) {
        this(beanClass, strategyFactory, (BeanPropertyDesc[])new PropsDesc(beanClass, BeanLuceneField.class).wrap(new PropDescConverter(strategyFactory), (Object[])new BeanPropertyDesc[0]));
    }

    public BeanDocumentDesc(Class<E> beanClass, BeanPropertyConfig ... configs) {
        this(beanClass, DEFAULT_STRATEGY_FACTORY, configs);
    }

    public BeanDocumentDesc(Class<E> beanClass, LuceneFieldStrategyFactory strategyFactory, BeanPropertyConfig ... configs) {
        this(beanClass, strategyFactory, (BeanPropertyDesc[])IterableUtils.each((Object[])configs, new ConfigConverter<E>(beanClass, strategyFactory), (Object[])new BeanPropertyDesc[0]));
    }

    BeanDocumentDesc(Class<E> beanClass, LuceneFieldStrategyFactory strategyFactory, BeanPropertyDesc<E>[] descs) {
        super(descs);
        this.descs = descs;
        try {
            this.ctor = beanClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = "Requires the default constructor: " + beanClass;
            throw new IllegalArgumentException(msg, e);
        }
    }

    private static BeanPropertyConfig bindStrategyIfNeeded(BeanPropertyConfig config, LuceneFieldStrategyFactory factory) {
        if (config.hasLuceneFieldStrategy()) {
            return config;
        }
        Class type = config.getPropDesc().getType();
        return (BeanPropertyConfig)config.luceneFieldStrategy(factory.getLuceneFieldStrategy(type));
    }

    @Override
    public Document createDocument(E bean) {
        Document doc = new Document();
        for (LucenePropertyDesc<E> desc : this.descs) {
            doc.add(desc.getField(bean));
        }
        return doc;
    }

    @Override
    public E createEntity(Document document) {
        E entity;
        try {
            entity = this.ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            String msg = "Failed to create entity: " + this.ctor;
            throw new InvocationTargetRuntimeException(msg, e.getCause());
        }
        for (LucenePropertyDesc<E> desc : this.descs) {
            Fieldable fieldable = document.getFieldable(desc.getName());
            if (fieldable == null) continue;
            desc.setField(entity, fieldable);
        }
        return entity;
    }

    private static class ConfigConverter<E>
    implements IterableUtils.Wrap<BeanPropertyConfig, BeanPropertyDesc<E>> {
        private int i = 0;
        private final Class<E> beanClass;
        private final LuceneFieldStrategyFactory factory;

        public ConfigConverter(Class<E> beanClass, LuceneFieldStrategyFactory factory) {
            this.beanClass = beanClass;
            this.factory = factory;
        }

        public BeanPropertyDesc<E> call(BeanPropertyConfig config) {
            if (config == null) {
                throw new NullPointerException("configs[" + this.i + "]");
            }
            Class propClass = config.getPropDesc().getDeclaringClass();
            if (propClass != this.beanClass) {
                throw new IllegalArgumentException("beanClass: " + this.beanClass + " but configs[" + this.i + "].declaringClass: " + propClass);
            }
            ++this.i;
            return new BeanPropertyDesc(BeanDocumentDesc.bindStrategyIfNeeded(config, this.factory));
        }
    }

    private static class PropDescConverter<E>
    implements PropsDesc.WrapCallback<BeanPropertyDesc<E>> {
        private final LuceneFieldStrategyFactory factory;

        public PropDescConverter(LuceneFieldStrategyFactory factory) {
            this.factory = factory;
        }

        public BeanPropertyDesc<E> call(PropDesc desc) {
            BeanLuceneField a = (BeanLuceneField)desc.getAnnotation(BeanLuceneField.class);
            String nm = a.name().isEmpty() ? desc.getName() : a.name();
            BeanPropertyConfig config = new BeanPropertyConfig(nm, desc);
            ((SimplePropertyConfig)config.id(a.id())).format(a.format());
            config.luceneFieldStrategy(a.luceneFieldStrategy());
            ((SimplePropertyConfig)((SimplePropertyConfig)config.store(a.store())).index(a.index())).termVector(a.termVector());
            config.analyzer(a.analyzer());
            ((SimplePropertyConfig)config.normalizers(a.normalizers())).filters(a.filters());
            return new BeanPropertyDesc(BeanDocumentDesc.bindStrategyIfNeeded(config, this.factory));
        }
    }
}

