/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.descriptor;

import java.io.Reader;
import java.lang.reflect.Constructor;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.mtzky.lucene.descriptor.LucenePropertyConfig;
import org.mtzky.lucene.descriptor.LucenePropertyDesc;
import org.mtzky.lucene.type.LuceneFieldStrategy;

public abstract class AbstractPropertyDesc<E>
implements LucenePropertyDesc<E> {
    private final boolean id;
    private final String name;
    private final Field.Store store;
    private final Field.Index index;
    private final Field.TermVector termVector;
    private final int maxTokenCount;
    private final String format;
    private final LuceneFieldStrategy luceneFieldStrategy;
    private final Analyzer analyzer;
    private final Constructor<? extends Reader>[] normalizers;
    private final Constructor<? extends TokenFilter>[] filters;

    public AbstractPropertyDesc(LucenePropertyConfig config) {
        this.id = config.isId();
        this.name = config.getName();
        this.store = config.getStore();
        this.index = config.getIndex();
        this.termVector = config.getTermVector();
        this.maxTokenCount = config.getMaxTokenCount();
        this.format = config.getFormat();
        this.luceneFieldStrategy = config.getLuceneFieldStrategy();
        this.analyzer = config.getAnalyzer();
        this.normalizers = config.getNormalizers();
        this.filters = config.getFilters();
    }

    @Override
    public Fieldable getFieldByValue(Object value) {
        return this.luceneFieldStrategy.getField(value);
    }

    @Override
    public Object getValue(Fieldable fieldable) {
        return this.luceneFieldStrategy.getValue(fieldable);
    }

    @Override
    public Term getTermByValue(Object value) {
        return this.luceneFieldStrategy.getTerm(value);
    }

    @Override
    public boolean isId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Field.Store getStore() {
        return this.store;
    }

    @Override
    public Field.Index getIndex() {
        return this.index;
    }

    @Override
    public Field.TermVector getTermVector() {
        return this.termVector;
    }

    @Override
    public int getMaxTokenCount() {
        return this.maxTokenCount;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public LuceneFieldStrategy getLuceneFieldStrategy() {
        return this.luceneFieldStrategy;
    }

    @Override
    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public Constructor<? extends Reader>[] getNormalizers() {
        return this.normalizers;
    }

    @Override
    public Constructor<? extends TokenFilter>[] getFilters() {
        return this.filters;
    }
}

