/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.analyzer;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;
import org.mtzky.io.Closable;
import org.mtzky.io.ClosingGuardian;
import org.mtzky.lucene.descriptor.LucenePropertyDesc;
import org.mtzky.reflect.InvocationTargetRuntimeException;

public class AnalyzerWrapper
extends Analyzer
implements Closable {
    private final Object guardian = new ClosingGuardian((Closable)this);
    private boolean closed = false;
    private final Analyzer analyzer;
    private final Constructor<? extends Reader>[] normalizerCtors;
    private final Constructor<? extends TokenFilter>[] filterCtors;

    public AnalyzerWrapper(LucenePropertyDesc<?> desc) {
        this.analyzer = desc.getAnalyzer();
        this.normalizerCtors = desc.getNormalizers();
        this.filterCtors = desc.getFilters();
    }

    public final TokenStream tokenStream(String field, Reader r) {
        return this.filter(this.analyzer.tokenStream(field, this.normalize(r)));
    }

    public final TokenStream reusableTokenStream(String field, Reader r) throws IOException {
        return this.filter(this.analyzer.reusableTokenStream(field, this.normalize(r)));
    }

    private Reader normalize(Reader r) {
        try {
            for (Constructor<? extends Reader> ctor : this.normalizerCtors) {
                r = ctor.newInstance(r);
            }
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(e.getCause());
        }
        catch (Exception e) {
            throw new InvocationTargetRuntimeException((Throwable)e);
        }
        return r;
    }

    private TokenStream filter(TokenStream ts) {
        try {
            for (Constructor<? extends TokenFilter> ctor : this.filterCtors) {
                ts = (TokenStream)ctor.newInstance(ts);
            }
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(e.getCause());
        }
        catch (Exception e) {
            throw new InvocationTargetRuntimeException((Throwable)e);
        }
        return ts;
    }

    public int getPositionIncrementGap(String fieldName) {
        return this.analyzer.getPositionIncrementGap(fieldName);
    }

    public int getOffsetGap(Fieldable field) {
        return this.analyzer.getOffsetGap(field);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.analyzer.close();
        this.closed = true;
    }
}

