/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.mtzky.io.Closable;
import org.mtzky.io.ClosingGuardian;
import org.mtzky.log.GenericMarker;
import org.mtzky.log.ThreadUtils;
import org.mtzky.lucene.FluentIndexSearcherRequest;
import org.mtzky.lucene.LuceneIndexSearcherRequest;
import org.mtzky.lucene.LuceneIndexSearcherResponse;
import org.mtzky.lucene.descriptor.LuceneDocumentDesc;
import org.mtzky.lucene.query.LuceneQueryParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class LuceneIndexSearcher<E>
extends IndexSearcher
implements Closable {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneIndexSearcher.class);
    private final Object guardian = new ClosingGuardian((Closable)this);
    private boolean closed = false;
    private final Lock delayCloseLock = new ReentrantLock();
    private boolean closeWhenDone = false;
    private int usageCount = 0;
    private final long version;
    private final Analyzer analyzer;
    private final LuceneDocumentDesc<E> desc;
    private final String defaultField;

    public LuceneIndexSearcher(Directory d, LuceneDocumentDesc<E> desc) throws CorruptIndexException, IOException {
        super(d, true);
        this.analyzer = desc.getAnalyzer();
        this.desc = desc;
        this.defaultField = desc.getIdName();
        this.version = IndexReader.getCurrentVersion((Directory)d);
    }

    Query parse(String query) throws ParseException {
        return new LuceneQueryParser(this.defaultField, this.analyzer).parse(query);
    }

    public FluentIndexSearcherRequest<E> findBy() {
        return new FluentIndexSearcherRequest(this);
    }

    public LuceneIndexSearcherResponse<E> find(String query) throws CorruptIndexException, IOException, ParseException {
        return this.findBy().query(query).execute();
    }

    public LuceneIndexSearcherResponse<E> find(Query query) throws CorruptIndexException, IOException {
        return this.findBy().query(query).execute();
    }

    public LuceneIndexSearcherResponse<E> find(LuceneIndexSearcherRequest req) throws CorruptIndexException, IOException {
        Sort sort = req.getSort();
        int limit = req.getLimit();
        int offset = req.getOffset();
        int maxIndex = limit + offset;
        Object topDocs = sort == null ? this.search(req.getQuery(), req.getFilter(), maxIndex) : this.search(req.getQuery(), req.getFilter(), maxIndex, sort);
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        int len = scoreDocs.length;
        int size = len - offset;
        LuceneIndexSearcherResponse<E> res = new LuceneIndexSearcherResponse<E>(size < 0 ? 0 : size);
        for (int i = offset; i < len; ++i) {
            res.add(this.desc.createEntity(this.doc(scoreDocs[i].doc)));
        }
        res.setLimit(limit);
        res.setOffset(offset);
        res.setTotalHits(topDocs.totalHits);
        if (LOG.isDebugEnabled((Marker)GenericMarker.LIST)) {
            String fmg = "find request=[{}], response=[{}]";
            LOG.debug((Marker)GenericMarker.LIST, "find request=[{}], response=[{}]", (Object)req, res);
        }
        return res;
    }

    public E findById(Object value) throws CorruptIndexException, IOException {
        TermQuery query = new TermQuery(this.desc.getIdTermByValue(value));
        ScoreDoc[] scoreDocs = this.search((Query)query, (int)1).scoreDocs;
        if (LOG.isDebugEnabled((Marker)GenericMarker.SHOW)) {
            String fmg = "find by id [{}], hits={}";
            LOG.debug((Marker)GenericMarker.SHOW, "find by id [{}], hits={}", value, (Object)scoreDocs.length);
        }
        if (scoreDocs.length < 1) {
            return null;
        }
        return this.desc.createEntity(this.doc(scoreDocs[0].doc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open() {
        try {
            this.delayCloseLock.lock();
            if (this.closeWhenDone) {
                throw new IllegalStateException("closeWhenDone() already called");
            }
            ++this.usageCount;
        }
        finally {
            this.delayCloseLock.unlock();
        }
        if (LOG.isDebugEnabled((Marker)GenericMarker.OPEN)) {
            String fmg = "[version: {}] open; usageCount: {}";
            LOG.debug((Marker)GenericMarker.OPEN, "[version: {}] open; usageCount: {}", (Object)this.version, (Object)this.usageCount);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        boolean doClose;
        if (ClosingGuardian.class.getName().equals(ThreadUtils.getCallingClassName())) {
            super.close();
            this.closed = true;
            if (LOG.isWarnEnabled((Marker)GenericMarker.CLOSE)) {
                String fmt = "[version: {}] close forcibly; usageCount: {}";
                LOG.warn((Marker)GenericMarker.CLOSE, "[version: {}] close forcibly; usageCount: {}", (Object)this.version, (Object)this.usageCount);
            }
            return;
        }
        try {
            this.delayCloseLock.lock();
            doClose = --this.usageCount <= 0 && this.closeWhenDone;
        }
        finally {
            this.delayCloseLock.unlock();
        }
        if (doClose) {
            super.close();
            this.closed = true;
            if (LOG.isDebugEnabled((Marker)GenericMarker.CLOSE)) {
                LOG.debug((Marker)GenericMarker.CLOSE, "[version: {}] close", (Object)this.version);
            }
        } else if (LOG.isDebugEnabled((Marker)GenericMarker.CANCEL)) {
            String fmg = "[version: {}] cancel to close; usageCount: {}, closeWhenDone: {}";
            Object[] args = new Object[]{this.version, this.usageCount, this.closeWhenDone};
            LOG.debug((Marker)GenericMarker.CLOSE, "[version: {}] cancel to close; usageCount: {}, closeWhenDone: {}", args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWhenDone() throws IOException {
        boolean doClose;
        try {
            this.delayCloseLock.lock();
            if (this.closeWhenDone) {
                if (LOG.isDebugEnabled((Marker)GenericMarker.CANCEL)) {
                    String fmg = "[version: {}] closeWhenDone() already called; usageCount: {}";
                    LOG.debug((Marker)GenericMarker.CLOSE, "[version: {}] closeWhenDone() already called; usageCount: {}", (Object)this.version, (Object)this.usageCount);
                }
            } else {
                this.closeWhenDone = true;
            }
            doClose = this.usageCount <= 0;
        }
        finally {
            this.delayCloseLock.unlock();
        }
        if (LOG.isDebugEnabled((Marker)GenericMarker.DESTROY)) {
            String fmt = "[version: {}] close when done; usageCount: {}";
            LOG.debug((Marker)GenericMarker.DESTROY, "[version: {}] close when done; usageCount: {}", (Object)this.version, (Object)this.usageCount);
        }
        if (doClose) {
            super.close();
            this.closed = true;
            if (LOG.isDebugEnabled((Marker)GenericMarker.CLOSE)) {
                LOG.debug((Marker)GenericMarker.CLOSE, "[version: {}] close", (Object)this.version);
            }
        }
    }

    public String toString() {
        return "LuceneIndexSearcher[version: " + this.version + "]";
    }
}

