/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene;

import java.io.IOException;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.mtzky.lucene.AbstractIndexSearcherRequest;
import org.mtzky.lucene.LuceneIndexSearcher;
import org.mtzky.lucene.LuceneIndexSearcherResponse;

public class FluentIndexSearcherRequest<E>
extends AbstractIndexSearcherRequest {
    private final LuceneIndexSearcher<E> searcher;

    protected FluentIndexSearcherRequest(LuceneIndexSearcher<E> searcher) {
        this.searcher = searcher;
    }

    public FluentIndexSearcherRequest<E> query(String query) throws ParseException {
        return this.query(this.searcher.parse(query));
    }

    public FluentIndexSearcherRequest<E> query(Query query) {
        return this.query(query, BooleanClause.Occur.MUST);
    }

    public FluentIndexSearcherRequest<E> query(String query, BooleanClause.Occur occur) throws ParseException {
        return this.query(this.searcher.parse(query), occur);
    }

    public FluentIndexSearcherRequest<E> query(Query query, BooleanClause.Occur occur) {
        this.addQuery(query, occur);
        return this;
    }

    public FluentIndexSearcherLimitRequest<E> filter(Filter filter) {
        return new FluentIndexSearcherFilterRequest(this).filter(filter);
    }

    public FluentIndexSearcherOffsetRequest<E> limit(int limit) {
        return new FluentIndexSearcherLimitRequest(this).limit(limit);
    }

    public FluentIndexSearcherSortRequest<E> offset(int offset) {
        return new FluentIndexSearcherOffsetRequest(this).offset(offset);
    }

    public FluentIndexSearcherSortRequest<E> sort(String ... fields) {
        return new FluentIndexSearcherSortRequest(this).sort(fields);
    }

    public FluentIndexSearcherSortRequest<E> sort(String field, boolean reverse) {
        return new FluentIndexSearcherSortRequest(this).sort(field, reverse);
    }

    public LuceneIndexSearcherResponse<E> execute() throws IOException {
        return this.searcher.find(this);
    }

    public static class FluentIndexSearcherSearchRequest<E> {
        private final FluentIndexSearcherRequest<E> ctx;

        protected FluentIndexSearcherSearchRequest(FluentIndexSearcherRequest<E> request) {
            this.ctx = request;
        }

        public LuceneIndexSearcherResponse<E> execute() throws IOException {
            return this.ctx.execute();
        }

        public String toString() {
            return this.ctx.toString();
        }
    }

    public static class FluentIndexSearcherSortRequest<E>
    extends FluentIndexSearcherSearchRequest<E> {
        private final FluentIndexSearcherRequest<E> ctx;

        private FluentIndexSearcherSortRequest(FluentIndexSearcherRequest<E> request) {
            super(request);
            this.ctx = request;
        }

        public FluentIndexSearcherSortRequest<E> sort(String ... fields) {
            this.ctx.addSort(fields);
            return this;
        }

        public FluentIndexSearcherSortRequest<E> sort(String field, boolean reverse) {
            this.ctx.addSort(field, reverse);
            return this;
        }
    }

    public static class FluentIndexSearcherOffsetRequest<E>
    extends FluentIndexSearcherSortRequest<E> {
        private final FluentIndexSearcherRequest<E> ctx;

        private FluentIndexSearcherOffsetRequest(FluentIndexSearcherRequest<E> request) {
            super(request);
            this.ctx = request;
        }

        public FluentIndexSearcherSortRequest<E> offset(int offset) {
            this.ctx.setOffset(offset);
            return new FluentIndexSearcherSortRequest(this.ctx);
        }

        @Override
        public FluentIndexSearcherSortRequest<E> sort(String ... fields) {
            this.ctx.sort(fields);
            return new FluentIndexSearcherSortRequest(this.ctx);
        }

        @Override
        public FluentIndexSearcherSortRequest<E> sort(String field, boolean reverse) {
            this.ctx.sort(field, reverse);
            return new FluentIndexSearcherSortRequest(this.ctx);
        }
    }

    public static class FluentIndexSearcherLimitRequest<E>
    extends FluentIndexSearcherOffsetRequest<E> {
        private final FluentIndexSearcherRequest<E> ctx;

        private FluentIndexSearcherLimitRequest(FluentIndexSearcherRequest<E> request) {
            super(request);
            this.ctx = request;
        }

        public FluentIndexSearcherOffsetRequest<E> limit(int limit) {
            this.ctx.setLimit(limit);
            return new FluentIndexSearcherOffsetRequest(this.ctx);
        }
    }

    public static class FluentIndexSearcherFilterRequest<E>
    extends FluentIndexSearcherLimitRequest<E> {
        private final FluentIndexSearcherRequest<E> ctx;

        private FluentIndexSearcherFilterRequest(FluentIndexSearcherRequest<E> request) {
            super(request);
            this.ctx = request;
        }

        public FluentIndexSearcherLimitRequest<E> filter(Filter filter) {
            this.ctx.setFilter(filter);
            return new FluentIndexSearcherLimitRequest(this.ctx);
        }
    }
}

