/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.utils.ValidateUtility;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.entity.WorkTypeEntityInterface;

public class TotalTimeUtility {
    private TotalTimeUtility() {
    }

    public static AttendanceDtoInterface getAttendanceDto(List<AttendanceDtoInterface> list, Date targetDate) {
        for (AttendanceDtoInterface dto : list) {
            if (targetDate.compareTo(dto.getWorkDate()) != 0) continue;
            return dto;
        }
        return null;
    }

    public static WorkOnHolidayRequestDtoInterface getWorkOnHolidayRequestDto(List<WorkOnHolidayRequestDtoInterface> list, Map<Long, WorkflowDtoInterface> workflowMap, Date targetDate) {
        for (WorkOnHolidayRequestDtoInterface dto : list) {
            if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowMap.get(dto.getWorkflow())) || targetDate.compareTo(dto.getRequestDate()) != 0) continue;
            return dto;
        }
        return null;
    }

    public static List<HolidayRequestDtoInterface> getHolidayRequestList(List<HolidayRequestDtoInterface> list, Map<Long, WorkflowDtoInterface> workflowMap, Date targetDate) {
        ArrayList<HolidayRequestDtoInterface> holidayRequests = new ArrayList<HolidayRequestDtoInterface>();
        for (HolidayRequestDtoInterface dto : list) {
            if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowMap.get(dto.getWorkflow())) || !ValidateUtility.chkTerm((Date)targetDate, (Date)dto.getRequestStartDate(), (Date)dto.getRequestEndDate())) continue;
            holidayRequests.add(dto);
        }
        return holidayRequests;
    }

    public static List<SubHolidayRequestDtoInterface> getSubHolidayRequestList(List<SubHolidayRequestDtoInterface> list, Map<Long, WorkflowDtoInterface> workflowMap, Date targetDate) {
        ArrayList<SubHolidayRequestDtoInterface> subHolidayRequests = new ArrayList<SubHolidayRequestDtoInterface>();
        for (SubHolidayRequestDtoInterface dto : list) {
            if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowMap.get(dto.getWorkflow())) || targetDate.compareTo(dto.getRequestDate()) != 0) continue;
            subHolidayRequests.add(dto);
        }
        return subHolidayRequests;
    }

    public static List<OvertimeRequestDtoInterface> getOvertimeRequestList(List<OvertimeRequestDtoInterface> list, Map<Long, WorkflowDtoInterface> workflowMap, Date targetDate) {
        ArrayList<OvertimeRequestDtoInterface> overtimeRequests = new ArrayList<OvertimeRequestDtoInterface>();
        for (OvertimeRequestDtoInterface dto : list) {
            if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowMap.get(dto.getWorkflow())) || targetDate.compareTo(dto.getRequestDate()) != 0) continue;
            overtimeRequests.add(dto);
        }
        return overtimeRequests;
    }

    public static WorkTypeChangeRequestDtoInterface getWorkTypeChangeRequestList(List<WorkTypeChangeRequestDtoInterface> list, Map<Long, WorkflowDtoInterface> workflowMap, Date targetDate) {
        for (WorkTypeChangeRequestDtoInterface dto : list) {
            if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowMap.get(dto.getWorkflow())) || targetDate.compareTo(dto.getRequestDate()) != 0) continue;
            return dto;
        }
        return null;
    }

    public static DifferenceRequestDtoInterface getDifferenceRequestDto(List<DifferenceRequestDtoInterface> list, Map<Long, WorkflowDtoInterface> workflowMap, Date targetDate) {
        for (DifferenceRequestDtoInterface dto : list) {
            if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowMap.get(dto.getWorkflow())) || targetDate.compareTo(dto.getRequestDate()) != 0) continue;
            return dto;
        }
        return null;
    }

    public static List<SubstituteDtoInterface> getSubstitutList(List<SubstituteDtoInterface> list, Map<Long, WorkflowDtoInterface> workflowMap, Date targetDate) {
        ArrayList<SubstituteDtoInterface> substituts = new ArrayList<SubstituteDtoInterface>();
        for (SubstituteDtoInterface dto : list) {
            if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowMap.get(dto.getWorkflow())) || targetDate.compareTo(dto.getSubstituteDate()) != 0) continue;
            substituts.add(dto);
        }
        return substituts;
    }

    public static WorkTypeEntityInterface getLatestWorkTypeEntity(Map<String, List<WorkTypeEntityInterface>> map, String workTypeCode, Date targetDate) {
        List<WorkTypeEntityInterface> history = map.get(workTypeCode);
        if (history == null || targetDate == null) {
            return null;
        }
        WorkTypeEntityInterface latestEntity = null;
        for (WorkTypeEntityInterface entity : history) {
            if (targetDate.before(entity.getActivateDate())) continue;
            latestEntity = entity;
        }
        return latestEntity;
    }
}

