/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.CapsuleUtility;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MenuUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.dto.base.WorkflowNumberDtoInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeVo;
import jp.mosp.time.dto.base.RequestDateDtoInterface;
import jp.mosp.time.dto.base.WorkTypeCodeDtoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.LimitStandardDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayTransactionDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayTransactionDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeEmployeeDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.HolidayRemainDto;
import jp.mosp.time.entity.CutoffEntityInterface;
import jp.mosp.time.entity.TimeDuration;
import jp.mosp.time.entity.TimeSettingEntityInterface;
import jp.mosp.time.entity.WorkTypeEntityInterface;
import jp.mosp.time.utils.TimeNamingUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimeUtility {
    public static final int DATE_UNLIMITED_YEAR = 5874897;
    public static final int DATE_YEAR_LAST_MONTH = 31;
    public static final String REG_ATTENDANCE_TIME = "([0-3][0-9]|[4][0-7])[0-5][0-9]";
    public static final String MAIN_MENU_TIME_INMPUT = "menuTimeInput";
    public static final String MENU_ATTENDANCE_LIST = "AttendanceList";
    public static final String MENU_OVERTIME_REQUEST = "OvertimeRequest";
    public static final String MENU_HOLIDAY_REQUEST = "HolidayRequest";
    public static final String MENU_WORK_ON_HOLIDAY_REQUEST = "WorkOnHolidayRequest";
    public static final String MENU_SUB_HOLIDAY_REQUEST = "SubHolidayRequest";
    public static final String MENU_WORK_TYPE_CHANGE_REQUEST = "WorkTypeChangeRequest";
    public static final String MENU_DIFFERENCE_REQUEST = "DifferenceRequest";
    public static final String MENU_CANCELLATION_REQUEST = "CancellationRequest";
    public static final int MAX_ATTENDANCE_MINUTES = 2879;

    private TimeUtility() {
    }

    public static Date getDateTime(Date date, Date time) throws MospException {
        if (time == null) {
            return null;
        }
        int hour = DateUtility.getHour((Date)time, (Date)DateUtility.getDefaultTime());
        int minute = DateUtility.getMinute((Date)time);
        return TimeUtility.getDateTime((Date)date, (int)hour, (int)minute);
    }

    public static Date getDefaultDateTime(Date time, Date standardDate) throws MospException {
        if (MospUtility.isEmpty((Object[])new Object[]{time, standardDate})) {
            return null;
        }
        int hour = DateUtility.getHour((Date)time, (Date)standardDate);
        int minute = DateUtility.getMinute((Date)time);
        return TimeUtility.getDateTime((Date)DateUtility.getDefaultTime(), (int)hour, (int)minute);
    }

    public static Date getDefaultTime(String hour, String minute) throws MospException {
        return TimeUtility.getDateTime((Date)DateUtility.getDefaultTime(), (String)hour, (String)minute);
    }

    public static Date getDateTime(Date date, String hour, String minute) {
        return TimeUtility.getDateTime((Date)date, (int)MospUtility.getInt((Object)hour), (int)MospUtility.getInt((Object)minute));
    }

    public static Date getDateTime(Date date, int hour, int minute) {
        if (date == null) {
            return null;
        }
        Date dateTime = DateUtility.getDate((Date)date);
        dateTime = DateUtility.addHour((Date)dateTime, (int)hour);
        dateTime = DateUtility.addMinute((Date)dateTime, (int)minute);
        return dateTime;
    }

    public static int getMinutes(Date targetTime) throws MospException {
        return TimeUtility.getMinutes((Date)targetTime, (Date)DateUtility.getDefaultTime());
    }

    public static int getMinutes(Date targetTime, Date targetDate) {
        return TimeUtility.getDifferenceMinutes((Date)targetDate, (Date)targetTime);
    }

    public static int getDifferenceMinutes(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return 0;
        }
        long defference = endTime.getTime() - startTime.getTime();
        return (int)(defference / 60000L);
    }

    public static Date getAttendanceTime(Date date, String time, MospParams mospParams) {
        if (!time.matches("([0-3][0-9]|[4][0-7])[0-5][0-9]")) {
            mospParams.addErrorMessage("TMW0233", new String[]{DateUtility.getStringDate((Date)date)});
            return null;
        }
        String hour = time.substring(0, 2);
        String minute = time.substring(2, 4);
        return TimeUtility.getDateTime((Date)date, (String)hour, (String)minute);
    }

    public static Date getAttendanceTime(Date date, String hour, String minute, MospParams mospParams) {
        StringBuffer sb = new StringBuffer();
        if (hour.length() == 1) {
            sb.append(0);
        }
        sb.append(hour);
        if (minute.length() == 1) {
            sb.append(0);
        }
        sb.append(minute);
        return TimeUtility.getAttendanceTime((Date)date, (String)sb.toString(), (MospParams)mospParams);
    }

    public static WorkTypeEntityInterface getBareWorkTypeEntity(MospParams mospParams) throws MospException {
        WorkTypeEntityInterface entity = (WorkTypeEntityInterface)MospUtility.createObject(WorkTypeEntityInterface.class, (MospParams)mospParams);
        entity.setWorkTypeItemList(Collections.emptyList());
        return entity;
    }

    public static TimeSettingEntityInterface getBareTimeSettingEntity(MospParams mospParams) throws MospException {
        TimeSettingEntityInterface entity = (TimeSettingEntityInterface)MospUtility.createObject(TimeSettingEntityInterface.class, (MospParams)mospParams);
        entity.setLimitStandardDtos(Collections.emptyMap());
        return entity;
    }

    public static CutoffEntityInterface getBareCutoffEntity(MospParams mospParams) throws MospException {
        return (CutoffEntityInterface)MospUtility.createObject(CutoffEntityInterface.class, (MospParams)mospParams);
    }

    public static Date getCutoffFirstDate(int cutoffDate, int targetYear, int targetMonth, MospParams mospParams) throws MospException {
        int cutoffDay = TimeUtility.adjustCutoffDay((int)cutoffDate, (MospParams)mospParams);
        return MonthUtility.getYearMonthTermFirstDate((int)targetYear, (int)targetMonth, (int)cutoffDay);
    }

    public static Date getCutoffFirstDate(int cutoffDate, Date targetDate, MospParams mospParams) throws MospException {
        Date cutffMonth = TimeUtility.getCutoffMonth((int)cutoffDate, (Date)targetDate, (MospParams)mospParams);
        int targetYear = DateUtility.getYear((Date)cutffMonth);
        int targetMonth = DateUtility.getMonth((Date)cutffMonth);
        return TimeUtility.getCutoffFirstDate((int)cutoffDate, (int)targetYear, (int)targetMonth, (MospParams)mospParams);
    }

    public static Date getCutoffLastDate(int cutoffDate, int targetYear, int targetMonth, MospParams mospParams) throws MospException {
        int cutoffDay = TimeUtility.adjustCutoffDay((int)cutoffDate, (MospParams)mospParams);
        return MonthUtility.getYearMonthTermLastDate((int)targetYear, (int)targetMonth, (int)cutoffDay);
    }

    public static Date getCutoffLastDate(int cutoffDate, Date targetDate, MospParams mospParams) throws MospException {
        Date cutffMonth = TimeUtility.getCutoffMonth((int)cutoffDate, (Date)targetDate, (MospParams)mospParams);
        int targetYear = DateUtility.getYear((Date)cutffMonth);
        int targetMonth = DateUtility.getMonth((Date)cutffMonth);
        return TimeUtility.getCutoffLastDate((int)cutoffDate, (int)targetYear, (int)targetMonth, (MospParams)mospParams);
    }

    protected static int adjustCutoffDay(int cutoffDay, MospParams mospParams) {
        if (cutoffDay == 0) {
            return cutoffDay;
        }
        int cutoffDateNextManthMax = mospParams.getApplicationProperty("CutoffDateNextMonthMax", 15);
        if (cutoffDay > cutoffDateNextManthMax) {
            return cutoffDay;
        }
        return cutoffDay + 100;
    }

    public static Date getCutoffTermTargetDate(int cutoffDate, int targetYear, int targetMonth, MospParams mospParams) throws MospException {
        return TimeUtility.getCutoffLastDate((int)cutoffDate, (int)targetYear, (int)targetMonth, (MospParams)mospParams);
    }

    public static Date getCutoffCalculationDate(int cutoffDate, int targetYear, int targetMonth, MospParams mospParams) throws MospException {
        return TimeUtility.getCutoffLastDate((int)cutoffDate, (int)targetYear, (int)targetMonth, (MospParams)mospParams);
    }

    public static Date getCutoffMonth(int cutoffDate, Date targetDate, MospParams mospParams) throws MospException {
        int cutoffDay = TimeUtility.adjustCutoffDay((int)cutoffDate, (MospParams)mospParams);
        return MonthUtility.getTargetYearMonth((Date)targetDate, (int)cutoffDay);
    }

    public static List<Date> getCutoffTerm(int cutoffDate, Date targetDate, MospParams mospParams) throws MospException {
        Date cutoffMonth = TimeUtility.getCutoffMonth((int)cutoffDate, (Date)targetDate, (MospParams)mospParams);
        int targetYear = DateUtility.getYear((Date)cutoffMonth);
        int targetMonth = DateUtility.getMonth((Date)cutoffMonth);
        return TimeUtility.getCutoffTerm((int)cutoffDate, (int)targetYear, (int)targetMonth, (MospParams)mospParams);
    }

    public static List<Date> getCutoffTerm(int cutoffDate, int targetYear, int targetMonth, MospParams mospParams) throws MospException {
        Date firstDate = TimeUtility.getCutoffFirstDate((int)cutoffDate, (int)targetYear, (int)targetMonth, (MospParams)mospParams);
        Date lastDate = TimeUtility.getCutoffLastDate((int)cutoffDate, (int)targetYear, (int)targetMonth, (MospParams)mospParams);
        return TimeUtility.getDateList((Date)firstDate, (Date)lastDate);
    }

    public static boolean isTightend(TotalTimeEmployeeDtoInterface dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return false;
        }
        return dto.getCutoffState() != 0;
    }

    public static Set<String> getTimeFunctionSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        set.add("3");
        set.add("4");
        set.add("5");
        set.add("6");
        set.add("7");
        return set;
    }

    public static boolean isAttendance(WorkflowDtoInterface dto) {
        return PlatformUtility.isTheFunction((WorkflowDtoInterface)dto, (String)"1");
    }

    public static String getFunctionName(MospParams mospParams, String function) {
        String functionName = MospUtility.getCodeName((MospParams)mospParams, (String)function, (String)"ApprovalType");
        if (MospUtility.isEqual((Object)functionName, (Object)"9")) {
            functionName = TimeNamingUtility.cancellationRequest((MospParams)mospParams);
        }
        return functionName;
    }

    public static Date getUnlimitedDate() throws MospException {
        return DateUtility.getDate((int)5874897, (int)12, (int)31);
    }

    public static boolean isUnlimited(HolidayDataDtoInterface dto) throws MospException {
        if (dto == null) {
            return false;
        }
        return TimeUtility.isUnlimited((Date)dto.getHolidayLimitDate());
    }

    public static boolean isUnlimited(Date limitDate) throws MospException {
        return DateUtility.isSame((Date)TimeUtility.getUnlimitedDate(), (Date)limitDate);
    }

    public static Date getYearMonthTargetDate(String targetYear, String targetMonth, MospParams mospParams) throws MospException {
        int year = MospUtility.getInt((Object)targetYear);
        int month = TimeUtility.getTargetMonth((String)targetMonth);
        return MonthUtility.getYearMonthTargetDate((int)year, (int)month, (MospParams)mospParams);
    }

    public static int getTargetMonth(String targetMonth) {
        int month = MospUtility.getIntOrZero((int)MospUtility.getInt((Object)targetMonth));
        if (month == 0) {
            month = 12;
        }
        return month;
    }

    public static List<Date> getDateList(Date firstDate, Date lastDate) {
        ArrayList<Date> list = new ArrayList<Date>();
        if (MospUtility.isEmpty((Object[])new Object[]{firstDate, lastDate})) {
            return list;
        }
        Date date = CapsuleUtility.getDateClone((Date)firstDate);
        while (!date.after(lastDate)) {
            list.add(date);
            date = DateUtility.addDay((Date)date, (int)1);
        }
        return list;
    }

    public static List<Date> getMonthList(Date firstMonth, Date lastMonth) {
        ArrayList<Date> list = new ArrayList<Date>();
        if (MospUtility.isEmpty((Object[])new Object[]{firstMonth, lastMonth})) {
            return list;
        }
        Date date = MonthUtility.getYearMonthDate((int)DateUtility.getYear((Date)firstMonth), (int)DateUtility.getMonth((Date)firstMonth));
        while (!date.after(lastMonth)) {
            list.add(date);
            date = DateUtility.addMonth((Date)date, (int)1);
        }
        return list;
    }

    public static int getRoundMinute(int time, int type, int unit) {
        if (time <= 0 || type == 0 || unit <= 0) {
            return time;
        }
        if (type == 1 || type == 2) {
            int remainder = time % unit;
            if (remainder == 0) {
                return time;
            }
            int rounded = time - remainder;
            if (type == 1) {
                return rounded;
            }
            if (type == 2) {
                return rounded + unit;
            }
        }
        return time;
    }

    public static Date getRoundMinute(Date time, int type, int unit) {
        if (time == null) {
            return null;
        }
        long milliseconds = time.getTime();
        if (milliseconds == 0L || type == 0 || unit <= 0) {
            return time;
        }
        if (type == 1 || type == 2) {
            int millisecondsUnit = unit * 60 * 1000;
            long remainder = milliseconds % (long)millisecondsUnit;
            if (remainder == 0L) {
                return time;
            }
            long rounded = milliseconds - remainder;
            if (type == 1) {
                return new Date(rounded);
            }
            if (type == 2) {
                return new Date(rounded + (long)millisecondsUnit);
            }
        }
        return time;
    }

    public static boolean isPrescribedHoliday(String workTypeCode) {
        return "prescribed_holiday".equals(workTypeCode);
    }

    public static boolean isLegalHoliday(String workTypeCode) {
        return "legal_holiday".equals(workTypeCode);
    }

    public static boolean isHoliday(String workTypeCode) {
        return TimeUtility.isPrescribedHoliday((String)workTypeCode) || TimeUtility.isLegalHoliday((String)workTypeCode);
    }

    public static boolean isWorkOnPrescribedHoliday(String workTypeCode) {
        return "work_on_prescribed".equals(workTypeCode);
    }

    public static boolean isWorkOnLegalHoliday(String workTypeCode) {
        return "work_on_legal".equals(workTypeCode);
    }

    public static boolean isWorkOnLegalOrPrescribedHoliday(String workTypeCode) {
        return TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode);
    }

    public static boolean isLegal(String workTypeCode) {
        return TimeUtility.isLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode);
    }

    public static boolean isPrescribed(String workTypeCode) {
        return TimeUtility.isPrescribedHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode);
    }

    public static boolean isLegalOrPrescribed(String workTypeCode) {
        return TimeUtility.isLegal((String)workTypeCode) || TimeUtility.isPrescribed((String)workTypeCode);
    }

    public static Set<String> getWorkTypeCodes(Collection<?> ... collections) {
        TreeSet<String> set = new TreeSet<String>();
        for (Collection<?> collection : collections) {
            for (Object obj : collection) {
                if (MospUtility.isEmpty((Object[])new Object[]{obj})) continue;
                WorkTypeCodeDtoInterface dto = (WorkTypeCodeDtoInterface)PlatformUtility.castObject(obj);
                String workTypeCode = dto.getWorkTypeCode();
                if (MospUtility.isEmpty((String[])new String[]{workTypeCode})) continue;
                set.add(workTypeCode);
            }
        }
        return set;
    }

    public static <T extends RequestDateDtoInterface> Map<Date, T> getRequestDateMap(Collection<T> dtos) {
        TreeMap<Date, RequestDateDtoInterface> map = new TreeMap<Date, RequestDateDtoInterface>();
        for (RequestDateDtoInterface dto : dtos) {
            map.put(dto.getRequestDate(), dto);
        }
        return map;
    }

    public static <T extends RequestDateDtoInterface & WorkflowNumberDtoInterface> Map<Date, T> getRequestDateMap(Collection<T> dtos, Map<Long, WorkflowDtoInterface> workflows, Set<String> statuses) {
        return TimeUtility.getRequestDateMap((Collection)WorkflowUtility.getStatusMatchedDtos(dtos, workflows, statuses));
    }

    public static <T extends RequestDateDtoInterface> Map<Date, List<T>> getRequestDatesMap(Collection<T> dtos) throws MospException {
        TreeMap<Date, List<T>> map = new TreeMap<Date, List<T>>();
        for (RequestDateDtoInterface dto : dtos) {
            List value = MospUtility.getListValue(map, (Object)dto.getRequestDate());
            value.add(dto);
        }
        return map;
    }

    public static Map<Date, List<SubstituteDtoInterface>> getSubstitutesMap(List<SubstituteDtoInterface> dtos) throws MospException {
        TreeMap<Date, List<SubstituteDtoInterface>> map = new TreeMap<Date, List<SubstituteDtoInterface>>();
        for (SubstituteDtoInterface dto : dtos) {
            List value = MospUtility.getListValue(map, (Object)dto.getSubstituteDate());
            value.add(dto);
        }
        return map;
    }

    public static Map<Date, Date> getSubstitutDates(List<SubstituteDtoInterface> dtos) throws MospException {
        TreeMap<Date, Date> map = new TreeMap<Date, Date>();
        for (SubstituteDtoInterface dto : dtos) {
            map.put(dto.getWorkDate(), dto.getSubstituteDate());
        }
        return map;
    }

    public static Map<Date, List<HolidayRequestDtoInterface>> getHolidayRequestsMap(List<HolidayRequestDtoInterface> dtos) throws MospException {
        TreeMap<Date, List<HolidayRequestDtoInterface>> map = new TreeMap<Date, List<HolidayRequestDtoInterface>>();
        for (HolidayRequestDtoInterface dto : dtos) {
            for (Date date : TimeUtility.getDateList((Date)dto.getRequestStartDate(), (Date)dto.getRequestEndDate())) {
                List value = MospUtility.getListValue(map, (Object)date);
                value.add(dto);
            }
        }
        return map;
    }

    public static boolean isAttendanceListAvailable(MospParams mospParams) {
        return MenuUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"AttendanceList");
    }

    public static boolean isOvertimeRequestValid(MospParams mospParams) {
        return MenuUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"OvertimeRequest");
    }

    public static boolean isOvertimeRequestAvailable(MospParams mospParams) {
        return MenuUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"OvertimeRequest");
    }

    public static boolean isHolidayRequestValid(MospParams mospParams) {
        return MenuUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"HolidayRequest");
    }

    public static boolean isHolidayRequestAvailable(MospParams mospParams) {
        return MenuUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"HolidayRequest");
    }

    public static boolean isWorkOnHolidayRequestValid(MospParams mospParams) {
        return MenuUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"WorkOnHolidayRequest");
    }

    public static boolean isWorkOnHolidayRequestAvailable(MospParams mospParams) {
        return MenuUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"WorkOnHolidayRequest");
    }

    public static boolean isSubHolidayRequestValid(MospParams mospParams) {
        return MenuUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"SubHolidayRequest");
    }

    public static boolean isSubHolidayRequestAvailable(MospParams mospParams) {
        return MenuUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"SubHolidayRequest");
    }

    public static boolean isWorkTypeChangeRequestValid(MospParams mospParams) {
        return MenuUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"WorkTypeChangeRequest");
    }

    public static boolean isWorkTypeChangeRequestAvailable(MospParams mospParams) {
        return MenuUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"WorkTypeChangeRequest");
    }

    public static boolean isDifferenceRequestValid(MospParams mospParams) {
        return MenuUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"DifferenceRequest");
    }

    public static boolean isCancellationRequestValid(MospParams mospParams) {
        return MenuUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"CancellationRequest");
    }

    public static double round(double value, int scale, int roundingMode) {
        BigDecimal bi = new BigDecimal(String.valueOf(value));
        return bi.setScale(scale, roundingMode).doubleValue();
    }

    public static double getRoundHalfUp2(double value) {
        return TimeUtility.round((double)value, (int)2, (int)4);
    }

    public static double getMinuteToHour(double minutes) {
        double dotMinutes = minutes / 60.0;
        return TimeUtility.getRoundHalfUp2((double)dotMinutes);
    }

    public static int count(Integer minutes) {
        if (MospUtility.isEmpty((Object[])new Object[]{minutes}) || minutes == 0) {
            return 0;
        }
        return 1;
    }

    public static int getHolidayHours(HolidayRequestDtoInterface dto) {
        int minutes = TimeUtility.getDuration((Date)dto.getStartTime(), (Date)dto.getEndTime()).getMinutes();
        return MospUtility.divide((int)minutes, (int)60);
    }

    public static boolean isHolidayTimesHalf(double holidayTimes) {
        return holidayTimes == 0.5;
    }

    public static boolean isHolidayRemain(HolidayRemainDto dto, double useDays, int useHours, int useMinutes, int hoursPerDay, int minutesPerDay, boolean isZeroRemain) throws MospException {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return false;
        }
        TimeUtility.calcHolidayRemains((HolidayRemainDto)dto, (double)useDays, (int)useHours, (int)useMinutes, (int)hoursPerDay, (int)minutesPerDay);
        return TimeUtility.isHolidayRemain((HolidayRemainDto)dto, (boolean)isZeroRemain);
    }

    public static boolean isHolidayRemain(HolidayRemainDto dto, boolean isZeroRemain) throws MospException {
        if (TimeUtility.isUnlimited((Date)dto.getHolidayLimitDate())) {
            return true;
        }
        double remainDays = dto.getRemainDays();
        int remainHours = dto.getRemainHours();
        int remainMinutes = dto.getRemainMinutes();
        if (!isZeroRemain && remainDays == 0.0 && remainHours == 0 && remainMinutes == 0) {
            return false;
        }
        return remainDays >= 0.0 && remainHours >= 0 && remainMinutes >= 0;
    }

    public static Set<HolidayRemainDto> getRemainHolidays(Set<HolidayRemainDto> dtos, boolean isZeroRemain) throws MospException {
        LinkedHashSet<HolidayRemainDto> remains = new LinkedHashSet<HolidayRemainDto>();
        for (HolidayRemainDto dto : dtos) {
            if (!TimeUtility.isHolidayRemain((HolidayRemainDto)dto, (boolean)false)) continue;
            remains.add(dto);
        }
        return remains;
    }

    public static HolidayRemainDto getHolidayRemains(HolidayDataDtoInterface dto, HolidayDtoInterface holiday, double useDays, int useHours, int useMinutes, int hoursPerDay, int minutesPerDay) throws MospException {
        HolidayRemainDto remain = new HolidayRemainDto();
        remain.setHolidayCode(dto.getHolidayCode());
        remain.setHolidayType(dto.getHolidayType());
        remain.setAcquisitionDate(dto.getActivateDate());
        remain.setHolidayLimitDate(dto.getHolidayLimitDate());
        remain.setGivenDays(TimeUtility.getCurrentDays((HolidayDataDtoInterface)dto));
        remain.setGivenHours(TimeUtility.getCurrentHours((HolidayDataDtoInterface)dto));
        remain.setHolidayName(holiday.getHolidayName());
        remain.setHolidayAbbr(holiday.getHolidayAbbr());
        if (TimeUtility.isUnlimited((HolidayDataDtoInterface)dto)) {
            return remain;
        }
        remain.setRemainDays(remain.getGivenDays());
        remain.setRemainHours(remain.getGivenHours());
        remain.setRemainMinutes(0);
        TimeUtility.calcHolidayRemains((HolidayRemainDto)remain, (double)useDays, (int)useHours, (int)useMinutes, (int)hoursPerDay, (int)minutesPerDay);
        return remain;
    }

    public static HolidayRemainDto getPaidHolidayRemain(PaidHolidayDataDtoInterface dto, double manualDays, int manualHours, double useDays, int useHours, int hoursPerDay) throws MospException {
        HolidayRemainDto remain = new HolidayRemainDto();
        remain.setHolidayCode("1");
        remain.setHolidayType(1);
        remain.setAcquisitionDate(dto.getAcquisitionDate());
        remain.setHolidayLimitDate(dto.getLimitDate());
        remain.setGivenDays(dto.getHoldDay() + manualDays);
        remain.setGivenHours(dto.getHoldHour() + manualHours);
        remain.setHolidayName("");
        remain.setHolidayAbbr("");
        remain.setRemainDays(remain.getGivenDays());
        remain.setRemainHours(remain.getGivenHours());
        remain.setRemainMinutes(0);
        TimeUtility.calcHolidayRemains((HolidayRemainDto)remain, (double)useDays, (int)useHours, (int)0, (int)hoursPerDay, (int)0);
        return remain;
    }

    public static HolidayRemainDto getBarePaidHolidayRemain(Date acquisitionDate, Date holidayLimitDate) throws MospException {
        HolidayRemainDto remain = new HolidayRemainDto();
        remain.setHolidayCode("1");
        remain.setHolidayType(1);
        remain.setAcquisitionDate(acquisitionDate);
        remain.setHolidayLimitDate(holidayLimitDate);
        remain.setGivenDays(0.0);
        remain.setGivenHours(0);
        remain.setRemainDays(0.0);
        remain.setRemainHours(0);
        remain.setRemainMinutes(0);
        remain.setHolidayName("");
        remain.setHolidayAbbr("");
        return remain;
    }

    public static HolidayRemainDto getStockHolidayRemain(StockHolidayDataDtoInterface dto, double manualDays, double useDays) throws MospException {
        HolidayRemainDto remain = new HolidayRemainDto();
        remain.setHolidayCode("2");
        remain.setHolidayType(1);
        remain.setAcquisitionDate(dto.getAcquisitionDate());
        remain.setHolidayLimitDate(dto.getLimitDate());
        remain.setGivenDays(dto.getHoldDay() + manualDays);
        remain.setGivenHours(0);
        remain.setHolidayName("");
        remain.setHolidayAbbr("");
        remain.setRemainDays(remain.getGivenDays());
        remain.setRemainHours(0);
        remain.setRemainMinutes(0);
        TimeUtility.calcHolidayRemains((HolidayRemainDto)remain, (double)useDays, (int)0, (int)0, (int)0, (int)0);
        return remain;
    }

    public static HolidayRemainDto getBareStockHolidayRemain(Date acquisitionDate, Date holidayLimitDate) throws MospException {
        HolidayRemainDto remain = new HolidayRemainDto();
        remain.setHolidayCode("2");
        remain.setHolidayType(1);
        remain.setAcquisitionDate(acquisitionDate);
        remain.setHolidayLimitDate(holidayLimitDate);
        remain.setGivenDays(0.0);
        remain.setGivenHours(0);
        remain.setRemainDays(0.0);
        remain.setRemainHours(0);
        remain.setRemainMinutes(0);
        remain.setHolidayName("");
        remain.setHolidayAbbr("");
        return remain;
    }

    public static void calcHolidayRemains(HolidayRemainDto dto, double useDays, int useHours, int useMinutes, int hoursPerDay, int minutesPerDay) {
        double remainDays = dto.getRemainDays();
        int remainHours = dto.getRemainHours();
        int remainMinutes = dto.getRemainMinutes();
        AbstractMap.SimpleEntry reduceDaysToHours = TimeUtility.reduceDays((double)(remainDays -= useDays), (int)(remainHours -= useHours), (int)hoursPerDay);
        remainDays = (Double)reduceDaysToHours.getKey();
        remainHours = (Integer)reduceDaysToHours.getValue();
        AbstractMap.SimpleEntry reduceDaysToMinutes = TimeUtility.reduceDays((double)remainDays, (int)(remainMinutes -= useMinutes), (int)minutesPerDay);
        remainDays = (Double)reduceDaysToMinutes.getKey();
        remainMinutes = (Integer)reduceDaysToMinutes.getValue();
        dto.setRemainDays(remainDays);
        dto.setRemainHours(remainHours);
        dto.setRemainMinutes(remainMinutes);
    }

    protected static AbstractMap.SimpleEntry<Double, Integer> reduceDays(double remainDays, int remainAmount, int amountPerDay) {
        if (amountPerDay == 0) {
            return new AbstractMap.SimpleEntry<Double, Integer>(remainDays, remainAmount);
        }
        if (remainAmount > 0) {
            remainDays += (double)Math.abs(remainAmount / amountPerDay);
            remainAmount %= amountPerDay;
        } else if (remainAmount < 0) {
            int breakDays = Math.abs(remainAmount / amountPerDay);
            remainDays -= (double)(breakDays += remainAmount % amountPerDay == 0 ? 0 : 1);
            remainAmount += breakDays * amountPerDay;
        }
        return new AbstractMap.SimpleEntry<Double, Integer>(remainDays, remainAmount);
    }

    public static double getCurrentDays(HolidayDataDtoInterface dto) {
        double currentDays = 0.0;
        if (dto == null) {
            return currentDays;
        }
        currentDays += dto.getGivingDay();
        return currentDays -= dto.getCancelDay();
    }

    public static int getCurrentHours(HolidayDataDtoInterface dto) {
        int currentHours = 0;
        if (dto == null) {
            return currentHours;
        }
        currentHours += dto.getGivingHour();
        return currentHours -= dto.getCancelHour();
    }

    public static double getRemainDays(Collection<HolidayRemainDto> dtos) {
        double days = 0.0;
        for (HolidayRemainDto dto : dtos) {
            days += dto.getRemainDays();
        }
        return days;
    }

    public static int getRemainHours(Collection<HolidayRemainDto> dtos) {
        int hours = 0;
        for (HolidayRemainDto dto : dtos) {
            hours += dto.getRemainHours();
        }
        return hours;
    }

    public static HolidayRemainDto getTotalHolidayRemain(Collection<HolidayRemainDto> remains) throws MospException {
        double remainDays = 0.0;
        int remainHours = 0;
        for (HolidayRemainDto remain : remains) {
            remainDays += remain.getRemainDays();
            remainHours += remain.getRemainHours();
        }
        HolidayRemainDto totalRemain = TimeUtility.getBareStockHolidayRemain(null, null);
        totalRemain.setRemainDays(remainDays);
        totalRemain.setRemainHours(remainHours);
        return totalRemain;
    }

    public static double getPaidHolidayManualGivingDays(Collection<PaidHolidayTransactionDtoInterface> dtos) {
        double days = 0.0;
        for (PaidHolidayTransactionDtoInterface dto : dtos) {
            days += dto.getGivingDay();
        }
        return days;
    }

    public static int getPaidHolidayManualGivingHours(Collection<PaidHolidayTransactionDtoInterface> dtos) {
        int hours = 0;
        for (PaidHolidayTransactionDtoInterface dto : dtos) {
            hours += dto.getGivingHour();
        }
        return hours;
    }

    public static double getPaidHolidayManualCancelDays(Collection<PaidHolidayTransactionDtoInterface> dtos) {
        double days = 0.0;
        for (PaidHolidayTransactionDtoInterface dto : dtos) {
            days += dto.getCancelDay();
        }
        return days;
    }

    public static int getPaidHolidayManualCancelHours(Collection<PaidHolidayTransactionDtoInterface> dtos) {
        int hours = 0;
        for (PaidHolidayTransactionDtoInterface dto : dtos) {
            hours += dto.getCancelHour();
        }
        return hours;
    }

    public static double getPaidHolidayManualDays(Collection<PaidHolidayTransactionDtoInterface> dtos) {
        return TimeUtility.getPaidHolidayManualGivingDays(dtos) - TimeUtility.getPaidHolidayManualCancelDays(dtos);
    }

    public static int getPaidHolidayManualHours(Collection<PaidHolidayTransactionDtoInterface> dtos) {
        return TimeUtility.getPaidHolidayManualGivingHours(dtos) - TimeUtility.getPaidHolidayManualCancelHours(dtos);
    }

    public static double getStockHolidayManualGivingDays(Collection<StockHolidayTransactionDtoInterface> dtos) {
        double days = 0.0;
        for (StockHolidayTransactionDtoInterface dto : dtos) {
            days += dto.getGivingDay();
        }
        return days;
    }

    public static double getStockHolidayManualCancelDays(Collection<StockHolidayTransactionDtoInterface> dtos) {
        double days = 0.0;
        for (StockHolidayTransactionDtoInterface dto : dtos) {
            days += dto.getCancelDay();
        }
        return days;
    }

    public static double getStockHolidayManualDays(Collection<StockHolidayTransactionDtoInterface> dtos) {
        return TimeUtility.getStockHolidayManualGivingDays(dtos) - TimeUtility.getStockHolidayManualCancelDays(dtos);
    }

    public static boolean isRegularPaidHoliday(PaidHolidayDataDtoInterface dto, Date grantDate) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto, grantDate})) {
            return false;
        }
        if (!DateUtility.isSame((Date)dto.getActivateDate(), (Date)grantDate)) {
            return false;
        }
        return DateUtility.isSame((Date)dto.getAcquisitionDate(), (Date)grantDate);
    }

    public static boolean hasRegularPaidHoliday(Collection<PaidHolidayDataDtoInterface> dtos, Date grantDate) {
        for (PaidHolidayDataDtoInterface dto : dtos) {
            if (!TimeUtility.isRegularPaidHoliday((PaidHolidayDataDtoInterface)dto, (Date)grantDate)) continue;
            return true;
        }
        return false;
    }

    public static double getHolidayUseDays(Collection<HolidayRequestDtoInterface> dtos) {
        double days = 0.0;
        for (HolidayRequestDtoInterface dto : dtos) {
            days += dto.getUseDay();
        }
        return days;
    }

    public static int getHolidayUseHours(Collection<HolidayRequestDtoInterface> dtos) {
        int hours = 0;
        for (HolidayRequestDtoInterface dto : dtos) {
            hours += dto.getUseHour();
        }
        return hours;
    }

    public static boolean isSalaryTypePay(HolidayDtoInterface dto) {
        return !MospUtility.isEmpty((Object[])new Object[]{dto}) && dto.getSalary() == 0;
    }

    public static boolean isUnlimited(HolidayDtoInterface dto) {
        return !MospUtility.isEmpty((Object[])new Object[]{dto}) && MospUtility.isChecked((int)dto.getNoLimit());
    }

    public static boolean isForcedConsecutive(HolidayDtoInterface dto) {
        return !MospUtility.isEmpty((Object[])new Object[]{dto}) && dto.getContinuousAcquisition() == 0;
    }

    public static HolidayDtoInterface getHolidayDto(Collection<HolidayDtoInterface> holidays, String holidayCode, int holidayType) {
        for (HolidayDtoInterface dto : holidays) {
            if (!TimeUtility.isTheHoliday((HolidayDtoInterface)dto, (String)holidayCode, (int)holidayType)) continue;
            return dto;
        }
        return null;
    }

    public static boolean isTheHoliday(HolidayDtoInterface dto, String holidayCode, int holidayType) {
        if (dto == null) {
            return false;
        }
        return MospUtility.isEqual((Object)dto.getHolidayCode(), (Object)holidayCode) && dto.getHolidayType() == holidayType;
    }

    public static boolean isPaidHoliday(String holidayCode, int holidayType) {
        return MospUtility.isEqual((Object)"1", (Object)holidayCode) && 1 == holidayType;
    }

    public static boolean isStockHoliday(String holidayCode, int holidayType) {
        return MospUtility.isEqual((Object)"2", (Object)holidayCode) && 1 == holidayType;
    }

    public static boolean isHourlyHolidayAvailable(HolidayDtoInterface dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return false;
        }
        return PlatformUtility.isActivate((int)dto.getTimelyHolidayFlag());
    }

    public static String getHolidayAbbr(Collection<HolidayDtoInterface> holidays, String holidayCode, int holidayType, MospParams mospParams) {
        HolidayDtoInterface dto = TimeUtility.getHolidayDto(holidays, (String)holidayCode, (int)holidayType);
        if (dto != null) {
            return dto.getHolidayAbbr();
        }
        if (TimeUtility.isPaidHoliday((String)holidayCode, (int)holidayType)) {
            return TimeNamingUtility.paidHolidayAbbr((MospParams)mospParams);
        }
        if (TimeUtility.isStockHoliday((String)holidayCode, (int)holidayType)) {
            return TimeNamingUtility.getStockHolidayAbbr((MospParams)mospParams);
        }
        return "";
    }

    public static String getHolidayRangeAbbr(MospParams mospParams, int holidayRange) {
        String holidayRangeAbbr = "";
        switch (holidayRange) {
            case 1: {
                holidayRangeAbbr = TimeNamingUtility.holidayRangeAll((MospParams)mospParams);
                break;
            }
            case 2: {
                holidayRangeAbbr = TimeNamingUtility.holidayRangeFrontAbbr((MospParams)mospParams);
                break;
            }
            case 3: {
                holidayRangeAbbr = TimeNamingUtility.holidayRangeBackAbbr((MospParams)mospParams);
                break;
            }
            case 4: {
                holidayRangeAbbr = TimeNamingUtility.holidayRangeHourAbbr((MospParams)mospParams);
                break;
            }
            default: {
                holidayRangeAbbr = "";
            }
        }
        return holidayRangeAbbr;
    }

    public static float getHolidayTimes(int holidayRange) {
        float holidayTimes = 0.0f;
        switch (holidayRange) {
            case 1: {
                holidayTimes = 1.0f;
                break;
            }
            case 2: 
            case 3: {
                holidayTimes = 0.5f;
                break;
            }
            default: {
                holidayTimes = 0.0f;
            }
        }
        return holidayTimes;
    }

    public static String getStringDaysHoursMinutes(MospParams mospParams, double days, int hours, int minutes, boolean isZeroHyphen) {
        if (isZeroHyphen && days == 0.0 && hours == 0 && minutes == 0) {
            return PfNameUtility.hyphen((MospParams)mospParams);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TimeUtility.getStringNumber((MospParams)mospParams, (double)days, (int)1, (int)4));
        sb.append(PfNameUtility.day((MospParams)mospParams));
        if (hours != 0) {
            sb.append(hours);
            sb.append(PfNameUtility.time((MospParams)mospParams));
        }
        if (minutes != 0) {
            sb.append(minutes);
            sb.append(PfNameUtility.minutes((MospParams)mospParams));
        }
        return sb.toString();
    }

    public static Date getUpdateActivateDate(MospParams mospParams) {
        TimeVo vo = (TimeVo)mospParams.getVo();
        return TimeUtility.getDate((MospParams)mospParams, (String)vo.getTxtUpdateActivateYear(), (String)vo.getTxtUpdateActivateMonth(), (String)vo.getTxtUpdateActivateDay());
    }

    public static Date getDate(MospParams mospParams, String year, String month, String day) {
        try {
            return DateUtility.getDate((String)year, (String)month, (String)day);
        }
        catch (Throwable e) {
            PfMessageUtility.addErrorCheckDate((MospParams)mospParams);
            return null;
        }
    }

    public static String getStringTime(MospParams mospParams, int time, String separator, String suffix) {
        StringBuilder sb = new StringBuilder();
        int hours = TimeUtility.getHours((int)time);
        int minutes = TimeUtility.getMinutes((int)time);
        if (time < 0 && hours == 0) {
            sb.append(PfNameUtility.hyphen((MospParams)mospParams));
        }
        sb.append(hours);
        sb.append(separator);
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMinimumIntegerDigits(2);
        sb.append(format.format(minutes));
        sb.append(suffix);
        return sb.toString();
    }

    public static String getStringTime(MospParams mospParams, int time, String separator) {
        return TimeUtility.getStringTime((MospParams)mospParams, (int)time, (String)separator, (String)"");
    }

    public static String getStringPeriodTime(MospParams mospParams, int time) {
        return TimeUtility.getStringTime((MospParams)mospParams, (int)time, (String)PfNameUtility.period((MospParams)mospParams));
    }

    public static String getStringPeriodTimeOrHyphen(MospParams mospParams, Integer time, boolean needHyphen) {
        if (time == null) {
            return PfNameUtility.hyphen((MospParams)mospParams);
        }
        if (needHyphen && time == 0) {
            return PfNameUtility.hyphen((MospParams)mospParams);
        }
        return TimeUtility.getStringPeriodTime((MospParams)mospParams, (int)time);
    }

    public static String getStringColonTime(MospParams mospParams, int time) {
        return TimeUtility.getStringTime((MospParams)mospParams, (int)time, (String)PfNameUtility.singleColon((MospParams)mospParams));
    }

    public static String getStringJpTime(MospParams mospParams, int time) {
        return TimeUtility.getStringTime((MospParams)mospParams, (int)time, (String)PfNameUtility.time((MospParams)mospParams), (String)PfNameUtility.minutes((MospParams)mospParams));
    }

    public static String getStringHourJpTime(MospParams mospParams, int time) {
        StringBuilder sb = new StringBuilder(TimeUtility.getStringJpTime((MospParams)mospParams, (int)time));
        if (TimeUtility.getMinutes((int)time) == 0) {
            sb.delete(sb.length() - 2 - PfNameUtility.minutes((MospParams)mospParams).length(), sb.length());
        }
        return sb.toString();
    }

    public static String getStringPeriodTimeAndTimes(MospParams mospParams, int time, double times, int fraction) {
        StringBuilder sb = new StringBuilder(TimeUtility.getStringPeriodTime((MospParams)mospParams, (int)time));
        sb.append(PfNameUtility.frontParentheses((MospParams)mospParams));
        sb.append(TimeUtility.getStringNumber((MospParams)mospParams, (double)times, (int)fraction, (int)4));
        sb.append(PfNameUtility.backParentheses((MospParams)mospParams));
        return sb.toString();
    }

    public static String getStringNumber(MospParams mospParams, double number, int fraction, int roundingMode) {
        StringBuilder sb = new StringBuilder("0");
        if (fraction > 0) {
            sb.append(PfNameUtility.period((MospParams)mospParams));
        }
        for (int i = 0; i < fraction; ++i) {
            sb.append("0");
        }
        DecimalFormat format = new DecimalFormat(sb.toString());
        return format.format(TimeUtility.round((double)number, (int)fraction, (int)roundingMode));
    }

    public static String getStringNumberOrHyphen(MospParams mospParams, Double number, int fraction, boolean needHyphen) {
        if (number == null) {
            return PfNameUtility.hyphen((MospParams)mospParams);
        }
        if (needHyphen && number == 0.0) {
            return PfNameUtility.hyphen((MospParams)mospParams);
        }
        return TimeUtility.getStringNumber((MospParams)mospParams, (double)number, (int)fraction, (int)4);
    }

    public static int getAttendanceMinutes(int minutes) {
        if (minutes < 0) {
            return 0;
        }
        if (2879 < minutes) {
            return 2879;
        }
        return minutes;
    }

    public static int getAttendMinutes(Date time, Date workDate) {
        if (time == null) {
            return Integer.MIN_VALUE;
        }
        return TimeUtility.getMinutes((Date)time, (Date)workDate);
    }

    public static int getHours(int time) {
        return time / 60;
    }

    public static int getMinutes(int time) {
        return Math.abs(time) % 60;
    }

    public static int getTime(int hours, int minutes) {
        return hours * 60 + minutes;
    }

    public static int getTime(String hours, String minutes) {
        int intHours = MospUtility.getInt((Object)hours);
        int intMinutes = MospUtility.getInt((Object)minutes);
        return TimeUtility.getTime((int)intHours, (int)intMinutes);
    }

    public static int getTime(String hours) {
        return TimeUtility.getTime((String)hours, (String)"");
    }

    public static boolean isNullTime(Date time) throws MospException {
        return TimeUtility.isNullTime((Date)time, (Date)DateUtility.getDefaultTime());
    }

    public static boolean isNullTime(Date time, Date targetDate) throws MospException {
        return time == null || time.getTime() == targetDate.getTime();
    }

    public static TimeDuration getDuration(Date startTime, Date endTime) {
        Date targetDate = DateUtility.getDate((Date)startTime);
        return TimeDuration.getInstance((int)TimeUtility.getMinutes((Date)startTime, (Date)targetDate), (int)TimeUtility.getMinutes((Date)endTime, (Date)targetDate));
    }

    public static TimeDuration getDuration(Date time) throws MospException {
        return TimeUtility.getDuration((Date)DateUtility.getDefaultTime(), (Date)time);
    }

    public static Map<Integer, TimeDuration> mergeDurations(Map<Integer, TimeDuration> durations1, Map<Integer, TimeDuration> durations2) {
        Map combine1 = TimeUtility.combineDurations(durations1);
        Map combine2 = TimeUtility.combineDurations(durations2);
        if (combine1.isEmpty() || combine2.isEmpty()) {
            combine1.putAll(combine2);
            return combine1;
        }
        for (TimeDuration duration2 : TimeUtility.combineDurations(durations2).values()) {
            combine1.putAll(duration2.getNotOverlap(combine1));
        }
        return TimeUtility.combineDurations((Map)combine1);
    }

    public static Map<Integer, TimeDuration> mergeDurations(Map<Integer, TimeDuration> durations1, Map<Integer, TimeDuration> durations2, Map<Integer, TimeDuration> durations3) {
        Map durations12 = TimeUtility.mergeDurations(durations1, durations2);
        return TimeUtility.mergeDurations((Map)durations12, durations3);
    }

    public static Map<Integer, TimeDuration> mergeDurations(Map<Integer, TimeDuration> durations, TimeDuration duration) {
        TreeMap<Integer, TimeDuration> durations2 = new TreeMap<Integer, TimeDuration>();
        durations2.put(duration.getStartTime(), duration);
        return TimeUtility.mergeDurations(durations, durations2);
    }

    public static Map<Integer, TimeDuration> mergeDurations(Collection<TimeDuration> durations) {
        Map<Integer, Object> merged = new TreeMap<Integer, TimeDuration>();
        for (TimeDuration duration : durations) {
            merged = TimeUtility.mergeDurations(merged, (TimeDuration)duration);
        }
        return merged;
    }

    public static Map<Integer, TimeDuration> sortDurations(Map<Integer, TimeDuration> durations) {
        TreeMap<Integer, TimeDuration> map = new TreeMap<Integer, TimeDuration>();
        if (MospUtility.isEmpty(durations)) {
            return map;
        }
        for (TimeDuration duration : durations.values()) {
            if (!duration.isValid()) continue;
            map.put(duration.getStartTime(), duration);
        }
        return map;
    }

    public static Map<Integer, TimeDuration> combineDurations(Map<Integer, TimeDuration> durations) {
        TreeMap<Integer, TimeDuration> map = new TreeMap<Integer, TimeDuration>();
        for (TimeDuration duration : TimeUtility.sortDurations(durations).values()) {
            int startTime = duration.getStartTime();
            int endTime = duration.getEndTime();
            TimeDuration lastDuration = (TimeDuration)MospUtility.getLastValue(map.values());
            if (lastDuration == null) {
                map.put(startTime, TimeDuration.getInstance((int)startTime, (int)endTime));
                continue;
            }
            if (startTime == lastDuration.getEndTime()) {
                map.put(lastDuration.getStartTime(), TimeDuration.getInstance((int)lastDuration.getStartTime(), (int)endTime));
                continue;
            }
            if (lastDuration.getOverlap(duration).isValid()) {
                endTime = endTime < lastDuration.getEndTime() ? lastDuration.getEndTime() : endTime;
                map.put(lastDuration.getStartTime(), TimeDuration.getInstance((int)lastDuration.getStartTime(), (int)endTime));
                continue;
            }
            map.put(startTime, TimeDuration.getInstance((int)startTime, (int)endTime));
        }
        return map;
    }

    public static int getMinutes(Map<Integer, TimeDuration> durations) {
        int minutes = 0;
        for (TimeDuration duration : TimeUtility.combineDurations(durations).values()) {
            minutes += duration.getMinutes();
        }
        return minutes;
    }

    public static int getReachTime(int startTime, int minutes, Map<Integer, TimeDuration> excludes) {
        int current = startTime;
        int progress = 0;
        if (minutes <= 0) {
            return startTime;
        }
        for (TimeDuration duration : TimeUtility.combineDurations(excludes).values()) {
            if (duration.isContain(current)) {
                current = duration.getEndTime();
                continue;
            }
            if (current < duration.getStartTime()) {
                progress += duration.getStartTime() - current;
                current = duration.getEndTime();
            }
            if (progress < minutes) continue;
            return duration.getStartTime() - (progress - minutes);
        }
        return current + (minutes - progress);
    }

    public static Map<Integer, TimeDuration> getBeforeTimes(Map<Integer, TimeDuration> durations, int targetTime) {
        TreeMap<Integer, TimeDuration> beforeTimes = new TreeMap<Integer, TimeDuration>();
        for (TimeDuration duration : TimeUtility.combineDurations(durations).values()) {
            TimeDuration beforeTime = duration.getBeforeTime(targetTime);
            beforeTimes.put(beforeTime.getStartTime(), beforeTime);
        }
        return TimeUtility.combineDurations(beforeTimes);
    }

    public static Map<Integer, TimeDuration> getAfterTimes(Map<Integer, TimeDuration> durations, int targetTime) {
        TreeMap<Integer, TimeDuration> afterTimes = new TreeMap<Integer, TimeDuration>();
        for (TimeDuration duration : TimeUtility.combineDurations(durations).values()) {
            TimeDuration afterTime = duration.getAfterTime(targetTime);
            afterTimes.put(afterTime.getStartTime(), afterTime);
        }
        return TimeUtility.combineDurations(afterTimes);
    }

    public static TimeDuration getContainTime(Map<Integer, TimeDuration> durations, int targetTime) {
        for (TimeDuration duration : TimeUtility.combineDurations(durations).values()) {
            if (!duration.isContain(targetTime)) continue;
            return duration;
        }
        return TimeDuration.getInvalid();
    }

    public static Map<Integer, TimeDuration> removeTime(Map<Integer, TimeDuration> durations, int time) {
        TreeMap<Integer, TimeDuration> removedTimes = new TreeMap<Integer, TimeDuration>();
        int remain = time;
        for (TimeDuration duration : TimeUtility.combineDurations(durations).values()) {
            if (remain == 0) {
                removedTimes.put(duration.getStartTime(), duration);
                continue;
            }
            int minutes = duration.getMinutes();
            if (minutes <= remain) {
                remain -= minutes;
                continue;
            }
            int startTime = duration.getStartTime() + remain;
            remain = 0;
            removedTimes.put(startTime, TimeDuration.getInstance((int)startTime, (int)duration.getEndTime()));
        }
        return TimeUtility.combineDurations(removedTimes);
    }

    public static Map<Integer, TimeDuration> getReachTimes(Map<Integer, TimeDuration> durations, int time) {
        Map removeBefore = TimeUtility.removeTime(durations, (int)time);
        return TimeUtility.getNotOverlap(durations, (Map)removeBefore);
    }

    public static Map<Integer, TimeDuration> getNotOverlap(Map<Integer, TimeDuration> durations, TimeDuration targetDuration) {
        TreeMap<Integer, TimeDuration> notOverlaps = new TreeMap<Integer, TimeDuration>();
        for (TimeDuration duration : TimeUtility.combineDurations(durations).values()) {
            notOverlaps.putAll(duration.getNotOverlap(targetDuration));
        }
        return notOverlaps;
    }

    public static Map<Integer, TimeDuration> getNotOverlap(Map<Integer, TimeDuration> durations, Map<Integer, TimeDuration> targetDurations) {
        TreeMap<Integer, TimeDuration> notOverlaps = new TreeMap<Integer, TimeDuration>();
        for (TimeDuration duration : TimeUtility.combineDurations(durations).values()) {
            notOverlaps.putAll(duration.getNotOverlap(targetDurations));
        }
        return notOverlaps;
    }

    public static Map<Integer, TimeDuration> getOverlap(Map<Integer, TimeDuration> durations, Map<Integer, TimeDuration> targetDurations) {
        TreeMap<Integer, TimeDuration> overlaps = new TreeMap<Integer, TimeDuration>();
        for (TimeDuration duration : TimeUtility.combineDurations(durations).values()) {
            overlaps.putAll(duration.getOverlap(targetDurations));
        }
        return overlaps;
    }

    public static boolean isOverlap(Collection<TimeDuration> durations) {
        if (durations == null) {
            return false;
        }
        int minutes = 0;
        for (TimeDuration duration : durations) {
            minutes += duration.getMinutes();
        }
        return TimeUtility.getMinutes((Map)TimeUtility.mergeDurations(durations)) < minutes;
    }

    public static boolean isApart(Map<Integer, TimeDuration> durations, TimeDuration duration) {
        for (TimeDuration notOverlap : TimeUtility.getNotOverlap(durations, (TimeDuration)duration).values()) {
            if (duration.isLink(notOverlap)) continue;
            return true;
        }
        return false;
    }

    public static Map<Integer, TimeDuration> getGap(Map<Integer, TimeDuration> durations) {
        TimeDuration duration = TimeUtility.getDuration(durations);
        return duration.getNotOverlap(durations);
    }

    public static TimeDuration getDuration(Map<Integer, TimeDuration> durations) {
        if (durations.isEmpty()) {
            return TimeDuration.getInvalid();
        }
        int startTime = Integer.MAX_VALUE;
        int endTime = 0;
        for (TimeDuration duration : TimeUtility.combineDurations(durations).values()) {
            if (duration.getStartTime() < startTime) {
                startTime = duration.getStartTime();
            }
            if (endTime >= duration.getEndTime()) continue;
            endTime = duration.getEndTime();
        }
        return TimeDuration.getInstance((int)startTime, (int)endTime);
    }

    public static Map<Integer, TimeDuration> getDurations(Map<String, Object> params, String key) {
        Map obj = (Map)MospUtility.getValue(params, (String)key);
        if (obj == null) {
            return Collections.emptyMap();
        }
        return obj;
    }

    public static void addDurations(Map<String, Object> params, String key, Map<Integer, TimeDuration> durations) {
        Map current = TimeUtility.getDurations(params, (String)key);
        Map merged = TimeUtility.mergeDurations((Map)current, durations);
        params.put(key, merged);
    }

    public static int getLegalWorkTime(MospParams mospParams) {
        return mospParams.getApplicationProperty("LegalWorkTime", 480);
    }

    public static int getLegalWeeklyWorkTime(MospParams mospParams) {
        return mospParams.getApplicationProperty("LegalWeeklyWorkTime", 2400);
    }

    public static int getNextDayStart() {
        return 1440;
    }

    public static int getNextDayEnd() {
        return TimeUtility.getNextDayStart() * 2;
    }

    public static int getNightStart(int idx) {
        int nightStart = 1320;
        nightStart = (idx - 1) * TimeUtility.getNextDayStart() + nightStart;
        return nightStart < 0 ? 0 : nightStart;
    }

    public static int getNightEnd(int idx) {
        int nightEnd = 1740;
        nightEnd = (idx - 1) * TimeUtility.getNextDayStart() + nightEnd;
        return nightEnd < TimeUtility.getNextDayEnd() ? nightEnd : TimeUtility.getNextDayEnd();
    }

    public static int getExportTimeFormat(MospParams mospParams) {
        return mospParams.getApplicationProperty("ExportTimeFormat", 0);
    }

    public static String getExportTime(MospParams mospParams, int minute, int format) {
        if (format == 0) {
            return Integer.toString(minute);
        }
        if (format == 1) {
            return TimeUtility.getExportTimeHour((int)minute);
        }
        if (format == 2) {
            return TimeUtility.getStringColonTime((MospParams)mospParams, (int)minute);
        }
        if (format == 3) {
            return TimeUtility.getStringPeriodTime((MospParams)mospParams, (int)minute);
        }
        return "";
    }

    public static String getExportTimeHour(int minute) {
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(TimeUtility.getRoundHalfUp2((double)TimeUtility.getMinuteToHour((double)minute)));
    }

    public static String getExportFileName(MospParams mospParams, ExportDtoInterface dto, Date firstDate, Date lastDate) {
        StringBuilder sb = new StringBuilder();
        sb.append(dto.getExportCode());
        sb.append(PfNameUtility.hyphen((MospParams)mospParams));
        sb.append(DateUtility.getStringDateNoSeparator((Date)firstDate));
        sb.append(PfNameUtility.hyphen((MospParams)mospParams));
        sb.append(DateUtility.getStringDateNoSeparator((Date)lastDate));
        sb.append(PlatformUtility.getFileExtension((ExportDtoInterface)dto));
        return sb.toString();
    }

    public static boolean isRestRegistered(Collection<RestDtoInterface> rests, Date workDate) {
        Date standardTime = DateUtility.getDate((Date)workDate);
        for (RestDtoInterface dto : rests) {
            if (!DateUtility.isSame((Date)standardTime, (Date)dto.getRestStart())) {
                return true;
            }
            if (DateUtility.isSame((Date)standardTime, (Date)dto.getRestEnd())) continue;
            return true;
        }
        return false;
    }

    public static String getWorkOnHolidayWorkType(WorkOnHolidayRequestDtoInterface dto) {
        String workTypeCode = "";
        int substitute = dto.getSubstitute();
        String workOnHolidayType = dto.getWorkOnHolidayType();
        if (substitute == 5) {
            workTypeCode = dto.getWorkTypeCode();
        }
        if (substitute == 2) {
            if (MospUtility.isEqual((Object)workOnHolidayType, (Object)"prescribed_holiday")) {
                workTypeCode = "work_on_prescribed";
            }
            if (MospUtility.isEqual((Object)workOnHolidayType, (Object)"legal_holiday")) {
                workTypeCode = "work_on_legal";
            }
        }
        return workTypeCode;
    }

    public static Set<Date> getSubstituteWorkDates(Map<Date, WorkOnHolidayRequestDtoInterface> workOnHolidayRequests, Map<Long, WorkflowDtoInterface> workflows) {
        TreeSet<Date> substituteWorkDates = new TreeSet<Date>();
        for (Map.Entry<Date, WorkOnHolidayRequestDtoInterface> entry : workOnHolidayRequests.entrySet()) {
            Date workDate = entry.getKey();
            WorkOnHolidayRequestDtoInterface dto = entry.getValue();
            WorkflowDtoInterface workflow = workflows.get(dto.getWorkflow());
            if (!WorkflowUtility.isMatch((WorkflowDtoInterface)workflow, (Set)WorkflowUtility.getEffectiveStatuses())) continue;
            if (!TimeUtility.isTheSubstitute((WorkOnHolidayRequestDtoInterface)dto, (int[])new int[]{1, 3, 4})) continue;
            substituteWorkDates.add(workDate);
        }
        return substituteWorkDates;
    }

    public static boolean isTheSubstitute(WorkOnHolidayRequestDtoInterface dto, int ... substitutes) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto, substitutes})) {
            return false;
        }
        for (int substitute : substitutes) {
            if (dto.getSubstitute() != substitute) continue;
            return true;
        }
        return false;
    }

    public static Map<String, LimitStandardDtoInterface> getLimitStandards(Collection<LimitStandardDtoInterface> dtos) {
        TreeMap<String, LimitStandardDtoInterface> map = new TreeMap<String, LimitStandardDtoInterface>();
        if (MospUtility.isEmpty(dtos)) {
            return map;
        }
        for (LimitStandardDtoInterface dto : dtos) {
            map.put(dto.getTerm(), dto);
        }
        return map;
    }

    public static int calcWeeklyOverFortyIn(int overtimeIn, int overtimeInNoWeeklyForty) {
        return overtimeInNoWeeklyForty - overtimeIn;
    }

    public static int calcWeeklyOverFortyNormal(int weeklyOverForty, int overtimeIn, int overtimeInNoWeeklyForty) {
        return weeklyOverForty - TimeUtility.calcWeeklyOverFortyIn((int)overtimeIn, (int)overtimeInNoWeeklyForty);
    }
}

