/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.utils;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.dto.base.WorkflowNumberDtoInterface;
import jp.mosp.time.dto.base.HolidayRangeDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimeRequestUtility {
    private TimeRequestUtility() {
    }

    public static final boolean isPaidHoliday(HolidayRequestDtoInterface dto) {
        return TimeRequestUtility.isTheHolidayType((HolidayRequestDtoInterface)dto, (int)1, (String)"1");
    }

    public static final boolean isStockHoliday(HolidayRequestDtoInterface dto) {
        return TimeRequestUtility.isTheHolidayType((HolidayRequestDtoInterface)dto, (int)1, (String)"2");
    }

    public static final boolean isSpecialHoliday(HolidayRequestDtoInterface dto) {
        return TimeRequestUtility.isTheHolidayType1((HolidayRequestDtoInterface)dto, (int)2);
    }

    public static final boolean isOtherHoliday(HolidayRequestDtoInterface dto) {
        return TimeRequestUtility.isTheHolidayType1((HolidayRequestDtoInterface)dto, (int)3);
    }

    public static final boolean isAbsenece(HolidayRequestDtoInterface dto) {
        return TimeRequestUtility.isTheHolidayType1((HolidayRequestDtoInterface)dto, (int)4);
    }

    protected static final boolean isTheHolidayType1(HolidayRequestDtoInterface dto, int holidayType1) {
        if (dto == null) {
            return false;
        }
        return dto.getHolidayType1() == holidayType1;
    }

    protected static final boolean isTheHolidayType2(HolidayRequestDtoInterface dto, String holidayType2) {
        if (dto == null || MospUtility.isEmpty((String[])new String[]{dto.getHolidayType2()})) {
            return false;
        }
        return dto.getHolidayType2().equals(holidayType2);
    }

    protected static final boolean isTheHolidayType(HolidayRequestDtoInterface dto, int holidayType1, String holidayType2) {
        if (MospUtility.isEmpty((String[])new String[]{holidayType2})) {
            return TimeRequestUtility.isTheHolidayType1((HolidayRequestDtoInterface)dto, (int)holidayType1);
        }
        return TimeRequestUtility.isTheHolidayType1((HolidayRequestDtoInterface)dto, (int)holidayType1) && TimeRequestUtility.isTheHolidayType2((HolidayRequestDtoInterface)dto, (String)holidayType2);
    }

    public static boolean isHolidayRangeAll(HolidayRangeDtoInterface dto) {
        return TimeRequestUtility.isTheHolidayRange((HolidayRangeDtoInterface)dto, (int)1);
    }

    public static boolean isHolidayRangeAm(HolidayRangeDtoInterface dto) {
        return TimeRequestUtility.isTheHolidayRange((HolidayRangeDtoInterface)dto, (int)2);
    }

    public static boolean isHolidayRangePm(HolidayRangeDtoInterface dto) {
        return TimeRequestUtility.isTheHolidayRange((HolidayRangeDtoInterface)dto, (int)3);
    }

    public static boolean isHolidayRangeHalf(HolidayRangeDtoInterface dto) {
        return TimeRequestUtility.isHolidayRangeAm((HolidayRangeDtoInterface)dto) || TimeRequestUtility.isHolidayRangePm((HolidayRangeDtoInterface)dto);
    }

    public static boolean isHolidayRangeHour(HolidayRangeDtoInterface dto) {
        return TimeRequestUtility.isTheHolidayRange((HolidayRangeDtoInterface)dto, (int)4);
    }

    public static boolean hasHolidayRangeAll(Collection<? extends HolidayRangeDtoInterface> dtos) {
        return TimeRequestUtility.hasTheHolidayRange(dtos, (int)1);
    }

    public static boolean hasHolidayRangeAm(Collection<? extends HolidayRangeDtoInterface> dtos) {
        return TimeRequestUtility.hasTheHolidayRange(dtos, (int)2);
    }

    public static boolean hasHolidayRangePm(Collection<? extends HolidayRangeDtoInterface> dtos) {
        return TimeRequestUtility.hasTheHolidayRange(dtos, (int)3);
    }

    protected static boolean isTheHolidayRange(HolidayRangeDtoInterface dto, int holidayRange) {
        if (dto == null) {
            return false;
        }
        return dto.getHolidayRange() == holidayRange;
    }

    protected static boolean hasTheHolidayRange(Collection<? extends HolidayRangeDtoInterface> dtos, int holidayRange) {
        for (HolidayRangeDtoInterface holidayRangeDtoInterface : dtos) {
            if (!TimeRequestUtility.isTheHolidayRange((HolidayRangeDtoInterface)holidayRangeDtoInterface, (int)holidayRange)) continue;
            return true;
        }
        return false;
    }

    public static String getAllHolidayAbbr(Collection<HolidayRequestDtoInterface> dtos, Collection<HolidayDtoInterface> holidays, MospParams mospParams) {
        return TimeRequestUtility.getTheHolidayRangeAbbr(dtos, (int)1, holidays, (MospParams)mospParams);
    }

    public static String getAmHolidayAbbr(Collection<HolidayRequestDtoInterface> dtos, Collection<HolidayDtoInterface> holidays, MospParams mospParams) {
        return TimeRequestUtility.getTheHolidayRangeAbbr(dtos, (int)2, holidays, (MospParams)mospParams);
    }

    public static String getPmHolidayAbbr(Collection<HolidayRequestDtoInterface> dtos, Collection<HolidayDtoInterface> holidays, MospParams mospParams) {
        return TimeRequestUtility.getTheHolidayRangeAbbr(dtos, (int)3, holidays, (MospParams)mospParams);
    }

    public static <T extends HolidayRangeDtoInterface & WorkflowNumberDtoInterface> Long getTheHolidayRangeWorkflow(Collection<T> dtos, int holidayRange) {
        HolidayRangeDtoInterface dto = TimeRequestUtility.getTheHolidayRangeDto(dtos, (int)holidayRange);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return null;
        }
        return ((WorkflowNumberDtoInterface)dto).getWorkflow();
    }

    public static <T extends HolidayRangeDtoInterface> T getTheHolidayRangeDto(Collection<T> dtos, int holidayRange) {
        for (HolidayRangeDtoInterface dto : dtos) {
            if (!TimeRequestUtility.isTheHolidayRange((HolidayRangeDtoInterface)dto, (int)holidayRange)) continue;
            return (T)dto;
        }
        return null;
    }

    protected static String getTheHolidayRangeAbbr(Collection<HolidayRequestDtoInterface> dtos, int holidayRange, Collection<HolidayDtoInterface> holidays, MospParams mospParams) {
        HolidayRequestDtoInterface dto = (HolidayRequestDtoInterface)TimeRequestUtility.getTheHolidayRangeDto(dtos, (int)holidayRange);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return "";
        }
        int holidayType = dto.getHolidayType1();
        String holidayCode = dto.getHolidayType2();
        return TimeUtility.getHolidayAbbr(holidays, (String)holidayCode, (int)holidayType, (MospParams)mospParams);
    }

    public static float getDays(HolidayRangeDtoInterface dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return 0.0f;
        }
        return TimeRequestUtility.getDays((int)dto.getHolidayRange());
    }

    public static float getDays(int holidayRange) {
        if (holidayRange == 1) {
            return 1.0f;
        }
        if (holidayRange == 2 || holidayRange == 3) {
            return 0.5f;
        }
        return 0.0f;
    }

    public static String getAllSubHolidayAbbr(Collection<SubHolidayRequestDtoInterface> dtos, MospParams mospParams) {
        SubHolidayRequestDtoInterface dto = (SubHolidayRequestDtoInterface)TimeRequestUtility.getTheHolidayRangeDto(dtos, (int)1);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return "";
        }
        int subHolidayType = dto.getWorkDateSubHolidayType();
        return TimeRequestUtility.getSubHolidayAbbr((int)subHolidayType, (MospParams)mospParams);
    }

    public static String getSubHolidayAbbr(int subHolidayType, MospParams mospParams) {
        switch (subHolidayType) {
            case 1: 
            case 3: {
                return TimeNamingUtility.prescribedSubHolidayAbbr((MospParams)mospParams);
            }
            case 2: {
                return TimeNamingUtility.legalSubHolidayAbbr((MospParams)mospParams);
            }
        }
        return "";
    }

    public static String getSubHolidayTypeName(int subHolidayType, MospParams mospParams) {
        switch (subHolidayType) {
            case 1: {
                return TimeNamingUtility.prescribedSubHoliday((MospParams)mospParams);
            }
            case 2: {
                return TimeNamingUtility.legalSubHoliday((MospParams)mospParams);
            }
            case 3: {
                return TimeNamingUtility.midnightSubHoliday((MospParams)mospParams);
            }
        }
        return "";
    }

    public static String getSubHolidayTypeAbbr(int subHolidayType, MospParams mospParams) {
        switch (subHolidayType) {
            case 1: {
                return TimeNamingUtility.prescribed((MospParams)mospParams);
            }
            case 2: {
                return TimeNamingUtility.legal((MospParams)mospParams);
            }
            case 3: {
                return TimeNamingUtility.midnight((MospParams)mospParams);
            }
        }
        return "";
    }

    public static String getSubHolidayDaysAbbr(double subHolidayDays, MospParams mospParams) {
        if (MospUtility.compare((double)subHolidayDays, (double)1.0) == 0) {
            return TimeNamingUtility.holidayRangeAll((MospParams)mospParams);
        }
        if (MospUtility.compare((double)subHolidayDays, (double)0.5) == 0) {
            return TimeNamingUtility.holidayHalf((MospParams)mospParams);
        }
        return "";
    }

    public static String getSubstituteAbbr(String substituteType, MospParams mospParams) {
        if (TimeUtility.isLegalHoliday((String)substituteType)) {
            return TimeNamingUtility.legalSubstituteAbbr((MospParams)mospParams);
        }
        if (TimeUtility.isPrescribedHoliday((String)substituteType)) {
            return TimeNamingUtility.prescribedSubstituteAbbr((MospParams)mospParams);
        }
        return "";
    }

    public static String getSubstituteRangeName(SubstituteDtoInterface dto, MospParams mospParams) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return "";
        }
        int ranget = dto.getSubstituteRange();
        if (TimeRequestUtility.isHolidayRangeAll((HolidayRangeDtoInterface)dto)) {
            return MospUtility.getCodeName((MospParams)mospParams, (int)ranget, (String)"SubstituteWorkRange");
        }
        if (TimeRequestUtility.isHolidayRangeHalf((HolidayRangeDtoInterface)dto)) {
            return MospUtility.getCodeName((MospParams)mospParams, (int)ranget, (String)"SubstituteHolidayRange");
        }
        return "";
    }

    public static int totalPaidHolidayHours(Collection<HolidayRequestDtoInterface> dtos) {
        return TimeRequestUtility.totalHolidayHours(dtos, (int)1, (String)"1");
    }

    public static int totalSpecialHolidayHours(Collection<HolidayRequestDtoInterface> dtos) {
        return TimeRequestUtility.totalHolidayHours(dtos, (int)2);
    }

    public static int totalOtherHolidayHours(Collection<HolidayRequestDtoInterface> dtos) {
        return TimeRequestUtility.totalHolidayHours(dtos, (int)3);
    }

    public static int totalAbsenceHolidayHours(Collection<HolidayRequestDtoInterface> dtos) {
        return TimeRequestUtility.totalHolidayHours(dtos, (int)4);
    }

    protected static int totalHolidayHours(Collection<HolidayRequestDtoInterface> dtos, int holidayType1, String holidayType2) {
        int holidayHours = 0;
        for (HolidayRequestDtoInterface dto : dtos) {
            if (!TimeRequestUtility.isTheHolidayType((HolidayRequestDtoInterface)dto, (int)holidayType1, (String)holidayType2) || !TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)dto)) continue;
            holidayHours += dto.getUseHour();
        }
        return holidayHours;
    }

    protected static int totalHolidayHours(Collection<HolidayRequestDtoInterface> dtos, int holidayType1) {
        return TimeRequestUtility.totalHolidayHours(dtos, (int)holidayType1, (String)"");
    }

    public static float totalPaidHolidayDays(Collection<HolidayRequestDtoInterface> dtos) {
        return TimeRequestUtility.totalHolidayDays(dtos, (int)1, (String)"1");
    }

    public static float totalStockHolidayDays(Collection<HolidayRequestDtoInterface> dtos) {
        return TimeRequestUtility.totalHolidayDays(dtos, (int)1, (String)"2");
    }

    public static float totalSpecialHolidayDays(Collection<HolidayRequestDtoInterface> dtos) {
        return TimeRequestUtility.totalHolidayDays(dtos, (int)2);
    }

    public static float totalOtherHolidayDays(Collection<HolidayRequestDtoInterface> dtos) {
        return TimeRequestUtility.totalHolidayDays(dtos, (int)3);
    }

    public static float totalAbsenceDays(Collection<HolidayRequestDtoInterface> dtos) {
        return TimeRequestUtility.totalHolidayDays(dtos, (int)4);
    }

    protected static float totalHolidayDays(Collection<HolidayRequestDtoInterface> dtos, int holidayType1, String holidayType2) {
        float holidayDays = 0.0f;
        for (HolidayRequestDtoInterface dto : dtos) {
            if (!TimeRequestUtility.isTheHolidayType((HolidayRequestDtoInterface)dto, (int)holidayType1, (String)holidayType2)) continue;
            holidayDays += TimeRequestUtility.getDays((HolidayRangeDtoInterface)dto);
        }
        return holidayDays;
    }

    protected static float totalHolidayDays(Collection<HolidayRequestDtoInterface> dtos, int holidayType1) {
        return TimeRequestUtility.totalHolidayDays(dtos, (int)holidayType1, (String)"");
    }

    protected static final boolean isTheSubHolidayType(SubHolidayRequestDtoInterface dto, int subHolidayType) {
        if (dto == null) {
            return false;
        }
        return dto.getWorkDateSubHolidayType() == subHolidayType;
    }

    public static float totalSubHolidayDays(Collection<SubHolidayRequestDtoInterface> dtos) {
        return TimeRequestUtility.totalSubHolidayDays(dtos, null);
    }

    public static float totalLegalSubHolidayDays(Collection<SubHolidayRequestDtoInterface> dtos) {
        return TimeRequestUtility.totalSubHolidayDays(dtos, (Integer)2);
    }

    public static float totalPrescribedSubHolidayDays(Collection<SubHolidayRequestDtoInterface> dtos) {
        return TimeRequestUtility.totalSubHolidayDays(dtos, (Integer)1);
    }

    public static float totalNightSubHolidayDays(Collection<SubHolidayRequestDtoInterface> dtos) {
        return TimeRequestUtility.totalSubHolidayDays(dtos, (Integer)3);
    }

    protected static float totalSubHolidayDays(Collection<SubHolidayRequestDtoInterface> dtos, Integer subHolidayType) {
        float subHolidayDays = 0.0f;
        for (SubHolidayRequestDtoInterface dto : dtos) {
            if (subHolidayType != null && !TimeRequestUtility.isTheSubHolidayType((SubHolidayRequestDtoInterface)dto, (int)subHolidayType)) continue;
            subHolidayDays += TimeRequestUtility.getDays((HolidayRangeDtoInterface)dto);
        }
        return subHolidayDays;
    }

    public static boolean isWorkOnHolidaySubstituteOff(WorkOnHolidayRequestDtoInterface dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return false;
        }
        return dto.getSubstitute() == 2;
    }

    public static boolean isWorkOnHolidaySubstitute(WorkOnHolidayRequestDtoInterface dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return false;
        }
        return MospUtility.isContain((int)dto.getSubstitute(), (int[])new int[]{1, 3, 4, 5});
    }

    public static boolean isWorkOnHolidayHalfSubstitute(WorkOnHolidayRequestDtoInterface dto) {
        return TimeRequestUtility.isWorkOnHolidayAnteSubstitute((WorkOnHolidayRequestDtoInterface)dto) || TimeRequestUtility.isWorkOnHolidayPostSubstitute((WorkOnHolidayRequestDtoInterface)dto);
    }

    public static boolean isWorkOnHolidayAnteSubstitute(WorkOnHolidayRequestDtoInterface dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return false;
        }
        return dto.getSubstitute() == 3;
    }

    public static boolean isWorkOnHolidayPostSubstitute(WorkOnHolidayRequestDtoInterface dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return false;
        }
        return dto.getSubstitute() == 4;
    }

    public static boolean isConsecutiveHolidays(HolidayRequestDtoInterface dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return false;
        }
        return !DateUtility.isSame((Date)dto.getRequestStartDate(), (Date)dto.getRequestEndDate());
    }

    public static boolean isNotHolidayForConsecutiveHolidays(String workTypeCode) {
        return TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalOrPrescribedHoliday((String)workTypeCode);
    }

    public static boolean isConsecutiveHolidaysExist(Collection<HolidayRequestDtoInterface> dtos) {
        for (HolidayRequestDtoInterface dto : dtos) {
            if (!TimeRequestUtility.isConsecutiveHolidays((HolidayRequestDtoInterface)dto)) continue;
            return true;
        }
        return false;
    }

    public static String getDifferenceTypeAbbr(DifferenceRequestDtoInterface dto, MospParams mospParams) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return "";
        }
        return TimeRequestUtility.getDifferenceTypeAbbr((String)dto.getDifferenceType(), (MospParams)mospParams);
    }

    public static String getDifferenceTypeAbbr(String differenceType, MospParams mospParams) {
        if (MospUtility.isEmpty((String[])new String[]{differenceType})) {
            return "";
        }
        if (MospUtility.isEqual((Object)differenceType, (Object)"a")) {
            return TimeNamingUtility.charaA((MospParams)mospParams);
        }
        if (MospUtility.isEqual((Object)differenceType, (Object)"b")) {
            return TimeNamingUtility.charaB((MospParams)mospParams);
        }
        if (MospUtility.isEqual((Object)differenceType, (Object)"c")) {
            return TimeNamingUtility.charaC((MospParams)mospParams);
        }
        if (MospUtility.isEqual((Object)differenceType, (Object)"d")) {
            return TimeNamingUtility.charaD((MospParams)mospParams);
        }
        if (MospUtility.isEqual((Object)differenceType, (Object)"s")) {
            return TimeNamingUtility.charaS((MospParams)mospParams);
        }
        return differenceType;
    }

    public static Set<HolidayRequestDtoInterface> getStartedHolidayRequests(Collection<HolidayRequestDtoInterface> dtos, Date targetDate) {
        LinkedHashSet<HolidayRequestDtoInterface> startedRequests = new LinkedHashSet<HolidayRequestDtoInterface>();
        if (MospUtility.isEmpty(dtos)) {
            return startedRequests;
        }
        if (MospUtility.isEmpty((Object[])new Object[]{targetDate})) {
            startedRequests.addAll(dtos);
            return startedRequests;
        }
        for (HolidayRequestDtoInterface dto : dtos) {
            if (dto.getRequestStartDate().after(targetDate)) continue;
            startedRequests.add(dto);
        }
        return startedRequests;
    }
}

