/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.utils.MonthUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class HolidayUtility {
    protected static final String NAM_COMING_OF_AGE_DAY = "ComingOfAgeDay";
    protected static final String NAM_MARINE_DAY = "MarineDay";
    protected static final String NAM_MOUNT_DAY = "MountDay";
    protected static final String NAM_RESPECT_FOR_THE_AGED_DAY = "RespectForTheAgedDay";
    protected static final String NAM_SPORTS_DAY = "SportsDay";
    protected static final String NAM_SPORTS_DAY_OLD = "SportsDayOld";
    protected static final String NAM_VERNAL_EQUINOX_DAY = "VernalEquinoxDay";
    protected static final String NAM_AUTUMNAL_EQUINOX_DAY = "AutumnalEquinoxDay";
    protected static final String NAM_NEW_YEARS_DAY = "NewYearsDay";
    protected static final String NAM_NATIONAL_FOUNDATION_DAY = "NationalFoundationDay";
    protected static final String NAM_SHOWA_DAY = "ShowaDay";
    protected static final String NAM_CONSTITUTION_DAY = "ConstitutionDay";
    protected static final String NAM_GREENERY_DAY = "GreeneryDay";
    protected static final String NAM_CHILDRENS_DAY = "ChildrensDay";
    protected static final String NAM_CULTURE_DAY = "CultureDay";
    protected static final String NAM_LABOR_THANKSGIVING_DAY = "LaborThanksgivingDay";
    protected static final String NAM_EMPERORS_BIRTHDAY = "EmperorsBirthday";
    protected static final String NAM_PEOPLES_DAY = "PeoplesDay";
    protected static final String NAM_OBSERVED_HOLIDAY = "ObservedHoliday";
    protected static final String NAM_ACCESSION_DAY = "AccessionDay";
    protected static final String NAM_CORONATION_CEREMONY = "CoronationCeremony";
    static Map<Integer, Map<Date, String>> holidayMap;

    private HolidayUtility() {
    }

    public static boolean isHoliday(Date targetDate, MospParams mospParams) throws MospException {
        int fisicalYear = MonthUtility.getFiscalYear((Date)targetDate, (MospParams)mospParams);
        Map map = HolidayUtility.getHolidayMap((int)fisicalYear, (MospParams)mospParams);
        return map.get(targetDate) != null;
    }

    public static Map<Date, String> getHolidayMap(int fiscalYear, MospParams mospParams) throws MospException {
        if (holidayMap == null) {
            holidayMap = new HashMap();
        }
        if (holidayMap.get(fiscalYear) != null) {
            return (Map)holidayMap.get(fiscalYear);
        }
        HolidayUtility.createHolidayMap((int)fiscalYear, (MospParams)mospParams);
        return (Map)holidayMap.get(fiscalYear);
    }

    public static String getWorkDayOfWeekStyle(Date targetDate, MospParams mospParams) throws MospException {
        if (HolidayUtility.isHoliday((Date)targetDate, (MospParams)mospParams)) {
            return "style=\"color: red\"";
        }
        if (DateUtility.isSaturday((Date)targetDate)) {
            return "style=\"color: blue\"";
        }
        if (DateUtility.isSunday((Date)targetDate)) {
            return "style=\"color: red\"";
        }
        return "";
    }

    public static Calendar getCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    protected static void createHolidayMap(int year, MospParams mospParams) throws MospException {
        TreeMap<Date, String> map = new TreeMap<Date, String>();
        map.put(HolidayUtility.getNewYearsDay((int)year, (MospParams)mospParams), mospParams.getName("NewYearsDay"));
        map.put(HolidayUtility.getComingOfAgeDay((int)year, (MospParams)mospParams), mospParams.getName("ComingOfAgeDay"));
        map.put(HolidayUtility.getNationalFoundationDay((int)year, (MospParams)mospParams), mospParams.getName("NationalFoundationDay"));
        map.put(HolidayUtility.getVernalEquinoxDay((int)year, (MospParams)mospParams), mospParams.getName("VernalEquinoxDay"));
        map.put(HolidayUtility.getShowaDay((int)year, (MospParams)mospParams), mospParams.getName("ShowaDay"));
        map.put(HolidayUtility.getConstitutionDay((int)year, (MospParams)mospParams), mospParams.getName("ConstitutionDay"));
        map.put(HolidayUtility.getGreeneryDay((int)year, (MospParams)mospParams), mospParams.getName("GreeneryDay"));
        map.put(HolidayUtility.getChildrensDay((int)year, (MospParams)mospParams), mospParams.getName("ChildrensDay"));
        map.put(HolidayUtility.getMarineDay((int)year, (MospParams)mospParams), mospParams.getName("MarineDay"));
        int mountainSwitchYear = 2016;
        if (HolidayUtility.getYear((int)year, (int)7, (MospParams)mospParams) >= 2016) {
            map.put(HolidayUtility.getMountDay((int)year, (MospParams)mospParams), mospParams.getName("MountDay"));
        }
        map.put(HolidayUtility.getRespectForTheAgedDay((int)year, (MospParams)mospParams), mospParams.getName("RespectForTheAgedDay"));
        map.put(HolidayUtility.getAutumnalEquinoxDay((int)year, (MospParams)mospParams), mospParams.getName("AutumnalEquinoxDay"));
        map.put(HolidayUtility.getSportsDay((int)year, (MospParams)mospParams), HolidayUtility.getSportsDayName((int)year, (MospParams)mospParams));
        map.put(HolidayUtility.getCultureDay((int)year, (MospParams)mospParams), mospParams.getName("CultureDay"));
        map.put(HolidayUtility.getLaborThanksgivingDay((int)year, (MospParams)mospParams), mospParams.getName("LaborThanksgivingDay"));
        map.put(HolidayUtility.getEmperorsBirthday((int)year, (MospParams)mospParams), mospParams.getName("EmperorsBirthday"));
        int heiseiEndYear = 2019;
        if (HolidayUtility.getYear((int)year, (int)4, (MospParams)mospParams) == 2019) {
            map.put(HolidayUtility.getAccessionDay((int)year, (MospParams)mospParams), mospParams.getName("AccessionDay"));
        }
        if (HolidayUtility.getYear((int)year, (int)9, (MospParams)mospParams) == 2019) {
            map.put(HolidayUtility.getCoronationCeremony((int)year, (MospParams)mospParams), mospParams.getName("CoronationCeremony"));
        }
        holidayMap.put(year, map);
        HolidayUtility.addSubstituteDate((int)year, map, (MospParams)mospParams);
    }

    protected static void addSubstituteDate(int year, Map<Date, String> map, MospParams mospParams) {
        Calendar cal = HolidayUtility.getCalendar();
        Set<Date> keySet = map.keySet();
        HashMap<Date, String> addMap = new HashMap<Date, String>();
        Date formerHoliday = null;
        for (Date date : keySet) {
            if (DateUtility.isSunday((Date)date)) {
                cal.setTime(date);
                cal.add(5, 1);
                while (map.containsKey(cal.getTime())) {
                    cal.add(5, 1);
                }
                if (!map.containsKey(cal.getTime())) {
                    addMap.put(cal.getTime(), mospParams.getName("ObservedHoliday"));
                }
            }
            if (formerHoliday != null) {
                cal.setTime(formerHoliday);
                cal.add(5, 2);
                if (cal.getTime().compareTo(date) == 0) {
                    cal.add(5, -1);
                    addMap.put(cal.getTime(), mospParams.getName("PeoplesDay"));
                }
            }
            formerHoliday = date;
        }
        map.putAll(addMap);
    }

    protected static Date getComingOfAgeDay(int year, MospParams mospParams) throws MospException {
        int targetYear = HolidayUtility.getYear((int)year, (int)0, (MospParams)mospParams);
        int switchYear = 2000;
        Calendar cal = HolidayUtility.getCalendar();
        cal.set(1, targetYear);
        cal.set(2, 0);
        if (targetYear < 2000) {
            cal.set(5, 15);
        } else {
            cal.set(7, 2);
            cal.set(8, 2);
        }
        return cal.getTime();
    }

    protected static Date getMarineDay(int year, MospParams mospParams) throws MospException {
        int targetYear = HolidayUtility.getYear((int)year, (int)6, (MospParams)mospParams);
        int switchYear = 2003;
        int specialYear2020 = 2020;
        int specialYear2021 = 2021;
        Calendar cal = HolidayUtility.getCalendar();
        cal.set(1, targetYear);
        cal.set(2, 6);
        if (targetYear < 2003) {
            cal.set(5, 20);
        } else if (targetYear == 2020) {
            cal.set(5, 23);
        } else if (targetYear == 2021) {
            cal.set(5, 22);
        } else {
            cal.set(7, 2);
            cal.set(8, 3);
        }
        return cal.getTime();
    }

    protected static Date getMountDay(int year, MospParams mospParams) throws MospException {
        int targetYear = HolidayUtility.getYear((int)year, (int)8, (MospParams)mospParams);
        int specialYear2020 = 2020;
        int specialYear2021 = 2021;
        Calendar cal = HolidayUtility.getCalendar();
        cal.set(1, targetYear);
        cal.set(2, 7);
        if (targetYear == 2020) {
            cal.set(5, 10);
        } else if (targetYear == 2021) {
            cal.set(5, 8);
        } else {
            cal.set(5, 11);
        }
        return cal.getTime();
    }

    protected static Date getRespectForTheAgedDay(int year, MospParams mospParams) throws MospException {
        int targetYear = HolidayUtility.getYear((int)year, (int)8, (MospParams)mospParams);
        int switchYear = 2003;
        Calendar cal = HolidayUtility.getCalendar();
        cal.set(1, targetYear);
        cal.set(2, 8);
        if (targetYear < 2003) {
            cal.set(5, 15);
        } else {
            cal.set(7, 2);
            cal.set(8, 3);
        }
        return cal.getTime();
    }

    protected static Date getSportsDay(int year, MospParams mospParams) throws MospException {
        int targetYear = HolidayUtility.getYear((int)year, (int)9, (MospParams)mospParams);
        int switchYear = 2000;
        int specialYear2020 = 2020;
        int specialYear2021 = 2021;
        Calendar cal = HolidayUtility.getCalendar();
        cal.set(1, targetYear);
        cal.set(2, 9);
        if (targetYear < 2000) {
            cal.set(5, 10);
        } else if (targetYear == 2020) {
            cal.set(2, 6);
            cal.set(5, 24);
        } else if (targetYear == 2021) {
            cal.set(2, 6);
            cal.set(5, 23);
        } else {
            cal.set(7, 2);
            cal.set(8, 2);
        }
        return cal.getTime();
    }

    protected static String getSportsDayName(int year, MospParams mospParams) {
        int switchYear = 2020;
        if (year < 2020) {
            return mospParams.getName("SportsDayOld");
        }
        return mospParams.getName("SportsDay");
    }

    protected static Date getVernalEquinoxDay(int year, MospParams mospParams) throws MospException {
        int targetYear = HolidayUtility.getYear((int)year, (int)2, (MospParams)mospParams);
        double param1 = 21.4471;
        double param2 = 0.242377;
        double param3 = 1900.0;
        double param4 = 4.0;
        Calendar cal = HolidayUtility.getCalendar();
        double date = 21.4471 + 0.242377 * ((double)targetYear - 1900.0) - Math.floor(((double)targetYear - 1900.0) / 4.0);
        int dd = (int)Math.floor(date);
        cal.set(1, targetYear);
        cal.set(2, 2);
        cal.set(5, dd);
        return cal.getTime();
    }

    protected static Date getAutumnalEquinoxDay(int year, MospParams mospParams) throws MospException {
        int targetYear = HolidayUtility.getYear((int)year, (int)8, (MospParams)mospParams);
        double param1 = 23.8896;
        double param2 = 0.242032;
        double param3 = 1900.0;
        double param4 = 4.0;
        Calendar cal = HolidayUtility.getCalendar();
        double date = 23.8896 + 0.242032 * ((double)targetYear - 1900.0) - Math.floor(((double)targetYear - 1900.0) / 4.0);
        int dd = (int)Math.floor(date);
        cal.set(1, targetYear);
        cal.set(2, 8);
        cal.set(5, dd);
        return cal.getTime();
    }

    protected static Date getNewYearsDay(int year, MospParams mospParams) throws MospException {
        Calendar cal = HolidayUtility.getCalendar();
        cal.set(1, HolidayUtility.getYear((int)year, (int)0, (MospParams)mospParams));
        cal.set(2, 0);
        cal.set(5, 1);
        return cal.getTime();
    }

    protected static Date getNationalFoundationDay(int year, MospParams mospParams) throws MospException {
        Calendar cal = HolidayUtility.getCalendar();
        cal.set(1, HolidayUtility.getYear((int)year, (int)1, (MospParams)mospParams));
        cal.set(2, 1);
        cal.set(5, 11);
        return cal.getTime();
    }

    protected static Date getConstitutionDay(int year, MospParams mospParams) throws MospException {
        Calendar cal = HolidayUtility.getCalendar();
        cal.set(1, HolidayUtility.getYear((int)year, (int)4, (MospParams)mospParams));
        cal.set(2, 4);
        cal.set(5, 3);
        return cal.getTime();
    }

    protected static Date getChildrensDay(int year, MospParams mospParams) throws MospException {
        Calendar cal = HolidayUtility.getCalendar();
        cal.set(1, HolidayUtility.getYear((int)year, (int)4, (MospParams)mospParams));
        cal.set(2, 4);
        cal.set(5, 5);
        return cal.getTime();
    }

    protected static Date getCultureDay(int year, MospParams mospParams) throws MospException {
        Calendar cal = HolidayUtility.getCalendar();
        cal.set(1, HolidayUtility.getYear((int)year, (int)10, (MospParams)mospParams));
        cal.set(2, 10);
        cal.set(5, 3);
        return cal.getTime();
    }

    protected static Date getLaborThanksgivingDay(int year, MospParams mospParams) throws MospException {
        Calendar cal = HolidayUtility.getCalendar();
        cal.set(1, HolidayUtility.getYear((int)year, (int)10, (MospParams)mospParams));
        cal.set(2, 10);
        cal.set(5, 23);
        return cal.getTime();
    }

    protected static Date getEmperorsBirthday(int year, MospParams mospParams) throws MospException {
        int birthDate;
        int birthMonth;
        int heiseiEndYear = 2019;
        if (HolidayUtility.getYear((int)year, (int)4, (MospParams)mospParams) < heiseiEndYear) {
            birthMonth = 11;
            birthDate = 23;
        } else {
            birthMonth = 1;
            birthDate = 23;
        }
        Calendar cal = HolidayUtility.getCalendar();
        cal.set(1, HolidayUtility.getYear((int)year, (int)birthMonth, (MospParams)mospParams));
        cal.set(2, birthMonth);
        cal.set(5, birthDate);
        return cal.getTime();
    }

    protected static Date getShowaDay(int year, MospParams mospParams) throws MospException {
        int dayOfMonth = 29;
        Calendar cal = HolidayUtility.getCalendar();
        cal.set(1, HolidayUtility.getYear((int)year, (int)3, (MospParams)mospParams));
        cal.set(2, 3);
        cal.set(5, 29);
        return cal.getTime();
    }

    protected static Date getGreeneryDay(int year, MospParams mospParams) throws MospException {
        Calendar cal = HolidayUtility.getCalendar();
        cal.set(1, HolidayUtility.getYear((int)year, (int)4, (MospParams)mospParams));
        cal.set(2, 4);
        cal.set(5, 4);
        return cal.getTime();
    }

    protected static int getYear(int fiscalYear, int targetMonth, MospParams mospParams) throws MospException {
        return DateUtility.getYear((Date)MonthUtility.getFiscalYearMonth((int)fiscalYear, (int)(targetMonth + 1), (MospParams)mospParams));
    }

    protected static Date getAccessionDay(int year, MospParams mospParams) throws MospException {
        Calendar cal = HolidayUtility.getCalendar();
        cal.set(1, HolidayUtility.getYear((int)year, (int)4, (MospParams)mospParams));
        cal.set(2, 4);
        cal.set(5, 1);
        return cal.getTime();
    }

    protected static Date getCoronationCeremony(int year, MospParams mospParams) throws MospException {
        Calendar cal = HolidayUtility.getCalendar();
        cal.set(1, HolidayUtility.getYear((int)year, (int)9, (MospParams)mospParams));
        cal.set(2, 9);
        cal.set(5, 22);
        return cal.getTime();
    }
}

