/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.utils;

import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.entity.WorkTypeEntityInterface;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeUtility;
import jp.mosp.time.utils.WorkTypeUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class DifferenceUtility {
    public static final int REST_START = 720;
    public static final int MINUTES_TO_REST = 180;
    public static final int REST_MINUTES = 60;

    public static WorkTypeEntityInterface makeDifferenceWorkType(MospParams mospParams, DifferenceRequestDtoInterface dto, WorkTypeEntityInterface workType) throws MospException {
        if (MospUtility.isEmpty((Object[])new Object[]{dto, workType})) {
            return WorkTypeUtility.emptyWorkType((MospParams)mospParams);
        }
        WorkTypeEntityInterface entity = WorkTypeUtility.clone((MospParams)mospParams, (WorkTypeEntityInterface)workType);
        String differenceType = dto.getDifferenceType();
        String differenceName = DifferenceUtility.getDifferenceName((MospParams)mospParams, (String)differenceType);
        Date requestDate = dto.getRequestDate();
        int requestStartMinutes = TimeUtility.getDifferenceMinutes((Date)requestDate, (Date)dto.getRequestStart());
        int requestEndMinutes = TimeUtility.getDifferenceMinutes((Date)requestDate, (Date)dto.getRequestEnd());
        int restStartMinutes = DifferenceUtility.getRestStart((String)differenceType, (int)requestStartMinutes);
        int restEndMinutes = restStartMinutes + 60;
        WorkTypeDtoInterface workTypeDto = entity.getWorkType();
        workTypeDto.setWorkTypeCode(differenceType);
        workTypeDto.setWorkTypeName(differenceName);
        workTypeDto.setWorkTypeAbbr(differenceName);
        WorkTypeItemDtoInterface workStart = entity.getWorkTypeItem("WorkStart");
        WorkTypeItemDtoInterface workEnd = entity.getWorkTypeItem("WorkEnd");
        WorkTypeItemDtoInterface restStart = entity.getWorkTypeItem("RestStart1");
        WorkTypeItemDtoInterface restEnd = entity.getWorkTypeItem("RestEnd1");
        if (MospUtility.isEmpty((Object[])new Object[]{workStart, workEnd, restStart, restEnd})) {
            return WorkTypeUtility.emptyWorkType((MospParams)mospParams);
        }
        workStart.setWorkTypeItemValue(DateUtility.getTime((int)requestStartMinutes));
        workEnd.setWorkTypeItemValue(DateUtility.getTime((int)requestEndMinutes));
        restStart.setWorkTypeItemValue(DateUtility.getTime((int)restStartMinutes));
        restEnd.setWorkTypeItemValue(DateUtility.getTime((int)restEndMinutes));
        return entity;
    }

    public static int getRestStart(String differenceType, int requestStart) {
        if (DifferenceUtility.isDifferenceTypeAtoD((String)differenceType)) {
            return 720;
        }
        return requestStart + 180;
    }

    public static String getDifferenceName(MospParams mospParams, String differenceType) {
        String name = differenceType;
        if (DifferenceUtility.isDifferenceTypeA((String)differenceType)) {
            name = TimeNamingUtility.differenceA((MospParams)mospParams);
        }
        if (DifferenceUtility.isDifferenceTypeB((String)differenceType)) {
            name = TimeNamingUtility.differenceB((MospParams)mospParams);
        }
        if (DifferenceUtility.isDifferenceTypeC((String)differenceType)) {
            name = TimeNamingUtility.differenceC((MospParams)mospParams);
        }
        if (DifferenceUtility.isDifferenceTypeD((String)differenceType)) {
            name = TimeNamingUtility.differenceD((MospParams)mospParams);
        }
        if (DifferenceUtility.isDifferenceTypeS((String)differenceType)) {
            name = TimeNamingUtility.differenceS((MospParams)mospParams);
        }
        return name;
    }

    public static boolean isDifferenceTypeA(String differenceType) {
        return MospUtility.isEqual((Object)differenceType, (Object)"a");
    }

    public static boolean isDifferenceTypeB(String differenceType) {
        return MospUtility.isEqual((Object)differenceType, (Object)"b");
    }

    public static boolean isDifferenceTypeC(String differenceType) {
        return MospUtility.isEqual((Object)differenceType, (Object)"c");
    }

    public static boolean isDifferenceTypeD(String differenceType) {
        return MospUtility.isEqual((Object)differenceType, (Object)"d");
    }

    public static boolean isDifferenceTypeS(String differenceType) {
        return MospUtility.isEqual((Object)differenceType, (Object)"s");
    }

    public static boolean isDifferenceTypeAtoD(String differenceType) {
        boolean isDifferenceTypeAtoD = DifferenceUtility.isDifferenceTypeA((String)differenceType);
        isDifferenceTypeAtoD = isDifferenceTypeAtoD || DifferenceUtility.isDifferenceTypeB((String)differenceType);
        isDifferenceTypeAtoD = isDifferenceTypeAtoD || DifferenceUtility.isDifferenceTypeC((String)differenceType);
        isDifferenceTypeAtoD = isDifferenceTypeAtoD || DifferenceUtility.isDifferenceTypeD((String)differenceType);
        return isDifferenceTypeAtoD;
    }
}

