/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.instance.InstanceFactory;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.comparator.settings.CorrectionDateComparator;
import jp.mosp.time.dto.settings.AttendanceCorrectionDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.RequestEntityInterface;
import jp.mosp.time.entity.TimeSettingEntityInterface;
import jp.mosp.time.entity.WorkTypeEntityInterface;
import jp.mosp.time.utils.TimeNamingUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class AttendanceUtility {
    public static final int TYPE_LIST_ATTENDANCE = 1;
    public static final int TYPE_LIST_ACTUAL = 2;
    public static final int TYPE_LIST_SCHEDULE = 3;
    public static final int TYPE_LIST_APPROVAL = 4;
    protected static final String APP_SCHEDULE_APPLY_REQUEST = "ScheduleApplyRequest";

    private AttendanceUtility() {
    }

    public static Date getStartTimeForTimeRecord(ApplicationEntity applicationEntity, RequestEntityInterface requestEntity, WorkTypeEntityInterface workTypeEntity, Date recordTime) throws MospException {
        Date scheduledTime = workTypeEntity.getStartTime(requestEntity);
        boolean isAutoBeforeOverwork = false;
        WorkTypeItemDtoInterface workTypeItemDto = workTypeEntity.getWorkTypeItem("AutoBefOverWork");
        if (workTypeItemDto != null) {
            isAutoBeforeOverwork = workTypeItemDto.getPreliminary().equals(String.valueOf(String.valueOf(0)));
        }
        int overtimeMinutesBeforeWork = requestEntity.getOvertimeMinutesBeforeWork(false);
        if (isAutoBeforeOverwork) {
            int beforeOvertimeInt = DateUtility.getHour((Date)recordTime) * 60;
            int scheduledTimeInt = DateUtility.getHour((Date)scheduledTime) * 60;
            overtimeMinutesBeforeWork = scheduledTimeInt - beforeOvertimeInt;
        }
        Date overScheduledTime = DateUtility.addMinute((Date)scheduledTime, (int)(-overtimeMinutesBeforeWork));
        TimeSettingDtoInterface timeSettingDto = applicationEntity.getTimeSettingDto();
        if (workTypeEntity.isDirectStart()) {
            return scheduledTime;
        }
        if (recordTime.compareTo(overScheduledTime) > 0) {
            if (applicationEntity.useScheduledTime() && !isAutoBeforeOverwork) {
                return AttendanceUtility.getRoundedStartTimeForTimeRecord((Date)recordTime, (TimeSettingDtoInterface)timeSettingDto);
            }
            return AttendanceUtility.getRoundedActualStartTimeForTimeRecord((Date)recordTime, (TimeSettingDtoInterface)timeSettingDto);
        }
        if (applicationEntity.useScheduledTime() && !isAutoBeforeOverwork) {
            return overScheduledTime;
        }
        return AttendanceUtility.getRoundedActualStartTimeForTimeRecord((Date)recordTime, (TimeSettingDtoInterface)timeSettingDto);
    }

    public static Date getRoundedStartTimeForTimeRecord(Date time, TimeSettingDtoInterface dto) {
        if (dto == null) {
            return AttendanceUtility.getRoundedTimeForTimeRecord((Date)time, (int)1, (int)1);
        }
        return AttendanceUtility.getRoundedTimeForTimeRecord((Date)time, (int)dto.getRoundDailyStartUnit(), (int)dto.getRoundDailyStart());
    }

    public static Date getRoundedActualStartTimeForTimeRecord(Date time, TimeSettingDtoInterface dto) {
        if (dto == null) {
            return AttendanceUtility.getRoundedTimeForTimeRecord((Date)time, (int)1, (int)1);
        }
        return AttendanceUtility.getMinuteRoundedTimeForTimeRecord((Date)time, (int)dto.getRoundDailyStartUnit(), (int)dto.getRoundDailyStart());
    }

    public static Date getRoundedEndTimeForTimeRecord(Date time, TimeSettingDtoInterface dto) {
        if (dto == null) {
            return AttendanceUtility.getRoundedTimeForTimeRecord((Date)time, (int)1, (int)1);
        }
        return AttendanceUtility.getRoundedTimeForTimeRecord((Date)time, (int)dto.getRoundDailyEndUnit(), (int)dto.getRoundDailyEnd());
    }

    public static Date getRoundedActualEndTimeForTimeRecord(Date time, TimeSettingDtoInterface dto) {
        if (dto == null) {
            return AttendanceUtility.getRoundedTimeForTimeRecord((Date)time, (int)1, (int)1);
        }
        return AttendanceUtility.getMinuteRoundedTimeForTimeRecord((Date)time, (int)dto.getRoundDailyEndUnit(), (int)dto.getRoundDailyEnd());
    }

    public static Date getRoundedRestStartTimeForTimeRecord(Date time, TimeSettingDtoInterface dto) {
        if (dto == null) {
            return AttendanceUtility.getRoundedTimeForTimeRecord((Date)time, (int)1, (int)1);
        }
        return AttendanceUtility.getMinuteRoundedTimeForTimeRecord((Date)time, (int)dto.getRoundDailyRestStartUnit(), (int)dto.getRoundDailyRestStart());
    }

    public static Date getRoundedRestEndTimeForTimeRecord(Date time, TimeSettingDtoInterface dto) {
        if (dto == null) {
            return AttendanceUtility.getRoundedTimeForTimeRecord((Date)time, (int)1, (int)1);
        }
        return AttendanceUtility.getMinuteRoundedTimeForTimeRecord((Date)time, (int)dto.getRoundDailyRestEndUnit(), (int)dto.getRoundDailyRestEnd());
    }

    public static Date getRoundedPrivateStartTimeForTimeRecord(Date time, TimeSettingDtoInterface dto) {
        if (dto == null) {
            return AttendanceUtility.getRoundedTimeForTimeRecord((Date)time, (int)1, (int)1);
        }
        return AttendanceUtility.getMinuteRoundedTimeForTimeRecord((Date)time, (int)dto.getRoundDailyPrivateStartUnit(), (int)dto.getRoundDailyPrivateStart());
    }

    public static Date getRoundedPrivateEndTimeForTimeRecord(Date time, TimeSettingDtoInterface dto) {
        if (dto == null) {
            return AttendanceUtility.getRoundedTimeForTimeRecord((Date)time, (int)1, (int)1);
        }
        return AttendanceUtility.getMinuteRoundedTimeForTimeRecord((Date)time, (int)dto.getRoundDailyPrivateEndUnit(), (int)dto.getRoundDailyPrivateEnd());
    }

    protected static Date getMinuteRoundedTimeForTimeRecord(Date targetTime, int roundUnit, int roundType) {
        if (roundUnit == 1 && roundType == 2) {
            return AttendanceUtility.getRoundedTimeForTimeRecord((Date)targetTime, (int)roundUnit, (int)roundType);
        }
        return AttendanceUtility.getRoundedTimeForTimeRecord((Date)targetTime, (int)1, (int)1);
    }

    protected static Date getRoundedTimeForTimeRecord(Date targetTime, int roundUnit, int roundType) {
        if (targetTime == null) {
            return null;
        }
        long milliseconds = targetTime.getTime();
        if (milliseconds <= 0L) {
            return targetTime;
        }
        int oneMinute = 60000;
        long fraction = milliseconds % (long)oneMinute;
        milliseconds -= fraction;
        if (fraction > 0L && roundType == 2 && roundUnit == 1) {
            milliseconds += (long)oneMinute;
        }
        if (roundType == 0 || roundUnit <= 0) {
            return new Date(milliseconds);
        }
        int millisecondsUnit = roundUnit * 60 * 1000;
        long rounded = milliseconds - milliseconds % (long)millisecondsUnit;
        if (roundType == 2 && milliseconds % (long)millisecondsUnit > 0L) {
            rounded += (long)millisecondsUnit;
        }
        return new Date(rounded);
    }

    public static AttendanceDtoInterface getAttendanceDtoClone(AttendanceDtoInterface dstDto, AttendanceDtoInterface srcDto) throws MospException {
        if (srcDto == null) {
            return null;
        }
        if (dstDto == null) {
            dstDto = (AttendanceDtoInterface)InstanceFactory.simplifiedInstance((String)srcDto.getClass().getName());
        }
        AttendanceUtility.getBaseDtoClone((BaseDtoInterface)dstDto, (BaseDtoInterface)srcDto);
        dstDto.setTmdAttendanceId(srcDto.getTmdAttendanceId());
        dstDto.setPersonalId(srcDto.getPersonalId());
        dstDto.setWorkDate(srcDto.getWorkDate());
        dstDto.setTimesWork(srcDto.getTimesWork());
        dstDto.setWorkTypeCode(srcDto.getWorkTypeCode());
        dstDto.setDirectStart(srcDto.getDirectStart());
        dstDto.setDirectEnd(srcDto.getDirectEnd());
        dstDto.setForgotRecordWorkStart(srcDto.getForgotRecordWorkStart());
        dstDto.setNotRecordWorkStart(srcDto.getNotRecordWorkStart());
        dstDto.setStartTime(srcDto.getStartTime());
        dstDto.setActualStartTime(srcDto.getActualStartTime());
        dstDto.setEndTime(srcDto.getEndTime());
        dstDto.setActualEndTime(srcDto.getActualEndTime());
        dstDto.setLateDays(srcDto.getLateDays());
        dstDto.setLateThirtyMinutesOrMore(srcDto.getLateThirtyMinutesOrMore());
        dstDto.setLateLessThanThirtyMinutes(srcDto.getLateLessThanThirtyMinutes());
        dstDto.setLateTime(srcDto.getLateTime());
        dstDto.setActualLateTime(srcDto.getActualLateTime());
        dstDto.setLateThirtyMinutesOrMoreTime(srcDto.getLateThirtyMinutesOrMoreTime());
        dstDto.setLateLessThanThirtyMinutesTime(srcDto.getLateLessThanThirtyMinutesTime());
        dstDto.setLateReason(srcDto.getLateReason());
        dstDto.setLateCertificate(srcDto.getLateCertificate());
        dstDto.setLateComment(srcDto.getLateComment());
        dstDto.setLeaveEarlyDays(srcDto.getLeaveEarlyDays());
        dstDto.setLeaveEarlyThirtyMinutesOrMore(srcDto.getLeaveEarlyThirtyMinutesOrMore());
        dstDto.setLeaveEarlyLessThanThirtyMinutes(srcDto.getLeaveEarlyLessThanThirtyMinutes());
        dstDto.setLeaveEarlyTime(srcDto.getLeaveEarlyTime());
        dstDto.setActualLeaveEarlyTime(srcDto.getActualLeaveEarlyTime());
        dstDto.setLeaveEarlyThirtyMinutesOrMoreTime(srcDto.getLeaveEarlyThirtyMinutesOrMoreTime());
        dstDto.setLeaveEarlyLessThanThirtyMinutesTime(srcDto.getLeaveEarlyLessThanThirtyMinutesTime());
        dstDto.setLeaveEarlyReason(srcDto.getLeaveEarlyReason());
        dstDto.setLeaveEarlyCertificate(srcDto.getLeaveEarlyCertificate());
        dstDto.setLeaveEarlyComment(srcDto.getLeaveEarlyComment());
        dstDto.setWorkTime(srcDto.getWorkTime());
        dstDto.setGeneralWorkTime(srcDto.getGeneralWorkTime());
        dstDto.setWorkTimeWithinPrescribedWorkTime(srcDto.getWorkTimeWithinPrescribedWorkTime());
        dstDto.setContractWorkTime(srcDto.getContractWorkTime());
        dstDto.setShortUnpaid(srcDto.getShortUnpaid());
        dstDto.setRestTime(srcDto.getRestTime());
        dstDto.setOverRestTime(srcDto.getOverRestTime());
        dstDto.setNightRestTime(srcDto.getNightRestTime());
        dstDto.setLegalHolidayRestTime(srcDto.getLegalHolidayRestTime());
        dstDto.setPrescribedHolidayRestTime(srcDto.getPrescribedHolidayRestTime());
        dstDto.setPublicTime(srcDto.getPublicTime());
        dstDto.setPrivateTime(srcDto.getPrivateTime());
        dstDto.setMinutelyHolidayATime(srcDto.getMinutelyHolidayATime());
        dstDto.setMinutelyHolidayBTime(srcDto.getMinutelyHolidayBTime());
        dstDto.setMinutelyHolidayA(srcDto.getMinutelyHolidayA());
        dstDto.setMinutelyHolidayB(srcDto.getMinutelyHolidayB());
        dstDto.setTimesOvertime(srcDto.getTimesOvertime());
        dstDto.setOvertime(srcDto.getOvertime());
        dstDto.setOvertimeBefore(srcDto.getOvertimeBefore());
        dstDto.setOvertimeAfter(srcDto.getOvertimeAfter());
        dstDto.setOvertimeIn(srcDto.getOvertimeIn());
        dstDto.setOvertimeOut(srcDto.getOvertimeOut());
        dstDto.setWorkdayOvertimeIn(srcDto.getWorkdayOvertimeIn());
        dstDto.setWorkdayOvertimeOut(srcDto.getWorkdayOvertimeOut());
        dstDto.setPrescribedHolidayOvertimeIn(srcDto.getPrescribedHolidayOvertimeIn());
        dstDto.setPrescribedHolidayOvertimeOut(srcDto.getPrescribedHolidayOvertimeOut());
        dstDto.setLateNightTime(srcDto.getLateNightTime());
        dstDto.setNightWorkWithinPrescribedWork(srcDto.getNightWorkWithinPrescribedWork());
        dstDto.setNightOvertimeWork(srcDto.getNightOvertimeWork());
        dstDto.setNightWorkOnHoliday(srcDto.getNightWorkOnHoliday());
        dstDto.setSpecificWorkTime(srcDto.getSpecificWorkTime());
        dstDto.setLegalWorkTime(srcDto.getLegalWorkTime());
        dstDto.setDecreaseTime(srcDto.getDecreaseTime());
        dstDto.setTimeComment(srcDto.getTimeComment());
        dstDto.setRemarks(srcDto.getRemarks());
        dstDto.setWorkDays(srcDto.getWorkDays());
        dstDto.setWorkDaysForPaidLeave(srcDto.getWorkDaysForPaidLeave());
        dstDto.setTotalWorkDaysForPaidLeave(srcDto.getTotalWorkDaysForPaidLeave());
        dstDto.setTimesHolidayWork(srcDto.getTimesHolidayWork());
        dstDto.setTimesLegalHolidayWork(srcDto.getTimesLegalHolidayWork());
        dstDto.setTimesPrescribedHolidayWork(srcDto.getTimesPrescribedHolidayWork());
        dstDto.setPaidLeaveDays(srcDto.getPaidLeaveDays());
        dstDto.setPaidLeaveHours(srcDto.getPaidLeaveHours());
        dstDto.setStockLeaveDays(srcDto.getStockLeaveDays());
        dstDto.setCompensationDays(srcDto.getCompensationDays());
        dstDto.setLegalCompensationDays(srcDto.getLegalCompensationDays());
        dstDto.setPrescribedCompensationDays(srcDto.getPrescribedCompensationDays());
        dstDto.setNightCompensationDays(srcDto.getNightCompensationDays());
        dstDto.setSpecialLeaveDays(srcDto.getSpecialLeaveDays());
        dstDto.setSpecialLeaveHours(srcDto.getSpecialLeaveHours());
        dstDto.setOtherLeaveDays(srcDto.getOtherLeaveDays());
        dstDto.setOtherLeaveHours(srcDto.getOtherLeaveHours());
        dstDto.setAbsenceDays(srcDto.getAbsenceDays());
        dstDto.setAbsenceHours(srcDto.getAbsenceHours());
        dstDto.setGrantedLegalCompensationDays(srcDto.getGrantedLegalCompensationDays());
        dstDto.setGrantedPrescribedCompensationDays(srcDto.getGrantedPrescribedCompensationDays());
        dstDto.setGrantedNightCompensationDays(srcDto.getGrantedNightCompensationDays());
        dstDto.setLegalHolidayWorkTimeWithCompensationDay(srcDto.getLegalHolidayWorkTimeWithCompensationDay());
        dstDto.setLegalHolidayWorkTimeWithoutCompensationDay(srcDto.getLegalHolidayWorkTimeWithoutCompensationDay());
        dstDto.setPrescribedHolidayWorkTimeWithCompensationDay(srcDto.getPrescribedHolidayWorkTimeWithCompensationDay());
        dstDto.setPrescribedHolidayWorkTimeWithoutCompensationDay(srcDto.getPrescribedHolidayWorkTimeWithoutCompensationDay());
        dstDto.setOvertimeInWithCompensationDay(srcDto.getOvertimeInWithCompensationDay());
        dstDto.setOvertimeInWithoutCompensationDay(srcDto.getOvertimeInWithoutCompensationDay());
        dstDto.setOvertimeOutWithCompensationDay(srcDto.getOvertimeOutWithCompensationDay());
        dstDto.setOvertimeOutWithoutCompensationDay(srcDto.getOvertimeOutWithoutCompensationDay());
        dstDto.setStatutoryHolidayWorkTimeIn(srcDto.getStatutoryHolidayWorkTimeIn());
        dstDto.setStatutoryHolidayWorkTimeOut(srcDto.getStatutoryHolidayWorkTimeOut());
        dstDto.setPrescribedHolidayWorkTimeIn(srcDto.getPrescribedHolidayWorkTimeIn());
        dstDto.setPrescribedHolidayWorkTimeOut(srcDto.getPrescribedHolidayWorkTimeOut());
        dstDto.setWorkflow(srcDto.getWorkflow());
        return dstDto;
    }

    public static RestDtoInterface getRestDtoClone(RestDtoInterface dstDto, RestDtoInterface srcDto) throws MospException {
        if (srcDto == null) {
            return null;
        }
        if (dstDto == null) {
            dstDto = (RestDtoInterface)InstanceFactory.simplifiedInstance((String)srcDto.getClass().getName());
        }
        AttendanceUtility.getBaseDtoClone((BaseDtoInterface)dstDto, (BaseDtoInterface)srcDto);
        dstDto.setTmdRestId(srcDto.getTmdRestId());
        dstDto.setPersonalId(srcDto.getPersonalId());
        dstDto.setWorkDate(srcDto.getWorkDate());
        dstDto.setTimesWork(srcDto.getTimesWork());
        dstDto.setRest(srcDto.getRest());
        dstDto.setRestStart(srcDto.getRestStart());
        dstDto.setRestEnd(srcDto.getRestEnd());
        dstDto.setRestTime(srcDto.getRestTime());
        return dstDto;
    }

    public static GoOutDtoInterface getGoOutDtoClone(GoOutDtoInterface dstDto, GoOutDtoInterface srcDto) throws MospException {
        if (srcDto == null) {
            return null;
        }
        if (dstDto == null) {
            dstDto = (GoOutDtoInterface)InstanceFactory.simplifiedInstance((String)srcDto.getClass().getName());
        }
        AttendanceUtility.getBaseDtoClone((BaseDtoInterface)dstDto, (BaseDtoInterface)srcDto);
        dstDto.setTmdGoOutId(srcDto.getTmdGoOutId());
        dstDto.setPersonalId(srcDto.getPersonalId());
        dstDto.setWorkDate(srcDto.getWorkDate());
        dstDto.setTimesWork(srcDto.getTimesWork());
        dstDto.setGoOutType(srcDto.getGoOutType());
        dstDto.setTimesGoOut(srcDto.getTimesGoOut());
        dstDto.setGoOutStart(srcDto.getGoOutStart());
        dstDto.setGoOutEnd(srcDto.getGoOutEnd());
        dstDto.setGoOutTime(srcDto.getGoOutTime());
        return dstDto;
    }

    public static BaseDtoInterface getBaseDtoClone(BaseDtoInterface dstDto, BaseDtoInterface srcDto) throws MospException {
        if (srcDto == null) {
            return null;
        }
        if (dstDto == null) {
            dstDto = (BaseDtoInterface)InstanceFactory.simplifiedInstance((String)srcDto.getClass().getName());
        }
        dstDto.setDeleteFlag(srcDto.getDeleteFlag());
        dstDto.setInsertDate(srcDto.getInsertDate());
        dstDto.setInsertUser(srcDto.getInsertUser());
        dstDto.setUpdateDate(srcDto.getUpdateDate());
        dstDto.setUpdateUser(srcDto.getUpdateUser());
        return dstDto;
    }

    public static AttendanceListDto getAttendanceListDto(Collection<AttendanceListDto> dtos, Date targetDate) {
        for (AttendanceListDto dto : dtos) {
            if (!targetDate.equals(dto.getWorkDate())) continue;
            return dto;
        }
        return null;
    }

    public static void addRemark(AttendanceListDto dto, String remark) {
        if (MospUtility.isEmpty((String[])new String[]{remark})) {
            return;
        }
        if (dto.getRemark() != null && dto.getRemark().indexOf(remark) >= 0) {
            return;
        }
        dto.setRemark(MospUtility.concat((String[])new String[]{dto.getRemark(), remark}));
    }

    public static void resetStartEndTimeString(MospParams mospParams, List<AttendanceListDto> attendList, TimeSettingEntityInterface timeSetting) {
        if (timeSetting.isScheduledTimeAvailable()) {
            return;
        }
        int listType = ((AttendanceListDto)MospUtility.getLastValue(attendList)).getListType();
        if (!AttendanceUtility.isListTypeAttendance((int)listType)) {
            return;
        }
        for (AttendanceListDto dto : attendList) {
            if (MospUtility.isEmpty((String[])new String[]{dto.getStartTimeStyle()})) continue;
            dto.setStartTimeString(PfNameUtility.hyphen((MospParams)mospParams));
            dto.setEndTimeString(PfNameUtility.hyphen((MospParams)mospParams));
        }
    }

    public static AttendanceCorrectionDtoInterface getLatestCorrection(Collection<AttendanceCorrectionDtoInterface> dtos) throws MospException {
        return (AttendanceCorrectionDtoInterface)MospUtility.getFirstValue(dtos, CorrectionDateComparator.class, (boolean)true);
    }

    public static String getCorrectionMark(MospParams mospParams, List<AttendanceCorrectionDtoInterface> dtos) throws MospException {
        return AttendanceUtility.getCorrectionMark((MospParams)mospParams, (AttendanceCorrectionDtoInterface)AttendanceUtility.getLatestCorrection(dtos));
    }

    public static String getCorrectionMark(MospParams mospParams, AttendanceCorrectionDtoInterface dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return "";
        }
        if (MospUtility.isEqual((Object)dto.getPersonalId(), (Object)dto.getCorrectionPersonalId())) {
            return TimeNamingUtility.selfCorrectAbbr((MospParams)mospParams);
        }
        return TimeNamingUtility.otherCorrectAbbr((MospParams)mospParams);
    }

    public static List<Date> getAttendanceAppliableDates(List<AttendanceListDto> attendList) {
        ArrayList<Date> dates = new ArrayList<Date>();
        for (AttendanceListDto dto : attendList) {
            if (!dto.isNeedCheckbox()) continue;
            dates.add(dto.getWorkDate());
        }
        return dates;
    }

    public static Set<String> getStatusesForListType(int listType) {
        switch (listType) {
            case 1: 
            case 4: {
                return WorkflowUtility.getEffectiveStatuses();
            }
            case 2: 
            case 3: {
                return WorkflowUtility.getCompletedStatuses();
            }
        }
        return Collections.emptySet();
    }

    public static boolean isAttendanceConsideredForAttendList(AttendanceListDto dto, WorkflowDtoInterface workflow) {
        if (AttendanceUtility.isTheListType((AttendanceListDto)dto, (int[])new int[]{3})) {
            return false;
        }
        if (AttendanceUtility.isTheListType((AttendanceListDto)dto, (int[])new int[]{2}) && !WorkflowUtility.isCompleted((WorkflowDtoInterface)workflow)) {
            return false;
        }
        return !AttendanceUtility.isTheListType((AttendanceListDto)dto, (int[])new int[]{4}) || !WorkflowUtility.isDraft((WorkflowDtoInterface)workflow);
    }

    public static boolean isTheListType(AttendanceListDto dto, int ... listTypes) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto, listTypes})) {
            return false;
        }
        for (int listType : listTypes) {
            if (dto.getListType() != listType) continue;
            return true;
        }
        return false;
    }

    public static boolean isListTypeAttendance(int listType) {
        return listType == 1;
    }

    public static boolean isListTypeActual(int listType) {
        return listType == 2;
    }

    public static boolean isListTypeSchedule(int listType) {
        return listType == 3;
    }

    public static boolean isListTypeApproval(int listType) {
        return listType == 4;
    }

    public static boolean isScheduleApplyRequest(MospParams mospParams) {
        return mospParams.getApplicationPropertyBool("ScheduleApplyRequest");
    }

    public static String getPortalParamAddonColumnNameKey(String className) {
        return className + "ColumnName";
    }

    public static String getPortalParamAddonColumnValueKey(String className) {
        return className + "ColumnValue";
    }

    public static String getPortalParamAddonColumnClassKey(String className) {
        return className + "ColumnClass";
    }
}

