/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.bean.WorkTypeSearchBeanInterface;
import jp.mosp.time.comparator.settings.WorkTypeMasterWorkTypeCodeComparator;
import jp.mosp.time.dto.settings.WorkTypeListDtoInterface;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.WorkTypeListVo;
import jp.mosp.time.utils.TimeUtility;

public class WorkTypeListAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM5210";
    public static final String CMD_SEARCH = "TM5212";
    public static final String CMD_RE_SHOW = "TM5213";
    public static final String CMD_SORT = "TM5218";
    public static final String CMD_PAGE = "TM5219";
    public static final String CMD_BATCH_UPDATE = "TM5285";

    public WorkTypeListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new WorkTypeListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        }
    }

    protected void show() {
        WorkTypeListVo vo = (WorkTypeListVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(WorkTypeMasterWorkTypeCodeComparator.class.getName());
    }

    protected void search() throws MospException {
        WorkTypeListVo vo = (WorkTypeListVo)this.mospParams.getVo();
        WorkTypeSearchBeanInterface search = this.timeReference().workTypeSearch();
        Date activeDate = MonthUtility.getYearMonthTargetDate((int)this.getInt(vo.getTxtSearchActivateYear()), (int)this.getInt(vo.getTxtSearchActivateMonth()), (MospParams)this.mospParams);
        search.setActivateDate(activeDate);
        search.setWorkTypeCode(vo.getTxtSearchWorkTypeCode());
        search.setWorkTypeName(vo.getTxtSearchWorkTypeName());
        search.setWorkTypeAbbr(vo.getTxtSearchWorkTypeAbbr());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(WorkTypeMasterWorkTypeCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void batchUpdate() throws MospException {
        WorkTypeListVo vo = (WorkTypeListVo)this.mospParams.getVo();
        Date date = MonthUtility.getYearMonthDate((int)this.getInt(vo.getTxtUpdateActivateYear()), (int)this.getInt(vo.getTxtUpdateActivateMonth()));
        this.time().workTypeRegist().update(this.getIdArray(vo.getCkbSelect()), date, this.getInt(vo.getPltUpdateInactivate()));
        this.time().workTypeItemRegist().update(this.getIdArray(vo.getCkbSelect()), date, this.getInt(vo.getPltUpdateInactivate()));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageUpdateFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageUpdatetSucceed((MospParams)this.mospParams);
        this.setSearchActivateDate(date);
        this.search();
    }

    public void setDefaultValues() {
        WorkTypeListVo vo = (WorkTypeListVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        vo.setTxtSearchActivateYear(this.getStringYear(date));
        vo.setTxtSearchActivateMonth(this.getStringMonth(date));
        vo.setTxtSearchActivateDay(this.getStringDay(date));
        vo.setTxtSearchWorkTypeCode("");
        vo.setTxtSearchWorkTypeName("");
        vo.setTxtSearchWorkTypeAbbr("");
        vo.setPltSearchInactivate(String.valueOf(0));
        vo.setTxtUpdateActivateYear(this.getStringYear(date));
        vo.setTxtUpdateActivateMonth(this.getStringMonth(date));
        vo.setTxtUpdateActivateDay(this.getStringDay(date));
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        WorkTypeListVo vo = (WorkTypeListVo)this.mospParams.getVo();
        String[] aryCkbWorkTypeListId = new String[list.size()];
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblActivateMonth = new String[list.size()];
        String[] aryLblWorkTypeCode = new String[list.size()];
        String[] aryLblWorkTypeName = new String[list.size()];
        String[] aryLblWorkTypeAbbr = new String[list.size()];
        String[] aryLblStartTime = new String[list.size()];
        String[] aryLblEndTime = new String[list.size()];
        String[] aryLblWorkTime = new String[list.size()];
        String[] aryLblRestTime = new String[list.size()];
        String[] aryLblFrontTime = new String[list.size()];
        String[] aryLblBackTime = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        Date defaultTime = DateUtility.getDefaultTime();
        for (int i = 0; i < list.size(); ++i) {
            WorkTypeListDtoInterface dto = (WorkTypeListDtoInterface)list.get(i);
            aryCkbWorkTypeListId[i] = String.valueOf(dto.getTmmWorkTypeId());
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblActivateMonth[i] = DateUtility.getStringYearMonth((Date)dto.getActivateDate());
            aryLblWorkTypeCode[i] = dto.getWorkTypeCode();
            aryLblWorkTypeName[i] = dto.getWorkTypeName();
            aryLblWorkTypeAbbr[i] = dto.getWorkTypeAbbr();
            aryLblStartTime[i] = DateUtility.getStringTime((Date)dto.getStartTime(), (Date)defaultTime);
            aryLblEndTime[i] = DateUtility.getStringTime((Date)dto.getEndTime(), (Date)defaultTime);
            aryLblWorkTime[i] = this.getStringWorkTypeTime(dto.getWorkTime());
            aryLblRestTime[i] = this.getStringWorkTypeTime(dto.getRestTime());
            aryLblFrontTime[i] = this.getStringWorkTypeTime(dto.getFrontTime());
            aryLblBackTime[i] = this.getStringWorkTypeTime(dto.getBackTime());
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
        }
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblActivateMonth(aryLblActivateMonth);
        vo.setAryLblWorkTypeCode(aryLblWorkTypeCode);
        vo.setAryLblWorkTypeName(aryLblWorkTypeName);
        vo.setAryLblWorkTypeAbbr(aryLblWorkTypeAbbr);
        vo.setAryLblStartTime(aryLblStartTime);
        vo.setAryLblEndTime(aryLblEndTime);
        vo.setAryLblWorkTime(aryLblWorkTime);
        vo.setAryLblRestTime(aryLblRestTime);
        vo.setAryLblFrontTime(aryLblFrontTime);
        vo.setAryLblBackTime(aryLblBackTime);
        vo.setAryLblInactivate(aryLblInactivate);
        vo.setAryCkbWorkTypeListId(aryCkbWorkTypeListId);
    }

    protected String getStringWorkTypeTime(Date time) throws MospException {
        if (time == null) {
            return "";
        }
        int minutes = TimeUtility.getMinutes((Date)time, (Date)DateUtility.getDefaultTime());
        return TimeUtility.getStringPeriodTime((MospParams)this.mospParams, (int)minutes);
    }
}

