/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.bean.WorkTypeBeanInterface;
import jp.mosp.time.bean.WorkTypeItemReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeItemRegistBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeRegistBeanInterface;
import jp.mosp.time.bean.impl.WorkTypeItemReferenceBean;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.WorkTypeCardVo;

public class WorkTypeCardAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM5220";
    public static final String CMD_SELECT_SHOW = "TM5221";
    public static final String CMD_REGIST = "TM5225";
    public static final String CMD_DELETE = "TM5227";
    public static final String CMD_INSERT_MODE = "TM5271";
    public static final String CMD_ADD_MODE = "TM5273";
    protected static final String CODE_KEY_ADDONS = "WorkTypeSettingAddons";

    protected BaseVo getSpecificVo() {
        return new WorkTypeCardVo();
    }

    protected BaseVo prepareVo(boolean useStoredVo, boolean useParametersMapper) throws MospException {
        BaseVo vo = super.prepareVo(useStoredVo, useParametersMapper);
        if (!useParametersMapper) {
            return vo;
        }
        for (WorkTypeBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.mapping();
        }
        return vo;
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(true, false);
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        }
    }

    protected void show() throws MospException {
        this.insertMode();
    }

    protected void regist() throws MospException {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        WorkTypeRegistBeanInterface regist = this.time().workTypeRegist();
        WorkTypeItemRegistBeanInterface itemRegist = this.time().workTypeItemRegist();
        WorkTypeDtoInterface dto = regist.getInitDto();
        ArrayList<WorkTypeItemDtoInterface> list = new ArrayList<WorkTypeItemDtoInterface>();
        this.setDtoFields(dto);
        regist.insert(dto);
        for (String item : itemRegist.getCodesWorkTypeItem()) {
            WorkTypeItemDtoInterface itemDto = itemRegist.getInitDto();
            this.setDtoFieldsItem(itemDto, item);
            list.add(itemDto);
        }
        for (WorkTypeBeanInterface addonBean : this.getAddonBeans()) {
            list.addAll(addonBean.setDtoFieldsAddonItems());
        }
        itemRegist.insert(list);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageInsertSucceed((MospParams)this.mospParams);
        this.setEditUpdateMode(dto.getWorkTypeCode(), dto.getActivateDate());
    }

    protected void add() throws MospException {
        WorkTypeRegistBeanInterface regist = this.time().workTypeRegist();
        WorkTypeItemRegistBeanInterface itemRegist = this.time().workTypeItemRegist();
        WorkTypeDtoInterface dto = regist.getInitDto();
        ArrayList<WorkTypeItemDtoInterface> list = new ArrayList<WorkTypeItemDtoInterface>();
        this.setDtoFields(dto);
        regist.add(dto);
        for (String item : itemRegist.getCodesWorkTypeItem()) {
            WorkTypeItemDtoInterface itemDto = itemRegist.getInitDto();
            this.setDtoFieldsItem(itemDto, item);
            list.add(itemDto);
        }
        for (WorkTypeBeanInterface addonBean : this.getAddonBeans()) {
            list.addAll(addonBean.setDtoFieldsAddonItems());
        }
        itemRegist.add(list);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageAddHistorySucceed((MospParams)this.mospParams);
        this.setEditUpdateMode(dto.getWorkTypeCode(), dto.getActivateDate());
    }

    protected void update() throws MospException {
        WorkTypeRegistBeanInterface regist = this.time().workTypeRegist();
        WorkTypeItemRegistBeanInterface itemRegist = this.time().workTypeItemRegist();
        WorkTypeDtoInterface dto = regist.getInitDto();
        ArrayList<WorkTypeItemDtoInterface> list = new ArrayList<WorkTypeItemDtoInterface>();
        this.setDtoFields(dto);
        regist.update(dto);
        for (String item : itemRegist.getCodesWorkTypeItem()) {
            WorkTypeItemDtoInterface itemDto = itemRegist.getInitDto();
            this.setDtoFieldsItem(itemDto, item);
            list.add(itemDto);
        }
        for (WorkTypeBeanInterface addonBean : this.getAddonBeans()) {
            list.addAll(addonBean.setDtoFieldsAddonItems());
        }
        itemRegist.update(list);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageUpdateFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageUpdatetSucceed((MospParams)this.mospParams);
        this.setEditUpdateMode(dto.getWorkTypeCode(), dto.getActivateDate());
    }

    protected void delete() throws MospException {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        WorkTypeRegistBeanInterface regist = this.time().workTypeRegist();
        WorkTypeDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        Date date = MonthUtility.getYearMonthDate((int)this.getInt(vo.getTxtEditActivateYear()), (int)this.getInt(vo.getTxtEditActivateMonth()));
        regist.delete(dto);
        this.time().workTypeItemRegist().delete(vo.getTxtWorkTypeCode(), date);
        for (WorkTypeBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.delete();
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        this.insertMode();
    }

    protected void insertMode() throws MospException {
        this.setEditInsertMode();
        this.setDefaultValues();
    }

    protected void addMode() throws MospException {
        this.setEditAddMode();
        for (WorkTypeBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.setEditAddMode();
        }
    }

    protected void editMode() throws MospException {
        this.setDefaultValues();
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
    }

    protected void setEditUpdateMode(String workTypeCode, Date activateDate) throws MospException {
        WorkTypeReferenceBeanInterface reference = this.timeReference().workType();
        WorkTypeItemRegistBeanInterface itemRegist = this.time().workTypeItemRegist();
        WorkTypeDtoInterface dto = reference.findForKey(workTypeCode, activateDate);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        for (String workTypeItemCode : itemRegist.getCodesWorkTypeItem()) {
            WorkTypeItemDtoInterface itemDto = this.timeReference().workTypeItem().findForKey(workTypeCode, activateDate, workTypeItemCode);
            if (itemDto == null) continue;
            this.setVoFieldsItem(itemDto, workTypeItemCode);
        }
        for (WorkTypeBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.setVoFields(dto);
        }
        this.setEditUpdateMode(reference.getWorkTypeHistory(workTypeCode));
    }

    public void setDefaultValues() throws MospException {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        vo.setTxtWorkTypeCode("");
        vo.setTxtWorkTypeName("");
        vo.setTxtWorkTypeAbbr("");
        vo.setTxtWorkStartHour("");
        vo.setTxtWorkStartMinute("");
        vo.setTxtWorkEndHour("");
        vo.setTxtWorkEndMinute("");
        vo.setTxtWorkTimeHour("0");
        vo.setTxtWorkTimeMinute("0");
        vo.setTxtRestTimeHour("0");
        vo.setTxtRestTimeMinute("0");
        vo.setTxtRestStart1Hour("");
        vo.setTxtRestStart1Minute("");
        vo.setTxtRestEnd1Hour("");
        vo.setTxtRestEnd1Minute("");
        vo.setTxtRestStart2Hour("");
        vo.setTxtRestStart2Minute("");
        vo.setTxtRestEnd2Hour("");
        vo.setTxtRestEnd2Minute("");
        vo.setTxtRestStart3Hour("");
        vo.setTxtRestStart3Minute("");
        vo.setTxtRestEnd3Hour("");
        vo.setTxtRestEnd3Minute("");
        vo.setTxtRestStart4Hour("");
        vo.setTxtRestStart4Minute("");
        vo.setTxtRestEnd4Hour("");
        vo.setTxtRestEnd4Minute("");
        vo.setTxtFrontStartHour("");
        vo.setTxtFrontStartMinute("");
        vo.setTxtFrontEndHour("");
        vo.setTxtFrontEndMinute("");
        vo.setTxtBackStartHour("");
        vo.setTxtBackStartMinute("");
        vo.setTxtBackEndHour("");
        vo.setTxtBackEndMinute("");
        vo.setTxtOverBeforeHour("");
        vo.setTxtOverBeforeMinute("");
        vo.setTxtOverPerHour("");
        vo.setTxtOverPerMinute("");
        vo.setTxtOverRestHour("");
        vo.setTxtOverRestMinute("");
        vo.setTxtHalfRestHour("");
        vo.setTxtHalfRestMinute("");
        vo.setTxtHalfRestStartHour("");
        vo.setTxtHalfRestStartMinute("");
        vo.setTxtHalfRestEndHour("");
        vo.setTxtHalfRestEndMinute("");
        vo.setCkbDirectStart("0");
        vo.setCkbDirectEnd("0");
        vo.setPltMidnightRestExclusion(String.valueOf(1));
        vo.setTxtShort1StartHour("");
        vo.setTxtShort1StartMinute("");
        vo.setTxtShort1EndHour("");
        vo.setTxtShort1EndMinute("");
        vo.setPltShort1Type("");
        vo.setTxtShort2StartHour("");
        vo.setTxtShort2StartMinute("");
        vo.setTxtShort2EndHour("");
        vo.setTxtShort2EndMinute("");
        vo.setPltShort2Type("");
        WorkTypeItemRegistBeanInterface itemRegist = this.time().workTypeItemRegist();
        vo.setTmmWorkTypeItemId(new long[itemRegist.getCodesWorkTypeItem().length]);
        vo.setPltAutoBeforeOverWork(String.valueOf(1));
        vo.setAddonJsps(this.getAddonJsps());
        vo.setAddonParams(new HashMap());
        vo.setAddonArrays(new HashMap());
        vo.setAddonAryPlts(new HashMap());
        for (WorkTypeBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.initVoFields();
        }
    }

    protected void setDtoFields(WorkTypeDtoInterface dto) throws MospException {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        dto.setTmmWorkTypeId(vo.getRecordId());
        dto.setActivateDate(MonthUtility.getYearMonthDate((int)this.getInt(vo.getTxtEditActivateYear()), (int)this.getInt(vo.getTxtEditActivateMonth())));
        dto.setWorkTypeCode(vo.getTxtWorkTypeCode());
        dto.setWorkTypeName(vo.getTxtWorkTypeName());
        dto.setWorkTypeAbbr(vo.getTxtWorkTypeAbbr());
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
    }

    protected void setVoFields(WorkTypeDtoInterface dto) {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        vo.setRecordId(dto.getTmmWorkTypeId());
        vo.setTxtEditActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setTxtWorkTypeCode(dto.getWorkTypeCode());
        vo.setTxtWorkTypeName(dto.getWorkTypeName());
        vo.setTxtWorkTypeAbbr(dto.getWorkTypeAbbr());
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
    }

    protected void setDtoFieldsItem(WorkTypeItemDtoInterface dto, String itemType) throws MospException {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        WorkTypeItemRegistBeanInterface item = this.time().workTypeItemRegist();
        WorkTypeItemReferenceBeanInterface itemRefer = this.timeReference().workTypeItem();
        dto.setActivateDate(MonthUtility.getYearMonthDate((int)this.getInt(vo.getTxtEditActivateYear()), (int)this.getInt(vo.getTxtEditActivateMonth())));
        dto.setWorkTypeCode(vo.getTxtWorkTypeCode());
        dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
        dto.setPreliminary("");
        if (itemType.equals("WorkStart")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(0));
            dto.setWorkTypeItemCode("WorkStart");
            dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtWorkStartHour(), vo.getTxtWorkStartMinute()));
        } else if (itemType.equals("WorkEnd")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(1));
            dto.setWorkTypeItemCode("WorkEnd");
            dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtWorkEndHour(), vo.getTxtWorkEndMinute()));
        } else if (itemType.equals("WorkTime")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(2));
            dto.setWorkTypeItemCode("WorkTime");
            dto.setWorkTypeItemValue(this.getTimestamp(itemRefer.getWorkTime(item.getDefaultTime(vo.getTxtWorkStartHour(), vo.getTxtWorkStartMinute()), item.getDefaultTime(vo.getTxtWorkEndHour(), vo.getTxtWorkEndMinute()), this.getRestTime())));
        } else if (itemType.equals("RestTime")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(3));
            dto.setWorkTypeItemCode("RestTime");
            dto.setWorkTypeItemValue(this.getTimestamp(this.getRestTime()));
        } else if (itemType.equals("RestStart1")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(4));
            dto.setWorkTypeItemCode("RestStart1");
            if (!vo.getTxtRestStart1Hour().isEmpty()) {
                dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtRestStart1Hour(), vo.getTxtRestStart1Minute()));
            }
        } else if (itemType.equals("RestEnd1")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(5));
            dto.setWorkTypeItemCode("RestEnd1");
            if (!vo.getTxtRestEnd1Hour().isEmpty()) {
                dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtRestEnd1Hour(), vo.getTxtRestEnd1Minute()));
            }
        } else if (itemType.equals("RestStart2")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(6));
            dto.setWorkTypeItemCode("RestStart2");
            if (!vo.getTxtRestStart2Hour().isEmpty()) {
                dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtRestStart2Hour(), vo.getTxtRestStart2Minute()));
            }
        } else if (itemType.equals("RestEnd2")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(7));
            dto.setWorkTypeItemCode("RestEnd2");
            if (!vo.getTxtRestEnd2Hour().isEmpty()) {
                dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtRestEnd2Hour(), vo.getTxtRestEnd2Minute()));
            }
        } else if (itemType.equals("RestStart3")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(8));
            dto.setWorkTypeItemCode("RestStart3");
            if (!vo.getTxtRestStart3Hour().isEmpty()) {
                dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtRestStart3Hour(), vo.getTxtRestStart3Minute()));
            }
        } else if (itemType.equals("RestEnd3")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(9));
            dto.setWorkTypeItemCode("RestEnd3");
            if (!vo.getTxtRestEnd3Hour().isEmpty()) {
                dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtRestEnd3Hour(), vo.getTxtRestEnd3Minute()));
            }
        } else if (itemType.equals("RestStart4")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(10));
            dto.setWorkTypeItemCode("RestStart4");
            if (!vo.getTxtRestStart4Hour().isEmpty()) {
                dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtRestStart4Hour(), vo.getTxtRestStart4Minute()));
            }
        } else if (itemType.equals("RestEnd4")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(11));
            dto.setWorkTypeItemCode("RestEnd4");
            if (!vo.getTxtRestEnd4Hour().isEmpty()) {
                dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtRestEnd4Hour(), vo.getTxtRestEnd4Minute()));
            }
        } else if (itemType.equals("FrontStart")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(12));
            dto.setWorkTypeItemCode("FrontStart");
            dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtFrontStartHour(), vo.getTxtFrontStartMinute()));
        } else if (itemType.equals("FrontEnd")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(13));
            dto.setWorkTypeItemCode("FrontEnd");
            dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtFrontEndHour(), vo.getTxtFrontEndMinute()));
        } else if (itemType.equals("BackStart")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(14));
            dto.setWorkTypeItemCode("BackStart");
            dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtBackStartHour(), vo.getTxtBackStartMinute()));
        } else if (itemType.equals("BackEnd")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(15));
            dto.setWorkTypeItemCode("BackEnd");
            dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtBackEndHour(), vo.getTxtBackEndMinute()));
        } else if (itemType.equals("OverBefore")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(16));
            dto.setWorkTypeItemCode("OverBefore");
            dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtOverBeforeHour(), vo.getTxtOverBeforeMinute()));
        } else if (itemType.equals("OverPer")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(17));
            dto.setWorkTypeItemCode("OverPer");
            dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtOverPerHour(), vo.getTxtOverPerMinute()));
        } else if (itemType.equals("OverRest")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(18));
            dto.setWorkTypeItemCode("OverRest");
            dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtOverRestHour(), vo.getTxtOverRestMinute()));
        } else if (itemType.equals("HalfRest")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(19));
            dto.setWorkTypeItemCode("HalfRest");
            if (!vo.getTxtHalfRestHour().isEmpty()) {
                dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtHalfRestHour(), vo.getTxtHalfRestMinute()));
            }
        } else if (itemType.equals("HalfRestStart")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(20));
            dto.setWorkTypeItemCode("HalfRestStart");
            if (!vo.getTxtHalfRestStartHour().isEmpty()) {
                dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtHalfRestStartHour(), vo.getTxtHalfRestStartMinute()));
            }
        } else if (itemType.equals("HalfRestEnd")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(21));
            dto.setWorkTypeItemCode("HalfRestEnd");
            if (!vo.getTxtHalfRestEndHour().isEmpty()) {
                dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtHalfRestEndHour(), vo.getTxtHalfRestEndMinute()));
            }
        } else if (itemType.equals("DirectStart")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(22));
            dto.setWorkTypeItemCode("DirectStart");
            dto.setPreliminary(vo.getCkbDirectStart());
        } else if (itemType.equals("DirectEnd")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(23));
            dto.setWorkTypeItemCode("DirectEnd");
            dto.setPreliminary(vo.getCkbDirectEnd());
        } else if (itemType.equals("ExcludeNightRest")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(24));
            dto.setWorkTypeItemCode("ExcludeNightRest");
            dto.setPreliminary(vo.getPltMidnightRestExclusion());
        } else if (itemType.equals("Short1Start")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(25));
            dto.setWorkTypeItemCode("Short1Start");
            if (!vo.getTxtShort1StartHour().isEmpty()) {
                dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtShort1StartHour(), vo.getTxtShort1StartMinute()));
                dto.setPreliminary(vo.getPltShort1Type());
            }
        } else if (itemType.equals("Short1End")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(26));
            dto.setWorkTypeItemCode("Short1End");
            if (!vo.getTxtShort1EndHour().isEmpty()) {
                dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtShort1EndHour(), vo.getTxtShort1EndMinute()));
            }
        } else if (itemType.equals("Short2Start")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(27));
            dto.setWorkTypeItemCode("Short2Start");
            if (!vo.getTxtShort2StartHour().isEmpty()) {
                dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtShort2StartHour(), vo.getTxtShort2StartMinute()));
                dto.setPreliminary(vo.getPltShort2Type());
            }
        } else if (itemType.equals("Short2End")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(28));
            dto.setWorkTypeItemCode("Short2End");
            if (!vo.getTxtShort2EndHour().isEmpty()) {
                dto.setWorkTypeItemValue(item.getDefaultTime(vo.getTxtShort2EndHour(), vo.getTxtShort2EndMinute()));
            }
        } else if (itemType.equals("AutoBefOverWork")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(29));
            dto.setWorkTypeItemCode("AutoBefOverWork");
            if (!vo.getPltAutoBeforeOverWork().isEmpty()) {
                dto.setPreliminary(vo.getPltAutoBeforeOverWork());
            }
        }
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
    }

    protected void setVoFieldsItem(WorkTypeItemDtoInterface dto, String itemType) throws MospException {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        if (itemType.equals("WorkStart")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 0);
            vo.setTxtWorkStartHour(DateUtility.getStringHour((Date)dto.getWorkTypeItemValue()));
            vo.setTxtWorkStartMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("WorkEnd")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 1);
            vo.setTxtWorkEndHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtWorkEndMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("WorkTime")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 2);
            vo.setTxtWorkTimeHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtWorkTimeMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestTime")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 3);
            vo.setTxtRestTimeHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestTimeMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestStart1")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 4);
            vo.setTxtRestStart1Hour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestStart1Minute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestEnd1")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 5);
            vo.setTxtRestEnd1Hour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestEnd1Minute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestStart2")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 6);
            vo.setTxtRestStart2Hour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestStart2Minute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestEnd2")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 7);
            vo.setTxtRestEnd2Hour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestEnd2Minute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestStart3")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 8);
            vo.setTxtRestStart3Hour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestStart3Minute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestEnd3")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 9);
            vo.setTxtRestEnd3Hour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestEnd3Minute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestStart4")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 10);
            vo.setTxtRestStart4Hour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestStart4Minute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestEnd4")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 11);
            vo.setTxtRestEnd4Hour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestEnd4Minute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("FrontStart")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 12);
            vo.setTxtFrontStartHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtFrontStartMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("FrontEnd")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 13);
            vo.setTxtFrontEndHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtFrontEndMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("BackStart")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 14);
            vo.setTxtBackStartHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtBackStartMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("BackEnd")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 15);
            vo.setTxtBackEndHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtBackEndMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("OverBefore")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 16);
            vo.setTxtOverBeforeHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtOverBeforeMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("OverPer")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 17);
            vo.setTxtOverPerHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtOverPerMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("OverRest")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 18);
            vo.setTxtOverRestHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtOverRestMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("HalfRest")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 19);
            vo.setTxtHalfRestHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtHalfRestMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("HalfRestStart")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 20);
            vo.setTxtHalfRestStartHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtHalfRestStartMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("HalfRestEnd")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 21);
            vo.setTxtHalfRestEndHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtHalfRestEndMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("DirectStart")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 22);
            vo.setCkbDirectStart(dto.getPreliminary());
        } else if (itemType.equals("DirectEnd")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 23);
            vo.setCkbDirectEnd(dto.getPreliminary());
        } else if (itemType.equals("ExcludeNightRest")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 24);
            vo.setPltMidnightRestExclusion(dto.getPreliminary());
        } else if (itemType.equals("Short1Start")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 25);
            vo.setTxtShort1StartHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtShort1StartMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
            vo.setPltShort1Type(dto.getPreliminary());
        } else if (itemType.equals("Short1End")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 26);
            vo.setTxtShort1EndHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtShort1EndMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("Short2Start")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 27);
            vo.setTxtShort2StartHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtShort2StartMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
            vo.setPltShort2Type(dto.getPreliminary());
        } else if (itemType.equals("Short2End")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 28);
            vo.setTxtShort2EndHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtShort2EndMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("AutoBefOverWork")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 29);
            vo.setPltAutoBeforeOverWork(dto.getPreliminary());
        }
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
    }

    protected int getRestTime() {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        WorkTypeItemReferenceBean time = new WorkTypeItemReferenceBean();
        int rest1 = time.getDifferenceTime(vo.getTxtRestStart1Hour(), vo.getTxtRestStart1Minute(), vo.getTxtRestEnd1Hour(), vo.getTxtRestEnd1Minute());
        int rest2 = time.getDifferenceTime(vo.getTxtRestStart2Hour(), vo.getTxtRestStart2Minute(), vo.getTxtRestEnd2Hour(), vo.getTxtRestEnd2Minute());
        int rest3 = time.getDifferenceTime(vo.getTxtRestStart3Hour(), vo.getTxtRestStart3Minute(), vo.getTxtRestEnd3Hour(), vo.getTxtRestEnd3Minute());
        int rest4 = time.getDifferenceTime(vo.getTxtRestStart4Hour(), vo.getTxtRestStart4Minute(), vo.getTxtRestEnd4Hour(), vo.getTxtRestEnd4Minute());
        return time.getRestTime(rest1, rest2, rest3, rest4);
    }

    private Date getTimestamp(int minute) throws MospException {
        return DateUtility.addMinute((Date)DateUtility.getDefaultTime(), (int)minute);
    }

    private String getWorkTypeItemHour(Date time) throws MospException {
        return DateUtility.getStringHour((Date)time, (Date)DateUtility.getDefaultTime());
    }

    protected List<String> getAddonJsps() {
        ArrayList<String> addonJsps = new ArrayList<String>();
        for (String[] addon : this.getCodeArray(CODE_KEY_ADDONS, false)) {
            String addonJsp = addon[1];
            if (MospUtility.isEmpty((String[])new String[]{addonJsp})) continue;
            addonJsps.add(addonJsp);
        }
        return addonJsps;
    }

    protected void registAddon() throws MospException {
        for (WorkTypeBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.regist();
        }
    }

    protected void registItemAddon() throws MospException {
    }

    protected List<WorkTypeBeanInterface> getAddonBeans() throws MospException {
        ArrayList<WorkTypeBeanInterface> addonBeans = new ArrayList<WorkTypeBeanInterface>();
        for (String[] addon : this.getCodeArray(CODE_KEY_ADDONS, false)) {
            String addonBean = addon[0];
            if (MospUtility.isEmpty((String[])new String[]{addonBean})) continue;
            WorkTypeBeanInterface bean = (WorkTypeBeanInterface)this.platform().createBean(addonBean);
            addonBeans.add(bean);
        }
        return addonBeans;
    }
}

