/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.comparator.base.EmployeeNameComparator;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.HolidayManagementSearchBeanInterface;
import jp.mosp.time.dto.settings.HolidayManagementListDtoInterface;
import jp.mosp.time.settings.vo.SpecialHolidayManagementVo;
import jp.mosp.time.utils.TimeUtility;

public class SpecialHolidayManagementAction
extends TimeAction {
    public static final String CMD_SHOW = "TM4210";
    public static final String CMD_SEARCH = "TM4212";
    public static final String CMD_RE_SHOW = "TM4213";
    public static final String CMD_SORT = "TM4218";
    public static final String CMD_PAGE = "TM4219";
    public static final String CMD_SET_ACTIVATION_DATE = "TM4280";

    public SpecialHolidayManagementAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new SpecialHolidayManagementVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        }
    }

    protected void show() throws MospException {
        SpecialHolidayManagementVo vo = (SpecialHolidayManagementVo)this.mospParams.getVo();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        vo.setComparatorName(EmployeeNameComparator.class.getName());
    }

    protected void search() throws MospException {
        SpecialHolidayManagementVo vo = (SpecialHolidayManagementVo)this.mospParams.getVo();
        HolidayManagementSearchBeanInterface search = this.timeReference().holidayManagementSearch();
        search.setActivateDate(this.getSearchActivateDate());
        search.setEmployeeCode(vo.getTxtSearchEmployeeCode());
        search.setEmployeeName(vo.getTxtSearchEmployeeName());
        search.setWorkPlaceCode(vo.getPltSearchWorkPlace());
        search.setEmploymentCode(vo.getPltSearchEmployment());
        search.setSectionCode(vo.getPltSearchSection());
        search.setPositionCode(vo.getPltSearchPosition());
        List list = search.getSearchList(Integer.parseInt(this.mospParams.getProperties().getCodeArray("HolidayTypeMaster", false)[0][0]));
        vo.setList(list);
        vo.setComparatorName(EmployeeNameComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void setActivationDate() throws MospException {
        SpecialHolidayManagementVo vo = (SpecialHolidayManagementVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    protected void insertMode() throws MospException {
        SpecialHolidayManagementVo vo = (SpecialHolidayManagementVo)this.mospParams.getVo();
        this.setDefaultValues();
        vo.setModeActivateDate("fixed");
        this.setPulldown();
    }

    public void setDefaultValues() {
        SpecialHolidayManagementVo vo = (SpecialHolidayManagementVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        vo.setTxtSearchActivateYear(DateUtility.getStringYear((Date)date));
        vo.setTxtSearchActivateMonth(DateUtility.getStringMonth((Date)date));
        vo.setTxtSearchActivateDay(DateUtility.getStringDay((Date)date));
        vo.setTxtSearchEmployeeCode("");
        vo.setTxtSearchEmployeeName("");
        vo.setPltSearchEmployment("");
        vo.setPltSearchPosition("");
        vo.setPltSearchSection("");
        vo.setPltSearchWorkPlace("");
    }

    protected void setPulldown() throws MospException {
        SpecialHolidayManagementVo vo = (SpecialHolidayManagementVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltSearchSection(this.getInputActivateDatePulldown());
            vo.setAryPltSearchPosition(this.getInputActivateDatePulldown());
            vo.setAryPltSearchEmployment(this.getInputActivateDatePulldown());
            vo.setAryPltSearchWorkPlace(this.getInputActivateDatePulldown());
            return;
        }
        Date targetDate = this.getSearchActivateDate();
        vo.setAryPltSearchSection(this.reference().section().getCodedSelectArray(targetDate, true, null));
        vo.setAryPltSearchPosition(this.reference().position().getCodedSelectArray(targetDate, true, null));
        vo.setAryPltSearchEmployment(this.reference().employmentContract().getCodedSelectArray(targetDate, true, null));
        vo.setAryPltSearchWorkPlace(this.reference().workPlace().getCodedSelectArray(targetDate, true, null));
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        SpecialHolidayManagementVo vo = (SpecialHolidayManagementVo)this.mospParams.getVo();
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblEmployeeName = new String[list.size()];
        String[] aryLblEmployeeCode = new String[list.size()];
        String[] aryLblSection = new String[list.size()];
        String[] aryLblHolidayCode = new String[list.size()];
        String[] aryLblHolidayCodeName = new String[list.size()];
        String[] aryLblHolidayRemainder = new String[list.size()];
        String[] aryLblHolidayLimit = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            HolidayManagementListDtoInterface dto = (HolidayManagementListDtoInterface)list.get(i);
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblEmployeeName[i] = this.getLastFirstName(dto.getLastName(), dto.getFirstName());
            aryLblEmployeeCode[i] = dto.getEmployeeCode();
            aryLblSection[i] = this.reference().section().getSectionAbbr(dto.getSectionCode(), this.getSearchActivateDate());
            aryLblHolidayCodeName[i] = this.getHolidayAbbr(dto.getHolidayCode(), this.getSearchActivateDate(), 2);
            aryLblHolidayCode[i] = String.valueOf(dto.getHolidayCode());
            if (TimeUtility.isUnlimited((Date)dto.getHolidayLimit())) {
                aryLblHolidayRemainder[i] = this.mospParams.getName("NoLimit");
                aryLblHolidayLimit[i] = this.mospParams.getName("NoLimit");
                continue;
            }
            aryLblHolidayRemainder[i] = this.getFormatDaysHoursMinutes(dto.getHolidayRemainder(), dto.getHolidayRemaindHours(), dto.getHolidayRemaindMinutes(), false);
            aryLblHolidayLimit[i] = this.getStringDate(dto.getHolidayLimit());
        }
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblEmployeeName(aryLblEmployeeName);
        vo.setAryLblEmployeeCode(aryLblEmployeeCode);
        vo.setAryLblSection(aryLblSection);
        vo.setAryLblHolidayCode(aryLblHolidayCode);
        vo.setAryLblHolidayCodeName(aryLblHolidayCodeName);
        vo.setAryLblHolidayRemainder(aryLblHolidayRemainder);
        vo.setAryLblHolidayLimit(aryLblHolidayLimit);
    }
}

