/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.ScheduleSearchBeanInterface;
import jp.mosp.time.comparator.settings.ScheduleMasterScheduleCodeComparator;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.settings.vo.ScheduleListVo;

public class ScheduleListAction
extends TimeAction {
    public static final String CMD_SHOW = "TM5410";
    public static final String CMD_SEARCH = "TM5412";
    public static final String CMD_RE_SHOW = "TM5413";
    public static final String CMD_SORT = "TM5418";
    public static final String CMD_PAGE = "TM5419";

    public ScheduleListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new ScheduleListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        }
    }

    protected void show() throws MospException {
        ScheduleListVo vo = (ScheduleListVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.setPulldown();
        vo.setComparatorName(ScheduleMasterScheduleCodeComparator.class.getName());
    }

    protected void search() throws MospException {
        ScheduleListVo vo = (ScheduleListVo)this.mospParams.getVo();
        ScheduleSearchBeanInterface search = this.timeReference().scheduleSearch();
        Date activateDate = MonthUtility.getYearDate((int)this.getInt(vo.getPltSearchFiscalYear()), (MospParams)this.mospParams);
        search.setActivateDate(activateDate);
        search.setFiscalYear(vo.getPltSearchFiscalYear());
        search.setScheduleCode(vo.getTxtSearchScheduleCode());
        search.setScheduleName(vo.getTxtSearchScheduleName());
        search.setScheduleAbbr(vo.getTxtSearchScheduleAbbr());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(ScheduleMasterScheduleCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        this.setPulldown();
        if (list.isEmpty()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() {
        this.setVoList(this.pageList());
    }

    public void setDefaultValues() {
        ScheduleListVo vo = (ScheduleListVo)this.mospParams.getVo();
        vo.setPltSearchFiscalYear(String.valueOf(MonthUtility.getFiscalYear((Date)this.getSystemDate(), (MospParams)this.mospParams)));
        vo.setTxtSearchScheduleCode("");
        vo.setTxtSearchScheduleName("");
        vo.setTxtSearchScheduleAbbr("");
        vo.setPltSearchInactivate(String.valueOf(0));
    }

    private void setPulldown() throws MospException {
        ScheduleListVo vo = (ScheduleListVo)this.mospParams.getVo();
        vo.setAryPltSearchFiscalYear(this.getYearArray(this.getInt(vo.getPltSearchFiscalYear())));
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) {
        ScheduleListVo vo = (ScheduleListVo)this.mospParams.getVo();
        String[] aryCkbScheduleListId = new String[list.size()];
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblFiscalYear = new String[list.size()];
        String[] aryLblScheduleCode = new String[list.size()];
        String[] aryLblScheduleName = new String[list.size()];
        String[] aryLblScheduleAbbr = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ScheduleDtoInterface dto = (ScheduleDtoInterface)list.get(i);
            aryCkbScheduleListId[i] = String.valueOf(dto.getTmmScheduleId());
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblFiscalYear[i] = String.valueOf(dto.getFiscalYear());
            aryLblScheduleCode[i] = dto.getScheduleCode();
            aryLblScheduleName[i] = dto.getScheduleName();
            aryLblScheduleAbbr[i] = dto.getScheduleAbbr();
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
        }
        vo.setAryCkbScheduleListId(aryCkbScheduleListId);
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblFiscalYear(aryLblFiscalYear);
        vo.setAryLblScheduleCode(aryLblScheduleCode);
        vo.setAryLblScheduleName(aryLblScheduleName);
        vo.setAryLblScheduleAbbr(aryLblScheduleAbbr);
        vo.setAryLblInactivate(aryLblInactivate);
    }
}

