/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.TransStringUtility;
import jp.mosp.time.bean.ScheduleDateReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleDateRegistBeanInterface;
import jp.mosp.time.bean.ScheduleReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleRegistBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmScheduleDateDto;
import jp.mosp.time.entity.WorkTypeEntityInterface;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.ScheduleCardVo;
import jp.mosp.time.utils.HolidayUtility;
import jp.mosp.time.utils.TimeUtility;

public class ScheduleCardAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM5420";
    public static final String CMD_SELECT_SHOW = "TM5421";
    public static final String CMD_REFLECTION = "TM5424";
    public static final String CMD_ALL_REFLECTION = "TM5436";
    public static final String CMD_REGIST = "TM5425";
    public static final String CMD_SET_COPY = "TM5426";
    public static final String CMD_DELETE = "TM5427";
    public static final String CMD_MONTH_SWITCH = "TM5429";
    public static final String CMD_SET_ACTIVATION_DATE = "TM5470";
    public static final String CMD_INSERT_MODE = "TM5471";
    public static final String CMD_ADD_MODE = "TM5473";
    public static final String CMD_REPLICATION_MODE = "TM5474";
    public static final String CMD_SET_PATTERN = "TM5478";

    protected BaseVo getSpecificVo() {
        return new ScheduleCardVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_REFLECTION)) {
            this.prepareVo();
            this.reflection();
        } else if (this.mospParams.getCommand().equals(CMD_ALL_REFLECTION)) {
            this.prepareVo();
            this.allReflection();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_SET_COPY)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_MONTH_SWITCH)) {
            this.prepareVo();
            this.monthSwitch();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        } else if (this.mospParams.getCommand().equals(CMD_REPLICATION_MODE)) {
            this.prepareVo();
            this.replicationMode();
        } else if (this.mospParams.getCommand().equals(CMD_SET_PATTERN)) {
            this.prepareVo();
            this.setPattern();
        }
    }

    protected void show() throws MospException {
        this.insertMode();
    }

    protected void reflection() throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        String pltWorkType = vo.getPltWorkType();
        String[] aryWorkTypeMonth = vo.getPltWorkTypeMonth();
        String[] aryLblStartTime = vo.getAryLblStartMonth();
        String[] aryLblEndTime = vo.getAryLblEndMonth();
        String[] aryLblWorkTime = vo.getAryLblWorkMonth();
        int year = DateUtility.getYear((Date)vo.getTargetMonth());
        int month = DateUtility.getMonth((Date)vo.getTargetMonth());
        Date firstDate = MonthUtility.getYearMonthTermFirstDate((int)year, (int)month, (MospParams)this.mospParams);
        Date lastDate = MonthUtility.getYearMonthTermLastDate((int)year, (int)month, (MospParams)this.mospParams);
        Map holidayMap = HolidayUtility.getHolidayMap((int)this.getInt(vo.getPltFiscalYear()), (MospParams)this.mospParams);
        List dateList = TimeUtility.getDateList((Date)firstDate, (Date)lastDate);
        TimeMasterBeanInterface timeMaster = this.timeReference().master();
        if (vo.getRadioSelect().equals("week")) {
            if (vo.getCkbMonday().equals("0") && vo.getCkbTuesday().equals("0") && vo.getCkbWednesday().equals("0") && vo.getCkbThursday().equals("0") && vo.getCkbFriday().equals("0") && vo.getCkbSatureday().equals("0") && vo.getCkbSunday().equals("0") && vo.getCkbNationalHoliday().equals("0")) {
                String[] aryMeassage = new String[]{this.mospParams.getName("DayOfTheWeek")};
                this.mospParams.addMessage("TMW0231", aryMeassage);
                return;
            }
            int i = 0;
            for (Date targetDate : dateList) {
                String strHoliday;
                if (!vo.getCkbMonday().equals("0") && DateUtility.isMonday((Date)targetDate)) {
                    aryWorkTypeMonth[i] = pltWorkType;
                    aryLblStartTime[i] = this.getWorkStartTime(timeMaster, pltWorkType, targetDate);
                    aryLblEndTime[i] = this.getWorkEndTime(timeMaster, pltWorkType, targetDate);
                    aryLblWorkTime[i] = this.getWorkTime(timeMaster, pltWorkType, targetDate);
                }
                if (!vo.getCkbTuesday().equals("0") && DateUtility.isTuesday((Date)targetDate)) {
                    aryWorkTypeMonth[i] = pltWorkType;
                    aryLblStartTime[i] = this.getWorkStartTime(timeMaster, pltWorkType, targetDate);
                    aryLblEndTime[i] = this.getWorkEndTime(timeMaster, pltWorkType, targetDate);
                    aryLblWorkTime[i] = this.getWorkTime(timeMaster, pltWorkType, targetDate);
                }
                if (!vo.getCkbWednesday().equals("0") && DateUtility.isWednesday((Date)targetDate)) {
                    aryWorkTypeMonth[i] = pltWorkType;
                    aryLblStartTime[i] = this.getWorkStartTime(timeMaster, pltWorkType, targetDate);
                    aryLblEndTime[i] = this.getWorkEndTime(timeMaster, pltWorkType, targetDate);
                    aryLblWorkTime[i] = this.getWorkTime(timeMaster, pltWorkType, targetDate);
                }
                if (!vo.getCkbThursday().equals("0") && DateUtility.isThursday((Date)targetDate)) {
                    aryWorkTypeMonth[i] = pltWorkType;
                    aryLblStartTime[i] = this.getWorkStartTime(timeMaster, pltWorkType, targetDate);
                    aryLblEndTime[i] = this.getWorkEndTime(timeMaster, pltWorkType, targetDate);
                    aryLblWorkTime[i] = this.getWorkTime(timeMaster, pltWorkType, targetDate);
                }
                if (!vo.getCkbFriday().equals("0") && DateUtility.isFriday((Date)targetDate)) {
                    aryWorkTypeMonth[i] = pltWorkType;
                    aryLblStartTime[i] = this.getWorkStartTime(timeMaster, pltWorkType, targetDate);
                    aryLblEndTime[i] = this.getWorkEndTime(timeMaster, pltWorkType, targetDate);
                    aryLblWorkTime[i] = this.getWorkTime(timeMaster, pltWorkType, targetDate);
                }
                if (!vo.getCkbSatureday().equals("0") && DateUtility.isSaturday((Date)targetDate)) {
                    aryWorkTypeMonth[i] = pltWorkType;
                    aryLblStartTime[i] = this.getWorkStartTime(timeMaster, pltWorkType, targetDate);
                    aryLblEndTime[i] = this.getWorkEndTime(timeMaster, pltWorkType, targetDate);
                    aryLblWorkTime[i] = this.getWorkTime(timeMaster, pltWorkType, targetDate);
                }
                if (!vo.getCkbSunday().equals("0") && DateUtility.isSunday((Date)targetDate)) {
                    aryWorkTypeMonth[i] = pltWorkType;
                    aryLblStartTime[i] = this.getWorkStartTime(timeMaster, pltWorkType, targetDate);
                    aryLblEndTime[i] = this.getWorkEndTime(timeMaster, pltWorkType, targetDate);
                    aryLblWorkTime[i] = this.getWorkTime(timeMaster, pltWorkType, targetDate);
                }
                if (!vo.getCkbNationalHoliday().equals("0") && (strHoliday = (String)holidayMap.get(DateUtility.getDate((int)year, (int)month, (int)(i + 1)))) != null && !strHoliday.isEmpty()) {
                    aryWorkTypeMonth[i] = pltWorkType;
                    aryLblStartTime[i] = this.getWorkStartTime(timeMaster, pltWorkType, targetDate);
                    aryLblEndTime[i] = this.getWorkEndTime(timeMaster, pltWorkType, targetDate);
                    aryLblWorkTime[i] = this.getWorkTime(timeMaster, pltWorkType, targetDate);
                }
                ++i;
            }
        } else if (vo.getRadioSelect().equals("period")) {
            int scheduleStartDay = this.getInt(vo.getPltScheduleStartDay());
            int scheduleEndDay = this.getInt(vo.getPltScheduleEndDay());
            for (int i = scheduleStartDay - 1; i < scheduleEndDay; ++i) {
                Date targetDate = DateUtility.getDate((int)year, (int)month, (int)(i + 1));
                aryWorkTypeMonth[i] = pltWorkType;
                aryLblStartTime[i] = this.getWorkStartTime(timeMaster, pltWorkType, targetDate);
                aryLblEndTime[i] = this.getWorkEndTime(timeMaster, pltWorkType, targetDate);
                aryLblWorkTime[i] = this.getWorkTime(timeMaster, pltWorkType, targetDate);
            }
        } else if (vo.getRadioSelect().equals("check")) {
            long[] idArray = this.getIdArray(vo.getCkbSelect());
            if (idArray.length == 0) {
                String[] aryMeassage = new String[]{this.mospParams.getName("Date")};
                this.mospParams.addMessage("TMW0231", aryMeassage);
                return;
            }
            for (int i = 0; i < vo.getPltWorkTypeMonth().length; ++i) {
                for (long element : idArray) {
                    if (element != (long)(i + 1)) continue;
                    Date targetDate = DateUtility.getDate((int)year, (int)month, (int)(i + 1));
                    aryWorkTypeMonth[i] = pltWorkType;
                    aryLblStartTime[i] = this.getWorkStartTime(timeMaster, pltWorkType, targetDate);
                    aryLblEndTime[i] = this.getWorkEndTime(timeMaster, pltWorkType, targetDate);
                    aryLblWorkTime[i] = this.getWorkTime(timeMaster, pltWorkType, targetDate);
                }
            }
        } else {
            this.mospParams.addMessage("TMW0205", new String[0]);
        }
        this.initCkbSelect();
        this.initRadioValue();
        vo.setPltWorkTypeMonth(aryWorkTypeMonth);
        vo.setAryLblStartMonth(aryLblStartTime);
        vo.setAryLblEndMonth(aryLblEndTime);
        vo.setAryLblWorkMonth(aryLblWorkTime);
    }

    protected void allReflection() throws MospException {
        Date activateDate;
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        ScheduleReferenceBeanInterface refer = this.timeReference().schedule();
        ScheduleDateReferenceBeanInterface dateRefer = this.timeReference().scheduleDate();
        ScheduleRegistBeanInterface regist = this.time().scheduleRegist();
        String scheduleCode = vo.getTxtScheduleCode();
        ScheduleDtoInterface scheduleDto = refer.findForKey(scheduleCode, activateDate = this.getActivateYearDate());
        if (scheduleDto == null) {
            scheduleDto = regist.getInitDto();
            this.setDtoFields(scheduleDto);
            if (vo.getModeCardEdit().equals("add")) {
                regist.add(scheduleDto);
            } else {
                regist.insert(scheduleDto);
            }
        } else {
            scheduleDto.setPatternCode(vo.getPltPattern());
            scheduleDto.setScheduleName(vo.getTxtScheduleName());
            scheduleDto.setScheduleAbbr(vo.getTxtScheduleAbbr());
            regist.update(scheduleDto);
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        int targetYear = this.getInt(vo.getPltFiscalYear());
        Date firstDate = MonthUtility.getFiscalYearFirstDate((int)targetYear, (MospParams)this.mospParams);
        Date lastDate = MonthUtility.getFiscalYearLastDate((int)targetYear, (MospParams)this.mospParams);
        Date targetDate = firstDate;
        Map holidayMap = HolidayUtility.getHolidayMap((int)targetYear, (MospParams)this.mospParams);
        ArrayList<ScheduleDateDtoInterface> workList = new ArrayList<ScheduleDateDtoInterface>();
        if (vo.getRadioSelect().equals("week")) {
            if (vo.getCkbMonday().equals("0") && vo.getCkbTuesday().equals("0") && vo.getCkbWednesday().equals("0") && vo.getCkbThursday().equals("0") && vo.getCkbFriday().equals("0") && vo.getCkbSatureday().equals("0") && vo.getCkbSunday().equals("0") && vo.getCkbNationalHoliday().equals("0")) {
                String[] aryMeassage = new String[]{this.mospParams.getName("DayOfTheWeek")};
                this.mospParams.addMessage("TMW0231", aryMeassage);
                return;
            }
            while (!targetDate.after(lastDate)) {
                String strHoliday;
                ScheduleDateDtoInterface dateDto = dateRefer.getScheduleDateInfo(scheduleCode, targetDate);
                if (dateDto == null) {
                    dateDto = new TmmScheduleDateDto();
                    dateDto.setScheduleCode(vo.getTxtScheduleCode());
                    dateDto.setActivateDate(this.getActivateYearDate());
                    dateDto.setScheduleDate(targetDate);
                    dateDto.setWorks(1);
                    dateDto.setWorkTypeCode("");
                    String remark = (String)holidayMap.get(targetDate);
                    if (remark == null) {
                        remark = "";
                    }
                    dateDto.setRemark(remark);
                    dateDto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
                }
                if (!vo.getRadioSelect().equals("week")) continue;
                if (vo.getCkbMonday().equals("0") && vo.getCkbTuesday().equals("0") && vo.getCkbWednesday().equals("0") && vo.getCkbThursday().equals("0") && vo.getCkbFriday().equals("0") && vo.getCkbSatureday().equals("0") && vo.getCkbSunday().equals("0") && vo.getCkbNationalHoliday().equals("0")) {
                    String[] aryMeassage = new String[]{this.mospParams.getName("DayOfTheWeek")};
                    this.mospParams.addMessage("TMW0231", aryMeassage);
                    return;
                }
                if (!vo.getCkbMonday().equals("0") && DateUtility.isMonday((Date)targetDate)) {
                    dateDto.setWorkTypeCode(vo.getPltWorkType());
                }
                if (!vo.getCkbTuesday().equals("0") && DateUtility.isTuesday((Date)targetDate)) {
                    dateDto.setWorkTypeCode(vo.getPltWorkType());
                }
                if (!vo.getCkbWednesday().equals("0") && DateUtility.isWednesday((Date)targetDate)) {
                    dateDto.setWorkTypeCode(vo.getPltWorkType());
                }
                if (!vo.getCkbThursday().equals("0") && DateUtility.isThursday((Date)targetDate)) {
                    dateDto.setWorkTypeCode(vo.getPltWorkType());
                }
                if (!vo.getCkbFriday().equals("0") && DateUtility.isFriday((Date)targetDate)) {
                    dateDto.setWorkTypeCode(vo.getPltWorkType());
                }
                if (!vo.getCkbSatureday().equals("0") && DateUtility.isSaturday((Date)targetDate)) {
                    dateDto.setWorkTypeCode(vo.getPltWorkType());
                }
                if (!vo.getCkbSunday().equals("0") && DateUtility.isSunday((Date)targetDate)) {
                    dateDto.setWorkTypeCode(vo.getPltWorkType());
                }
                if (!vo.getCkbNationalHoliday().equals("0") && (strHoliday = (String)holidayMap.get(targetDate)) != null && !strHoliday.isEmpty()) {
                    dateDto.setWorkTypeCode(vo.getPltWorkType());
                }
                targetDate = DateUtility.addDay((Date)targetDate, (int)1);
                workList.add(dateDto);
            }
        } else if (vo.getRadioSelect().equals("period")) {
            int scheduleStartDay = this.getInt(vo.getPltScheduleStartDay());
            int scheduleEndDay = this.getInt(vo.getPltScheduleEndDay());
            while (!targetDate.after(lastDate)) {
                int targetDay = DateUtility.getDay((Date)targetDate);
                ScheduleDateDtoInterface dateDto = dateRefer.getScheduleDateInfo(scheduleCode, targetDate);
                if (dateDto == null) {
                    dateDto = new TmmScheduleDateDto();
                    dateDto.setScheduleCode(vo.getTxtScheduleCode());
                    dateDto.setActivateDate(this.getActivateYearDate());
                    dateDto.setScheduleDate(targetDate);
                    dateDto.setWorks(1);
                    dateDto.setWorkTypeCode("");
                    String remark = (String)holidayMap.get(targetDate);
                    if (remark == null) {
                        remark = "";
                    }
                    dateDto.setRemark(remark);
                    dateDto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
                }
                if (targetDay >= scheduleStartDay && targetDay <= scheduleEndDay) {
                    dateDto.setWorkTypeCode(vo.getPltWorkType());
                }
                targetDate = DateUtility.addDay((Date)targetDate, (int)1);
                workList.add(dateDto);
            }
        } else if (vo.getRadioSelect().equals("check")) {
            long[] idArray = this.getIdArray(vo.getCkbSelect());
            if (idArray.length == 0) {
                String[] aryMeassage = new String[]{this.mospParams.getName("Date")};
                this.mospParams.addMessage("TMW0231", aryMeassage);
                return;
            }
            HashSet<Integer> daySet = new HashSet<Integer>();
            for (long id : idArray) {
                daySet.add(this.getInt(String.valueOf(id)));
            }
            while (!targetDate.after(lastDate)) {
                int targetDay = DateUtility.getDay((Date)targetDate);
                ScheduleDateDtoInterface dateDto = dateRefer.getScheduleDateInfo(scheduleCode, targetDate);
                if (dateDto == null) {
                    dateDto = new TmmScheduleDateDto();
                    dateDto.setScheduleCode(vo.getTxtScheduleCode());
                    dateDto.setActivateDate(this.getActivateYearDate());
                    dateDto.setScheduleDate(targetDate);
                    dateDto.setWorks(1);
                    dateDto.setWorkTypeCode("");
                    String remark = (String)holidayMap.get(targetDate);
                    if (remark == null) {
                        remark = "";
                    }
                    dateDto.setRemark(remark);
                    dateDto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
                }
                if (daySet.contains(targetDay)) {
                    dateDto.setWorkTypeCode(vo.getPltWorkType());
                }
                targetDate = DateUtility.addDay((Date)targetDate, (int)1);
                workList.add(dateDto);
            }
        } else {
            this.mospParams.addMessage("TMW0205", new String[0]);
            return;
        }
        this.allYearRegist(workList);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.setVoFields(scheduleDto);
        List list = this.getScheduleDateList(vo.getTxtScheduleCode(), vo.getTargetMonth());
        this.setVoFieldsDate(list);
        for (int i = 0; i < list.size(); ++i) {
            this.setVoFieldsWork((ScheduleDateDtoInterface)list.get(i), i);
        }
        this.setEditUpdateMode(scheduleDto.getScheduleCode(), scheduleDto.getActivateDate());
        this.setButtonColor(scheduleDto.getScheduleCode());
    }

    protected void regist() throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            if (!vo.getJsCopyModeEdit().equals(CMD_REPLICATION_MODE)) {
                this.insert();
            } else {
                this.replication();
            }
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void allYearRegist(List<ScheduleDateDtoInterface> list) throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        ScheduleDateRegistBeanInterface regist = this.time().scheduleDateRegist();
        if (vo.getModeCardEdit().equals("insert")) {
            if (!vo.getJsCopyModeEdit().equals(CMD_REPLICATION_MODE)) {
                regist.allReflectionRegist(list);
                if (this.mospParams.hasErrorMessage()) {
                    PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
                    return;
                }
                this.commit();
                PfMessageUtility.addMessageNewInsertSucceed((MospParams)this.mospParams);
            }
        } else if (vo.getModeCardEdit().equals("add")) {
            regist.add(list);
            if (this.mospParams.hasErrorMessage()) {
                PfMessageUtility.addMessageUpdateFailed((MospParams)this.mospParams);
                return;
            }
            this.commit();
            PfMessageUtility.addMessageAddHistorySucceed((MospParams)this.mospParams);
        } else if (vo.getModeCardEdit().equals("edit")) {
            regist.allReflectionRegist(list);
            if (this.mospParams.hasErrorMessage()) {
                PfMessageUtility.addMessageUpdateFailed((MospParams)this.mospParams);
                return;
            }
            this.commit();
            PfMessageUtility.addMessageEditHistorySucceed((MospParams)this.mospParams);
        }
    }

    protected void delete() throws MospException {
        ScheduleDtoInterface dto = this.time().scheduleRegist().getInitDto();
        this.setDtoFields(dto);
        this.time().scheduleRegist().delete(dto);
        this.time().scheduleDateRegist().delete(dto.getScheduleCode(), dto.getActivateDate());
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        this.insertMode();
    }

    protected void monthSwitch() throws MospException {
        this.setMonthDate();
        this.initRadioValue();
    }

    protected void setActivationDate() throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        ScheduleReferenceBeanInterface schedule = this.timeReference().schedule();
        if (vo.getModeActivateDate().equals("chaning")) {
            ScheduleDtoInterface dto;
            if (vo.getModeCardEdit().equals("add") && (dto = this.timeReference().schedule().findForKey(vo.getTxtScheduleCode(), this.getActivateYearDate())) != null) {
                this.mospParams.addErrorMessage("TMW0228", new String[0]);
                return;
            }
            this.setModeActivateDate("fixed");
        } else {
            this.setModeActivateDate("chaning");
        }
        vo.setAryPltFiscalYear(this.getYearArray(this.getInt(vo.getPltFiscalYear())));
        this.setPatternPulldown();
        ScheduleDtoInterface scheduleDto = schedule.getScheduleInfo(vo.getTxtScheduleCode(), this.getActivateYearDate());
        if (scheduleDto == null) {
            return;
        }
        vo.setPltPattern(scheduleDto.getPatternCode());
    }

    protected void setMonthDate() throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        int fiscalYear = this.getInt(vo.getPltFiscalYear());
        Date targetMonth = MonthUtility.getFiscalStartMonth((int)fiscalYear, (MospParams)this.mospParams);
        String transferredMonth = this.getTransferredMonth();
        if (transferredMonth != null) {
            targetMonth = MonthUtility.getFiscalYearMonth((int)fiscalYear, (int)this.getInt(transferredMonth), (MospParams)this.mospParams);
        }
        vo.setTargetMonth(targetMonth);
        int year = DateUtility.getYear((Date)targetMonth);
        int month = DateUtility.getMonth((Date)targetMonth);
        Date firstDate = MonthUtility.getYearMonthTermFirstDate((int)year, (int)month, (MospParams)this.mospParams);
        Date lastDate = MonthUtility.getYearMonthTermLastDate((int)year, (int)month, (MospParams)this.mospParams);
        Map holidayMap = HolidayUtility.getHolidayMap((int)fiscalYear, (MospParams)this.mospParams);
        this.setPulldown();
        String[][] workType = vo.getAryPltWorkType();
        if (workType.length == 0 || !workType[0][1].isEmpty()) {
            String mes1 = year + this.mospParams.getName("FiscalYear") + month + this.mospParams.getName("Month", new String[]{"Point"});
            String mes2 = this.mospParams.getName("Work", new String[]{"Form"});
            this.mospParams.addErrorMessage("TMW0265", new String[]{mes1, mes2});
            this.mospParams.addErrorMessage("TMW0266", new String[0]);
            String[] aryLblWorkTypeMonth = new String[]{};
            vo.setPltWorkTypeMonth(aryLblWorkTypeMonth);
            return;
        }
        vo.setLblFiscalYear(year + this.mospParams.getName("Year") + month + this.mospParams.getName("Month"));
        ScheduleDateReferenceBeanInterface scheduleDate = this.timeReference().scheduleDate();
        TimeMasterBeanInterface timeMaster = this.timeReference().master();
        List dateList = TimeUtility.getDateList((Date)firstDate, (Date)lastDate);
        long[] aryCkbRecordId = new long[dateList.size()];
        String[] aryLblWorkTypeMonth = new String[dateList.size()];
        String[] aryLblRemarkMonth = new String[dateList.size()];
        String[] aryLblMonth = new String[dateList.size()];
        String[] aryLblStartMonth = new String[dateList.size()];
        String[] aryLblEndMonth = new String[dateList.size()];
        String[] aryLblWorkMonth = new String[dateList.size()];
        String[][] aryPltWorkType = vo.getAryPltWorkType();
        int i = 0;
        for (Date targetDate : dateList) {
            ScheduleDateDtoInterface dto = scheduleDate.getScheduleDateInfo(vo.getTxtScheduleCode(), targetDate);
            aryCkbRecordId[i] = i + 1;
            aryLblMonth[i] = DateUtility.getStringMonthAndDay((Date)targetDate);
            if (!MospUtility.isEmpty((Object[])new Object[]{dto})) {
                String workTypeCode;
                aryLblWorkTypeMonth[i] = workTypeCode = dto.getWorkTypeCode();
                aryLblStartMonth[i] = this.getWorkStartTime(timeMaster, workTypeCode, targetDate);
                aryLblEndMonth[i] = this.getWorkEndTime(timeMaster, workTypeCode, targetDate);
                aryLblWorkMonth[i] = this.getWorkTime(timeMaster, workTypeCode, targetDate);
                aryLblRemarkMonth[i] = String.valueOf(dto.getRemark());
            } else {
                aryLblWorkTypeMonth[i] = aryPltWorkType[0][0];
                aryLblStartMonth[i] = this.getWorkStartTime(timeMaster, aryLblWorkTypeMonth[i], targetDate);
                aryLblEndMonth[i] = this.getWorkEndTime(timeMaster, aryLblWorkTypeMonth[i], targetDate);
                aryLblWorkMonth[i] = this.getWorkTime(timeMaster, aryLblWorkTypeMonth[i], targetDate);
                String strHoliday = (String)holidayMap.get(targetDate);
                aryLblRemarkMonth[i] = strHoliday != null && !strHoliday.isEmpty() ? strHoliday : "";
            }
            ++i;
        }
        vo.setAryCkbRecordId(aryCkbRecordId);
        vo.setAryLblMonth(aryLblMonth);
        vo.setPltWorkTypeMonth(aryLblWorkTypeMonth);
        vo.setAryLblStartMonth(aryLblStartMonth);
        vo.setAryLblEndMonth(aryLblEndMonth);
        vo.setAryLblWorkMonth(aryLblWorkMonth);
        vo.setTxtRemarkMonth(aryLblRemarkMonth);
    }

    protected void insertMode() throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        this.setEditInsertMode();
        this.setDefaultValues();
        this.setModeActivateDate("chaning");
        vo.setModePattern("chaning");
        this.setPulldown();
        this.setPatternPulldown();
    }

    protected void addMode() throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        vo.setJsCopyModeEdit("off");
        vo.setButtonBackColorJanuary(this.setButtonBackColor(0));
        vo.setButtonBackColorFebruary(this.setButtonBackColor(0));
        vo.setButtonBackColorMarch(this.setButtonBackColor(0));
        vo.setButtonBackColorApril(this.setButtonBackColor(0));
        vo.setButtonBackColorMay(this.setButtonBackColor(0));
        vo.setButtonBackColorJune(this.setButtonBackColor(0));
        vo.setButtonBackColorJuly(this.setButtonBackColor(0));
        vo.setButtonBackColorAugust(this.setButtonBackColor(0));
        vo.setButtonBackColorSeptember(this.setButtonBackColor(0));
        vo.setButtonBackColorOctorber(this.setButtonBackColor(0));
        vo.setButtonBackColorNovember(this.setButtonBackColor(0));
        vo.setButtonBackColorDecember(this.setButtonBackColor(0));
        this.setEditAddMode();
        this.setModeActivateDate("chaning");
        vo.setModePattern("chaning");
        this.setPatternPulldown();
    }

    protected void editMode() throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        vo.setJsCopyModeEdit("off");
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
        this.setModeActivateDate("fixed");
        vo.setModePattern("fixed");
        this.setPulldown();
        this.setPatternPulldown();
        this.monthSwitch();
    }

    protected void replicationMode() {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        this.setEditReplicationMode();
        vo.setModePattern("chaning");
        vo.setJsCopyModeEdit(CMD_REPLICATION_MODE);
        vo.setCopyFiscalYear(vo.getPltFiscalYear());
        vo.setCopyScheduleCode(vo.getTxtScheduleCode());
        vo.setTxtScheduleCode("");
    }

    protected void setPattern() throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        if ("chaning".equals(vo.getModePattern())) {
            vo.setModePattern("fixed");
            this.monthSwitch();
            return;
        }
        if ("fixed".equals(vo.getModePattern())) {
            vo.setModePattern("chaning");
        }
    }

    protected void insert() throws MospException {
        ScheduleRegistBeanInterface regist = this.time().scheduleRegist();
        ScheduleDateRegistBeanInterface regist2 = this.time().scheduleDateRegist();
        ScheduleDtoInterface dto = regist.getInitDto();
        ArrayList listWork = new ArrayList();
        this.setDtoFields(dto);
        List list = this.setDtoFieldsDate(listWork);
        regist.insert(dto);
        regist2.insert(list);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageNewInsertSucceed((MospParams)this.mospParams);
        this.setVoFields(dto);
        this.setVoFieldsDate(list);
        for (int i = 0; i < list.size(); ++i) {
            this.setVoFieldsWork((ScheduleDateDtoInterface)list.get(i), i);
        }
        this.setEditUpdateMode(dto.getScheduleCode(), dto.getActivateDate());
        this.setButtonColor(dto.getScheduleCode());
    }

    protected void add() throws MospException {
        int i;
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        ScheduleRegistBeanInterface regist = this.time().scheduleRegist();
        ScheduleDateRegistBeanInterface regist2 = this.time().scheduleDateRegist();
        ScheduleDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.add(dto);
        String scheduleCode = vo.getTxtScheduleCode();
        List list = this.getScheduleDateList(scheduleCode, vo.getTargetMonth());
        List workList = this.setDtoFieldsDate(list);
        regist2.add(workList);
        Date targetMonth = MonthUtility.getFiscalStartMonth((int)this.getInt(vo.getPltFiscalYear()), (MospParams)this.mospParams);
        for (i = 0; i < 12; ++i) {
            if (targetMonth.equals(vo.getTargetMonth())) {
                targetMonth = DateUtility.addMonth((Date)targetMonth, (int)1);
                continue;
            }
            List allMonthList = this.getScheduleDateList(scheduleCode, targetMonth);
            if (!allMonthList.isEmpty()) {
                ArrayList<ScheduleDateDtoInterface> workAllMonthList = new ArrayList<ScheduleDateDtoInterface>();
                for (int j = 0; j < allMonthList.size(); ++j) {
                    ScheduleDateDtoInterface scheduleDto = (ScheduleDateDtoInterface)allMonthList.get(j);
                    scheduleDto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
                    workAllMonthList.add(scheduleDto);
                }
                regist2.add(workAllMonthList);
            }
            targetMonth = DateUtility.addMonth((Date)targetMonth, (int)1);
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageUpdateFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageAddHistorySucceed((MospParams)this.mospParams);
        this.setVoFields(dto);
        this.setVoFieldsDate(workList);
        for (i = 0; i < workList.size(); ++i) {
            this.setVoFieldsWork((ScheduleDateDtoInterface)workList.get(i), i);
        }
        this.setEditUpdateMode(dto.getScheduleCode(), dto.getActivateDate());
        this.setButtonColor(dto.getScheduleCode());
    }

    protected void update() throws MospException {
        int i;
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        ScheduleRegistBeanInterface regist = this.time().scheduleRegist();
        ScheduleDateRegistBeanInterface dateRegist = this.time().scheduleDateRegist();
        ScheduleDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        String scheduleCode = vo.getTxtScheduleCode();
        List list = this.getScheduleDateList(scheduleCode, vo.getTargetMonth());
        List workList = this.setDtoFieldsDate(list);
        if (list.isEmpty()) {
            dateRegist.insert(workList);
        } else {
            dateRegist.update(workList);
        }
        Date targetMonth = MonthUtility.getFiscalStartMonth((int)this.getInt(vo.getPltFiscalYear()), (MospParams)this.mospParams);
        for (i = 0; i < 12; ++i) {
            List allMonthList = this.getScheduleDateList(scheduleCode, targetMonth);
            if (!allMonthList.isEmpty()) {
                ArrayList<ScheduleDateDtoInterface> workAllMonthList = new ArrayList<ScheduleDateDtoInterface>();
                for (int j = 0; j < allMonthList.size(); ++j) {
                    ScheduleDateDtoInterface scheduleDto = (ScheduleDateDtoInterface)allMonthList.get(j);
                    scheduleDto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
                    workAllMonthList.add(scheduleDto);
                }
                dateRegist.update(workAllMonthList);
            }
            targetMonth = DateUtility.addMonth((Date)targetMonth, (int)1);
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageUpdateFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageEditHistorySucceed((MospParams)this.mospParams);
        this.setVoFields(dto);
        this.setVoFieldsDate(workList);
        for (i = 0; i < workList.size(); ++i) {
            this.setVoFieldsWork((ScheduleDateDtoInterface)workList.get(i), i);
        }
        this.setEditUpdateMode(dto.getScheduleCode(), dto.getActivateDate());
        this.setButtonColor(dto.getScheduleCode());
    }

    protected void replication() throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        ScheduleRegistBeanInterface regist = this.time().scheduleRegist();
        ScheduleDateRegistBeanInterface regist2 = this.time().scheduleDateRegist();
        ScheduleDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        Date targetMonth = MonthUtility.getFiscalStartMonth((int)this.getInt(vo.getPltFiscalYear()), (MospParams)this.mospParams);
        for (int i = 0; i < 12; ++i) {
            String[][] workTypeArray = this.getWorkTypeArray(targetMonth);
            String[][] dayOffArray = this.mospParams.getProperties().getCodeArray("PrescribedLegalHoliday", true);
            List allMonthList = this.getScheduleDateList(vo.getCopyScheduleCode(), targetMonth);
            if (!allMonthList.isEmpty()) {
                ArrayList<ScheduleDateDtoInterface> workAllMonthList = new ArrayList<ScheduleDateDtoInterface>();
                for (int j = 0; j < allMonthList.size(); ++j) {
                    ScheduleDateDtoInterface scheduleDto = (ScheduleDateDtoInterface)allMonthList.get(j);
                    scheduleDto.setActivateDate(dto.getActivateDate());
                    scheduleDto.setScheduleCode(dto.getScheduleCode());
                    if (!this.contains(scheduleDto.getWorkTypeCode(), workTypeArray) && !this.contains(scheduleDto.getWorkTypeCode(), dayOffArray)) {
                        scheduleDto.setWorkTypeCode("");
                    }
                    scheduleDto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
                    workAllMonthList.add(scheduleDto);
                }
                regist2.insert(workAllMonthList);
            }
            targetMonth = DateUtility.addMonth((Date)targetMonth, (int)1);
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageNewInsertSucceed((MospParams)this.mospParams);
        this.setVoFields(dto);
        List list = this.getScheduleDateList(vo.getTxtScheduleCode(), vo.getTargetMonth());
        this.setVoFieldsDate(list);
        for (int i = 0; i < list.size(); ++i) {
            this.setVoFieldsWork((ScheduleDateDtoInterface)list.get(i), i);
        }
        this.setEditUpdateMode(dto.getScheduleCode(), dto.getActivateDate());
        this.setButtonColor(dto.getScheduleCode());
        vo.setJsCopyModeEdit("off");
    }

    protected void setEditUpdateMode(String scheduleCode, Date activateDate) throws MospException {
        ScheduleReferenceBeanInterface schedule = this.timeReference().schedule();
        ScheduleDtoInterface dto = schedule.findForKey(scheduleCode, activateDate);
        this.setVoFields(dto);
        this.setModeActivateDate("fixed");
        this.setEditUpdateMode(schedule.getScheduleHistory(scheduleCode));
        this.setButtonColor(scheduleCode);
    }

    public void setDefaultValues() {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        vo.setPltFiscalYear(String.valueOf(MonthUtility.getFiscalYear((Date)this.getSystemDate(), (MospParams)this.mospParams)));
        vo.setPltPattern("");
        vo.setTxtScheduleCode("");
        vo.setTxtScheduleName("");
        vo.setTxtScheduleAbbr("");
        vo.setPltWorkTypeChange(String.valueOf(0));
        vo.setLblFiscalYear("");
        vo.setPltWorkType("");
        vo.setPltScheduleStartDay("");
        vo.setPltScheduleEndDay("");
        String[] initWorkTypeMonth = new String[]{""};
        vo.setPltWorkTypeMonth(initWorkTypeMonth);
        vo.setButtonBackColorJanuary(this.setButtonBackColor(0));
        vo.setButtonBackColorFebruary(this.setButtonBackColor(0));
        vo.setButtonBackColorMarch(this.setButtonBackColor(0));
        vo.setButtonBackColorApril(this.setButtonBackColor(0));
        vo.setButtonBackColorMay(this.setButtonBackColor(0));
        vo.setButtonBackColorJune(this.setButtonBackColor(0));
        vo.setButtonBackColorJuly(this.setButtonBackColor(0));
        vo.setButtonBackColorAugust(this.setButtonBackColor(0));
        vo.setButtonBackColorSeptember(this.setButtonBackColor(0));
        vo.setButtonBackColorOctorber(this.setButtonBackColor(0));
        vo.setButtonBackColorNovember(this.setButtonBackColor(0));
        vo.setButtonBackColorDecember(this.setButtonBackColor(0));
        vo.setJsCopyModeEdit("off");
        vo.setCopyFiscalYear("");
        vo.setCopyScheduleCode("");
        vo.setRadioWeek("week");
        vo.setRadioPeriod("period");
        vo.setRadioCheck("check");
    }

    protected void setPulldown() throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        String[][] aryDataType = this.mospParams.getProperties().getCodeArray("PrescribedLegalHoliday", true);
        int fiscalYear = this.getInt(vo.getPltFiscalYear());
        vo.setAryPltFiscalYear(this.getYearArray(fiscalYear));
        Date targetMonth = MonthUtility.getFiscalStartMonth((int)fiscalYear, (MospParams)this.mospParams);
        String transferredMonth = this.getTransferredMonth();
        if (transferredMonth != null) {
            targetMonth = MonthUtility.getFiscalYearMonth((int)fiscalYear, (int)this.getInt(transferredMonth), (MospParams)this.mospParams);
        }
        int year = DateUtility.getYear((Date)targetMonth);
        int month = DateUtility.getMonth((Date)targetMonth);
        Date yearMonthTermLastDate = MonthUtility.getYearMonthTermLastDate((int)year, (int)month, (MospParams)this.mospParams);
        String[][] pltWorkType = this.getWorkTypeArray(targetMonth, true);
        vo.setAryPltScheduleDay(this.getDayArray(DateUtility.getDay((Date)yearMonthTermLastDate), false));
        String[][] pltWorkTypeMonth = this.getWorkTypeArray(targetMonth, false);
        ArrayList workTypeList = new ArrayList(Arrays.asList(aryDataType));
        ArrayList workTypeMonthList = new ArrayList(Arrays.asList(aryDataType));
        workTypeList.addAll(Arrays.asList(pltWorkType));
        workTypeMonthList.addAll(Arrays.asList(pltWorkTypeMonth));
        vo.setAryPltWorkType((String[][])workTypeList.toArray((T[])new String[workTypeList.size()][]));
        vo.setAryPltWorkTypeMonth((String[][])workTypeMonthList.toArray((T[])new String[workTypeMonthList.size()][]));
    }

    protected void setPatternPulldown() throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        if ("chaning".equals(vo.getModeActivateDate())) {
            vo.setAryPltPattern(this.getInputActivateDatePulldown());
            return;
        }
        String[][] aryPltPattern = this.timeReference().workTypePattern().getSelectArray(this.getActivateYearDate());
        if (aryPltPattern.length == 1) {
            vo.setAryPltPattern((String[][])new String[][]{{"", ""}});
            return;
        }
        vo.setAryPltPattern(aryPltPattern);
    }

    protected void setDtoFields(ScheduleDtoInterface dto) throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        dto.setTmmScheduleId(vo.getRecordId());
        dto.setActivateDate(MonthUtility.getFiscalYearFirstDate((int)this.getInt(vo.getPltFiscalYear()), (MospParams)this.mospParams));
        dto.setFiscalYear(this.getInt(vo.getPltFiscalYear()));
        dto.setScheduleCode(vo.getTxtScheduleCode());
        dto.setScheduleName(vo.getTxtScheduleName());
        dto.setScheduleAbbr(vo.getTxtScheduleAbbr());
        dto.setPatternCode(vo.getPltPattern());
        dto.setWorkTypeChangeFlag(this.getInt(vo.getPltWorkTypeChange()));
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
    }

    protected void setVoFields(ScheduleDtoInterface dto) {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        vo.setRecordId(dto.getTmmScheduleId());
        Date date = dto.getActivateDate();
        vo.setTxtEditActivateYear(this.getStringYear(date));
        vo.setTxtEditActivateMonth(this.getStringMonth(date));
        vo.setTxtEditActivateDay(this.getStringDay(date));
        vo.setPltFiscalYear(String.valueOf(dto.getFiscalYear()));
        vo.setTxtScheduleCode(dto.getScheduleCode());
        vo.setTxtScheduleName(dto.getScheduleName());
        vo.setTxtScheduleAbbr(dto.getScheduleAbbr());
        vo.setPltPattern(dto.getPatternCode());
        vo.setPltWorkTypeChange(String.valueOf(dto.getWorkTypeChangeFlag()));
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
    }

    protected List<ScheduleDateDtoInterface> setDtoFieldsDate(List<ScheduleDateDtoInterface> list) throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        int year = DateUtility.getYear((Date)vo.getTargetMonth());
        int month = DateUtility.getMonth((Date)vo.getTargetMonth());
        Date lastDate = MonthUtility.getYearMonthTermLastDate((int)year, (int)month, (MospParams)this.mospParams);
        Date targetDate = MonthUtility.getYearMonthTermFirstDate((int)year, (int)month, (MospParams)this.mospParams);
        ArrayList<ScheduleDateDtoInterface> workList = new ArrayList<ScheduleDateDtoInterface>();
        String[] aryWorkTypeMonth = vo.getPltWorkTypeMonth();
        String[] aryTxtRemarkMonth = vo.getTxtRemarkMonth();
        int index = 0;
        while (!targetDate.after(lastDate)) {
            TmmScheduleDateDto dto = new TmmScheduleDateDto();
            if (!list.isEmpty()) {
                ScheduleDateDtoInterface listDto = list.get(index);
                dto.setTmmScheduleDateId(listDto.getTmmScheduleDateId());
            }
            dto.setScheduleCode(vo.getTxtScheduleCode());
            dto.setActivateDate(this.getActivateYearDate());
            dto.setScheduleDate(targetDate);
            dto.setWorks(1);
            dto.setWorkTypeCode(aryWorkTypeMonth[index]);
            dto.setRemark(aryTxtRemarkMonth[index]);
            dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
            workList.add((ScheduleDateDtoInterface)dto);
            ++index;
            targetDate = DateUtility.addDay((Date)targetDate, (int)1);
        }
        return workList;
    }

    protected void setVoFieldsDate(List<ScheduleDateDtoInterface> list) throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        String[] aryPltWorkTypeMonth = new String[vo.getPltWorkTypeMonth().length];
        String[] aryTxtRemarkMonth = new String[vo.getTxtRemarkMonth().length];
        int i = 0;
        for (ScheduleDateDtoInterface dto : list) {
            aryPltWorkTypeMonth[i] = dto.getWorkTypeCode();
            aryTxtRemarkMonth[i] = dto.getRemark();
            ++i;
        }
        vo.setPltWorkTypeMonth(aryPltWorkTypeMonth);
        vo.setTxtRemarkMonth(aryTxtRemarkMonth);
    }

    protected void setVoFieldsWork(ScheduleDateDtoInterface dto, int i) throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        if (vo.getPltWorkTypeMonth().length == 0) {
            return;
        }
        vo.setTxtScheduleCode(dto.getScheduleCode());
        String workTypeCode = dto.getWorkTypeCode();
        Date targetDate = dto.getScheduleDate();
        TimeMasterBeanInterface timeMaster = this.timeReference().master();
        String[] aryLblStartMonth = vo.getAryLblStartMonth();
        String[] aryLblEndMonth = vo.getAryLblEndMonth();
        String[] aryLblWorkMonth = vo.getAryLblWorkMonth();
        aryLblStartMonth[i] = this.getWorkStartTime(timeMaster, workTypeCode, targetDate);
        aryLblEndMonth[i] = this.getWorkEndTime(timeMaster, workTypeCode, targetDate);
        aryLblWorkMonth[i] = this.getWorkTime(timeMaster, workTypeCode, targetDate);
        vo.setAryLblStartMonth(aryLblStartMonth);
        vo.setAryLblEndMonth(aryLblEndMonth);
        vo.setAryLblWorkMonth(aryLblWorkMonth);
    }

    protected String getWorkStartTime(TimeMasterBeanInterface timeMaster, String workTypeCode, Date targetDate) throws MospException {
        WorkTypeEntityInterface workType = timeMaster.getWorkTypeEntity(workTypeCode, targetDate);
        Date date = workType.getItemValue("WorkStart", true);
        return TransStringUtility.getHourColonMinute((MospParams)this.mospParams, (Date)date, (Date)DateUtility.getDefaultTime(), (boolean)true);
    }

    protected String getWorkEndTime(TimeMasterBeanInterface timeMaster, String workTypeCode, Date targetDate) throws MospException {
        WorkTypeEntityInterface workType = timeMaster.getWorkTypeEntity(workTypeCode, targetDate);
        Date date = workType.getItemValue("WorkEnd", true);
        return TransStringUtility.getHourColonMinute((MospParams)this.mospParams, (Date)date, (Date)DateUtility.getDefaultTime(), (boolean)true);
    }

    protected String getWorkTime(TimeMasterBeanInterface timeMaster, String workTypeCode, Date targetDate) throws MospException {
        WorkTypeEntityInterface workType = timeMaster.getWorkTypeEntity(workTypeCode, targetDate);
        Date date = workType.getItemValue("WorkTime", true);
        return TransStringUtility.getHourPeriodMinute((MospParams)this.mospParams, (Date)date, (Date)DateUtility.getDefaultTime(), (boolean)false, (boolean)true);
    }

    protected void setButtonColor(String scheduleCode) throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        vo.setButtonBackColorJanuary(this.setButtonBackColor(0));
        vo.setButtonBackColorFebruary(this.setButtonBackColor(0));
        vo.setButtonBackColorMarch(this.setButtonBackColor(0));
        vo.setButtonBackColorApril(this.setButtonBackColor(0));
        vo.setButtonBackColorMay(this.setButtonBackColor(0));
        vo.setButtonBackColorJune(this.setButtonBackColor(0));
        vo.setButtonBackColorJuly(this.setButtonBackColor(0));
        vo.setButtonBackColorAugust(this.setButtonBackColor(0));
        vo.setButtonBackColorSeptember(this.setButtonBackColor(0));
        vo.setButtonBackColorOctorber(this.setButtonBackColor(0));
        vo.setButtonBackColorNovember(this.setButtonBackColor(0));
        vo.setButtonBackColorDecember(this.setButtonBackColor(0));
        Date targetMonth = MonthUtility.getFiscalStartMonth((int)this.getInt(vo.getPltFiscalYear()), (MospParams)this.mospParams);
        for (int i = 0; i < 12; ++i) {
            List list = this.getScheduleDateList(scheduleCode, targetMonth);
            if (!list.isEmpty()) {
                int month = DateUtility.getMonth((Date)targetMonth);
                if (month == this.getInt("1")) {
                    vo.setButtonBackColorJanuary(this.setButtonBackColor(1));
                } else if (month == this.getInt("2")) {
                    vo.setButtonBackColorFebruary(this.setButtonBackColor(1));
                } else if (month == this.getInt("3")) {
                    vo.setButtonBackColorMarch(this.setButtonBackColor(1));
                } else if (month == this.getInt("4")) {
                    vo.setButtonBackColorApril(this.setButtonBackColor(1));
                } else if (month == this.getInt("5")) {
                    vo.setButtonBackColorMay(this.setButtonBackColor(1));
                } else if (month == this.getInt("6")) {
                    vo.setButtonBackColorJune(this.setButtonBackColor(1));
                } else if (month == this.getInt("7")) {
                    vo.setButtonBackColorJuly(this.setButtonBackColor(1));
                } else if (month == this.getInt("8")) {
                    vo.setButtonBackColorAugust(this.setButtonBackColor(1));
                } else if (month == this.getInt("9")) {
                    vo.setButtonBackColorSeptember(this.setButtonBackColor(1));
                } else if (month == this.getInt("10")) {
                    vo.setButtonBackColorOctorber(this.setButtonBackColor(1));
                } else if (month == this.getInt("11")) {
                    vo.setButtonBackColorNovember(this.setButtonBackColor(1));
                } else if (month == this.getInt("12")) {
                    vo.setButtonBackColorDecember(this.setButtonBackColor(1));
                }
            }
            targetMonth = DateUtility.addMonth((Date)targetMonth, (int)1);
        }
    }

    protected List<ScheduleDateDtoInterface> getScheduleDateList(String scheduleCode, Date targetMonth) throws MospException {
        int year = DateUtility.getYear((Date)targetMonth);
        int month = DateUtility.getMonth((Date)targetMonth);
        Date startDate = MonthUtility.getYearMonthTermFirstDate((int)year, (int)month, (MospParams)this.mospParams);
        Date endDate = MonthUtility.getYearMonthTermLastDate((int)year, (int)month, (MospParams)this.mospParams);
        return this.timeReference().scheduleDate().findForList(scheduleCode, startDate, endDate);
    }

    protected void initRadioValue() {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        vo.setRadioSelect("0");
        vo.setRadioCheck("check");
        vo.setRadioPeriod("period");
        vo.setRadioWeek("week");
    }

    protected String[][] getWorkTypeArray(Date targetDate) throws MospException {
        return this.getWorkTypeArray(targetDate, true);
    }

    protected String[][] getWorkTypeArray(Date targetDate, boolean isName) throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        return this.getWorkTypeArray(vo.getPltPattern(), targetDate, isName, isName, false, false);
    }

    protected Date getActivateYearDate() throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        return MonthUtility.getYearDate((int)this.getInt(vo.getPltFiscalYear()), (MospParams)this.mospParams);
    }

    protected Date getFiscalYearMonth(String month) throws MospException {
        ScheduleCardVo vo = (ScheduleCardVo)this.mospParams.getVo();
        int fiscalYear = this.getInt(vo.getPltFiscalYear());
        return MonthUtility.getFiscalYearMonth((int)fiscalYear, (int)this.getInt(month), (MospParams)this.mospParams);
    }

    protected boolean contains(String code, String[][] array) {
        for (String[] strings : array) {
            if (!code.equals(strings[0])) continue;
            return true;
        }
        return false;
    }
}

