/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.MospProperties;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.bean.PaidHolidaySearchBeanInterface;
import jp.mosp.time.comparator.settings.PaidHolidayMasterPaidHolidayCodeComparator;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.PaidHolidayListVo;

public class PaidHolidayListAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM5310";
    public static final String CMD_SEARCH = "TM5312";
    public static final String CMD_RE_SHOW = "TM5313";
    public static final String CMD_SORT = "TM5318";
    public static final String CMD_PAGE = "TM5319";
    public static final String CMD_BATCH_UPDATE = "TM5385";

    public PaidHolidayListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new PaidHolidayListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        }
    }

    protected void show() {
        PaidHolidayListVo vo = (PaidHolidayListVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.setPulldown();
        vo.setComparatorName(PaidHolidayMasterPaidHolidayCodeComparator.class.getName());
    }

    public void setDefaultValues() {
        PaidHolidayListVo vo = (PaidHolidayListVo)this.mospParams.getVo();
        Date date = DateUtility.getSystemDate();
        vo.setTxtSearchActivateYear(DateUtility.getStringYear((Date)date));
        vo.setTxtSearchActivateMonth(DateUtility.getStringMonth((Date)date));
        vo.setTxtSearchActivateDay(DateUtility.getStringDay((Date)date));
        vo.setPltSearchPaidHolidayType("");
        vo.setTxtSearchPaidHolidayCode("");
        vo.setTxtSearchPaidHolidayName("");
        vo.setTxtSearchPaidHolidayAbbr("");
        vo.setPltSearchInactivate(String.valueOf(0));
        vo.setPltSearchPaidHolidayType("");
        vo.setTxtUpdateActivateYear(DateUtility.getStringYear((Date)date));
        vo.setTxtUpdateActivateMonth(DateUtility.getStringMonth((Date)date));
        vo.setTxtUpdateActivateDay(DateUtility.getStringDay((Date)date));
    }

    private void setPulldown() {
        PaidHolidayListVo vo = (PaidHolidayListVo)this.mospParams.getVo();
        MospProperties properties = this.mospParams.getProperties();
        String[][] aryHolidayType = properties.getCodeArray("PaidHolidayType", false);
        vo.setAryPltSearchPaidHolidayType(aryHolidayType);
    }

    protected void search() throws MospException {
        PaidHolidayListVo vo = (PaidHolidayListVo)this.mospParams.getVo();
        PaidHolidaySearchBeanInterface search = this.timeReference().paidHolidaySearch();
        search.setActivateDate(this.getSearchActivateDate());
        search.setPaidHolidayType(vo.getPltSearchPaidHolidayType());
        search.setPaidHolidayCode(vo.getTxtSearchPaidHolidayCode());
        search.setPaidHolidayName(vo.getTxtSearchPaidHolidayName());
        search.setPaidHolidayAbbr(vo.getTxtSearchPaidHolidayAbbr());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(PaidHolidayMasterPaidHolidayCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.size() == 0) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) {
        PaidHolidayListVo vo = (PaidHolidayListVo)this.mospParams.getVo();
        String[] aryCkbPaidHolidayListId = new String[list.size()];
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblPaidHolidayType = new String[list.size()];
        String[] aryLblPaidHolidayCode = new String[list.size()];
        String[] aryLblPaidHolidayName = new String[list.size()];
        String[] aryLblPaidHolidayAbbr = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            PaidHolidayDtoInterface dto = (PaidHolidayDtoInterface)list.get(i);
            aryCkbPaidHolidayListId[i] = Long.toString(dto.getTmmPaidHolidayId());
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblPaidHolidayType[i] = this.mospParams.getProperties().getCodeItemName("PaidHolidayType", Integer.toString(dto.getPaidHolidayType()));
            aryLblPaidHolidayCode[i] = dto.getPaidHolidayCode();
            aryLblPaidHolidayName[i] = dto.getPaidHolidayName();
            aryLblPaidHolidayAbbr[i] = dto.getPaidHolidayAbbr();
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
        }
        vo.setAryCkbPaidHolidayListId(aryCkbPaidHolidayListId);
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblPaidHolidayType(aryLblPaidHolidayType);
        vo.setAryLblPaidHolidayCode(aryLblPaidHolidayCode);
        vo.setAryLblPaidHolidayName(aryLblPaidHolidayName);
        vo.setAryLblPaidHolidayAbbr(aryLblPaidHolidayAbbr);
        vo.setAryLblInactivate(aryLblInactivate);
    }

    protected void page() {
        this.setVoList(this.pageList());
    }

    protected void batchUpdate() throws MospException {
        PaidHolidayListVo vo = (PaidHolidayListVo)this.mospParams.getVo();
        this.time().paidHolidayRegist().update(this.getIdArray(vo.getCkbSelect()), this.getUpdateActivateDate(), this.getInt(vo.getPltUpdateInactivate()));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageUpdateFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageUpdatetSucceed((MospParams)this.mospParams);
        this.setSearchActivateDate(this.getUpdateActivateDate());
        this.search();
    }
}

