/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.base.TimeBeanHandlerInterface;
import jp.mosp.time.bean.PaidHolidayEntranceDateRegistBeanInterface;
import jp.mosp.time.bean.PaidHolidayFirstYearRegistBeanInterface;
import jp.mosp.time.bean.PaidHolidayPointDateRegistBeanInterface;
import jp.mosp.time.bean.PaidHolidayProportionallyReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayProportionallyRegistBeanInterface;
import jp.mosp.time.bean.PaidHolidayRegistBeanInterface;
import jp.mosp.time.bean.StockHolidayRegistBeanInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayEntranceDateDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayFirstYearDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayPointDateDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayProportionallyDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayDtoInterface;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.PaidHolidayCardVo;

public class PaidHolidayCardAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM5320";
    public static final String CMD_SELECT_SHOW = "TM5321";
    public static final String CMD_REGIST = "TM5325";
    public static final String CMD_DELETE = "TM5327";
    public static final String CMD_INSERT_MODE = "TM5371";
    public static final String CMD_ADD_MODE = "TM5373";
    public static final String CMD_REPLICATION_MODE = "TM5374";

    protected BaseVo getSpecificVo() {
        return new PaidHolidayCardVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        } else if (this.mospParams.getCommand().equals(CMD_REPLICATION_MODE)) {
            this.prepareVo();
            this.replicationMode();
        }
    }

    protected void show() throws MospException {
        this.insertMode();
    }

    protected void regist() throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        vo.setPltEditInactivate("0");
        TimeBeanHandlerInterface time = this.time();
        PaidHolidayRegistBeanInterface regist = time.paidHolidayRegist();
        PaidHolidayDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        PaidHolidayFirstYearRegistBeanInterface registFirst = time.paidHolidayFirstYearRegist();
        for (int i = 1; i <= 12; ++i) {
            PaidHolidayFirstYearDtoInterface firstDto = registFirst.getInitDto();
            firstDto.setEntranceMonth(i);
            this.setDtoFields(firstDto);
            registFirst.insert(firstDto);
        }
        StockHolidayRegistBeanInterface registStock = time.stockHolidayRegist();
        StockHolidayDtoInterface dtoStock = registStock.getInitDto();
        this.setDtoFields(dtoStock);
        registStock.insert(dtoStock);
        if (vo.getPltPaidHolidayType().equals(String.valueOf(0))) {
            PaidHolidayPointDateRegistBeanInterface registPoint = time.paidHolidayPointDateRegist();
            String[] aryPointDateAmount = new String[]{vo.getTxtPointDateAmount1(), vo.getTxtPointDateAmount2(), vo.getTxtPointDateAmount3(), vo.getTxtPointDateAmount4(), vo.getTxtPointDateAmount5(), vo.getTxtPointDateAmount6(), vo.getTxtPointDateAmount7(), vo.getTxtPointDateAmount8(), vo.getTxtPointDateAmount9(), vo.getTxtPointDateAmount10(), vo.getTxtPointDateAmount11(), vo.getTxtPointDateAmount12()};
            for (int i = 1; i <= 12; ++i) {
                if (aryPointDateAmount[i - 1].isEmpty()) continue;
                PaidHolidayPointDateDtoInterface pointDto = registPoint.getInitDto();
                pointDto.setTimesPointDate(i);
                this.setDtoFields(pointDto);
                registPoint.insert(pointDto);
            }
        } else if (vo.getPltPaidHolidayType().equals("1") || vo.getPltPaidHolidayType().equals("2")) {
            this.registEntranceDto();
        } else if (this.isProportionally()) {
            this.insertProportionally();
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageInsertSucceed((MospParams)this.mospParams);
        this.setDefaultValues();
        this.setEditUpdateMode(dto.getPaidHolidayCode(), dto.getActivateDate());
    }

    protected void add() throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        TimeBeanHandlerInterface time = this.time();
        PaidHolidayRegistBeanInterface regist = time.paidHolidayRegist();
        PaidHolidayDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.add(dto);
        PaidHolidayFirstYearRegistBeanInterface registFirst = time.paidHolidayFirstYearRegist();
        for (int i = 1; i <= 12; ++i) {
            PaidHolidayFirstYearDtoInterface firstDto = registFirst.getInitDto();
            firstDto.setEntranceMonth(i);
            this.setDtoFields(firstDto);
            registFirst.add(firstDto);
        }
        StockHolidayRegistBeanInterface registStock = time.stockHolidayRegist();
        StockHolidayDtoInterface dtoStock = registStock.getInitDto();
        this.setDtoFields(dtoStock);
        registStock.add(dtoStock);
        if (vo.getPltPaidHolidayType().equals(String.valueOf(0))) {
            PaidHolidayPointDateRegistBeanInterface registPoint = time.paidHolidayPointDateRegist();
            String[] aryPointDateAmount = new String[]{vo.getTxtPointDateAmount1(), vo.getTxtPointDateAmount2(), vo.getTxtPointDateAmount3(), vo.getTxtPointDateAmount4(), vo.getTxtPointDateAmount5(), vo.getTxtPointDateAmount6(), vo.getTxtPointDateAmount7(), vo.getTxtPointDateAmount8(), vo.getTxtPointDateAmount9(), vo.getTxtPointDateAmount10(), vo.getTxtPointDateAmount11(), vo.getTxtPointDateAmount12()};
            for (int i = 1; i <= 12; ++i) {
                if (aryPointDateAmount[i - 1].isEmpty()) continue;
                PaidHolidayPointDateDtoInterface pointDto = registPoint.getInitDto();
                pointDto.setTimesPointDate(i);
                this.setDtoFields(pointDto);
                registPoint.add(pointDto);
            }
        } else if (vo.getPltPaidHolidayType().equals("1") || vo.getPltPaidHolidayType().equals("2")) {
            this.registEntranceDto();
        } else if (this.isProportionally()) {
            this.addProportionally();
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageUpdateFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageAddHistorySucceed((MospParams)this.mospParams);
        this.setDefaultValues();
        this.setEditUpdateMode(dto.getPaidHolidayCode(), dto.getActivateDate());
    }

    protected void update() throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        TimeBeanHandlerInterface time = this.time();
        PaidHolidayPointDateRegistBeanInterface registPoint = time.paidHolidayPointDateRegist();
        PaidHolidayProportionallyRegistBeanInterface paidHolidayProportionallyRegist = time.paidHolidayProportionallyRegist();
        PaidHolidayRegistBeanInterface regist = time.paidHolidayRegist();
        Date activateDate = this.getEditActivateDate();
        PaidHolidayDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        registPoint.delete(vo.getTxtPaidHolidayCode(), activateDate);
        paidHolidayProportionallyRegist.delete(vo.getTxtPaidHolidayCode(), activateDate);
        PaidHolidayFirstYearRegistBeanInterface registFirst = time.paidHolidayFirstYearRegist();
        for (int i = 1; i <= 12; ++i) {
            PaidHolidayFirstYearDtoInterface firstDto = registFirst.getInitDto();
            firstDto.setEntranceMonth(i);
            this.setDtoFields(firstDto);
            registFirst.update(firstDto);
        }
        StockHolidayRegistBeanInterface registStock = time.stockHolidayRegist();
        StockHolidayDtoInterface dtoStock = registStock.getInitDto();
        this.setDtoFields(dtoStock);
        registStock.update(dtoStock);
        if (vo.getPltPaidHolidayType().equals(String.valueOf(0))) {
            String[] aryPointDateAmount = new String[]{vo.getTxtPointDateAmount1(), vo.getTxtPointDateAmount2(), vo.getTxtPointDateAmount3(), vo.getTxtPointDateAmount4(), vo.getTxtPointDateAmount5(), vo.getTxtPointDateAmount6(), vo.getTxtPointDateAmount7(), vo.getTxtPointDateAmount8(), vo.getTxtPointDateAmount9(), vo.getTxtPointDateAmount10(), vo.getTxtPointDateAmount11(), vo.getTxtPointDateAmount12()};
            for (int i = 1; i <= 12; ++i) {
                if (aryPointDateAmount[i - 1].isEmpty()) continue;
                PaidHolidayPointDateDtoInterface pointDto = registPoint.getInitDto();
                pointDto.setTimesPointDate(i);
                this.setDtoFields(pointDto);
                registPoint.update(pointDto);
            }
        } else if (vo.getPltPaidHolidayType().equals(String.valueOf(1)) || vo.getPltPaidHolidayType().equals(String.valueOf(2))) {
            this.time().paidHolidayEntranceDateRegist().delete(vo.getTxtPaidHolidayCode(), this.getEditActivateDate());
            this.registEntranceDto();
        } else if (this.isProportionally()) {
            this.addProportionally();
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageUpdateFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageUpdatetSucceed((MospParams)this.mospParams);
        this.setDefaultValues();
        this.setEditUpdateMode(dto.getPaidHolidayCode(), dto.getActivateDate());
    }

    protected void delete() throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        TimeBeanHandlerInterface time = this.time();
        Date activateDate = this.getEditActivateDate();
        PaidHolidayPointDateRegistBeanInterface registPoint = time.paidHolidayPointDateRegist();
        PaidHolidayProportionallyRegistBeanInterface paidHolidayProportionallyRegist = time.paidHolidayProportionallyRegist();
        PaidHolidayDtoInterface dto = this.timeReference().paidHoliday().findForKey(vo.getTxtPaidHolidayCode(), this.getEditActivateDate());
        this.setDtoFields(dto);
        time.paidHolidayRegist().delete(dto);
        registPoint.delete(vo.getTxtPaidHolidayCode(), activateDate);
        paidHolidayProportionallyRegist.delete(vo.getTxtPaidHolidayCode(), activateDate);
        time.paidHolidayFirstYearRegist().delete(dto.getPaidHolidayCode(), dto.getActivateDate());
        StockHolidayDtoInterface dtoStock = this.timeReference().stockHoliday().findForKey(vo.getTxtPaidHolidayCode(), this.getEditActivateDate());
        this.setDtoFields(dtoStock);
        time.stockHolidayRegist().delete(dtoStock);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        this.insertMode();
    }

    protected void insertMode() {
        this.setEditInsertMode();
        this.setDefaultValues();
    }

    protected void addMode() {
        this.setEditAddMode();
    }

    protected void replicationMode() {
        this.setEditReplicationMode();
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        vo.setTxtPaidHolidayCode("");
    }

    protected void editMode() throws MospException {
        this.setDefaultValues();
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
    }

    protected void setEditUpdateMode(String paidHolidayCode, Date activateDate) throws MospException {
        PaidHolidayProportionallyReferenceBeanInterface paidHolidayProportionally = this.timeReference().paidHolidayProportionally();
        PaidHolidayDtoInterface dto = this.timeReference().paidHoliday().findForKey(paidHolidayCode, activateDate);
        List PaidHolidayProportionallyList = paidHolidayProportionally.findForList(paidHolidayCode, activateDate);
        PaidHolidayFirstYearDtoInterface firstDto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayCode, activateDate, 1);
        List pointList = this.timeReference().paidHolidayPointDate().findForList(paidHolidayCode, activateDate);
        List entranceList = this.timeReference().paidHolidayEntranceDate().findForList(paidHolidayCode, activateDate);
        StockHolidayDtoInterface stockDto = this.timeReference().stockHoliday().findForKey(paidHolidayCode, activateDate);
        this.checkSelectedDataExist((Object)dto);
        for (PaidHolidayProportionallyDtoInterface paidHolidayProportionallyDto : PaidHolidayProportionallyList) {
            this.checkSelectedDataExist((Object)paidHolidayProportionallyDto);
        }
        this.checkSelectedDataExist((Object)firstDto);
        for (PaidHolidayPointDateDtoInterface paidHolidayPointDateDto : pointList) {
            this.checkSelectedDataExist((Object)paidHolidayPointDateDto);
        }
        for (PaidHolidayEntranceDateDtoInterface paidHolidayEntranceDateDto : entranceList) {
            this.checkSelectedDataExist((Object)paidHolidayEntranceDateDto);
        }
        this.checkSelectedDataExist((Object)stockDto);
        this.setVoFields(dto);
        this.setVoFieldsProportionally(PaidHolidayProportionallyList);
        this.setVoFieldsFirst(firstDto.getPaidHolidayCode());
        this.setVoFields(pointList);
        this.setVoFieldsEntrance(entranceList);
        this.setVoFields(stockDto);
        this.setEditUpdateMode(this.timeReference().paidHoliday().getPaidHolidayHistory(paidHolidayCode));
    }

    public void setDefaultValues() {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        vo.setTxtPaidHolidayCode("");
        vo.setTxtPaidHolidayName("");
        vo.setTxtPaidHolidayAbbr("");
        vo.setTxtWorkRatio("0");
        vo.setPltPaidHolidayType("0");
        vo.setPltTimelyPaidHoliday(String.valueOf(0));
        vo.setPltTimeAcquisitionLimitDays("0");
        vo.setPltTimeAcquisitionLimitTimes("0");
        vo.setPltAppliTimeInterval("0");
        vo.setTxtMaxCarryOverAmount("");
        vo.setTxtTotalMaxAmount("");
        vo.setPltMaxCarryOverYear(String.valueOf(0));
        vo.setPltMaxCarryOverTimes("0");
        vo.setPltHalfDayUnit(String.valueOf(0));
        vo.setPltWorkOnHolidayCalc("3");
        vo.setTxtProportionallyOneDayAndSixMonths(Integer.toString(1));
        vo.setTxtProportionallyOneDayAndOneYearAndSixMonths(Integer.toString(2));
        vo.setTxtProportionallyOneDayAndTwoYearsAndSixMonths(Integer.toString(2));
        vo.setTxtProportionallyOneDayAndThreeYearsAndSixMonths(Integer.toString(2));
        vo.setTxtProportionallyOneDayAndFourYearsAndSixMonths(Integer.toString(3));
        vo.setTxtProportionallyOneDayAndFiveYearsAndSixMonths(Integer.toString(3));
        vo.setTxtProportionallyOneDayAndSixYearsAndSixMonthsOrMore(Integer.toString(3));
        vo.setTxtProportionallyTwoDaysAndSixMonths(Integer.toString(3));
        vo.setTxtProportionallyTwoDaysAndOneYearAndSixMonths(Integer.toString(4));
        vo.setTxtProportionallyTwoDaysAndTwoYearsAndSixMonths(Integer.toString(4));
        vo.setTxtProportionallyTwoDaysAndThreeYearsAndSixMonths(Integer.toString(5));
        vo.setTxtProportionallyTwoDaysAndFourYearsAndSixMonths(Integer.toString(6));
        vo.setTxtProportionallyTwoDaysAndFiveYearsAndSixMonths(Integer.toString(6));
        vo.setTxtProportionallyTwoDaysAndSixYearsAndSixMonthsOrMore(Integer.toString(7));
        vo.setTxtProportionallyThreeDaysAndSixMonths(Integer.toString(5));
        vo.setTxtProportionallyThreeDaysAndOneYearAndSixMonths(Integer.toString(6));
        vo.setTxtProportionallyThreeDaysAndTwoYearsAndSixMonths(Integer.toString(6));
        vo.setTxtProportionallyThreeDaysAndThreeYearsAndSixMonths(Integer.toString(8));
        vo.setTxtProportionallyThreeDaysAndFourYearsAndSixMonths(Integer.toString(9));
        vo.setTxtProportionallyThreeDaysAndFiveYearsAndSixMonths(Integer.toString(10));
        vo.setTxtProportionallyThreeDaysAndSixYearsAndSixMonthsOrMore(Integer.toString(11));
        vo.setTxtProportionallyFourDaysAndSixMonths(Integer.toString(7));
        vo.setTxtProportionallyFourDaysAndOneYearAndSixMonths(Integer.toString(8));
        vo.setTxtProportionallyFourDaysAndTwoYearsAndSixMonths(Integer.toString(9));
        vo.setTxtProportionallyFourDaysAndThreeYearsAndSixMonths(Integer.toString(10));
        vo.setTxtProportionallyFourDaysAndFourYearsAndSixMonths(Integer.toString(12));
        vo.setTxtProportionallyFourDaysAndFiveYearsAndSixMonths(Integer.toString(13));
        vo.setTxtProportionallyFourDaysAndSixYearsAndSixMonthsOrMore(Integer.toString(15));
        vo.setTxtProportionallyFiveDaysOrMoreAndSixMonths(Integer.toString(10));
        vo.setTxtProportionallyFiveDaysOrMoreAndOneYearAndSixMonths(Integer.toString(11));
        vo.setTxtProportionallyFiveDaysOrMoreAndTwoYearsAndSixMonths(Integer.toString(12));
        vo.setTxtProportionallyFiveDaysOrMoreAndThreeYearsAndSixMonths(Integer.toString(14));
        vo.setTxtProportionallyFiveDaysOrMoreAndFourYearsAndSixMonths(Integer.toString(16));
        vo.setTxtProportionallyFiveDaysOrMoreAndFiveYearsAndSixMonths(Integer.toString(18));
        vo.setTxtProportionallyFiveDaysOrMoreAndSixYearsAndSixMonthsOrMore(Integer.toString(20));
        vo.setTxtGivingTimingJanuary("0");
        vo.setTxtGivingTimingFebruary("0");
        vo.setTxtGivingTimingMarch("0");
        vo.setTxtGivingTimingApril("0");
        vo.setTxtGivingTimingMay("0");
        vo.setTxtGivingTimingJune("0");
        vo.setTxtGivingTimingJuly("0");
        vo.setTxtGivingTimingAugust("0");
        vo.setTxtGivingTimingSeptember("0");
        vo.setTxtGivingTimingOctober("0");
        vo.setTxtGivingTimingNovember("0");
        vo.setTxtGivingTimingDecember("0");
        vo.setTxtGivingAmountJanuary("0");
        vo.setTxtGivingAmountFebruary("0");
        vo.setTxtGivingAmountMarch("0");
        vo.setTxtGivingAmountApril("0");
        vo.setTxtGivingAmountMay("0");
        vo.setTxtGivingAmountJune("0");
        vo.setTxtGivingAmountJuly("0");
        vo.setTxtGivingAmountAugust("0");
        vo.setTxtGivingAmountSeptember("0");
        vo.setTxtGivingAmountOctober("0");
        vo.setTxtGivingAmountNovember("0");
        vo.setTxtGivingAmountDecember("0");
        vo.setTxtGivingLimitJanuary("0");
        vo.setTxtGivingLimitFebruary("0");
        vo.setTxtGivingLimitMarch("0");
        vo.setTxtGivingLimitApril("0");
        vo.setTxtGivingLimitMay("0");
        vo.setTxtGivingLimitJune("0");
        vo.setTxtGivingLimitJuly("0");
        vo.setTxtGivingLimitAugust("0");
        vo.setTxtGivingLimitSeptember("0");
        vo.setTxtGivingLimitOctober("0");
        vo.setTxtGivingLimitNovember("0");
        vo.setTxtGivingLimitDecember("0");
        vo.setTxtPointDateMonth("1");
        vo.setTxtPointDateDay("1");
        vo.setTxtTimesPointDate1("1");
        vo.setTxtTimesPointDate2("2");
        vo.setTxtTimesPointDate3("3");
        vo.setTxtTimesPointDate4("4");
        vo.setTxtTimesPointDate5("5");
        vo.setTxtTimesPointDate6("6");
        vo.setTxtTimesPointDate7("7");
        vo.setTxtTimesPointDate8("8");
        vo.setTxtTimesPointDate9("9");
        vo.setTxtTimesPointDate10("10");
        vo.setTxtTimesPointDate11("11");
        vo.setTxtTimesPointDate12("12");
        vo.setTxtPointDateAmount1("");
        vo.setTxtPointDateAmount2("");
        vo.setTxtPointDateAmount3("");
        vo.setTxtPointDateAmount4("");
        vo.setTxtPointDateAmount5("");
        vo.setTxtPointDateAmount6("");
        vo.setTxtPointDateAmount7("");
        vo.setTxtPointDateAmount8("");
        vo.setTxtPointDateAmount9("");
        vo.setTxtPointDateAmount10("");
        vo.setTxtPointDateAmount11("");
        vo.setTxtPointDateAmount12("");
        vo.setTxtGeneralPointAmount("0");
        vo.setTxtWorkYear1("");
        vo.setTxtWorkYear2("");
        vo.setTxtWorkYear3("");
        vo.setTxtWorkYear4("");
        vo.setTxtWorkYear5("");
        vo.setTxtWorkYear6("");
        vo.setTxtWorkYear7("");
        vo.setTxtWorkYear8("");
        vo.setTxtWorkYear9("");
        vo.setTxtWorkYear10("");
        vo.setTxtWorkYear11("");
        vo.setTxtWorkYear12("");
        vo.setTxtWorkMonth1("");
        vo.setTxtWorkMonth2("");
        vo.setTxtWorkMonth3("");
        vo.setTxtWorkMonth4("");
        vo.setTxtWorkMonth5("");
        vo.setTxtWorkMonth6("");
        vo.setTxtWorkMonth7("");
        vo.setTxtWorkMonth8("");
        vo.setTxtWorkMonth9("");
        vo.setTxtWorkMonth10("");
        vo.setTxtWorkMonth11("");
        vo.setTxtWorkMonth12("");
        vo.setTxtJoiningDateAmount1("");
        vo.setTxtJoiningDateAmount2("");
        vo.setTxtJoiningDateAmount3("");
        vo.setTxtJoiningDateAmount4("");
        vo.setTxtJoiningDateAmount5("");
        vo.setTxtJoiningDateAmount6("");
        vo.setTxtJoiningDateAmount7("");
        vo.setTxtJoiningDateAmount8("");
        vo.setTxtJoiningDateAmount9("");
        vo.setTxtJoiningDateAmount10("");
        vo.setTxtJoiningDateAmount11("");
        vo.setTxtJoiningDateAmount12("");
        vo.setTxtGeneralJoiningMonth("");
        vo.setTxtGeneralJoiningAmount("");
        vo.setTxtStockYearAmount("0");
        vo.setTxtStockTotalAmount("0");
        vo.setTxtStockLimitDate("0");
        long[] aryId = new long[12];
        vo.setTmmPaidHolidayFirstYearId(aryId);
        vo.setTmmPaidHolidayPointDateId(aryId);
        vo.setTmmPaidHolidayEntranceDateId(aryId);
    }

    protected void insertProportionally() throws MospException {
        PaidHolidayProportionallyRegistBeanInterface regist = this.time().paidHolidayProportionallyRegist();
        for (int i = 0; i < 5; ++i) {
            int prescribedWeeklyWorkingDays = i + 1;
            for (int j = 0; j < 7; ++j) {
                PaidHolidayProportionallyDtoInterface dto = regist.getInitDto();
                int continuousServiceTermsCountingFromTheEmploymentDay = 12 * j + 6;
                this.setDtoFields(dto, prescribedWeeklyWorkingDays, continuousServiceTermsCountingFromTheEmploymentDay);
                regist.insert(dto);
            }
        }
    }

    protected void addProportionally() throws MospException {
        PaidHolidayProportionallyRegistBeanInterface regist = this.time().paidHolidayProportionallyRegist();
        for (int i = 0; i < 5; ++i) {
            int prescribedWeeklyWorkingDays = i + 1;
            for (int j = 0; j < 7; ++j) {
                PaidHolidayProportionallyDtoInterface dto = regist.getInitDto();
                int continuousServiceTermsCountingFromTheEmploymentDay = 12 * j + 6;
                this.setDtoFields(dto, prescribedWeeklyWorkingDays, continuousServiceTermsCountingFromTheEmploymentDay);
                regist.add(dto);
            }
        }
    }

    protected void setDtoFields(PaidHolidayDtoInterface dto) {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        dto.setTmmPaidHolidayId(vo.getRecordId());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
        dto.setPaidHolidayName(vo.getTxtPaidHolidayName());
        dto.setPaidHolidayAbbr(vo.getTxtPaidHolidayAbbr());
        dto.setWorkRatio(this.getInt(vo.getTxtWorkRatio()));
        dto.setPaidHolidayType(this.getInt(vo.getPltPaidHolidayType()));
        dto.setScheduleGiving(0);
        dto.setTimelyPaidHolidayFlag(this.getInt(vo.getPltTimelyPaidHoliday()));
        dto.setTimelyPaidHolidayTime(1);
        dto.setTimeAcquisitionLimitDays(this.getInt(vo.getPltTimeAcquisitionLimitDays()));
        dto.setTimeAcquisitionLimitTimes(this.getInt(vo.getPltTimeAcquisitionLimitTimes()));
        dto.setAppliTimeInterval(this.getInt(vo.getPltAppliTimeInterval()));
        dto.setMaxCarryOverYear(this.getInt(vo.getPltMaxCarryOverYear()));
        dto.setMaxCarryOverTimes(this.getInt(vo.getPltMaxCarryOverTimes()));
        dto.setHalfDayUnit(this.getInt(vo.getPltHalfDayUnit()));
        dto.setWorkOnHolidayCalc(this.getInt(vo.getPltWorkOnHolidayCalc()));
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
        dto.setPointDateMonth(this.getInt(vo.getTxtPointDateMonth()));
        dto.setPointDateDay(this.getInt(vo.getTxtPointDateDay()));
        if (vo.getTxtGeneralPointAmount().length() != 0) {
            dto.setGeneralPointAmount(this.getInt(vo.getTxtGeneralPointAmount()));
        }
        if (vo.getTxtGeneralJoiningMonth().length() != 0) {
            dto.setGeneralJoiningMonth(this.getInt(vo.getTxtGeneralJoiningMonth()));
        }
        if (vo.getTxtGeneralJoiningAmount().length() != 0) {
            dto.setGeneralJoiningAmount(this.getInt(vo.getTxtGeneralJoiningAmount()));
        }
    }

    protected void setDtoFields(PaidHolidayProportionallyDtoInterface dto, int prescribedWeeklyWorkingDays, int continuousServiceTermsCountingFromTheEmploymentDay) {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setPrescribedWeeklyWorkingDays(prescribedWeeklyWorkingDays);
        dto.setContinuousServiceTermsCountingFromTheEmploymentDay(continuousServiceTermsCountingFromTheEmploymentDay);
        dto.setDays(0);
        dto.setInactivateFlag(Integer.parseInt(vo.getPltEditInactivate()));
        if (!Integer.toString(4).equals(vo.getPltPaidHolidayType())) {
            return;
        }
        if (this.isFiveDays(prescribedWeeklyWorkingDays)) {
            if (this.isSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyFiveDaysOrMoreAndSixMonths()));
                return;
            }
            if (this.isOneYearAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyFiveDaysOrMoreAndOneYearAndSixMonths()));
                return;
            }
            if (this.isTwoYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyFiveDaysOrMoreAndTwoYearsAndSixMonths()));
                return;
            }
            if (this.isThreeYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyFiveDaysOrMoreAndThreeYearsAndSixMonths()));
                return;
            }
            if (this.isFourYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyFiveDaysOrMoreAndFourYearsAndSixMonths()));
                return;
            }
            if (this.isFiveYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyFiveDaysOrMoreAndFiveYearsAndSixMonths()));
                return;
            }
            if (this.isSixYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyFiveDaysOrMoreAndSixYearsAndSixMonthsOrMore()));
                return;
            }
        } else if (this.isFourDays(prescribedWeeklyWorkingDays)) {
            if (this.isSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyFourDaysAndSixMonths()));
                return;
            }
            if (this.isOneYearAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyFourDaysAndOneYearAndSixMonths()));
                return;
            }
            if (this.isTwoYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyFourDaysAndTwoYearsAndSixMonths()));
                return;
            }
            if (this.isThreeYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyFourDaysAndThreeYearsAndSixMonths()));
                return;
            }
            if (this.isFourYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyFourDaysAndFourYearsAndSixMonths()));
                return;
            }
            if (this.isFiveYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyFourDaysAndFiveYearsAndSixMonths()));
                return;
            }
            if (this.isSixYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyFourDaysAndSixYearsAndSixMonthsOrMore()));
                return;
            }
        } else if (this.isThreeDays(prescribedWeeklyWorkingDays)) {
            if (this.isSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyThreeDaysAndSixMonths()));
                return;
            }
            if (this.isOneYearAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyThreeDaysAndOneYearAndSixMonths()));
                return;
            }
            if (this.isTwoYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyThreeDaysAndTwoYearsAndSixMonths()));
                return;
            }
            if (this.isThreeYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyThreeDaysAndThreeYearsAndSixMonths()));
                return;
            }
            if (this.isFourYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyThreeDaysAndFourYearsAndSixMonths()));
                return;
            }
            if (this.isFiveYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyThreeDaysAndFiveYearsAndSixMonths()));
                return;
            }
            if (this.isSixYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyThreeDaysAndSixYearsAndSixMonthsOrMore()));
                return;
            }
        } else if (this.isTwoDays(prescribedWeeklyWorkingDays)) {
            if (this.isSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyTwoDaysAndSixMonths()));
                return;
            }
            if (this.isOneYearAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyTwoDaysAndOneYearAndSixMonths()));
                return;
            }
            if (this.isTwoYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyTwoDaysAndTwoYearsAndSixMonths()));
                return;
            }
            if (this.isThreeYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyTwoDaysAndThreeYearsAndSixMonths()));
                return;
            }
            if (this.isFourYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyTwoDaysAndFourYearsAndSixMonths()));
                return;
            }
            if (this.isFiveYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyTwoDaysAndFiveYearsAndSixMonths()));
                return;
            }
            if (this.isSixYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyTwoDaysAndSixYearsAndSixMonthsOrMore()));
                return;
            }
        } else if (this.isOneDay(prescribedWeeklyWorkingDays)) {
            if (this.isSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyOneDayAndSixMonths()));
                return;
            }
            if (this.isOneYearAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyOneDayAndOneYearAndSixMonths()));
                return;
            }
            if (this.isTwoYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyOneDayAndTwoYearsAndSixMonths()));
                return;
            }
            if (this.isThreeYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyOneDayAndThreeYearsAndSixMonths()));
                return;
            }
            if (this.isFourYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyOneDayAndFourYearsAndSixMonths()));
                return;
            }
            if (this.isFiveYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyOneDayAndFiveYearsAndSixMonths()));
                return;
            }
            if (this.isSixYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                dto.setDays(Integer.parseInt(vo.getTxtProportionallyOneDayAndSixYearsAndSixMonthsOrMore()));
            }
        }
    }

    protected void setVoFields(PaidHolidayDtoInterface dto) {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        vo.setRecordId(dto.getTmmPaidHolidayId());
        vo.setTxtEditActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setTxtPaidHolidayCode(dto.getPaidHolidayCode());
        vo.setTxtPaidHolidayName(dto.getPaidHolidayName());
        vo.setTxtPaidHolidayAbbr(dto.getPaidHolidayAbbr());
        vo.setTxtWorkRatio(String.valueOf(dto.getWorkRatio()));
        vo.setPltPaidHolidayType(String.valueOf(dto.getPaidHolidayType()));
        vo.setPltTimelyPaidHoliday(String.valueOf(dto.getTimelyPaidHolidayFlag()));
        vo.setPltTimeAcquisitionLimitDays(String.valueOf(dto.getTimeAcquisitionLimitDays()));
        vo.setPltTimeAcquisitionLimitTimes(String.valueOf(dto.getTimeAcquisitionLimitTimes()));
        vo.setPltAppliTimeInterval(String.valueOf(dto.getAppliTimeInterval()));
        vo.setTxtMaxCarryOverAmount(String.valueOf(dto.getMaxCarryOverAmount()));
        vo.setTxtTotalMaxAmount(String.valueOf(dto.getTotalMaxAmount()));
        vo.setPltMaxCarryOverYear(String.valueOf(dto.getMaxCarryOverYear()));
        vo.setPltMaxCarryOverTimes(String.valueOf(dto.getMaxCarryOverTimes()));
        vo.setPltHalfDayUnit(String.valueOf(dto.getHalfDayUnit()));
        vo.setPltWorkOnHolidayCalc(String.valueOf(dto.getWorkOnHolidayCalc()));
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
        vo.setTxtGeneralPointAmount(String.valueOf(dto.getGeneralPointAmount()));
        vo.setTxtGeneralJoiningMonth(String.valueOf(dto.getGeneralJoiningMonth()));
        vo.setTxtGeneralJoiningAmount(String.valueOf(dto.getGeneralJoiningAmount()));
        vo.setTxtPointDateMonth(String.valueOf(dto.getPointDateMonth()));
        vo.setTxtPointDateDay(String.valueOf(dto.getPointDateDay()));
    }

    protected void setVoFieldsProportionally(List<PaidHolidayProportionallyDtoInterface> list) {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        for (PaidHolidayProportionallyDtoInterface dto : list) {
            int prescribedWeeklyWorkingDays = dto.getPrescribedWeeklyWorkingDays();
            int continuousServiceTermsCountingFromTheEmploymentDay = dto.getContinuousServiceTermsCountingFromTheEmploymentDay();
            if (this.isFiveDays(prescribedWeeklyWorkingDays)) {
                if (this.isSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyFiveDaysOrMoreAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isOneYearAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyFiveDaysOrMoreAndOneYearAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isTwoYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyFiveDaysOrMoreAndTwoYearsAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isThreeYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyFiveDaysOrMoreAndThreeYearsAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isFourYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyFiveDaysOrMoreAndFourYearsAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isFiveYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyFiveDaysOrMoreAndFiveYearsAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (!this.isSixYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) continue;
                vo.setTxtProportionallyFiveDaysOrMoreAndSixYearsAndSixMonthsOrMore(Integer.toString(dto.getDays()));
                continue;
            }
            if (this.isFourDays(prescribedWeeklyWorkingDays)) {
                if (this.isSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyFourDaysAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isOneYearAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyFourDaysAndOneYearAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isTwoYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyFourDaysAndTwoYearsAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isThreeYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyFourDaysAndThreeYearsAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isFourYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyFourDaysAndFourYearsAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isFiveYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyFourDaysAndFiveYearsAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (!this.isSixYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) continue;
                vo.setTxtProportionallyFourDaysAndSixYearsAndSixMonthsOrMore(Integer.toString(dto.getDays()));
                continue;
            }
            if (this.isThreeDays(prescribedWeeklyWorkingDays)) {
                if (this.isSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyThreeDaysAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isOneYearAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyThreeDaysAndOneYearAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isTwoYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyThreeDaysAndTwoYearsAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isThreeYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyThreeDaysAndThreeYearsAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isFourYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyThreeDaysAndFourYearsAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isFiveYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyThreeDaysAndFiveYearsAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (!this.isSixYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) continue;
                vo.setTxtProportionallyThreeDaysAndSixYearsAndSixMonthsOrMore(Integer.toString(dto.getDays()));
                continue;
            }
            if (this.isTwoDays(prescribedWeeklyWorkingDays)) {
                if (this.isSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyTwoDaysAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isOneYearAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyTwoDaysAndOneYearAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isTwoYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyTwoDaysAndTwoYearsAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isThreeYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyTwoDaysAndThreeYearsAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isFourYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyTwoDaysAndFourYearsAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (this.isFiveYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                    vo.setTxtProportionallyTwoDaysAndFiveYearsAndSixMonths(Integer.toString(dto.getDays()));
                    continue;
                }
                if (!this.isSixYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) continue;
                vo.setTxtProportionallyTwoDaysAndSixYearsAndSixMonthsOrMore(Integer.toString(dto.getDays()));
                continue;
            }
            if (prescribedWeeklyWorkingDays != 1) continue;
            if (this.isSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                vo.setTxtProportionallyOneDayAndSixMonths(Integer.toString(dto.getDays()));
                continue;
            }
            if (this.isOneYearAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                vo.setTxtProportionallyOneDayAndOneYearAndSixMonths(Integer.toString(dto.getDays()));
                continue;
            }
            if (this.isTwoYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                vo.setTxtProportionallyOneDayAndTwoYearsAndSixMonths(Integer.toString(dto.getDays()));
                continue;
            }
            if (this.isThreeYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                vo.setTxtProportionallyOneDayAndThreeYearsAndSixMonths(Integer.toString(dto.getDays()));
                continue;
            }
            if (this.isFourYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                vo.setTxtProportionallyOneDayAndFourYearsAndSixMonths(Integer.toString(dto.getDays()));
                continue;
            }
            if (this.isFiveYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) {
                vo.setTxtProportionallyOneDayAndFiveYearsAndSixMonths(Integer.toString(dto.getDays()));
                continue;
            }
            if (!this.isSixYearsAndSixMonths(continuousServiceTermsCountingFromTheEmploymentDay)) continue;
            vo.setTxtProportionallyOneDayAndSixYearsAndSixMonthsOrMore(Integer.toString(dto.getDays()));
        }
    }

    protected void setDtoFields(PaidHolidayFirstYearDtoInterface dto) {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        dto.setActivateDate(this.getEditActivateDate());
        dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
        if (dto.getEntranceMonth() == this.getInt("1")) {
            dto.setTmmPaidHolidayFirstYearId(vo.getTmmPaidHolidayFirstYearId(0));
            if (!(vo.getTxtGivingTimingJanuary().isEmpty() && vo.getTxtGivingAmountJanuary().isEmpty() && vo.getTxtGivingLimitJanuary().isEmpty())) {
                dto.setGivingMonth(this.getInt(vo.getTxtGivingTimingJanuary()));
                dto.setGivingAmount(this.getInt(vo.getTxtGivingAmountJanuary()));
                dto.setGivingLimit(this.getInt(vo.getTxtGivingLimitJanuary()));
            } else {
                dto.setGivingMonth(0);
                dto.setGivingAmount(0);
                dto.setGivingLimit(0);
            }
        }
        if (dto.getEntranceMonth() == this.getInt("2")) {
            dto.setTmmPaidHolidayFirstYearId(vo.getTmmPaidHolidayFirstYearId(1));
            if (!(vo.getTxtGivingTimingFebruary().isEmpty() && vo.getTxtGivingAmountFebruary().isEmpty() && vo.getTxtGivingLimitFebruary().isEmpty())) {
                dto.setGivingMonth(this.getInt(vo.getTxtGivingTimingFebruary()));
                dto.setGivingAmount(this.getInt(vo.getTxtGivingAmountFebruary()));
                dto.setGivingLimit(this.getInt(vo.getTxtGivingLimitFebruary()));
            } else {
                dto.setGivingMonth(0);
                dto.setGivingAmount(0);
                dto.setGivingLimit(0);
            }
        }
        if (dto.getEntranceMonth() == this.getInt("3")) {
            dto.setTmmPaidHolidayFirstYearId(vo.getTmmPaidHolidayFirstYearId(2));
            if (!(vo.getTxtGivingTimingMarch().isEmpty() && vo.getTxtGivingAmountMarch().isEmpty() && vo.getTxtGivingLimitMarch().isEmpty())) {
                dto.setGivingMonth(this.getInt(vo.getTxtGivingTimingMarch()));
                dto.setGivingAmount(this.getInt(vo.getTxtGivingAmountMarch()));
                dto.setGivingLimit(this.getInt(vo.getTxtGivingLimitMarch()));
            } else {
                dto.setGivingMonth(0);
                dto.setGivingAmount(0);
                dto.setGivingLimit(0);
            }
        }
        if (dto.getEntranceMonth() == this.getInt("4")) {
            dto.setTmmPaidHolidayFirstYearId(vo.getTmmPaidHolidayFirstYearId(3));
            if (!(vo.getTxtGivingTimingApril().isEmpty() && vo.getTxtGivingAmountApril().isEmpty() && vo.getTxtGivingLimitApril().isEmpty())) {
                dto.setGivingMonth(this.getInt(vo.getTxtGivingTimingApril()));
                dto.setGivingAmount(this.getInt(vo.getTxtGivingAmountApril()));
                dto.setGivingLimit(this.getInt(vo.getTxtGivingLimitApril()));
            } else {
                dto.setGivingMonth(0);
                dto.setGivingAmount(0);
                dto.setGivingLimit(0);
            }
        }
        if (dto.getEntranceMonth() == this.getInt("5")) {
            dto.setTmmPaidHolidayFirstYearId(vo.getTmmPaidHolidayFirstYearId(4));
            if (!(vo.getTxtGivingTimingMay().isEmpty() && vo.getTxtGivingAmountMay().isEmpty() && vo.getTxtGivingLimitMay().isEmpty())) {
                dto.setGivingMonth(this.getInt(vo.getTxtGivingTimingMay()));
                dto.setGivingAmount(this.getInt(vo.getTxtGivingAmountMay()));
                dto.setGivingLimit(this.getInt(vo.getTxtGivingLimitMay()));
            } else {
                dto.setGivingMonth(0);
                dto.setGivingAmount(0);
                dto.setGivingLimit(0);
            }
        }
        if (dto.getEntranceMonth() == this.getInt("6")) {
            dto.setTmmPaidHolidayFirstYearId(vo.getTmmPaidHolidayFirstYearId(5));
            if (!(vo.getTxtGivingTimingJune().isEmpty() && vo.getTxtGivingAmountJune().isEmpty() && vo.getTxtGivingLimitJune().isEmpty())) {
                dto.setGivingMonth(this.getInt(vo.getTxtGivingTimingJune()));
                dto.setGivingAmount(this.getInt(vo.getTxtGivingAmountJune()));
                dto.setGivingLimit(this.getInt(vo.getTxtGivingLimitJune()));
            } else {
                dto.setGivingMonth(0);
                dto.setGivingAmount(0);
                dto.setGivingLimit(0);
            }
        }
        if (dto.getEntranceMonth() == this.getInt("7")) {
            dto.setTmmPaidHolidayFirstYearId(vo.getTmmPaidHolidayFirstYearId(6));
            if (!(vo.getTxtGivingTimingJuly().isEmpty() && vo.getTxtGivingAmountJuly().isEmpty() && vo.getTxtGivingLimitJuly().isEmpty())) {
                dto.setGivingMonth(this.getInt(vo.getTxtGivingTimingJuly()));
                dto.setGivingAmount(this.getInt(vo.getTxtGivingAmountJuly()));
                dto.setGivingLimit(this.getInt(vo.getTxtGivingLimitJuly()));
            } else {
                dto.setGivingMonth(0);
                dto.setGivingAmount(0);
                dto.setGivingLimit(0);
            }
        }
        if (dto.getEntranceMonth() == this.getInt("8")) {
            dto.setTmmPaidHolidayFirstYearId(vo.getTmmPaidHolidayFirstYearId(7));
            if (!(vo.getTxtGivingTimingAugust().isEmpty() && vo.getTxtGivingAmountAugust().isEmpty() && vo.getTxtGivingLimitAugust().isEmpty())) {
                dto.setGivingMonth(this.getInt(vo.getTxtGivingTimingAugust()));
                dto.setGivingAmount(this.getInt(vo.getTxtGivingAmountAugust()));
                dto.setGivingLimit(this.getInt(vo.getTxtGivingLimitAugust()));
            } else {
                dto.setGivingMonth(0);
                dto.setGivingAmount(0);
                dto.setGivingLimit(0);
            }
        }
        if (dto.getEntranceMonth() == this.getInt("9")) {
            dto.setTmmPaidHolidayFirstYearId(vo.getTmmPaidHolidayFirstYearId(8));
            if (!(vo.getTxtGivingTimingSeptember().isEmpty() && vo.getTxtGivingAmountSeptember().isEmpty() && vo.getTxtGivingLimitSeptember().isEmpty())) {
                dto.setGivingMonth(this.getInt(vo.getTxtGivingTimingSeptember()));
                dto.setGivingAmount(this.getInt(vo.getTxtGivingAmountSeptember()));
                dto.setGivingLimit(this.getInt(vo.getTxtGivingLimitSeptember()));
            } else {
                dto.setGivingMonth(0);
                dto.setGivingAmount(0);
                dto.setGivingLimit(0);
            }
        }
        if (dto.getEntranceMonth() == this.getInt("10")) {
            dto.setTmmPaidHolidayFirstYearId(vo.getTmmPaidHolidayFirstYearId(9));
            if (!(vo.getTxtGivingTimingOctober().isEmpty() && vo.getTxtGivingAmountOctober().isEmpty() && vo.getTxtGivingLimitOctober().isEmpty())) {
                dto.setGivingMonth(this.getInt(vo.getTxtGivingTimingOctober()));
                dto.setGivingAmount(this.getInt(vo.getTxtGivingAmountOctober()));
                dto.setGivingLimit(this.getInt(vo.getTxtGivingLimitOctober()));
            } else {
                dto.setGivingMonth(0);
                dto.setGivingAmount(0);
                dto.setGivingLimit(0);
            }
        }
        if (dto.getEntranceMonth() == this.getInt("11")) {
            dto.setTmmPaidHolidayFirstYearId(vo.getTmmPaidHolidayFirstYearId(10));
            if (!(vo.getTxtGivingTimingNovember().isEmpty() && vo.getTxtGivingAmountNovember().isEmpty() && vo.getTxtGivingLimitNovember().isEmpty())) {
                dto.setGivingMonth(this.getInt(vo.getTxtGivingTimingNovember()));
                dto.setGivingAmount(this.getInt(vo.getTxtGivingAmountNovember()));
                dto.setGivingLimit(this.getInt(vo.getTxtGivingLimitNovember()));
            } else {
                dto.setGivingMonth(0);
                dto.setGivingAmount(0);
                dto.setGivingLimit(0);
            }
        }
        if (dto.getEntranceMonth() == this.getInt("12")) {
            dto.setTmmPaidHolidayFirstYearId(vo.getTmmPaidHolidayFirstYearId(11));
            if (!(vo.getTxtGivingTimingDecember().isEmpty() && vo.getTxtGivingAmountDecember().isEmpty() && vo.getTxtGivingLimitDecember().isEmpty())) {
                dto.setGivingMonth(this.getInt(vo.getTxtGivingTimingDecember()));
                dto.setGivingAmount(this.getInt(vo.getTxtGivingAmountDecember()));
                dto.setGivingLimit(this.getInt(vo.getTxtGivingLimitDecember()));
            } else {
                dto.setGivingMonth(0);
                dto.setGivingAmount(0);
                dto.setGivingLimit(0);
            }
        }
    }

    protected void setVoFieldsFirst(String paidHolidayCode) throws MospException {
        this.setVoFieldsJanuary(paidHolidayCode);
        this.setVoFieldsFebruary(paidHolidayCode);
        this.setVoFieldsMarch(paidHolidayCode);
        this.setVoFieldsApril(paidHolidayCode);
        this.setVoFieldsMay(paidHolidayCode);
        this.setVoFieldsJune(paidHolidayCode);
        this.setVoFieldsJuly(paidHolidayCode);
        this.setVoFieldsAugust(paidHolidayCode);
        this.setVoFieldsSeptember(paidHolidayCode);
        this.setVoFieldsOctober(paidHolidayCode);
        this.setVoFieldsNovember(paidHolidayCode);
        this.setVoFieldsDecember(paidHolidayCode);
    }

    protected void setVoFieldsJanuary(String paidHolidayCode) throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        PaidHolidayFirstYearDtoInterface dto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayCode, this.getEditActivateDate(), 1);
        if (dto == null) {
            return;
        }
        vo.setTmmPaidHolidayFirstYearId(dto.getTmmPaidHolidayFirstYearId(), 0);
        vo.setTxtGivingTimingJanuary(String.valueOf(dto.getGivingMonth()));
        vo.setTxtGivingAmountJanuary(String.valueOf(dto.getGivingAmount()));
        vo.setTxtGivingLimitJanuary(String.valueOf(dto.getGivingLimit()));
    }

    protected void setVoFieldsFebruary(String paidHolidayCode) throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        PaidHolidayFirstYearDtoInterface dto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayCode, this.getEditActivateDate(), 2);
        if (dto == null) {
            return;
        }
        vo.setTmmPaidHolidayFirstYearId(dto.getTmmPaidHolidayFirstYearId(), 1);
        vo.setTxtGivingTimingFebruary(String.valueOf(dto.getGivingMonth()));
        vo.setTxtGivingAmountFebruary(String.valueOf(dto.getGivingAmount()));
        vo.setTxtGivingLimitFebruary(String.valueOf(dto.getGivingLimit()));
    }

    protected void setVoFieldsMarch(String paidHolidayCode) throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        PaidHolidayFirstYearDtoInterface dto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayCode, this.getEditActivateDate(), 3);
        if (dto == null) {
            return;
        }
        vo.setTmmPaidHolidayFirstYearId(dto.getTmmPaidHolidayFirstYearId(), 2);
        vo.setTxtGivingTimingMarch(String.valueOf(dto.getGivingMonth()));
        vo.setTxtGivingAmountMarch(String.valueOf(dto.getGivingAmount()));
        vo.setTxtGivingLimitMarch(String.valueOf(dto.getGivingLimit()));
    }

    protected void setVoFieldsApril(String paidHolidayCode) throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        PaidHolidayFirstYearDtoInterface dto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayCode, this.getEditActivateDate(), 4);
        if (dto == null) {
            return;
        }
        vo.setTmmPaidHolidayFirstYearId(dto.getTmmPaidHolidayFirstYearId(), 3);
        vo.setTxtGivingTimingApril(String.valueOf(dto.getGivingMonth()));
        vo.setTxtGivingAmountApril(String.valueOf(dto.getGivingAmount()));
        vo.setTxtGivingLimitApril(String.valueOf(dto.getGivingLimit()));
    }

    protected void setVoFieldsMay(String paidHolidayCode) throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        PaidHolidayFirstYearDtoInterface dto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayCode, this.getEditActivateDate(), 5);
        if (dto == null) {
            return;
        }
        vo.setTmmPaidHolidayFirstYearId(dto.getTmmPaidHolidayFirstYearId(), 4);
        vo.setTxtGivingTimingMay(String.valueOf(dto.getGivingMonth()));
        vo.setTxtGivingAmountMay(String.valueOf(dto.getGivingAmount()));
        vo.setTxtGivingLimitMay(String.valueOf(dto.getGivingLimit()));
    }

    protected void setVoFieldsJune(String paidHolidayCode) throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        PaidHolidayFirstYearDtoInterface dto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayCode, this.getEditActivateDate(), 6);
        if (dto == null) {
            return;
        }
        vo.setTmmPaidHolidayFirstYearId(dto.getTmmPaidHolidayFirstYearId(), 5);
        vo.setTxtGivingTimingJune(String.valueOf(dto.getGivingMonth()));
        vo.setTxtGivingAmountJune(String.valueOf(dto.getGivingAmount()));
        vo.setTxtGivingLimitJune(String.valueOf(dto.getGivingLimit()));
    }

    protected void setVoFieldsJuly(String paidHolidayCode) throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        PaidHolidayFirstYearDtoInterface dto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayCode, this.getEditActivateDate(), 7);
        if (dto == null) {
            return;
        }
        vo.setTmmPaidHolidayFirstYearId(dto.getTmmPaidHolidayFirstYearId(), 6);
        vo.setTxtGivingTimingJuly(String.valueOf(dto.getGivingMonth()));
        vo.setTxtGivingAmountJuly(String.valueOf(dto.getGivingAmount()));
        vo.setTxtGivingLimitJuly(String.valueOf(dto.getGivingLimit()));
    }

    protected void setVoFieldsAugust(String paidHolidayCode) throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        PaidHolidayFirstYearDtoInterface dto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayCode, this.getEditActivateDate(), 8);
        if (dto == null) {
            return;
        }
        vo.setTmmPaidHolidayFirstYearId(dto.getTmmPaidHolidayFirstYearId(), 7);
        vo.setTxtGivingTimingAugust(String.valueOf(dto.getGivingMonth()));
        vo.setTxtGivingAmountAugust(String.valueOf(dto.getGivingAmount()));
        vo.setTxtGivingLimitAugust(String.valueOf(dto.getGivingLimit()));
    }

    protected void setVoFieldsSeptember(String paidHolidayCode) throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        PaidHolidayFirstYearDtoInterface dto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayCode, this.getEditActivateDate(), 9);
        if (dto == null) {
            return;
        }
        vo.setTmmPaidHolidayFirstYearId(dto.getTmmPaidHolidayFirstYearId(), 8);
        vo.setTxtGivingTimingSeptember(String.valueOf(dto.getGivingMonth()));
        vo.setTxtGivingAmountSeptember(String.valueOf(dto.getGivingAmount()));
        vo.setTxtGivingLimitSeptember(String.valueOf(dto.getGivingLimit()));
    }

    protected void setVoFieldsOctober(String paidHolidayCode) throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        PaidHolidayFirstYearDtoInterface dto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayCode, this.getEditActivateDate(), 10);
        if (dto == null) {
            return;
        }
        vo.setTmmPaidHolidayFirstYearId(dto.getTmmPaidHolidayFirstYearId(), 9);
        vo.setTxtGivingTimingOctober(String.valueOf(dto.getGivingMonth()));
        vo.setTxtGivingAmountOctober(String.valueOf(dto.getGivingAmount()));
        vo.setTxtGivingLimitOctober(String.valueOf(dto.getGivingLimit()));
    }

    protected void setVoFieldsNovember(String paidHolidayCode) throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        PaidHolidayFirstYearDtoInterface dto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayCode, this.getEditActivateDate(), 11);
        if (dto == null) {
            return;
        }
        vo.setTmmPaidHolidayFirstYearId(dto.getTmmPaidHolidayFirstYearId(), 10);
        vo.setTxtGivingTimingNovember(String.valueOf(dto.getGivingMonth()));
        vo.setTxtGivingAmountNovember(String.valueOf(dto.getGivingAmount()));
        vo.setTxtGivingLimitNovember(String.valueOf(dto.getGivingLimit()));
    }

    protected void setVoFieldsDecember(String paidHolidayCode) throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        PaidHolidayFirstYearDtoInterface dto = this.timeReference().paidHolidayFirstYear().findForKey(paidHolidayCode, this.getEditActivateDate(), 12);
        if (dto == null) {
            return;
        }
        vo.setTmmPaidHolidayFirstYearId(dto.getTmmPaidHolidayFirstYearId(), 11);
        vo.setTxtGivingTimingDecember(String.valueOf(dto.getGivingMonth()));
        vo.setTxtGivingAmountDecember(String.valueOf(dto.getGivingAmount()));
        vo.setTxtGivingLimitDecember(String.valueOf(dto.getGivingLimit()));
    }

    protected void setDtoFields(PaidHolidayPointDateDtoInterface dto) {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        dto.setActivateDate(this.getEditActivateDate());
        dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
        if (dto.getTimesPointDate() == 1 && !vo.getTxtPointDateAmount1().isEmpty()) {
            dto.setTmmPaidHolidayPointDateId(vo.getTmmPaidHolidayPointDateId(0));
            dto.setTimesPointDate(this.getInt(vo.getTxtTimesPointDate1()));
            dto.setPointDateAmount(this.getInt(vo.getTxtPointDateAmount1()));
        }
        if (dto.getTimesPointDate() == 2 && !vo.getTxtPointDateAmount2().isEmpty()) {
            dto.setTmmPaidHolidayPointDateId(vo.getTmmPaidHolidayPointDateId(1));
            dto.setTimesPointDate(this.getInt(vo.getTxtTimesPointDate2()));
            dto.setPointDateAmount(this.getInt(vo.getTxtPointDateAmount2()));
        }
        if (dto.getTimesPointDate() == 3 && !vo.getTxtPointDateAmount3().isEmpty()) {
            dto.setTmmPaidHolidayPointDateId(vo.getTmmPaidHolidayPointDateId(2));
            dto.setTimesPointDate(this.getInt(vo.getTxtTimesPointDate3()));
            dto.setPointDateAmount(this.getInt(vo.getTxtPointDateAmount3()));
        }
        if (dto.getTimesPointDate() == 4 && !vo.getTxtPointDateAmount4().isEmpty()) {
            dto.setTmmPaidHolidayPointDateId(vo.getTmmPaidHolidayPointDateId(3));
            dto.setTimesPointDate(this.getInt(vo.getTxtTimesPointDate4()));
            dto.setPointDateAmount(this.getInt(vo.getTxtPointDateAmount4()));
        }
        if (dto.getTimesPointDate() == 5 && !vo.getTxtPointDateAmount5().isEmpty()) {
            dto.setTmmPaidHolidayPointDateId(vo.getTmmPaidHolidayPointDateId(4));
            dto.setTimesPointDate(this.getInt(vo.getTxtTimesPointDate5()));
            dto.setPointDateAmount(this.getInt(vo.getTxtPointDateAmount5()));
        }
        if (dto.getTimesPointDate() == 6 && !vo.getTxtPointDateAmount6().isEmpty()) {
            dto.setTmmPaidHolidayPointDateId(vo.getTmmPaidHolidayPointDateId(5));
            dto.setTimesPointDate(this.getInt(vo.getTxtTimesPointDate6()));
            dto.setPointDateAmount(this.getInt(vo.getTxtPointDateAmount6()));
        }
        if (dto.getTimesPointDate() == 7 && !vo.getTxtPointDateAmount7().isEmpty()) {
            dto.setTmmPaidHolidayPointDateId(vo.getTmmPaidHolidayPointDateId(6));
            dto.setTimesPointDate(this.getInt(vo.getTxtTimesPointDate7()));
            dto.setPointDateAmount(this.getInt(vo.getTxtPointDateAmount7()));
        }
        if (dto.getTimesPointDate() == 8 && !vo.getTxtPointDateAmount8().isEmpty()) {
            dto.setTmmPaidHolidayPointDateId(vo.getTmmPaidHolidayPointDateId(7));
            dto.setTimesPointDate(this.getInt(vo.getTxtTimesPointDate8()));
            dto.setPointDateAmount(this.getInt(vo.getTxtPointDateAmount8()));
        }
        if (dto.getTimesPointDate() == 9 && !vo.getTxtPointDateAmount9().isEmpty()) {
            dto.setTmmPaidHolidayPointDateId(vo.getTmmPaidHolidayPointDateId(8));
            dto.setTimesPointDate(this.getInt(vo.getTxtTimesPointDate9()));
            dto.setPointDateAmount(this.getInt(vo.getTxtPointDateAmount9()));
        }
        if (dto.getTimesPointDate() == 10 && !vo.getTxtPointDateAmount10().isEmpty()) {
            dto.setTmmPaidHolidayPointDateId(vo.getTmmPaidHolidayPointDateId(9));
            dto.setTimesPointDate(this.getInt(vo.getTxtTimesPointDate10()));
            dto.setPointDateAmount(this.getInt(vo.getTxtPointDateAmount10()));
        }
        if (dto.getTimesPointDate() == 11 && !vo.getTxtPointDateAmount11().isEmpty()) {
            dto.setTmmPaidHolidayPointDateId(vo.getTmmPaidHolidayPointDateId(10));
            dto.setTimesPointDate(this.getInt(vo.getTxtTimesPointDate11()));
            dto.setPointDateAmount(this.getInt(vo.getTxtPointDateAmount11()));
        }
        if (dto.getTimesPointDate() == 12 && !vo.getTxtPointDateAmount12().isEmpty()) {
            dto.setTmmPaidHolidayPointDateId(vo.getTmmPaidHolidayPointDateId(11));
            dto.setTimesPointDate(this.getInt(vo.getTxtTimesPointDate12()));
            dto.setPointDateAmount(this.getInt(vo.getTxtPointDateAmount12()));
        }
    }

    protected void setVoFields(List<PaidHolidayPointDateDtoInterface> list) throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        for (int i = 0; i < list.size(); ++i) {
            PaidHolidayPointDateDtoInterface dto = list.get(i);
            vo.setTmmPaidHolidayPointDateId(dto.getTmmPaidHolidayPointDateId(), i);
            int timesPointDate = dto.getTimesPointDate();
            if (timesPointDate == 1) {
                vo.setTxtPointDateAmount1(String.valueOf(dto.getPointDateAmount()));
                continue;
            }
            if (timesPointDate == 2) {
                vo.setTxtPointDateAmount2(String.valueOf(dto.getPointDateAmount()));
                continue;
            }
            if (timesPointDate == 3) {
                vo.setTxtPointDateAmount3(String.valueOf(dto.getPointDateAmount()));
                continue;
            }
            if (timesPointDate == 4) {
                vo.setTxtPointDateAmount4(String.valueOf(dto.getPointDateAmount()));
                continue;
            }
            if (timesPointDate == 5) {
                vo.setTxtPointDateAmount5(String.valueOf(dto.getPointDateAmount()));
                continue;
            }
            if (timesPointDate == 6) {
                vo.setTxtPointDateAmount6(String.valueOf(dto.getPointDateAmount()));
                continue;
            }
            if (timesPointDate == 7) {
                vo.setTxtPointDateAmount7(String.valueOf(dto.getPointDateAmount()));
                continue;
            }
            if (timesPointDate == 8) {
                vo.setTxtPointDateAmount8(String.valueOf(dto.getPointDateAmount()));
                continue;
            }
            if (timesPointDate == 9) {
                vo.setTxtPointDateAmount9(String.valueOf(dto.getPointDateAmount()));
                continue;
            }
            if (timesPointDate == 10) {
                vo.setTxtPointDateAmount10(String.valueOf(dto.getPointDateAmount()));
                continue;
            }
            if (timesPointDate == 11) {
                vo.setTxtPointDateAmount11(String.valueOf(dto.getPointDateAmount()));
                continue;
            }
            if (timesPointDate != 12) continue;
            vo.setTxtPointDateAmount12(String.valueOf(dto.getPointDateAmount()));
        }
    }

    protected void registEntranceDto() throws MospException {
        PaidHolidayEntranceDateDtoInterface dto;
        PaidHolidayEntranceDateRegistBeanInterface regist = this.time.paidHolidayEntranceDateRegist();
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        Date activateDate = this.getEditActivateDate();
        int inactivateFlag = this.getInt(vo.getPltEditInactivate());
        if (!(vo.getTxtWorkYear1().isEmpty() || vo.getTxtWorkMonth1().isEmpty() || vo.getTxtJoiningDateAmount1().isEmpty())) {
            dto = regist.getInitDto();
            dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
            dto.setActivateDate(activateDate);
            dto.setWorkMonth(this.getInt(vo.getTxtWorkYear1()) * 12 + this.getInt(vo.getTxtWorkMonth1()));
            dto.setJoiningDateAmount(this.getInt(vo.getTxtJoiningDateAmount1()));
            dto.setInactivateFlag(inactivateFlag);
            regist.insert(dto);
        }
        if (!(vo.getTxtWorkYear2().isEmpty() || vo.getTxtWorkMonth2().isEmpty() || vo.getTxtJoiningDateAmount2().isEmpty())) {
            dto = regist.getInitDto();
            dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
            dto.setActivateDate(activateDate);
            dto.setWorkMonth(this.getInt(vo.getTxtWorkYear2()) * 12 + this.getInt(vo.getTxtWorkMonth2()));
            dto.setJoiningDateAmount(this.getInt(vo.getTxtJoiningDateAmount2()));
            dto.setInactivateFlag(inactivateFlag);
            regist.insert(dto);
        }
        if (!(vo.getTxtWorkYear3().isEmpty() || vo.getTxtWorkMonth3().isEmpty() || vo.getTxtJoiningDateAmount3().isEmpty())) {
            dto = regist.getInitDto();
            dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
            dto.setActivateDate(activateDate);
            dto.setWorkMonth(this.getInt(vo.getTxtWorkYear3()) * 12 + this.getInt(vo.getTxtWorkMonth3()));
            dto.setJoiningDateAmount(this.getInt(vo.getTxtJoiningDateAmount3()));
            dto.setInactivateFlag(inactivateFlag);
            regist.insert(dto);
        }
        if (!(vo.getTxtWorkYear4().isEmpty() || vo.getTxtWorkMonth4().isEmpty() || vo.getTxtJoiningDateAmount4().isEmpty())) {
            dto = regist.getInitDto();
            dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
            dto.setActivateDate(activateDate);
            dto.setWorkMonth(this.getInt(vo.getTxtWorkYear4()) * 12 + this.getInt(vo.getTxtWorkMonth4()));
            dto.setJoiningDateAmount(this.getInt(vo.getTxtJoiningDateAmount4()));
            dto.setInactivateFlag(inactivateFlag);
            regist.insert(dto);
        }
        if (!(vo.getTxtWorkYear5().isEmpty() || vo.getTxtWorkMonth5().isEmpty() || vo.getTxtJoiningDateAmount5().isEmpty())) {
            dto = regist.getInitDto();
            dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
            dto.setActivateDate(activateDate);
            dto.setWorkMonth(this.getInt(vo.getTxtWorkYear5()) * 12 + this.getInt(vo.getTxtWorkMonth5()));
            dto.setJoiningDateAmount(this.getInt(vo.getTxtJoiningDateAmount5()));
            dto.setInactivateFlag(inactivateFlag);
            regist.insert(dto);
        }
        if (!(vo.getTxtWorkYear6().isEmpty() || vo.getTxtWorkMonth6().isEmpty() || vo.getTxtJoiningDateAmount6().isEmpty())) {
            dto = regist.getInitDto();
            dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
            dto.setActivateDate(activateDate);
            dto.setWorkMonth(this.getInt(vo.getTxtWorkYear6()) * 12 + this.getInt(vo.getTxtWorkMonth6()));
            dto.setJoiningDateAmount(this.getInt(vo.getTxtJoiningDateAmount6()));
            dto.setInactivateFlag(inactivateFlag);
            regist.insert(dto);
        }
        if (!(vo.getTxtWorkYear7().isEmpty() || vo.getTxtWorkMonth7().isEmpty() || vo.getTxtJoiningDateAmount7().isEmpty())) {
            dto = regist.getInitDto();
            dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
            dto.setActivateDate(activateDate);
            dto.setWorkMonth(this.getInt(vo.getTxtWorkYear7()) * 12 + this.getInt(vo.getTxtWorkMonth7()));
            dto.setJoiningDateAmount(this.getInt(vo.getTxtJoiningDateAmount7()));
            dto.setInactivateFlag(inactivateFlag);
            regist.insert(dto);
        }
        if (!(vo.getTxtWorkYear8().isEmpty() || vo.getTxtWorkMonth8().isEmpty() || vo.getTxtJoiningDateAmount8().isEmpty())) {
            dto = regist.getInitDto();
            dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
            dto.setActivateDate(activateDate);
            dto.setWorkMonth(this.getInt(vo.getTxtWorkYear8()) * 12 + this.getInt(vo.getTxtWorkMonth8()));
            dto.setJoiningDateAmount(this.getInt(vo.getTxtJoiningDateAmount8()));
            dto.setInactivateFlag(inactivateFlag);
            regist.insert(dto);
        }
        if (!(vo.getTxtWorkYear9().isEmpty() || vo.getTxtWorkMonth9().isEmpty() || vo.getTxtJoiningDateAmount9().isEmpty())) {
            dto = regist.getInitDto();
            dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
            dto.setActivateDate(activateDate);
            dto.setWorkMonth(this.getInt(vo.getTxtWorkYear9()) * 12 + this.getInt(vo.getTxtWorkMonth9()));
            dto.setJoiningDateAmount(this.getInt(vo.getTxtJoiningDateAmount9()));
            dto.setInactivateFlag(inactivateFlag);
            regist.insert(dto);
        }
        if (!(vo.getTxtWorkYear10().isEmpty() || vo.getTxtWorkMonth10().isEmpty() || vo.getTxtJoiningDateAmount10().isEmpty())) {
            dto = regist.getInitDto();
            dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
            dto.setActivateDate(activateDate);
            dto.setWorkMonth(this.getInt(vo.getTxtWorkYear10()) * 12 + this.getInt(vo.getTxtWorkMonth10()));
            dto.setJoiningDateAmount(this.getInt(vo.getTxtJoiningDateAmount10()));
            dto.setInactivateFlag(inactivateFlag);
            regist.insert(dto);
        }
        if (!(vo.getTxtWorkYear11().isEmpty() || vo.getTxtWorkMonth11().isEmpty() || vo.getTxtJoiningDateAmount11().isEmpty())) {
            dto = regist.getInitDto();
            dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
            dto.setActivateDate(activateDate);
            dto.setWorkMonth(this.getInt(vo.getTxtWorkYear11()) * 12 + this.getInt(vo.getTxtWorkMonth11()));
            dto.setJoiningDateAmount(this.getInt(vo.getTxtJoiningDateAmount11()));
            dto.setInactivateFlag(inactivateFlag);
            regist.insert(dto);
        }
        if (!(vo.getTxtWorkYear12().isEmpty() || vo.getTxtWorkMonth12().isEmpty() || vo.getTxtJoiningDateAmount12().isEmpty())) {
            dto = regist.getInitDto();
            dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
            dto.setActivateDate(activateDate);
            dto.setWorkMonth(this.getInt(vo.getTxtWorkYear12()) * 12 + this.getInt(vo.getTxtWorkMonth12()));
            dto.setJoiningDateAmount(this.getInt(vo.getTxtJoiningDateAmount12()));
            dto.setInactivateFlag(inactivateFlag);
            regist.insert(dto);
        }
    }

    protected void setVoFieldsEntrance(List<PaidHolidayEntranceDateDtoInterface> list) throws MospException {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        for (int i = 0; i < list.size(); ++i) {
            PaidHolidayEntranceDateDtoInterface dto = list.get(i);
            vo.setTmmPaidHolidayEntranceDateId(dto.getTmmPaidHolidayEntranceDateId(), i);
            if (i == 0) {
                vo.setTxtWorkYear1(String.valueOf(dto.getWorkMonth() / 12));
                vo.setTxtWorkMonth1(String.valueOf(dto.getWorkMonth() % 12));
                vo.setTxtJoiningDateAmount1(String.valueOf(dto.getJoiningDateAmount()));
                continue;
            }
            if (i == 1) {
                vo.setTxtWorkYear2(String.valueOf(dto.getWorkMonth() / 12));
                vo.setTxtWorkMonth2(String.valueOf(dto.getWorkMonth() % 12));
                vo.setTxtJoiningDateAmount2(String.valueOf(dto.getJoiningDateAmount()));
                continue;
            }
            if (i == 2) {
                vo.setTxtWorkYear3(String.valueOf(dto.getWorkMonth() / 12));
                vo.setTxtWorkMonth3(String.valueOf(dto.getWorkMonth() % 12));
                vo.setTxtJoiningDateAmount3(String.valueOf(dto.getJoiningDateAmount()));
                continue;
            }
            if (i == 3) {
                vo.setTxtWorkYear4(String.valueOf(dto.getWorkMonth() / 12));
                vo.setTxtWorkMonth4(String.valueOf(dto.getWorkMonth() % 12));
                vo.setTxtJoiningDateAmount4(String.valueOf(dto.getJoiningDateAmount()));
                continue;
            }
            if (i == 4) {
                vo.setTxtWorkYear5(String.valueOf(dto.getWorkMonth() / 12));
                vo.setTxtWorkMonth5(String.valueOf(dto.getWorkMonth() % 12));
                vo.setTxtJoiningDateAmount5(String.valueOf(dto.getJoiningDateAmount()));
                continue;
            }
            if (i == 5) {
                vo.setTxtWorkYear6(String.valueOf(dto.getWorkMonth() / 12));
                vo.setTxtWorkMonth6(String.valueOf(dto.getWorkMonth() % 12));
                vo.setTxtJoiningDateAmount6(String.valueOf(dto.getJoiningDateAmount()));
                continue;
            }
            if (i == 6) {
                vo.setTxtWorkYear7(String.valueOf(dto.getWorkMonth() / 12));
                vo.setTxtWorkMonth7(String.valueOf(dto.getWorkMonth() % 12));
                vo.setTxtJoiningDateAmount7(String.valueOf(dto.getJoiningDateAmount()));
                continue;
            }
            if (i == 7) {
                vo.setTxtWorkYear8(String.valueOf(dto.getWorkMonth() / 12));
                vo.setTxtWorkMonth8(String.valueOf(dto.getWorkMonth() % 12));
                vo.setTxtJoiningDateAmount8(String.valueOf(dto.getJoiningDateAmount()));
                continue;
            }
            if (i == 8) {
                vo.setTxtWorkYear9(String.valueOf(dto.getWorkMonth() / 12));
                vo.setTxtWorkMonth9(String.valueOf(dto.getWorkMonth() % 12));
                vo.setTxtJoiningDateAmount9(String.valueOf(dto.getJoiningDateAmount()));
                continue;
            }
            if (i == 9) {
                vo.setTxtWorkYear10(String.valueOf(dto.getWorkMonth() / 12));
                vo.setTxtWorkMonth10(String.valueOf(dto.getWorkMonth() % 12));
                vo.setTxtJoiningDateAmount10(String.valueOf(dto.getJoiningDateAmount()));
                continue;
            }
            if (i == 10) {
                vo.setTxtWorkYear11(String.valueOf(dto.getWorkMonth() / 12));
                vo.setTxtWorkMonth11(String.valueOf(dto.getWorkMonth() % 12));
                vo.setTxtJoiningDateAmount11(String.valueOf(dto.getJoiningDateAmount()));
                continue;
            }
            if (i != 11) continue;
            vo.setTxtWorkYear12(String.valueOf(dto.getWorkMonth() / 12));
            vo.setTxtWorkMonth12(String.valueOf(dto.getWorkMonth() % 12));
            vo.setTxtJoiningDateAmount12(String.valueOf(dto.getJoiningDateAmount()));
        }
    }

    protected void setDtoFields(StockHolidayDtoInterface dto) {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        dto.setTmmStockHolidayId(vo.getTmmStockHolidayId());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setPaidHolidayCode(vo.getTxtPaidHolidayCode());
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
        dto.setStockYearAmount(this.getInt(vo.getTxtStockYearAmount()));
        dto.setStockTotalAmount(this.getInt(vo.getTxtStockTotalAmount()));
        dto.setStockLimitDate(this.getInt(vo.getTxtStockLimitDate()));
    }

    protected void setVoFields(StockHolidayDtoInterface dto) {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        vo.setTmmStockHolidayId(dto.getTmmStockHolidayId());
        vo.setTxtStockYearAmount(String.valueOf(dto.getStockYearAmount()));
        vo.setTxtStockTotalAmount(String.valueOf(dto.getStockTotalAmount()));
        vo.setTxtStockLimitDate(String.valueOf(dto.getStockLimitDate()));
    }

    protected boolean isProportionally() {
        PaidHolidayCardVo vo = (PaidHolidayCardVo)this.mospParams.getVo();
        return Integer.toString(4).equals(vo.getPltPaidHolidayType());
    }

    protected boolean isOneDay(int prescribedWeeklyWorkingDays) {
        return prescribedWeeklyWorkingDays == 1;
    }

    protected boolean isTwoDays(int prescribedWeeklyWorkingDays) {
        return prescribedWeeklyWorkingDays == 2;
    }

    protected boolean isThreeDays(int prescribedWeeklyWorkingDays) {
        return prescribedWeeklyWorkingDays == 3;
    }

    protected boolean isFourDays(int prescribedWeeklyWorkingDays) {
        return prescribedWeeklyWorkingDays == 4;
    }

    protected boolean isFiveDays(int prescribedWeeklyWorkingDays) {
        return prescribedWeeklyWorkingDays == 5;
    }

    protected boolean isSixMonths(int continuousServiceTermsCountingFromTheEmploymentDay) {
        return continuousServiceTermsCountingFromTheEmploymentDay == 6;
    }

    protected boolean isOneYearAndSixMonths(int continuousServiceTermsCountingFromTheEmploymentDay) {
        return continuousServiceTermsCountingFromTheEmploymentDay == 18;
    }

    protected boolean isTwoYearsAndSixMonths(int continuousServiceTermsCountingFromTheEmploymentDay) {
        return continuousServiceTermsCountingFromTheEmploymentDay == 30;
    }

    protected boolean isThreeYearsAndSixMonths(int continuousServiceTermsCountingFromTheEmploymentDay) {
        return continuousServiceTermsCountingFromTheEmploymentDay == 42;
    }

    protected boolean isFourYearsAndSixMonths(int continuousServiceTermsCountingFromTheEmploymentDay) {
        return continuousServiceTermsCountingFromTheEmploymentDay == 54;
    }

    protected boolean isFiveYearsAndSixMonths(int continuousServiceTermsCountingFromTheEmploymentDay) {
        return continuousServiceTermsCountingFromTheEmploymentDay == 66;
    }

    protected boolean isSixYearsAndSixMonths(int continuousServiceTermsCountingFromTheEmploymentDay) {
        int day = 78;
        return continuousServiceTermsCountingFromTheEmploymentDay == day;
    }
}

