/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.bean.CutoffRegistBeanInterface;
import jp.mosp.time.bean.CutoffSearchBeanInterface;
import jp.mosp.time.comparator.settings.CutoffMasterCutoffCodeComparator;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.CutoffMasterVo;

public class CutoffMasterAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM5500";
    public static final String CMD_SEARCH = "TM5502";
    public static final String CMD_RE_SHOW = "TM5503";
    public static final String CMD_REGIST = "TM5505";
    public static final String CMD_DELETE = "TM5507";
    public static final String CMD_SORT = "TM5508";
    public static final String CMD_PAGE = "TM5509";
    public static final String CMD_INSERT_MODE = "TM5591";
    public static final String CMD_EDIT_MODE = "TM5592";
    public static final String CMD_ADD_MODE = "TM5593";
    public static final String CMD_BATCH_UPDATE = "TM5595";

    public CutoffMasterAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new CutoffMasterVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        }
    }

    protected void show() {
        CutoffMasterVo vo = (CutoffMasterVo)this.mospParams.getVo();
        this.initTimeSettingVoFields();
        vo.setTxtSearchCutoffCode("");
        vo.setTxtSearchCutoffName("");
        vo.setTxtSearchCutoffAbbr("");
        vo.setPltSearchCutoffDate("");
        vo.setPltSearchNoApproval("");
        vo.setPltSearchSelfTightening("");
        this.insertMode();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(CutoffMasterCutoffCodeComparator.class.getName());
    }

    protected void search() throws MospException {
        CutoffMasterVo vo = (CutoffMasterVo)this.mospParams.getVo();
        CutoffSearchBeanInterface search = this.timeReference().cutoffSearch();
        search.setActivateDate(this.getSearchActivateDate());
        search.setCutoffCode(vo.getTxtSearchCutoffCode());
        search.setCutoffName(vo.getTxtSearchCutoffName());
        search.setCutoffAbbr(vo.getTxtSearchCutoffAbbr());
        search.setCutoffDate(vo.getPltSearchCutoffDate());
        search.setNoApproval(vo.getPltSearchNoApproval());
        search.setSelfTightening(vo.getPltSearchSelfTightening());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(CutoffMasterCutoffCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        this.initCkbSelect();
        if (list.size() == 0) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() {
        this.setVoList(this.pageList());
    }

    protected void regist() throws MospException {
        CutoffMasterVo vo = (CutoffMasterVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        CutoffRegistBeanInterface regist = this.time().cutoffRegist();
        CutoffDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageInsertSucceed((MospParams)this.mospParams);
        this.setEditUpdateMode(dto.getCutoffCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void add() throws MospException {
        CutoffRegistBeanInterface regist = this.time().cutoffRegist();
        CutoffDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageUpdateFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageUpdatetSucceed((MospParams)this.mospParams);
        this.setVoFields(dto);
        this.setEditUpdateMode(dto.getCutoffCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void update() throws MospException {
        CutoffRegistBeanInterface regist = this.time().cutoffRegist();
        CutoffDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageUpdateFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageUpdatetSucceed((MospParams)this.mospParams);
        this.setVoFields(dto);
        this.setEditUpdateMode(dto.getCutoffCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void delete() throws MospException {
        CutoffMasterVo vo = (CutoffMasterVo)this.mospParams.getVo();
        long[] idArray = this.getIdArray(vo.getCkbSelect());
        this.time().cutoffRegist().delete(idArray);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageDeleteHistory((MospParams)this.mospParams, (int)idArray.length);
        this.insertMode();
        this.search();
    }

    protected void batchUpdate() throws MospException {
        CutoffMasterVo vo = (CutoffMasterVo)this.mospParams.getVo();
        this.time().cutoffRegist().update(this.getIdArray(vo.getCkbSelect()), this.getUpdateActivateDate(), this.getInt(vo.getPltUpdateInactivate()));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageBatchUpdatetFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageUpdatetSucceed((MospParams)this.mospParams);
        this.insertMode();
        this.setSearchActivateDate(this.getUpdateActivateDate());
        this.search();
    }

    protected void insertMode() {
        this.setEditInsertMode();
        CutoffMasterVo vo = (CutoffMasterVo)this.mospParams.getVo();
        vo.setTxtEditCutoffCode("");
        vo.setTxtEditCutoffName("");
        vo.setTxtEditCutoffAbbr("");
        vo.setPltEditCutoffDate(String.valueOf(0));
        vo.setPltEditNoApproval("");
        vo.setPltEditSelfTightening(String.valueOf(1));
        vo.setPltEditInactivate(String.valueOf(0));
    }

    protected void addMode() {
        this.setEditAddMode();
    }

    protected void editMode() throws MospException {
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
    }

    protected void setEditUpdateMode(String cutoffCode, Date activateDate) throws MospException {
        CutoffDtoInterface dto = this.timeReference().cutoff().findForKey(cutoffCode, activateDate);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        this.setEditUpdateMode(this.timeReference().cutoff().getCutoffHistory(cutoffCode));
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) {
        CutoffMasterVo vo = (CutoffMasterVo)this.mospParams.getVo();
        long[] aryCkbRecordId = new long[list.size()];
        String[] aryActivateDate = new String[list.size()];
        String[] aryCutoffCode = new String[list.size()];
        String[] aryCutoffName = new String[list.size()];
        String[] aryCutoffAbbr = new String[list.size()];
        String[] aryCutOffDate = new String[list.size()];
        String[] aryNoApproval = new String[list.size()];
        String[] arySelfTightening = new String[list.size()];
        String[] aryInactivateFlag = new String[list.size()];
        String[][] cutoffDateArray = this.mospParams.getProperties().getCodeArray("CutoffDate", false);
        for (int i = 0; i < list.size(); ++i) {
            CutoffDtoInterface dto = (CutoffDtoInterface)list.get(i);
            aryCkbRecordId[i] = dto.getTmmCutoffId();
            aryActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryCutoffCode[i] = dto.getCutoffCode();
            aryCutoffName[i] = dto.getCutoffName();
            aryCutoffAbbr[i] = dto.getCutoffAbbr();
            aryCutOffDate[i] = this.getCodeName(String.valueOf(dto.getCutoffDate()), cutoffDateArray);
            aryNoApproval[i] = this.getCodeName(String.valueOf(dto.getNoApproval()), this.mospParams.getProperties().getCodeArray("NoApproval", false));
            arySelfTightening[i] = this.getInactivateFlagName(dto.getSelfTightening());
            aryInactivateFlag[i] = this.getInactivateFlagName(dto.getInactivateFlag());
        }
        vo.setAryCkbRecordId(aryCkbRecordId);
        vo.setAryLblActivateDate(aryActivateDate);
        vo.setAryLblCutoffCode(aryCutoffCode);
        vo.setAryLblCutoffName(aryCutoffName);
        vo.setAryLblCutoffAbbr(aryCutoffAbbr);
        vo.setAryLblCutoffDate(aryCutOffDate);
        vo.setAryLblNoApproval(aryNoApproval);
        vo.setAryLblSelfTightening(arySelfTightening);
        vo.setAryLblInactivate(aryInactivateFlag);
    }

    protected void setVoFields(CutoffDtoInterface dto) {
        CutoffMasterVo vo = (CutoffMasterVo)this.mospParams.getVo();
        vo.setRecordId(dto.getTmmCutoffId());
        vo.setTxtEditActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setTxtEditCutoffCode(dto.getCutoffCode());
        vo.setTxtEditCutoffName(dto.getCutoffName());
        vo.setTxtEditCutoffAbbr(dto.getCutoffAbbr());
        vo.setPltEditCutoffDate(String.valueOf(dto.getCutoffDate()));
        vo.setPltEditNoApproval(String.valueOf(dto.getNoApproval()));
        vo.setPltEditSelfTightening(String.valueOf(dto.getSelfTightening()));
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
    }

    protected void setDtoFields(CutoffDtoInterface dto) {
        CutoffMasterVo vo = (CutoffMasterVo)this.mospParams.getVo();
        dto.setTmmCutoffId(vo.getRecordId());
        dto.setCutoffCode(vo.getTxtEditCutoffCode());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setCutoffName(vo.getTxtEditCutoffName());
        dto.setCutoffAbbr(vo.getTxtEditCutoffAbbr());
        dto.setCutoffDate(this.getInt(vo.getPltEditCutoffDate()));
        dto.setNoApproval(this.getInt(vo.getPltEditNoApproval()));
        dto.setSelfTightening(this.getInt(vo.getPltEditSelfTightening()));
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
        dto.setCutoffType("month");
    }
}

