/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.comparator.base.EmployeeCodeComparator;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.bean.ApplicationReferenceSearchBeanInterface;
import jp.mosp.time.dto.settings.ApplicationReferenceDtoInterface;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.ApplicationReferenceVo;

public class ApplicationReferenceAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM5710";
    public static final String CMD_SEARCH = "TM5712";
    public static final String CMD_SET_ACTIVATION_DATE = "TM5716";
    public static final String CMD_SORT = "TM5718";
    public static final String CMD_PAGE = "TM5719";

    protected BaseVo getSpecificVo() {
        return new ApplicationReferenceVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        }
    }

    protected void show() throws MospException {
        ApplicationReferenceVo vo = (ApplicationReferenceVo)this.mospParams.getVo();
        this.initTimeSettingVoFields();
        vo.setTxtSearchEmployeeCode("");
        vo.setTxtSearchEmployeeName("");
        vo.setTxtSearchApplicationCode("");
        vo.setTxtSearchApplicationName("");
        vo.setJsSearchConditionRequired(this.isSearchConditionRequired());
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
        vo.setModeActivateDate("fixed");
        this.setPulldown();
    }

    protected void search() throws MospException {
        ApplicationReferenceVo vo = (ApplicationReferenceVo)this.mospParams.getVo();
        ApplicationReferenceSearchBeanInterface search = this.timeReference().applicationReferenceSearch();
        if (vo.getModeActivateDate().equals("chaning")) {
            PfMessageUtility.addErrorActivateDateNotSettled((MospParams)this.mospParams);
            return;
        }
        this.checkSearchCondition(new String[]{vo.getTxtSearchEmployeeCode(), vo.getTxtSearchEmployeeName(), vo.getPltSearchWorkPlace(), vo.getPltSearchEmployment(), vo.getPltSearchSection(), vo.getPltSearchPosition(), vo.getTxtSearchApplicationCode(), vo.getTxtSearchApplicationName(), vo.getPltSearchTimeSetting(), vo.getPltSearchSchedule(), vo.getPltSearchPaidHoliday(), vo.getPltSearchCutoff()});
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        search.setActivateDate(this.getSearchActivateDate());
        search.setEmployeeCode(vo.getTxtSearchEmployeeCode());
        search.setEmployeeName(vo.getTxtSearchEmployeeName());
        search.setWorkPlaceCode(vo.getPltSearchWorkPlace());
        search.setEmploymentCode(vo.getPltSearchEmployment());
        search.setSectionCode(vo.getPltSearchSection());
        search.setPositionCode(vo.getPltSearchPosition());
        search.setApplicationCode(vo.getTxtSearchApplicationCode());
        search.setApplicationName(vo.getTxtSearchApplicationName());
        search.setTimeSettingCode(vo.getPltSearchTimeSetting());
        search.setCutoffCode(vo.getPltSearchCutoff());
        search.setScheduleCode(vo.getPltSearchSchedule());
        search.setPaidHolidayCode(vo.getPltSearchPaidHoliday());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.size() == 0) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void setActivationDate() throws MospException {
        ApplicationReferenceVo vo = (ApplicationReferenceVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    private void setPulldown() throws MospException {
        ApplicationReferenceVo vo = (ApplicationReferenceVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltSearchWorkPlaceMaster(this.getInputActivateDatePulldown());
            vo.setAryPltSearchEmploymentMaster(this.getInputActivateDatePulldown());
            vo.setAryPltSearchSectionMaster(this.getInputActivateDatePulldown());
            vo.setAryPltSearchPositionMaster(this.getInputActivateDatePulldown());
            vo.setAryPltSearchTimeSetting(this.getInputActivateDatePulldown());
            vo.setAryPltSearchSchedule(this.getInputActivateDatePulldown());
            vo.setAryPltSearchPaidHoliday(this.getInputActivateDatePulldown());
            vo.setAryPltSearchCutoff(this.getInputActivateDatePulldown());
            return;
        }
        Date date = this.getSearchActivateDate();
        vo.setAryPltSearchWorkPlaceMaster(this.reference().workPlace().getCodedSelectArray(date, true, null));
        vo.setAryPltSearchEmploymentMaster(this.reference().employmentContract().getCodedSelectArray(date, true, null));
        vo.setAryPltSearchSectionMaster(this.reference().section().getCodedSelectArray(date, true, null));
        vo.setAryPltSearchPositionMaster(this.reference().position().getCodedSelectArray(date, true, null));
        vo.setAryPltSearchTimeSetting(this.timeReference().timeSetting().getCodedSelectArray(date, true));
        vo.setAryPltSearchSchedule(this.timeReference().scheduleUtil().getCodedSelectArray(date, true));
        vo.setAryPltSearchPaidHoliday(this.timeReference().paidHoliday().getCodedSelectArray(date, true));
        vo.setAryPltSearchCutoff(this.timeReference().cutoff().getCodedSelectArray(date, true, null));
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        ApplicationReferenceVo vo = (ApplicationReferenceVo)this.mospParams.getVo();
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblEmployeeCode = new String[list.size()];
        String[] aryLblEmployeeName = new String[list.size()];
        String[] aryLblApplicationCode = new String[list.size()];
        String[] aryLblApplication = new String[list.size()];
        String[] aryLblTimeSetting = new String[list.size()];
        String[] aryLblCutoff = new String[list.size()];
        String[] aryLblSchadeule = new String[list.size()];
        String[] aryLblPaidHoliday = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ApplicationReferenceDtoInterface dto = (ApplicationReferenceDtoInterface)list.get(i);
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblEmployeeCode[i] = dto.getEmployeeCode();
            aryLblEmployeeName[i] = dto.getEmployeeName();
            aryLblApplicationCode[i] = dto.getApplicationCode();
            aryLblApplication[i] = dto.getApplicationName();
            aryLblTimeSetting[i] = dto.getTimeSettingAbbr();
            aryLblCutoff[i] = dto.getCutoffAbbr();
            aryLblSchadeule[i] = dto.getScheduleAbbr();
            aryLblPaidHoliday[i] = dto.getPaidHolidayAbbr();
        }
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblEmployeeCode(aryLblEmployeeCode);
        vo.setAryLblEmployeeName(aryLblEmployeeName);
        vo.setAryLblApplicationCode(aryLblApplicationCode);
        vo.setAryLblApplication(aryLblApplication);
        vo.setAryLblTimeSetting(aryLblTimeSetting);
        vo.setAryLblCutoff(aryLblCutoff);
        vo.setAryLblSchadeule(aryLblSchadeule);
        vo.setAryLblPaidHoliday(aryLblPaidHoliday);
    }
}

