/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.ApplicationRegistBeanInterface;
import jp.mosp.time.bean.CheckAvailableBeanInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmApplicationDto;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.ApplicationCardVo;

public class ApplicationCardAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM5620";
    public static final String CMD_SELECT_SHOW = "TM5621";
    public static final String CMD_REGIST = "TM5625";
    public static final String CMD_DELETE = "TM5627";
    public static final String CMD_SET_ACTIVATION_DATE = "TM5670";
    public static final String CMD_INSERT_MODE = "TM5671";
    public static final String CMD_ADD_MODE = "TM5673";
    protected static final String CODE_KEY_CHECK = "CheckApplication";

    protected BaseVo getSpecificVo() {
        return new ApplicationCardVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        }
    }

    protected void show() throws MospException {
        this.insertMode();
    }

    protected void regist() throws MospException {
        ApplicationCardVo vo = (ApplicationCardVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        ApplicationRegistBeanInterface regist = this.time().applicationRegist();
        ApplicationDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        this.isAvailableApplySetting(dto.getActivateDate(), new String[]{dto.getWorkSettingCode(), dto.getScheduleCode()});
        regist.insert(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageInsertSucceed((MospParams)this.mospParams);
        this.setEditUpdateMode(dto.getApplicationCode(), dto.getActivateDate());
    }

    protected void add() throws MospException {
        ApplicationRegistBeanInterface regist = this.time().applicationRegist();
        TmmApplicationDto dto = new TmmApplicationDto();
        this.setDtoFields((ApplicationDtoInterface)dto);
        this.isAvailableApplySetting(dto.getActivateDate(), new String[]{dto.getWorkSettingCode(), dto.getScheduleCode()});
        regist.add((ApplicationDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageUpdateFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageAddHistorySucceed((MospParams)this.mospParams);
        this.setVoFields((ApplicationDtoInterface)dto);
        this.setEditUpdateMode(dto.getApplicationCode(), dto.getActivateDate());
    }

    protected void update() throws MospException {
        ApplicationCardVo vo = (ApplicationCardVo)this.mospParams.getVo();
        ApplicationRegistBeanInterface regist = this.time().applicationRegist();
        ApplicationDtoInterface dto = this.timeReference().application().findForKey(vo.getTxtEditApplicationCode(), this.getEditActivateDate());
        this.setDtoFields(dto);
        this.isAvailableApplySetting(dto.getActivateDate(), new String[]{dto.getWorkSettingCode(), dto.getScheduleCode()});
        regist.update(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageUpdateFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageUpdatetSucceed((MospParams)this.mospParams);
        this.setVoFields(dto);
        this.setEditUpdateMode(dto.getApplicationCode(), dto.getActivateDate());
    }

    protected void delete() throws MospException {
        TmmApplicationDto dto = new TmmApplicationDto();
        this.setDtoFields((ApplicationDtoInterface)dto);
        this.time().applicationRegist().delete((ApplicationDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        this.insertMode();
    }

    protected void setActivationDate() throws MospException {
        ApplicationCardVo vo = (ApplicationCardVo)this.mospParams.getVo();
        ApplicationReferenceBeanInterface application = this.timeReference().application();
        if (vo.getModeActivateDate().equals("fixed")) {
            vo.setModeActivateDate("chaning");
            this.setPulldown();
            return;
        }
        vo.setModeActivateDate("fixed");
        this.setPulldown();
        String workSetting = vo.getAryPltEditWorkSetting()[0][0];
        String schedule = vo.getAryPltEditSchedule()[0][0];
        String paidHoliday = vo.getAryPltEditPaidHoliday()[0][0];
        if (workSetting.isEmpty() || schedule.isEmpty() || paidHoliday.isEmpty()) {
            String emptySetting = "";
            if (workSetting.isEmpty()) {
                emptySetting = this.mospParams.getName("WorkManage", new String[]{"Set"});
                this.mospParams.addErrorMessage("TMW0213", new String[]{emptySetting});
            }
            if (schedule.isEmpty()) {
                emptySetting = this.mospParams.getName("Calendar");
                this.mospParams.addErrorMessage("TMW0213", new String[]{emptySetting});
            }
            if (paidHoliday.isEmpty()) {
                emptySetting = this.mospParams.getName("PaidVacation", new String[]{"Set"});
                this.mospParams.addErrorMessage("TMW0213", new String[]{emptySetting});
            }
            vo.setModeActivateDate("chaning");
            this.setPulldown();
            return;
        }
        ApplicationDtoInterface applicationDto = application.findFormerInfo(vo.getTxtEditApplicationCode(), this.getEditActivateDate());
        if (applicationDto == null) {
            return;
        }
        vo.setPltEditWorkSetting(applicationDto.getWorkSettingCode());
        vo.setPltEditSchedule(applicationDto.getScheduleCode());
        vo.setPltEditPaidHoliday(applicationDto.getPaidHolidayCode());
    }

    protected void insertMode() throws MospException {
        this.setEditInsertMode();
        ApplicationCardVo vo = (ApplicationCardVo)this.mospParams.getVo();
        vo.setTxtEditApplicationCode("");
        vo.setTxtEditApplicationName("");
        vo.setTxtEditApplicationAbbr("");
        vo.setTxtEditEmployeeCode("");
        vo.setLblEmployeeName("");
        vo.setPltEditWorkPlaceMaster("");
        vo.setPltEditEmploymentMaster("");
        vo.setPltEditPositionMaster("");
        vo.setPltEditSectionMaster("");
        vo.setRadApplicationType("0");
        vo.setModeActivateDate("chaning");
        this.setPulldown();
    }

    protected void addMode() throws MospException {
        this.setEditAddMode();
        this.setModeActivateDate("chaning");
        this.setPulldown();
    }

    protected void editMode() throws MospException {
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
    }

    protected void setEditUpdateMode(String applicationCode, Date activateDate) throws MospException {
        ApplicationCardVo vo = (ApplicationCardVo)this.mospParams.getVo();
        ApplicationReferenceBeanInterface application = this.timeReference().application();
        ApplicationDtoInterface dto = application.findForKey(applicationCode, activateDate);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        this.setEditUpdateMode(application.getApplicationHistory(applicationCode));
        vo.setModeActivateDate("fixed");
        this.setPulldown();
    }

    protected void setPulldown() throws MospException {
        ApplicationCardVo vo = (ApplicationCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltEditWorkPlaceMaster(this.getInputActivateDatePulldown());
            vo.setAryPltEditEmploymentMaster(this.getInputActivateDatePulldown());
            vo.setAryPltEditSectionMaster(this.getInputActivateDatePulldown());
            vo.setAryPltEditPositionMaster(this.getInputActivateDatePulldown());
            vo.setAryPltEditWorkSetting(this.getInputActivateDatePulldown());
            vo.setAryPltEditSchedule(this.getInputActivateDatePulldown());
            vo.setAryPltEditPaidHoliday(this.getInputActivateDatePulldown());
            return;
        }
        Date date = this.getEditActivateDate();
        vo.setAryPltEditWorkPlaceMaster(this.reference().workPlace().getCodedSelectArray(date, true, null));
        vo.setAryPltEditEmploymentMaster(this.reference().employmentContract().getCodedSelectArray(date, true, null));
        vo.setAryPltEditSectionMaster(this.reference().section().getCodedSelectArray(date, true, null));
        vo.setAryPltEditPositionMaster(this.reference().position().getCodedSelectArray(date, true, null));
        vo.setAryPltEditWorkSetting(this.timeReference().timeSetting().getCodedSelectArray(date, false));
        vo.setAryPltEditSchedule(this.timeReference().scheduleUtil().getCodedSelectArray(date, false));
        vo.setAryPltEditPaidHoliday(this.timeReference().paidHoliday().getCodedSelectArray(date, false));
    }

    protected void setDtoFields(ApplicationDtoInterface dto) throws MospException {
        ApplicationCardVo vo = (ApplicationCardVo)this.mospParams.getVo();
        Date targetDate = this.getEditActivateDate();
        dto.setTmmApplicationId(vo.getRecordId());
        dto.setActivateDate(targetDate);
        dto.setApplicationCode(vo.getTxtEditApplicationCode());
        dto.setApplicationType(this.getInt(vo.getRadApplicationType()));
        dto.setApplicationName(vo.getTxtEditApplicationName());
        dto.setApplicationAbbr(vo.getTxtEditApplicationAbbr());
        dto.setWorkSettingCode(vo.getPltEditWorkSetting());
        dto.setScheduleCode(vo.getPltEditSchedule());
        dto.setPaidHolidayCode(vo.getPltEditPaidHoliday());
        dto.setInactivateFlag(Integer.parseInt(vo.getPltEditInactivate()));
        if (vo.getRadApplicationType().equals("0")) {
            dto.setWorkPlaceCode(vo.getPltEditWorkPlaceMaster());
            dto.setEmploymentContractCode(vo.getPltEditEmploymentMaster());
            dto.setSectionCode(vo.getPltEditSectionMaster());
            dto.setPositionCode(vo.getPltEditPositionMaster());
            dto.setPersonalIds("");
        } else {
            dto.setWorkPlaceCode("");
            dto.setEmploymentContractCode("");
            dto.setSectionCode("");
            dto.setPositionCode("");
            List humanList = this.reference().human().getPersonalIdList(vo.getTxtEditEmployeeCode(), targetDate);
            StringBuffer sb = new StringBuffer();
            String targetId = "";
            for (int i = 0; i < humanList.size(); ++i) {
                targetId = (String)humanList.get(i);
                if (targetId.equals("")) continue;
                String employeeCode = this.getEmployeeCode(targetId);
                if (!this.reference().entrance().isEntered(targetId, targetDate)) {
                    PfMessageUtility.addErrorEmployeeNotEntered((MospParams)this.mospParams, (Date)targetDate, (String)employeeCode);
                    continue;
                }
                if (this.reference().retirement().getRetireInfo(targetId, targetDate) != null) {
                    PfMessageUtility.addErrorEmployeeRetired((MospParams)this.mospParams, (Date)targetDate, (String)employeeCode);
                    continue;
                }
                if (sb.length() == 0) {
                    sb.append(targetId);
                    continue;
                }
                sb.append(this.mospParams.getName("Comma") + targetId);
            }
            dto.setPersonalIds(sb.toString());
        }
    }

    protected void setVoFields(ApplicationDtoInterface dto) throws MospException {
        ApplicationCardVo vo = (ApplicationCardVo)this.mospParams.getVo();
        vo.setRecordId(dto.getTmmApplicationId());
        vo.setTxtEditActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setTxtEditApplicationCode(dto.getApplicationCode());
        vo.setRadApplicationType(String.valueOf(dto.getApplicationType()));
        vo.setTxtEditApplicationName(dto.getApplicationName());
        vo.setTxtEditApplicationAbbr(dto.getApplicationAbbr());
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
        vo.setPltEditWorkPlaceMaster(dto.getWorkPlaceCode());
        vo.setPltEditEmploymentMaster(dto.getEmploymentContractCode());
        vo.setPltEditSectionMaster(dto.getSectionCode());
        vo.setPltEditPositionMaster(dto.getPositionCode());
        vo.setPltEditWorkSetting(dto.getWorkSettingCode());
        vo.setPltEditSchedule(dto.getScheduleCode());
        vo.setPltEditPaidHoliday(dto.getPaidHolidayCode());
        vo.setTxtEditEmployeeCode(this.reference().human().getEmployeeCodes(dto.getPersonalIds(), dto.getActivateDate()));
        vo.setLblEmployeeName(this.reference().human().getHumanNames(dto.getPersonalIds(), dto.getActivateDate()));
    }

    public boolean isAvailableApplySetting(Date targetDate, String ... types) throws MospException {
        boolean checkApplySetting = true;
        for (CheckAvailableBeanInterface addonBean : this.getBeans(CheckAvailableBeanInterface.class, CODE_KEY_CHECK)) {
            checkApplySetting = addonBean.check("", targetDate, types);
        }
        return checkApplySetting;
    }
}

