/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.report.bean.impl;

import java.util.ArrayList;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.jasperreport.JasperReportUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.AttendanceListReferenceBeanInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;
import jp.mosp.time.report.bean.ScheduleBookBeanInterface;

public class ScheduleBookBean
extends PlatformBean
implements ScheduleBookBeanInterface {
    protected AttendanceListReferenceBeanInterface attendanceListRefer;

    public void initBean() throws MospException {
        this.attendanceListRefer = (AttendanceListReferenceBeanInterface)this.createBeanInstance(AttendanceListReferenceBeanInterface.class);
    }

    public void makeScheduleBook(String personalId, int year, int month) throws MospException {
        List attendanceList = this.attendanceListRefer.getScheduleList(personalId, year, month);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.makeScheduleBook(attendanceList);
    }

    public void makeScheduleBooks(String[] personalIds, int year, int month) throws MospException {
        ArrayList list = new ArrayList();
        for (String personalId : personalIds) {
            List attendanceList = this.attendanceListRefer.getScheduleList(personalId, year, month);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            list.addAll(attendanceList);
        }
        this.makeScheduleBook(list);
    }

    protected void makeScheduleBook(List<AttendanceListDto> attendanceList) throws MospException {
        for (AttendanceListDto dto : attendanceList) {
            dto.setTitle(this.getReportTitle());
        }
        this.mospParams.setFile((Object)JasperReportUtility.createJasperPrint((String)this.getTemplatePath(), attendanceList));
        this.mospParams.setFileName("attendanceBook.pdf");
    }

    protected String getTemplatePath() {
        return this.mospParams.getApplicationProperty("Docbase") + this.mospParams.getApplicationProperty("attendanceBook.pdf");
    }

    protected String getReportTitle() {
        return this.mospParams.getName("ScheduleBook");
    }
}

