/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.report.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.ExportTableReferenceBeanInterface;
import jp.mosp.time.bean.TimeExportBeanInterface;
import jp.mosp.time.entity.CutoffEntityInterface;
import jp.mosp.time.file.vo.TimeExportListVo;
import jp.mosp.time.utils.TimeUtility;

public class TimeExportAction
extends TimeAction {
    public static final String CMD_EXECUTION = "TM3315";
    protected static final String CODE_KEY_TIME_EXPORT_BEAN = "TimeExportBean";

    protected BaseVo getSpecificVo() {
        return new TimeExportListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_EXECUTION)) {
            this.prepareVo();
            this.execution();
        }
    }

    protected void execution() throws MospException {
        TimeExportListVo vo = (TimeExportListVo)this.mospParams.getVo();
        ExportDtoInterface dto = this.reference().export().findForKey(vo.getRadSelect());
        if (dto == null) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
            return;
        }
        String exportCode = dto.getExportCode();
        String exportTable = dto.getExportTable();
        String modelClass = MospUtility.getCodeName((MospParams)this.mospParams, (String)exportTable, (String)CODE_KEY_TIME_EXPORT_BEAN);
        int startYear = this.getInt(vo.getTxtStartYear());
        int startMonth = this.getInt(vo.getTxtStartMonth());
        int endYear = this.getInt(vo.getTxtEndYear());
        int endMonth = this.getInt(vo.getTxtEndMonth());
        String cutoffCode = vo.getPltCutoff();
        String workPlaceCode = vo.getPltWorkPlace();
        String employmentContractCode = vo.getPltEmployment();
        String sectionCode = vo.getPltSection();
        String positionCode = vo.getPltPosition();
        String ckbNeedLowerSection = vo.getCkbNeedLowerSection();
        if (!MospUtility.isEqual((Object)modelClass, (Object)exportTable)) {
            TimeExportBeanInterface exportBean = (TimeExportBeanInterface)this.reference().createBean(TimeExportBeanInterface.class, modelClass);
            exportBean.export(exportCode, startYear, startMonth, endYear, endMonth, cutoffCode, workPlaceCode, employmentContractCode, sectionCode, MospUtility.isChecked((String)ckbNeedLowerSection), positionCode);
            return;
        }
        ExportTableReferenceBeanInterface exportTableRefer = this.timeReference().exportTable();
        exportTableRefer.setExportCode(vo.getRadSelect());
        exportTableRefer.setStartYear(startYear);
        exportTableRefer.setStartMonth(startMonth);
        exportTableRefer.setEndYear(endYear);
        exportTableRefer.setEndMonth(endMonth);
        exportTableRefer.setCutoffCode(cutoffCode);
        exportTableRefer.setWorkPlaceCode(workPlaceCode);
        exportTableRefer.setEmploymentCode(employmentContractCode);
        exportTableRefer.setSectionCode(sectionCode);
        exportTableRefer.setCkbNeedLowerSection(this.getInt(ckbNeedLowerSection));
        exportTableRefer.setPositionCode(positionCode);
        List csvDataList = exportTableRefer.export();
        if (this.mospParams.hasErrorMessage()) {
            vo.setRadSelect("");
            return;
        }
        if (csvDataList.isEmpty()) {
            PfMessageUtility.addErrorNoExportInfo((MospParams)this.mospParams);
            vo.setRadSelect("");
            return;
        }
        this.mospParams.setFile((Object)OrangeSignalUtility.getOrangeSignalParams((List)csvDataList));
        this.setFileName(dto);
    }

    protected void setFileName(ExportDtoInterface dto) throws MospException {
        TimeExportListVo vo = (TimeExportListVo)this.mospParams.getVo();
        int startYear = this.getInt(vo.getTxtStartYear());
        int startMonth = this.getInt(vo.getTxtStartMonth());
        Date targetDate = MonthUtility.getYearMonthTargetDate((int)startYear, (int)startMonth, (MospParams)this.mospParams);
        CutoffEntityInterface cutoff = this.timeReference().master().getCutoff(vo.getPltCutoff(), targetDate);
        this.timeReference().cutoff().chkExistCutoff(cutoff.getCutoffDto(), targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        Date firstDate = cutoff.getCutoffFirstDate(startYear, startMonth, this.mospParams);
        Date lastDate = cutoff.getCutoffLastDate(this.getInt(vo.getTxtEndYear()), this.getInt(vo.getTxtEndMonth()), this.mospParams);
        this.mospParams.setFileName(TimeUtility.getExportFileName((MospParams)this.mospParams, (ExportDtoInterface)dto, (Date)firstDate, (Date)lastDate));
    }
}

