/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.portal.bean.impl;

import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.portal.PortalBeanInterface;
import jp.mosp.platform.bean.portal.impl.PortalBean;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.TimeRecordBeanInterface;
import jp.mosp.time.bean.TimeRecordReferenceBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.dto.settings.TimeRecordDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeUtility;

public class PortalTimeCardBean
extends PortalBean
implements PortalBeanInterface {
    protected static final String PATH_PORTAL_VIEW = "/jsp/time/portal/portalTimeCard.jsp";
    public static final String JS_TIME = "jsTime";
    public static final String RECODE_START_WORK = "StartWork";
    public static final String RECODE_END_WORK = "EndWork";
    public static final String RECODE_START_REST = "StartRest";
    public static final String RECODE_END_REST = "EndRest";
    public static final String RECODE_REGULAR_END = "RegularEnd";
    public static final String RECODE_OVER_END = "OverEnd";
    public static final String RECODE_REGULAR_WORK = "RegularWork";
    public static final String PRM_RECODE_TYPE = "RecodeType";
    public static final String PRM_TIME_BUTTON = "TimeButton";
    public static final String PRM_REST_BUTTON = "RestButton";
    public static final String PRM_RECORD_END_STR = "RecordEndStr";

    public void initBean() {
    }

    public void show() throws MospException {
        if (!TimeUtility.isAttendanceListAvailable((MospParams)this.mospParams)) {
            return;
        }
        this.showPortalTimeCard();
    }

    public void regist() throws MospException {
        String recodeType = this.getPortalParameter(PRM_RECODE_TYPE);
        if (recodeType.equals(RECODE_START_WORK)) {
            this.recordStartWork();
        } else if (recodeType.equals(RECODE_END_WORK)) {
            this.recordEndWork();
        } else if (recodeType.equals(RECODE_START_REST)) {
            this.recordStartRest();
        } else if (recodeType.equals(RECODE_END_REST)) {
            this.recordEndRest();
        } else if (recodeType.equals(RECODE_REGULAR_END)) {
            this.recordRegularEnd();
        } else if (recodeType.equals(RECODE_OVER_END)) {
            this.recordOverEnd();
        } else if (recodeType.equals(RECODE_REGULAR_WORK)) {
            this.recordRegularWork();
        }
    }

    protected void showPortalTimeCard() throws MospException {
        int endWorkAppliStatus;
        this.addPortalViewList(PATH_PORTAL_VIEW);
        this.mospParams.addGeneralParam(JS_TIME, (Object)String.valueOf(this.getSystemTimeAndSecond().getTime()));
        String personalId = this.mospParams.getUser().getPersonalId();
        Date targetDate = this.getSystemDate();
        ApplicationEntity application = this.getApplicationReferenceBean().getApplicationEntity(personalId, targetDate);
        this.putPortalParameter(PRM_TIME_BUTTON, String.valueOf(application.getPortalTimeButtons()));
        this.putPortalParameter(PRM_REST_BUTTON, String.valueOf(application.getPortalRestButtons()));
        this.putPortalParameter(PRM_RECORD_END_STR, PfNameUtility.application((MospParams)this.mospParams));
        if (application.getPortalTimeButtons() == 1 && (endWorkAppliStatus = this.getTimeSettingRefer().getEntity(application.getTimeSettingDto()).getLimit("rs_end_work_application_status", 1)) == 2) {
            this.putPortalParameter(PRM_RECORD_END_STR, PfNameUtility.draft((MospParams)this.mospParams));
        }
    }

    protected void recordStartWork() throws MospException {
        TimeRecordDtoInterface dto = this.getTimeRecordReferenceBean().findForKey(this.mospParams.getUser().getPersonalId(), this.getSystemDate(), RECODE_START_WORK);
        String recordTime = DateUtility.getStringTimeAndSecond((Date)this.getTimeRecordBean().recordStartWork());
        if (this.mospParams.hasErrorMessage()) {
            if (dto == null) {
                PfMessageUtility.addMessageConfirmError((MospParams)this.mospParams);
                return;
            }
            TimeMessageUtility.addMessageRecordStartTimeFailed((MospParams)this.mospParams);
            return;
        }
        TimeMessageUtility.addMessageRecordStartWork((MospParams)this.mospParams, (String)recordTime);
    }

    protected void recordEndWork() throws MospException {
        String recordTime = DateUtility.getStringTimeAndSecond((Date)this.getTimeRecordBean().recordEndWork());
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageConfirmError((MospParams)this.mospParams);
            return;
        }
        TimeMessageUtility.addMessageRecordEndWork((MospParams)this.mospParams, (String)recordTime);
    }

    protected void recordStartRest() throws MospException {
        String recordTime = DateUtility.getStringTimeAndSecond((Date)this.getTimeRecordBean().recordStartRest());
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageConfirmError((MospParams)this.mospParams);
            return;
        }
        TimeMessageUtility.addMessageRecordStartRest((MospParams)this.mospParams, (String)recordTime);
    }

    protected void recordEndRest() throws MospException {
        String recordTime = DateUtility.getStringTimeAndSecond((Date)this.getTimeRecordBean().recordEndRest());
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageConfirmError((MospParams)this.mospParams);
            return;
        }
        TimeMessageUtility.addMessageRecordEndRest((MospParams)this.mospParams, (String)recordTime);
    }

    protected void recordRegularEnd() throws MospException {
        String recordTime = DateUtility.getStringTimeAndSecond((Date)this.getTimeRecordBean().recordRegularEnd());
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageConfirmError((MospParams)this.mospParams);
            return;
        }
        if (!this.mospParams.getMessageList().isEmpty()) {
            return;
        }
        TimeMessageUtility.addMessageRecordRegularEnd((MospParams)this.mospParams, (String)recordTime);
    }

    protected void recordOverEnd() throws MospException {
        this.getTimeRecordBean().recordOverEnd();
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageConfirmError((MospParams)this.mospParams);
        }
    }

    protected void recordRegularWork() throws MospException {
        String recordTime = DateUtility.getStringTimeAndSecond((Date)this.getTimeRecordBean().recordRegularWork());
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageConfirmError((MospParams)this.mospParams);
            return;
        }
        TimeMessageUtility.addMessageRecordRegularWork((MospParams)this.mospParams, (String)recordTime);
    }

    protected ApplicationReferenceBeanInterface getApplicationReferenceBean() throws MospException {
        return (ApplicationReferenceBeanInterface)this.createBeanInstance(ApplicationReferenceBeanInterface.class);
    }

    protected TimeSettingReferenceBeanInterface getTimeSettingRefer() throws MospException {
        return (TimeSettingReferenceBeanInterface)this.createBeanInstance(TimeSettingReferenceBeanInterface.class);
    }

    protected TimeRecordBeanInterface getTimeRecordBean() throws MospException {
        return (TimeRecordBeanInterface)this.createBeanInstance(TimeRecordBeanInterface.class);
    }

    protected TimeRecordReferenceBeanInterface getTimeRecordReferenceBean() throws MospException {
        return (TimeRecordReferenceBeanInterface)this.createBeanInstance(TimeRecordReferenceBeanInterface.class);
    }
}

