/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.portal.bean.impl;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.EntranceReferenceBeanInterface;
import jp.mosp.platform.bean.portal.PortalBeanInterface;
import jp.mosp.platform.bean.portal.impl.PortalBean;
import jp.mosp.time.bean.AttendanceListReferenceBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.TotalTimeEmployeeTransactionReferenceBeanInterface;
import jp.mosp.time.dto.settings.TotalTimeEmployeeDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.CutoffEntityInterface;
import jp.mosp.time.utils.AttendanceUtility;

public class PortalAttendanceCheckBean
extends PortalBean
implements PortalBeanInterface {
    protected static final String PATH_PORTAL_CHECK_TIME_VIEW = "/jsp/time/portal/portalAttendanceCheck.jsp";
    public static final String MSG_NO_APPLI_TIME_WORK = "TMW0287";
    public static final String MSG_CONFIRM = "TMI0003";
    public static final String PRM_ATTENDANCE_CHECK_MESSAGE = "prmAttendanceCheckMessage";
    protected EntranceReferenceBeanInterface entranceRefer;
    protected TotalTimeEmployeeTransactionReferenceBeanInterface totalTimeEmployeeRefer;
    protected AttendanceListReferenceBeanInterface attendanceList;
    protected TimeMasterBeanInterface timeMaster;

    public void initBean() throws MospException {
        this.entranceRefer = (EntranceReferenceBeanInterface)this.createBeanInstance(EntranceReferenceBeanInterface.class);
        this.totalTimeEmployeeRefer = (TotalTimeEmployeeTransactionReferenceBeanInterface)this.createBeanInstance(TotalTimeEmployeeTransactionReferenceBeanInterface.class);
        this.attendanceList = (AttendanceListReferenceBeanInterface)this.createBeanInstance(AttendanceListReferenceBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
    }

    public void show() throws MospException {
        this.addPortalViewList(PATH_PORTAL_CHECK_TIME_VIEW);
        String personalId = this.mospParams.getUser().getPersonalId();
        Date yesterday = DateUtility.addDay((Date)this.getSystemDate(), (int)-1);
        Date startDate = this.setStartDate(personalId, yesterday);
        if (startDate == null || startDate.after(yesterday)) {
            this.mospParams.getErrorMessageList().clear();
            return;
        }
        List attendList = this.attendanceList.getTermAttendanceList(personalId, startDate, yesterday);
        List dates = AttendanceUtility.getAttendanceAppliableDates((List)attendList);
        this.addErrorMessageNotTimeAppli(dates);
        this.mospParams.getErrorMessageList().clear();
    }

    protected Date setStartDate(String personalId, Date yesterday) throws MospException {
        Date today = this.getSystemDate();
        Date entranceDate = this.entranceRefer.getEntranceDate(personalId);
        ApplicationEntity application = this.timeMaster.getApplicationEntity(personalId, today);
        if (!application.isValid() || !application.isTimeManaged()) {
            return null;
        }
        CutoffEntityInterface cutoff = application.getCutoffEntity();
        TotalTimeEmployeeDtoInterface totalTimeEmployeeDto = this.totalTimeEmployeeRefer.findForPersonalList(personalId, 1);
        if (totalTimeEmployeeDto != null) {
            int totalTimeMounth;
            int totalTimeYear = totalTimeEmployeeDto.getCalculationYear();
            Date startDate = DateUtility.addDay((Date)cutoff.getCutoffLastDate(totalTimeYear, totalTimeMounth = totalTimeEmployeeDto.getCalculationMonth(), this.mospParams), (int)1);
            if (entranceDate.after(startDate)) {
                return entranceDate;
            }
            return startDate;
        }
        Date startDate = cutoff.getCutoffFirstDate(today, this.mospParams);
        if (DateUtility.isTermContain((Date)entranceDate, (Date)startDate, (Date)yesterday)) {
            return entranceDate;
        }
        return startDate;
    }

    protected void addErrorMessageNotTimeAppli(List<Date> errorDateList) throws MospException {
        if (errorDateList.isEmpty()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < errorDateList.size(); ++i) {
            String[] rep = new String[]{DateUtility.getStringDate((Date)errorDateList.get(i))};
            sb.append(this.mospParams.getMessage(MSG_NO_APPLI_TIME_WORK, rep));
            sb.append("\\\\n");
            if (i != 9 || errorDateList.size() <= 10) continue;
            sb.append(this.mospParams.getName("Other"));
            sb.append(errorDateList.size() - (i + 1));
            sb.append(this.mospParams.getName("Count"));
            sb.append("\\\\n");
            break;
        }
        String[] rep = new String[]{sb.toString()};
        this.mospParams.addGeneralParam(PRM_ATTENDANCE_CHECK_MESSAGE, (Object)this.mospParams.getMessage(MSG_CONFIRM, rep));
    }

    public void regist() {
    }
}

