/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.management.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.MospProperties;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.TopicPathUtility;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.comparator.base.EmployeeCodeComparator;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.bean.SubordinateSearchBeanInterface;
import jp.mosp.time.bean.TotalTimeCalcBeanInterface;
import jp.mosp.time.dto.settings.SubordinateListDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;
import jp.mosp.time.input.action.AttendanceListAction;
import jp.mosp.time.input.action.ScheduleReferenceAction;
import jp.mosp.time.management.vo.SubordinateListVo;
import jp.mosp.time.settings.base.TimeSettingAction;

public class SubordinateListAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM2100";
    public static final String CMD_SEARCH = "TM2102";
    public static final String CMD_RE_SHOW = "TM2103";
    public static final String CMD_TRANSFER = "TM2105";
    public static final String CMD_CALC = "TM2106";
    public static final String CMD_SORT = "TM2108";
    public static final String CMD_PAGE = "TM2109";
    public static final String CMD_SET_ACTIVATION_DATE = "TM2190";
    public static final String CMD_OUTPUT = "TM2196";
    public static final String CMD_SCHEDULE = "TM2197";
    public static final String CMD_PAID_HOLIDAY_USAGE = "TM2198";
    public static final String CMD_SHOW_APPROVED = "TM2410";

    public SubordinateListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new SubordinateListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SHOW_APPROVED)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.reShowJudging();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_CALC)) {
            this.prepareVo();
            this.calc();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivateDate();
        } else if (this.mospParams.getCommand().equals(CMD_OUTPUT)) {
            this.prepareVo();
            this.outputAttendanceBooks();
        } else if (this.mospParams.getCommand().equals(CMD_SCHEDULE)) {
            this.prepareVo();
            this.outputScheduleBooks();
        } else if (this.mospParams.getCommand().equals(CMD_PAID_HOLIDAY_USAGE)) {
            this.prepareVo();
            this.outputPaidHolidayUsage();
        }
    }

    protected void reShowJudging() throws MospException {
        if (this.mospParams.getApplicationPropertyBool("ViewTotalValues")) {
            return;
        }
        this.search();
    }

    protected void show() throws MospException {
        SubordinateListVo vo = (SubordinateListVo)this.mospParams.getVo();
        vo.setShowCommand(this.mospParams.getCommand());
        if (vo.getShowCommand().equals(CMD_SHOW_APPROVED)) {
            TopicPathUtility.setTopicPathName((MospParams)this.mospParams, (String)vo.getClassName(), (String)this.mospParams.getName("AttendanceHumanList"));
        }
        this.setDefaultValues();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.setPulldown();
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
    }

    protected void search() throws MospException {
        SubordinateListVo vo = (SubordinateListVo)this.mospParams.getVo();
        int targetYear = this.getInt(vo.getPltSearchRequestYear());
        int targetMonth = this.getInt(vo.getPltSearchRequestMonth());
        SubordinateSearchBeanInterface search = this.timeReference().subordinateSearch();
        if (vo.getModeActivateDate().equals("chaning")) {
            PfMessageUtility.addErrorActivateDateNotSettled((MospParams)this.mospParams);
            return;
        }
        this.checkSearchCondition(new String[]{vo.getTxtSearchEmployeeCode(), vo.getTxtSearchEmployeeName(), vo.getPltSearchWorkPlace(), vo.getPltSearchEmployment(), vo.getPltSearchSection(), vo.getPltSearchPosition(), vo.getPltSearchApproval(), vo.getPltSearchCalc(), vo.getPltSearchHumanType()});
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        search.setTargetDate(this.getSearchDate());
        search.setEmployeeCode(vo.getTxtSearchEmployeeCode());
        search.setEmployeeName(vo.getTxtSearchEmployeeName());
        search.setWorkPlaceCode(vo.getPltSearchWorkPlace());
        search.setEmploymentContractCode(vo.getPltSearchEmployment());
        search.setSectionCode(vo.getPltSearchSection());
        search.setPositionCode(vo.getPltSearchPosition());
        search.setApproval(vo.getPltSearchApproval());
        search.setApprovalBeforeDay(vo.getCkbYesterday());
        search.setCalc(vo.getPltSearchCalc());
        search.setHumanType(vo.getPltSearchHumanType());
        search.setStartDate(MonthUtility.getYearMonthTermFirstDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams));
        search.setEndDate(MonthUtility.getYearMonthTermLastDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams));
        search.setTargetYear(targetYear);
        search.setTargetMonth(targetMonth);
        List list = search.getSubordinateList();
        vo.setList(list);
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        this.initCkbSelect();
        if (list.isEmpty()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void transfer() {
        SubordinateListVo vo = (SubordinateListVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(this.getSelectedPersonalId(this.getTransferredIndex()));
        this.setTargetYear(this.getInt(vo.getPltSearchRequestYear()));
        this.setTargetMonth(this.getInt(vo.getPltSearchRequestMonth()));
        if (actionName.equals(AttendanceListAction.class.getName())) {
            if (vo.getShowCommand().equals(CMD_SHOW_APPROVED)) {
                this.mospParams.setNextCommand("TM2421");
            } else {
                this.mospParams.addGeneralParam("RollArray", (Object)this.getArray());
                this.mospParams.setNextCommand("TM1101");
            }
        } else if (actionName.equals(ScheduleReferenceAction.class.getName())) {
            this.mospParams.setNextCommand("TM1301");
        }
    }

    protected void calc() throws MospException {
        SubordinateListVo vo = (SubordinateListVo)this.mospParams.getVo();
        HumanReferenceBeanInterface human = this.reference().human();
        SubordinateSearchBeanInterface search = this.timeReference().subordinateSearch();
        TotalTimeCalcBeanInterface total = this.time().totalTimeCalc();
        search.setTargetDate(this.getSearchDate());
        List list = this.getSelectedListDto();
        for (SubordinateListDtoInterface dto : list) {
            String personalId = dto.getPersonalId();
            int targetYear = dto.getTargetYear();
            int targetMonth = dto.getTargetMonth();
            TotalTimeDataDtoInterface totalTimeDataDto = total.calc(personalId, targetYear, targetMonth, true);
            search.setTotalTimeData(dto, totalTimeDataDto);
            HumanDtoInterface humanDto = human.getHumanInfo(dto.getPersonalId(), this.getSearchDate());
            search.setLimitStandard(dto, humanDto);
        }
        vo.setList(list);
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        this.initCkbSelect();
        if (list.isEmpty()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void setActivateDate() throws MospException {
        SubordinateListVo vo = (SubordinateListVo)this.mospParams.getVo();
        this.checkSubordinateAvailable(this.getSearchDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
            this.setPulldown();
        } else {
            vo.setModeActivateDate("chaning");
            this.setInitPulldown();
        }
        ArrayList list = new ArrayList();
        vo.setList(list);
        this.setVoList(list);
    }

    public void setDefaultValues() throws MospException {
        SubordinateListVo vo = (SubordinateListVo)this.mospParams.getVo();
        vo.setTxtSearchEmployeeCode("");
        vo.setTxtSearchEmployeeName("");
        vo.setPltSearchWorkPlace("");
        vo.setPltSearchEmployment("");
        vo.setPltSearchSection("");
        vo.setPltSearchPosition("");
        vo.setPltSearchApproval("");
        vo.setCkbYesterday("0");
        vo.setPltSearchCalc("");
        vo.setPltSearchHumanType(String.valueOf(2));
        if (vo.getShowCommand().equals(CMD_SHOW_APPROVED)) {
            vo.setPltSearchHumanType(String.valueOf(1));
        }
        vo.setModeActivateDate("chaning");
        Date targetYearMonth = MonthUtility.getTargetYearMonth((Date)this.getSystemDate(), (MospParams)this.mospParams);
        vo.setAryPltRequestYear(this.getYearArray(DateUtility.getYear((Date)targetYearMonth)));
        vo.setAryPltRequestMonth(this.getMonthArray());
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)targetYearMonth));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)targetYearMonth));
        this.checkSubordinateAvailable(this.getSearchDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        vo.setModeActivateDate("fixed");
        vo.setJsSearchConditionRequired(this.isSearchConditionRequired());
    }

    private void setPulldown() throws MospException {
        SubordinateListVo vo = (SubordinateListVo)this.mospParams.getVo();
        String operationType = "1";
        if (vo.getShowCommand().equals(CMD_SHOW_APPROVED)) {
            operationType = null;
        }
        String[][] workPlace = this.reference().workPlace().getNameSelectArray(this.getSearchDate(), true, operationType);
        vo.setAryPltWorkPlace(workPlace);
        String[][] aryEmployment = this.reference().employmentContract().getNameSelectArray(this.getSearchDate(), true, operationType);
        vo.setAryPltEmployment(aryEmployment);
        String[][] arySection = this.reference().section().getCodedSelectArray(this.getSearchDate(), true, operationType);
        vo.setAryPltSection(arySection);
        String[][] aryPosition = this.reference().position().getCodedSelectArray(this.getSearchDate(), true, operationType);
        vo.setAryPltPosition(aryPosition);
        MospProperties properties = this.mospParams.getProperties();
        vo.setAryPltApproval(properties.getCodeArray("NotApproved", true));
        vo.setAryPltCalc(properties.getCodeArray("CutoffState", true));
        vo.setAryPltHumanType(properties.getCodeArray("SubordinateSearchType", true));
        vo.setAryPltRequestYear(this.getYearArray(MospUtility.getInt((Object)vo.getPltSearchRequestYear())));
    }

    private void setInitPulldown() throws MospException {
        SubordinateListVo vo = (SubordinateListVo)this.mospParams.getVo();
        String[][] initPulldown = this.getInputActivateDatePulldown();
        vo.setAryPltWorkPlace(initPulldown);
        vo.setAryPltEmployment(initPulldown);
        vo.setAryPltSection(initPulldown);
        vo.setAryPltPosition(initPulldown);
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        SubordinateListVo vo = (SubordinateListVo)this.mospParams.getVo();
        String[] aryLblEmployeeCode = new String[list.size()];
        String[] aryLblEmployeeName = new String[list.size()];
        String[] aryLblSection = new String[list.size()];
        String[] aryLblWorkDate = new String[list.size()];
        String[] aryLblWorkTime = new String[list.size()];
        String[] aryLblRestTime = new String[list.size()];
        String[] aryLblPrivateTime = new String[list.size()];
        String[] aryLblLateTime = new String[list.size()];
        String[] aryLblLeaveEarlyTime = new String[list.size()];
        String[] aryLblLateLeaveEarlyTime = new String[list.size()];
        String[] aryLblOverTimeIn = new String[list.size()];
        String[] aryLblOverTimeOut = new String[list.size()];
        String[] aryLblWorkOnHolidayTime = new String[list.size()];
        String[] aryLblLateNightTime = new String[list.size()];
        String[] aryLblPaidHoliday = new String[list.size()];
        String[] aryLblAllHoliday = new String[list.size()];
        String[] aryLblAbsence = new String[list.size()];
        String[] aryLblApploval = new String[list.size()];
        String[] aryLblCalc = new String[list.size()];
        String[] aryLblCorrection = new String[list.size()];
        String[] aryOvertimeOutStyle = new String[list.size()];
        String[] claApploval = new String[list.size()];
        String[] claCalc = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SubordinateListDtoInterface dto = (SubordinateListDtoInterface)list.get(i);
            aryLblEmployeeCode[i] = dto.getEmployeeCode();
            aryLblEmployeeName[i] = this.getLastFirstName(dto.getLastName(), dto.getFirstName());
            aryLblSection[i] = this.reference().section().getSectionAbbr(dto.getSectionCode(), this.getSearchDate());
            aryLblWorkDate[i] = this.getNumberString(dto.getWorkDate(), 1);
            aryLblWorkTime[i] = this.toTimeDotFormatString(dto.getWorkTime());
            aryLblRestTime[i] = this.toTimeDotFormatString(dto.getRestTime());
            aryLblPrivateTime[i] = this.toTimeDotFormatString(dto.getPrivateTime());
            aryLblLateTime[i] = this.toTimeDotFormatString(dto.getLateTime());
            aryLblLeaveEarlyTime[i] = this.toTimeDotFormatString(dto.getLeaveEarlyTime());
            aryLblLateLeaveEarlyTime[i] = this.toTimeDotFormatString(dto.getLateLeaveEarlyTime());
            aryLblOverTimeIn[i] = this.toTimeDotFormatString(dto.getOverTimeIn());
            aryOvertimeOutStyle[i] = dto.getOvertimeOutStyle();
            aryLblOverTimeOut[i] = this.toTimeDotFormatString(dto.getOverTimeOut());
            aryLblWorkOnHolidayTime[i] = this.toTimeDotFormatString(dto.getWorkOnHolidayTime());
            aryLblLateNightTime[i] = this.toTimeDotFormatString(dto.getLateNightTime());
            aryLblPaidHoliday[i] = this.getNumberString(dto.getPaidHoliday(), 1);
            aryLblAllHoliday[i] = this.getNumberString(dto.getAllHoliday(), 1);
            aryLblAbsence[i] = this.getNumberString(dto.getAbsence(), 1);
            claApploval[i] = dto.getApprovalStateClass();
            aryLblApploval[i] = dto.getApproval();
            claCalc[i] = dto.getCutoffStateClass();
            aryLblCalc[i] = dto.getCalc();
            aryLblCorrection[i] = dto.getCorrection();
        }
        vo.setAryLblEmployeeCode(aryLblEmployeeCode);
        vo.setAryLblEmployeeName(aryLblEmployeeName);
        vo.setAryLblSection(aryLblSection);
        vo.setAryLblWorkDate(aryLblWorkDate);
        vo.setAryLblWorkTime(aryLblWorkTime);
        vo.setAryLblRestTime(aryLblRestTime);
        vo.setAryLblPrivateTime(aryLblPrivateTime);
        vo.setAryLblLateTime(aryLblLateTime);
        vo.setAryLblLeaveEarlyTime(aryLblLeaveEarlyTime);
        vo.setAryLblLateLeaveEarlyTime(aryLblLateLeaveEarlyTime);
        vo.setAryLblOverTimeIn(aryLblOverTimeIn);
        vo.setAryLblOverTimeOut(aryLblOverTimeOut);
        vo.setAryLblWorkOnHolidayTime(aryLblWorkOnHolidayTime);
        vo.setAryLblLateNightTime(aryLblLateNightTime);
        vo.setAryLblPaidHoliday(aryLblPaidHoliday);
        vo.setAryLblAllHoliday(aryLblAllHoliday);
        vo.setAryLblAbsence(aryLblAbsence);
        vo.setClaApploval(claApploval);
        vo.setAryLblApploval(aryLblApploval);
        vo.setAryOvertimeOutStyle(aryOvertimeOutStyle);
        vo.setClaCalc(claCalc);
        vo.setAryLblCalc(aryLblCalc);
        vo.setAryLblCorrection(aryLblCorrection);
    }

    protected void outputAttendanceBooks() throws MospException {
        SubordinateListVo vo = (SubordinateListVo)this.mospParams.getVo();
        String[] personalIds = this.getSelectedPersonalIds(vo.getCkbSelect());
        int year = this.getInt(vo.getPltSearchRequestYear());
        int month = this.getInt(vo.getPltSearchRequestMonth());
        this.timeReference().attendanceBook().makeAttendanceBooks(personalIds, year, month);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void outputScheduleBooks() throws MospException {
        SubordinateListVo vo = (SubordinateListVo)this.mospParams.getVo();
        String[] personalIds = this.getSelectedPersonalIds(vo.getCkbSelect());
        int year = this.getInt(vo.getPltSearchRequestYear());
        int month = this.getInt(vo.getPltSearchRequestMonth());
        this.timeReference().scheduleBook().makeScheduleBooks(personalIds, year, month);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void outputPaidHolidayUsage() throws MospException {
        SubordinateListVo vo = (SubordinateListVo)this.mospParams.getVo();
        String[] personalIds = this.getSelectedPersonalIds(vo.getCkbSelect());
        int year = this.getInt(vo.getPltSearchRequestYear());
        int month = this.getInt(vo.getPltSearchRequestMonth());
        this.timeReference().paidHolidayUsageExport().export(personalIds, year, month);
    }

    protected Date getSearchDate() throws MospException {
        SubordinateListVo vo = (SubordinateListVo)this.mospParams.getVo();
        return MonthUtility.getYearMonthTargetDate((int)this.getInt(vo.getPltSearchRequestYear()), (int)this.getInt(vo.getPltSearchRequestMonth()), (MospParams)this.mospParams);
    }

    protected List<SubordinateListDtoInterface> getSelectedListDto() {
        SubordinateListVo vo = (SubordinateListVo)this.mospParams.getVo();
        ArrayList<SubordinateListDtoInterface> selectedList = new ArrayList<SubordinateListDtoInterface>();
        for (String idx : vo.getCkbSelect()) {
            selectedList.add((SubordinateListDtoInterface)this.getSelectedListDto(idx));
        }
        return selectedList;
    }
}

