/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.management.action;

import java.util.Date;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.base.TimeVo;
import jp.mosp.time.bean.AttendanceTotalInfoBeanInterface;
import jp.mosp.time.dto.settings.SubordinateFiscalListDtoInterface;
import jp.mosp.time.management.vo.SubordinateFiscalReferenceVo;

public class SubordinateFiscalReferenceAction
extends TimeAction {
    public static final String CMD_SELECT_SHOW = "TM2521";
    public static final String CMD_SEARCH = "TM2522";
    public static final String CMD_RE_SHOW = "TM2523";

    public SubordinateFiscalReferenceAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new SubordinateFiscalReferenceVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.show();
        }
    }

    protected void show() throws MospException {
        SubordinateFiscalReferenceVo vo = (SubordinateFiscalReferenceVo)this.mospParams.getVo();
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getTargetDate();
        int fiscalYear = this.getTargetYear();
        vo.setFiscalYear(fiscalYear);
        if (personalId != null && !personalId.isEmpty()) {
            this.setEmployeeInfo(personalId, targetDate);
        } else {
            this.setEmployeeInfo(vo.getPersonalId(), targetDate);
        }
        this.setList(personalId, fiscalYear);
    }

    protected void search() throws MospException {
        SubordinateFiscalReferenceVo vo = (SubordinateFiscalReferenceVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        String searchMode = this.mospParams.getRequestParam("transferSearch");
        if ("searchBack".equals(searchMode)) {
            personalId = vo.getPrevPersonalId();
        } else if ("searchNext".equals(searchMode)) {
            personalId = vo.getNextPersonalId();
        }
        Date targetDate = vo.getTargetDate();
        Date yearMonthTargetDate = MonthUtility.getYearMonthTargetDate((int)DateUtility.getYear((Date)targetDate), (int)DateUtility.getMonth((Date)targetDate), (MospParams)this.mospParams);
        this.timeReference().holidayRequest().chkBasicInfo(personalId, yearMonthTargetDate);
        this.setList(personalId, vo.getFiscalYear());
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
            return;
        }
    }

    public void setList(String personalId, int fiscalYear) throws MospException {
        SubordinateFiscalReferenceVo vo = (SubordinateFiscalReferenceVo)this.mospParams.getVo();
        AttendanceTotalInfoBeanInterface info = this.timeReference().attendanceTotalInfo();
        this.setVoHumanFields(personalId, vo.getTargetDate());
        this.setVoRollEmployeeFields();
        vo.setVoList(info.setFiscalYearAttendanceTotalList(personalId, fiscalYear));
    }

    protected void setVoHumanFields(String personalId, Date targetDate) throws MospException {
        TimeVo vo = (TimeVo)this.mospParams.getVo();
        HumanDtoInterface humanDto = this.reference().human().getHumanInfo(personalId, targetDate);
        if (humanDto == null) {
            return;
        }
        vo.setPersonalId(humanDto.getPersonalId());
        vo.setLblEmployeeCode(humanDto.getEmployeeCode());
        vo.setLblEmployeeName(this.getLastFirstName(humanDto.getLastName(), humanDto.getFirstName()));
        vo.setLblSectionName(this.reference().section().getSectionName(humanDto.getSectionCode(), targetDate));
        if (this.reference().section().useDisplayName()) {
            vo.setLblSectionName(this.reference().section().getSectionDisplay(humanDto.getSectionCode(), targetDate));
        }
    }

    protected void setVoRollEmployeeFields() {
        BaseDtoInterface baseDto;
        SubordinateFiscalReferenceVo vo = (SubordinateFiscalReferenceVo)this.mospParams.getVo();
        Object object = this.mospParams.getGeneralParam("RollArray");
        if (object != null) {
            vo.setRollArray((BaseDtoInterface[])object);
        }
        if (vo.getRollArray() == null || vo.getRollArray().length == 0) {
            return;
        }
        int i = 0;
        for (BaseDtoInterface baseDto2 : vo.getRollArray()) {
            SubordinateFiscalListDtoInterface dto = (SubordinateFiscalListDtoInterface)baseDto2;
            if (vo.getPersonalId().equals(dto.getPersonalId())) break;
            ++i;
        }
        vo.setLblPrevEmployeeCode("");
        vo.setPrevPersonalId("");
        if (i > 0) {
            baseDto = vo.getRollArray()[i - 1];
            SubordinateFiscalListDtoInterface dto = (SubordinateFiscalListDtoInterface)baseDto;
            vo.setLblPrevEmployeeCode(dto.getEmployeeCode());
            vo.setPrevPersonalId(dto.getPersonalId());
        }
        vo.setLblNextEmployeeCode("");
        vo.setNextPersonalId("");
        if (i + 1 < vo.getRollArray().length) {
            baseDto = vo.getRollArray()[i + 1];
            SubordinateFiscalListDtoInterface dto = (SubordinateFiscalListDtoInterface)baseDto;
            vo.setLblNextEmployeeCode(dto.getEmployeeCode());
            vo.setNextPersonalId(dto.getPersonalId());
        }
    }
}

