/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.management.action;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.MospProperties;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.human.HumanSubordinateBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.bean.SubordinateSearchBeanInterface;
import jp.mosp.time.comparator.settings.ManagementRequestRequestDateComparator;
import jp.mosp.time.dto.settings.ManagementRequestListDtoInterface;
import jp.mosp.time.input.action.ApprovalHistoryAction;
import jp.mosp.time.management.action.ApprovalCardAction;
import jp.mosp.time.management.vo.RequestListVo;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.utils.TimeUtility;

public class RequestListAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM2200";
    public static final String CMD_SEARCH = "TM2202";
    public static final String CMD_RE_SHOW = "TM2203";
    public static final String CMD_TRANSFER = "TM2206";
    public static final String CMD_SORT = "TM2208";
    public static final String CMD_PAGE = "TM2209";
    public static final String CMD_SET_ACTIVATION_DATE = "TM2290";

    public RequestListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new RequestListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivateDate();
        }
    }

    protected void show() throws MospException {
        RequestListVo vo = (RequestListVo)this.mospParams.getVo();
        this.setDefaultValues();
        Date systemDate = this.getSystemDate();
        vo.setAryPltSearchRequestYear(this.getYearArray(DateUtility.getYear((Date)systemDate)));
        vo.setAryPltSearchRequestMonth(this.getMonthArray());
        vo.setAryPltSearchRequestDay(this.getDayArray(true));
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)systemDate));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)systemDate));
        vo.setPltSearchRequestDay(DateUtility.getStringDayD((Date)systemDate));
        this.setPulldown();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(ManagementRequestRequestDateComparator.class.getName());
    }

    protected void search() throws MospException {
        RequestListVo vo = (RequestListVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            PfMessageUtility.addErrorActivateDateNotSettled((MospParams)this.mospParams);
            return;
        }
        this.checkSearchCondition(new String[]{vo.getTxtSearchEmployeeCode(), vo.getTxtSearchEmployeeName(), vo.getPltSearchWorkPlace(), vo.getPltSearchEmployment(), vo.getPltSearchSection(), vo.getPltSearchPosition(), vo.getPltSearchApprovalType(), vo.getPltSearchState()});
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        String personalId = this.mospParams.getUser().getPersonalId();
        List list = this.timeReference().approvalInfo().getEffectiveList(personalId, this.getFromDate(), this.getToDate(), this.getFunctionCodeSet(), vo.getPltSearchState(), this.getConditionIdSet(), this.getSubordinateIdSet());
        vo.setList(list);
        vo.setComparatorName(ManagementRequestRequestDateComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected Set<String> getConditionIdSet() throws MospException {
        RequestListVo vo = (RequestListVo)this.mospParams.getVo();
        if (vo.getTxtSearchEmployeeCode().isEmpty() && vo.getTxtSearchEmployeeName().isEmpty() && vo.getPltSearchWorkPlace().isEmpty() && vo.getPltSearchEmployment().isEmpty() && vo.getPltSearchSection().isEmpty() && vo.getPltSearchPosition().isEmpty()) {
            return null;
        }
        SubordinateSearchBeanInterface humanSearch = this.timeReference().subordinateSearch();
        humanSearch.setTargetDate(this.getSearchTargetDate());
        humanSearch.setStartDate(this.getFromDate());
        humanSearch.setEndDate(this.getToDate());
        humanSearch.setEmployeeCode(vo.getTxtSearchEmployeeCode());
        humanSearch.setEmployeeName(vo.getTxtSearchEmployeeName());
        humanSearch.setWorkPlaceCode(vo.getPltSearchWorkPlace());
        humanSearch.setEmploymentContractCode(vo.getPltSearchEmployment());
        humanSearch.setSectionCode(vo.getPltSearchSection());
        humanSearch.setPositionCode(vo.getPltSearchPosition());
        humanSearch.setEmployeeCodeType("forward");
        humanSearch.setOperationType(null);
        return humanSearch.getPersonalIdSet();
    }

    protected Set<String> getSubordinateIdSet() throws MospException {
        HumanSubordinateBeanInterface bean = this.reference().humanSubordinate();
        bean.setTargetDate(this.getSearchTargetDate());
        bean.setStartDate(this.getFromDate());
        bean.setEndDate(this.getToDate());
        return bean.getSubordinateIds();
    }

    protected Date getFromDate() throws MospException {
        RequestListVo vo = (RequestListVo)this.mospParams.getVo();
        String year = vo.getPltSearchRequestYear();
        String month = vo.getPltSearchRequestMonth();
        String day = vo.getPltSearchRequestDay();
        if (!day.isEmpty()) {
            return this.getDate(year, month, day);
        }
        return MonthUtility.getYearMonthTermFirstDate((int)this.getInt(year), (int)this.getInt(month), (MospParams)this.mospParams);
    }

    protected Date getToDate() throws MospException {
        RequestListVo vo = (RequestListVo)this.mospParams.getVo();
        String year = vo.getPltSearchRequestYear();
        String month = vo.getPltSearchRequestMonth();
        String day = vo.getPltSearchRequestDay();
        if (!day.isEmpty()) {
            return this.getDate(year, month, day);
        }
        return MonthUtility.getYearMonthTermLastDate((int)this.getInt(year), (int)this.getInt(month), (MospParams)this.mospParams);
    }

    protected Date getSearchTargetDate() throws MospException {
        RequestListVo vo = (RequestListVo)this.mospParams.getVo();
        String year = vo.getPltSearchRequestYear();
        String month = vo.getPltSearchRequestMonth();
        String day = vo.getPltSearchRequestDay();
        if (!day.isEmpty()) {
            return this.getDate(year, month, day);
        }
        return MonthUtility.getYearMonthTargetDate((int)this.getInt(year), (int)this.getInt(month), (MospParams)this.mospParams);
    }

    protected Set<String> getFunctionCodeSet() {
        RequestListVo vo = (RequestListVo)this.mospParams.getVo();
        if (vo.getPltSearchApprovalType().isEmpty()) {
            return TimeUtility.getTimeFunctionSet();
        }
        HashSet<String> functionCodeSet = new HashSet<String>();
        functionCodeSet.add(vo.getPltSearchApprovalType());
        return functionCodeSet;
    }

    protected void transfer() {
        RequestListVo vo = (RequestListVo)this.mospParams.getVo();
        this.setTargetWorkflow(this.getLong(vo.getAryWorkflow(this.getTransferredIndex())));
        String actionName = this.getTransferredAction();
        if (actionName.equals(ApprovalHistoryAction.class.getName())) {
            this.mospParams.setNextCommand(vo.getAryHistoryCmd(this.getTransferredIndex()));
        } else if (actionName.equals(ApprovalCardAction.class.getName())) {
            this.mospParams.addGeneralParam("RollArray", (Object)this.getArray());
            this.mospParams.setNextCommand(vo.getAryRequestTypeCmd(this.getTransferredIndex()));
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void setActivateDate() throws MospException {
        RequestListVo vo = (RequestListVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    public void setDefaultValues() {
        RequestListVo vo = (RequestListVo)this.mospParams.getVo();
        vo.setPltSearchRequestYear("");
        vo.setPltSearchRequestMonth("");
        vo.setPltSearchRequestDay("");
        vo.setPltSearchApprovalType("");
        vo.setPltSearchState("");
        vo.setTxtSearchEmployeeCode("");
        vo.setTxtSearchEmployeeName("");
        vo.setPltSearchWorkPlace("");
        vo.setPltSearchEmployment("");
        vo.setPltSearchSection("");
        vo.setPltSearchPosition("");
        vo.setJsSearchConditionRequired(this.isSearchConditionRequired());
        vo.setModeActivateDate("fixed");
    }

    private void setPulldown() throws MospException {
        RequestListVo vo = (RequestListVo)this.mospParams.getVo();
        int targetYear = Integer.parseInt(vo.getPltSearchRequestYear());
        int targetMonth = Integer.parseInt(vo.getPltSearchRequestMonth());
        Date date = MonthUtility.getYearMonthTargetDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        if (!vo.getPltSearchRequestDay().isEmpty()) {
            date = DateUtility.getDate((String)vo.getPltSearchRequestYear(), (String)vo.getPltSearchRequestMonth(), (String)vo.getPltSearchRequestDay());
        }
        MospProperties properties = this.mospParams.getProperties();
        String[][] aryState = properties.getCodeArray("EffectiveState", true);
        vo.setAryPltSearchState(aryState);
        String[][] aryWorkPlace = this.reference().workPlace().getNameSelectArray(date, true, null);
        vo.setAryPltSearchWorkPlace(aryWorkPlace);
        String[][] aryEmployment = this.reference().employmentContract().getNameSelectArray(date, true, null);
        vo.setAryPltSearchEmployment(aryEmployment);
        String[][] aryPltSection = this.reference().section().getCodedSelectArray(date, true, null);
        vo.setAryPltSearchSection(aryPltSection);
        String[][] aryPltPosition = this.reference().position().getCodedSelectArray(date, true, null);
        vo.setAryPltSearchPosition(aryPltPosition);
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        RequestListVo vo = (RequestListVo)this.mospParams.getVo();
        String[] aryLblEmployeeCode = new String[list.size()];
        String[] aryLblEmployeeName = new String[list.size()];
        String[] aryLblSection = new String[list.size()];
        String[] aryLblRequestType = new String[list.size()];
        String[] aryLblRequestDate = new String[list.size()];
        String[] aryLblRequestInfo = new String[list.size()];
        String[] aryLblState = new String[list.size()];
        String[] aryStateStyle = new String[list.size()];
        String[] aryWorkflow = new String[list.size()];
        String[] aryStage = new String[list.size()];
        String[] aryState = new String[list.size()];
        String[] aryLblRequestTypeCmd = new String[list.size()];
        String[] aryLblHistoryCmd = new String[list.size()];
        String[] aryLblRequestFunctionCode = new String[list.size()];
        String[] aryBackColor = new String[list.size()];
        SectionReferenceBeanInterface section = this.reference().section();
        Date date = DateUtility.getSystemDate();
        for (int i = 0; i < list.size(); ++i) {
            ManagementRequestListDtoInterface dto = (ManagementRequestListDtoInterface)list.get(i);
            aryLblEmployeeCode[i] = dto.getEmployeeCode();
            aryLblEmployeeName[i] = MospUtility.getHumansName((String)dto.getFirstName(), (String)dto.getLastName());
            aryLblSection[i] = section.getSectionAbbr(dto.getSectionCode(), date);
            aryLblRequestType[i] = this.getRequestTypeForView(dto);
            aryLblRequestTypeCmd[i] = this.getCardCommand(dto);
            aryLblHistoryCmd[i] = this.getHistoryCommand(dto.getRequestType());
            aryLblRequestFunctionCode[i] = dto.getRequestType();
            aryLblRequestDate[i] = DateUtility.getStringDateAndDay((Date)dto.getRequestDate());
            aryLblRequestInfo[i] = this.getRequestInfo(dto);
            aryStateStyle[i] = this.getStatusColor(dto.getState());
            aryLblState[i] = this.getStatusStageValueView(dto.getState(), dto.getStage());
            aryWorkflow[i] = String.valueOf(dto.getWorkflow());
            aryStage[i] = String.valueOf(dto.getStage());
            aryState[i] = dto.getState();
            aryBackColor[i] = this.setBackColor(dto.getPersonalId(), dto.getRequestDate(), dto.getRequestType());
        }
        vo.setAryLblEmployeeCode(aryLblEmployeeCode);
        vo.setAryLblEmployeeName(aryLblEmployeeName);
        vo.setAryLblSection(aryLblSection);
        vo.setAryLblRequestType(aryLblRequestType);
        vo.setAryLblRequestDate(aryLblRequestDate);
        vo.setAryLblRequestInfo(aryLblRequestInfo);
        vo.setAryLblState(aryLblState);
        vo.setAryStateStyle(aryStateStyle);
        vo.setAryRequestTypeCmd(aryLblRequestTypeCmd);
        vo.setAryHistoryCmd(aryLblHistoryCmd);
        vo.setAryRequestFunctionCode(aryLblRequestFunctionCode);
        vo.setAryWorkflow(aryWorkflow);
        vo.setAryStage(aryStage);
        vo.setAryState(aryState);
        vo.setAryBackColor(aryBackColor);
    }

    protected String getCardCommand(ManagementRequestListDtoInterface dto) {
        if (dto == null) {
            return "";
        }
        if ("1".equals(dto.getRequestType())) {
            return "TM2320";
        }
        if ("2".equals(dto.getRequestType())) {
            return "TM2330";
        }
        if ("3".equals(dto.getRequestType())) {
            return "TM2340";
        }
        if ("4".equals(dto.getRequestType())) {
            return "TM2350";
        }
        if ("5".equals(dto.getRequestType())) {
            return "TM2360";
        }
        if ("6".equals(dto.getRequestType())) {
            return "TM2370";
        }
        if ("7".equals(dto.getRequestType())) {
            return "TM2380";
        }
        return "";
    }
}

