/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.input.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleReferenceBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestRegistBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestSearchBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.comparator.settings.WorkTypeChangeRequestRequestDateComparator;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestListDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.input.vo.WorkTypeChangeRequestVo;
import jp.mosp.time.utils.TimeUtility;

public class WorkTypeChangeRequestAction
extends TimeAction {
    public static final String CMD_SHOW = "TM011100";
    public static final String CMD_SELECT_SHOW = "TM011101";
    public static final String CMD_SEARCH = "TM011102";
    public static final String CMD_RE_SHOW = "TM011103";
    public static final String CMD_BATCH_UPDATE = "TM011106";
    public static final String CMD_SORT = "TM011107";
    public static final String CMD_PAGE = "TM011108";
    public static final String CMD_SET_ACTIVATION_DATE = "TM011109";
    public static final String CMD_INSERT_MODE = "TM011110";
    public static final String CMD_EDIT_MODE = "TM011111";
    public static final String CMD_DRAFT = "TM011114";
    public static final String CMD_APPLI = "TM011115";
    public static final String CMD_WITHDRAWN = "TM011118";
    public static final String CMD_TRANSFER = "TM011120";
    public static final String CMD_SET_VIEW_PERIOD = "TM011131";
    public static final String CMD_BATCH_WITHDRAWN = "TM011136";
    protected static final String CODE_FUNCTION = "7";

    public WorkTypeChangeRequestAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new WorkTypeChangeRequestVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_DRAFT)) {
            this.prepareVo();
            this.draft();
        } else if (this.mospParams.getCommand().equals(CMD_APPLI)) {
            this.prepareVo();
            this.appli();
        } else if (this.mospParams.getCommand().equals(CMD_WITHDRAWN)) {
            this.prepareVo();
            this.withdrawn();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_SET_VIEW_PERIOD)) {
            this.prepareVo();
            this.setViewPeriod();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_WITHDRAWN)) {
            this.prepareVo();
            this.batchWithdrawn();
        }
    }

    protected void show() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        String personalId = this.mospParams.getUser().getPersonalId();
        Date targetDate = this.getSystemDate();
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        vo.setComparatorName(WorkTypeChangeRequestRequestDateComparator.class.getName());
        this.search();
        this.isAvailable(this.getEditRequestDate(), CODE_FUNCTION);
    }

    protected void select() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getSystemDate();
        if (personalId == null || personalId.isEmpty()) {
            personalId = this.mospParams.getUser().getPersonalId();
        }
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        vo.setComparatorName(WorkTypeChangeRequestRequestDateComparator.class.getName());
        this.search();
        this.isAvailable(this.getEditRequestDate(), CODE_FUNCTION);
    }

    protected void search() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        WorkTypeChangeRequestSearchBeanInterface search = this.timeReference().workTypeChangeRequestSearch();
        String personalId = vo.getPersonalId();
        search.setPersonalId(personalId);
        search.setWorkflowStatus(vo.getPltSearchState());
        search.setWorkTypeCode(vo.getPltSearchWorkType());
        int year = Integer.parseInt(vo.getPltSearchRequestYear());
        int startMonth = this.getInt("1");
        int endMonth = this.getInt("12");
        if (!MospUtility.isEmpty((String[])new String[]{vo.getPltSearchRequestMonth()})) {
            endMonth = startMonth = this.getInt(vo.getPltSearchRequestMonth());
        }
        TimeMasterBeanInterface timeMaster = this.timeReference().master();
        ApplicationEntity applicationFrom = timeMaster.getApplicationEntity(personalId, year, startMonth);
        ApplicationEntity applicationTo = timeMaster.getApplicationEntity(personalId, year, endMonth);
        Date firstDate = applicationFrom.getCutoffEntity().getCutoffFirstDate(year, startMonth, this.mospParams);
        Date lastDate = applicationTo.getCutoffEntity().getCutoffLastDate(year, endMonth, this.mospParams);
        search.setRequestStartDate(firstDate);
        search.setRequestEndDate(lastDate);
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(WorkTypeChangeRequestRequestDateComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty() && this.mospParams.getCommand().equals(CMD_SEARCH)) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void batchUpdate() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        if (!this.isAvailable(this.getSystemDate(), CODE_FUNCTION)) {
            return;
        }
        this.time().workTypeChangeRequestRegist().update(this.getIdArray(vo.getCkbSelect()));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageBatchUpdatetFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageUpdatetSucceed((MospParams)this.mospParams);
        String searchYear = vo.getPltSearchRequestYear();
        String searchMonth = vo.getPltSearchRequestMonth();
        this.insertMode();
        vo.setPltSearchRequestYear(searchYear);
        vo.setPltSearchRequestMonth(searchMonth);
        this.search();
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void setActivationDate() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        WorkTypeChangeRequestRegistBeanInterface regist = this.time().workTypeChangeRequestRegist();
        if ("chaning".equals(vo.getModeActivateDate())) {
            if (!this.isAvailable(this.getEditRequestDate(), CODE_FUNCTION)) {
                return;
            }
            if (!this.setApproverPullDown(vo.getPersonalId(), this.getEditRequestDate(), 1)) {
                PfMessageUtility.addMessageDecisiontFailed((MospParams)this.mospParams);
                return;
            }
            WorkTypeChangeRequestDtoInterface dto = this.timeReference().workTypeChangeRequest().findForKey(vo.getRecordId());
            if (dto == null) {
                dto = regist.getInitDto();
            }
            dto.setPersonalId(vo.getPersonalId());
            dto.setRequestDate(this.getEditRequestDate());
            regist.checkSetActivationDate(dto);
            if (this.mospParams.hasErrorMessage()) {
                PfMessageUtility.addMessageDecisiontFailed((MospParams)this.mospParams);
                return;
            }
            this.setEditEndDate();
            vo.setModeActivateDate("fixed");
        } else {
            vo.setCkbEndDate("0");
            vo.setAryPltLblApproverSetting(new String[0]);
            vo.setModeActivateDate("chaning");
        }
        this.setLblWorkTypeName();
        this.setEditWorkTypePulldown();
    }

    protected void insertMode() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        vo.setModeCardEdit("new");
        vo.setModeActivateDate("chaning");
        vo.setModeSearchActivateDate("fixed");
        this.setDefaultValues();
        this.setEditEndDate();
        this.setSearchRequestDate(this.getSystemDate());
        this.setLblWorkTypeName();
        this.setPulldown();
        this.setEditWorkTypePulldown();
        this.setSearchWorkTypePulldown();
    }

    protected void editMode() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        String personalId = this.getTargetPersonalId();
        if (personalId != null) {
            this.setEmployeeInfo(personalId, this.getSystemDate());
            this.setPageInfo(CMD_PAGE, this.getListLength());
            this.insertMode();
            vo.setComparatorName(WorkTypeChangeRequestRequestDateComparator.class.getName());
            this.search();
        }
        String transferredActivateDate = this.getTransferredActivateDate();
        Date targetDate = this.getTargetDate();
        if (transferredActivateDate != null && !transferredActivateDate.isEmpty()) {
            this.setEditUpdateMode(this.getDate(transferredActivateDate));
        } else if (targetDate != null) {
            this.setEditUpdateMode(targetDate);
        }
        vo.setModeActivateDate("chaning");
        this.setActivationDate();
    }

    protected void setEditUpdateMode(Date requestDate) throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        WorkTypeChangeRequestDtoInterface dto = this.timeReference().workTypeChangeRequest().findForKeyOnWorkflow(vo.getPersonalId(), requestDate);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
    }

    protected void draft() throws MospException {
        Date requestDate;
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        WorkTypeChangeRequestReferenceBeanInterface reference = this.timeReference().workTypeChangeRequest();
        WorkTypeChangeRequestRegistBeanInterface regist = this.time().workTypeChangeRequestRegist();
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        Date startDate = requestDate = this.getEditRequestDate();
        Date endDate = requestDate;
        if (this.isCheckedEndDate()) {
            endDate = this.getEditEndDate();
        }
        this.checkPeriod(startDate, endDate);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        regist.checkSchedule(vo.getPersonalId(), startDate);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        regist.checkSchedule(vo.getPersonalId(), endDate);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        List list = TimeUtility.getDateList((Date)startDate, (Date)endDate);
        for (Date date : list) {
            WorkTypeChangeRequestDtoInterface dto = reference.findForKey(vo.getRecordId());
            if (dto == null) {
                dto = regist.getInitDto();
            }
            if (!date.equals(startDate)) {
                dto = regist.getInitDto();
            }
            this.setDtoFields(dto, date);
            if (!date.equals(startDate)) {
                dto.setTmdWorkTypeChangeRequestId(0L);
            }
            regist.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
                return;
            }
            String workTypeCode = regist.getScheduledWorkTypeCode(vo.getPersonalId(), date);
            if ("legal_holiday".equals(workTypeCode) || "prescribed_holiday".equals(workTypeCode)) continue;
            regist.checkDraft(dto);
            if (this.mospParams.hasErrorMessage()) {
                PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
                return;
            }
            WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
            if (workflowDto == null) {
                workflowDto = workflowRegist.getInitDto();
                workflowDto.setFunctionCode(CODE_FUNCTION);
            }
            workflowRegist.setDtoApproverIds(workflowDto, this.getSelectApproverIds());
            if ((workflowDto = workflowRegist.draft(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1)) == null) continue;
            this.platform().workflowCommentRegist().addComment(workflowDto, this.mospParams.getUser().getPersonalId(), PfMessageUtility.getDraftSucceed((MospParams)this.mospParams));
            dto.setWorkflow(workflowDto.getWorkflow());
            regist.regist(dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addDraftMessage();
        this.setSearchRequestDate(requestDate);
        this.search();
        this.setEditUpdateMode(requestDate);
    }

    protected void appli() throws MospException {
        Date requestDate;
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        WorkTypeChangeRequestReferenceBeanInterface reference = this.timeReference().workTypeChangeRequest();
        WorkTypeChangeRequestRegistBeanInterface regist = this.time().workTypeChangeRequestRegist();
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        Date startDate = requestDate = this.getEditRequestDate();
        Date endDate = requestDate;
        if (this.isCheckedEndDate()) {
            endDate = this.getEditEndDate();
        }
        this.checkPeriod(startDate, endDate);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        regist.checkSchedule(vo.getPersonalId(), startDate);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        regist.checkSchedule(vo.getPersonalId(), endDate);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        List list = TimeUtility.getDateList((Date)startDate, (Date)endDate);
        for (Date date : list) {
            WorkTypeChangeRequestDtoInterface dto = reference.findForKey(vo.getRecordId());
            if (dto == null) {
                dto = regist.getInitDto();
            }
            if (!date.equals(startDate)) {
                dto = regist.getInitDto();
            }
            this.setDtoFields(dto, date);
            if (!date.equals(startDate)) {
                dto.setTmdWorkTypeChangeRequestId(0L);
            }
            regist.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
                return;
            }
            String workTypeCode = regist.getScheduledWorkTypeCode(vo.getPersonalId(), date);
            if ("legal_holiday".equals(workTypeCode) || "prescribed_holiday".equals(workTypeCode)) continue;
            regist.checkAppli(dto);
            if (this.mospParams.hasErrorMessage()) {
                PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
                return;
            }
            WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
            if (workflowDto == null) {
                workflowDto = workflowRegist.getInitDto();
                workflowDto.setFunctionCode(CODE_FUNCTION);
            }
            workflowRegist.setDtoApproverIds(workflowDto, this.getSelectApproverIds());
            if ((workflowDto = workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1, null)) == null) continue;
            dto.setWorkflow(workflowDto.getWorkflow());
            regist.regist(dto);
            regist.draftAttendance(dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addAppliMessage();
        if (!this.mospParams.hasErrorMessage()) {
            this.insertMode();
            this.setSearchRequestDate(requestDate);
            this.search();
        }
    }

    protected void withdrawn() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        WorkTypeChangeRequestRegistBeanInterface regist = this.time().workTypeChangeRequestRegist();
        WorkflowIntegrateBeanInterface workflowIntegrate = this.reference().workflowIntegrate();
        WorkTypeChangeRequestDtoInterface dto = this.timeReference().workTypeChangeRequest().findForKey(vo.getRecordId());
        this.checkSelectedDataExist((Object)dto);
        if (workflowIntegrate.isDraft(dto.getWorkflow())) {
            this.delete(dto);
            return;
        }
        regist.checkWithdrawn(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        WorkflowDtoInterface workflowDto = workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
        this.checkSelectedDataExist((Object)workflowDto);
        workflowDto = this.platform().workflowRegist().withdrawn(workflowDto);
        if (workflowDto != null) {
            this.platform().workflowCommentRegist().addComment(workflowDto, this.mospParams.getUser().getPersonalId(), PfMessageUtility.getWithdrawSucceed((MospParams)this.mospParams));
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addTakeDownMessage();
        this.insertMode();
        this.setSearchRequestDate(this.getEditRequestDate());
        this.search();
    }

    protected void delete(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        WorkTypeChangeRequestRegistBeanInterface regist = this.time().workTypeChangeRequestRegist();
        regist.checkWithdrawn(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        this.checkSelectedDataExist((Object)workflowDto);
        this.platform().workflowRegist().delete(workflowDto);
        this.platform().workflowCommentRegist().deleteList(this.reference().workflowComment().getWorkflowCommentList(workflowDto.getWorkflow()));
        regist.delete(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        this.insertMode();
        this.setSearchRequestDate(this.getEditRequestDate());
        this.search();
    }

    protected void transfer() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        this.setTargetWorkflow(vo.getAryWorkflow()[this.getTransferredIndex()]);
        this.mospParams.setNextCommand("TM1871");
    }

    protected void setViewPeriod() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        if ("chaning".equals(vo.getModeSearchActivateDate())) {
            vo.setModeSearchActivateDate("fixed");
        } else {
            vo.setModeSearchActivateDate("chaning");
        }
        this.setSearchWorkTypePulldown();
    }

    protected void batchWithdrawn() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        if (!this.isAvailable(this.getSystemDate(), CODE_FUNCTION)) {
            return;
        }
        this.time().workTypeChangeRequestRegist().withdrawn(this.getIdArray(vo.getCkbSelect()));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageBatchUpdatetFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addTakeDownMessage();
        String searchYear = vo.getPltSearchRequestYear();
        String searchMonth = vo.getPltSearchRequestMonth();
        this.insertMode();
        vo.setPltSearchRequestYear(searchYear);
        vo.setPltSearchRequestMonth(searchMonth);
        this.search();
    }

    protected void setDefaultValues() {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        if (this.getTargetDate() != null) {
            date = this.getTargetDate();
        }
        vo.setPltEditRequestYear(DateUtility.getStringYear((Date)date));
        vo.setPltEditRequestMonth(DateUtility.getStringMonthM((Date)date));
        vo.setPltEditRequestDay(DateUtility.getStringDayD((Date)date));
        vo.setCkbEndDate("0");
        vo.setTxtEditRequestReason("");
        vo.setRecordId(0L);
        vo.setPltSearchState("");
        vo.setPltSearchWorkType("");
        vo.setAryPltLblApproverSetting(new String[0]);
        vo.setPltApproverSetting1("");
        vo.setPltApproverSetting2("");
        vo.setPltApproverSetting3("");
        vo.setPltApproverSetting4("");
        vo.setPltApproverSetting5("");
        vo.setPltApproverSetting6("");
        vo.setPltApproverSetting7("");
        vo.setPltApproverSetting8("");
        vo.setPltApproverSetting9("");
        vo.setPltApproverSetting10("");
    }

    protected void setEditEndDate() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        vo.setPltEditEndYear(vo.getPltEditRequestYear());
        vo.setPltEditEndMonth(vo.getPltEditRequestMonth());
        vo.setPltEditEndDay(vo.getPltEditRequestDay());
    }

    protected void setSearchRequestDate(Date targetDate) throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        Date searchDate = this.timeReference().cutoffUtil().getCutoffMonth(vo.getPersonalId(), targetDate);
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchDate));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchDate));
    }

    protected void setLblWorkTypeName() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        vo.setLblWorkTypeName("");
        if ("fixed".equals(vo.getModeActivateDate())) {
            vo.setLblWorkTypeName(this.time().workTypeChangeRequestRegist().getScheduledWorkTypeName(vo.getPersonalId(), this.getEditRequestDate()));
        }
    }

    protected void setPulldown() {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        int year = DateUtility.getYear((Date)date);
        vo.setAryPltEditRequestYear(this.getYearArray(year));
        vo.setAryPltEditRequestMonth(this.getMonthArray());
        vo.setAryPltEditRequestDay(this.getDayArray());
        vo.setAryPltEditEndYear(this.getYearArray(year));
        vo.setAryPltEditEndMonth(this.getMonthArray());
        vo.setAryPltEditEndDay(this.getDayArray());
        vo.setAryPltSearchRequestYear(this.getYearArray(year));
        vo.setAryPltSearchRequestMonth(this.getMonthArray(true));
    }

    protected void setEditWorkTypePulldown() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        ApplicationReferenceBeanInterface application = this.timeReference().application();
        ScheduleReferenceBeanInterface schedule = this.timeReference().schedule();
        vo.setAryPltEditWorkType(new String[0][0]);
        if ("fixed".equals(vo.getModeActivateDate())) {
            Date requestDate = this.getEditRequestDate();
            ApplicationDtoInterface applicationDto = application.findForPerson(vo.getPersonalId(), requestDate);
            application.chkExistApplication(applicationDto, requestDate);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            ScheduleDtoInterface scheduleDto = schedule.getScheduleInfo(applicationDto.getScheduleCode(), requestDate);
            schedule.chkExistSchedule(scheduleDto, requestDate);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            String[][] aryWorkType = this.getWorkTypeArray(scheduleDto.getPatternCode(), requestDate, false, true, false, false);
            if (aryWorkType == null) {
                vo.setAryPltEditWorkType(new String[0][0]);
                return;
            }
            vo.setAryPltEditWorkType(aryWorkType);
        }
        this.doAdditionalLogic("ChangeWorkTypePulldown");
    }

    protected void setSearchWorkTypePulldown() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        vo.setAryPltSearchWorkType(new String[0][0]);
        if ("fixed".equals(vo.getModeSearchActivateDate())) {
            vo.setAryPltSearchWorkType(this.timeReference().workType().getTimeSelectArray(this.getSearchRequestDate()));
            this.doAdditionalLogic("ChangeWorkTypePulldown");
        }
    }

    protected Date getEditRequestDate() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        return DateUtility.getDate((String)vo.getPltEditRequestYear(), (String)vo.getPltEditRequestMonth(), (String)vo.getPltEditRequestDay());
    }

    protected Date getEditEndDate() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        return DateUtility.getDate((String)vo.getPltEditEndYear(), (String)vo.getPltEditEndMonth(), (String)vo.getPltEditEndDay());
    }

    protected Date getSearchRequestDate() throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        int searchRequestMonth = 1;
        if (!vo.getPltSearchRequestMonth().isEmpty()) {
            searchRequestMonth = this.getInt(vo.getPltSearchRequestMonth());
        }
        return MonthUtility.getYearMonthTargetDate((int)this.getInt(vo.getPltSearchRequestYear()), (int)searchRequestMonth, (MospParams)this.mospParams);
    }

    protected boolean isCheckedEndDate() {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        return "1".equals(vo.getCkbEndDate());
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        WorkTypeReferenceBeanInterface workType = this.timeReference().workType();
        String[] aryCkbWorkTypeChangeRequestId = new String[list.size()];
        String[] aryDate = new String[list.size()];
        String[] aryLblDateAndDay = new String[list.size()];
        String[] aryLblWorkType = new String[list.size()];
        String[] aryLblRequestReason = new String[list.size()];
        String[] aryLblState = new String[list.size()];
        String[] aryStateStyle = new String[list.size()];
        String[] aryLblApprover = new String[list.size()];
        String[] aryOnOff = new String[list.size()];
        String[] aryWorkflowStatus = new String[list.size()];
        long[] aryWorkflow = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            WorkTypeChangeRequestListDtoInterface dto = (WorkTypeChangeRequestListDtoInterface)list.get(i);
            aryCkbWorkTypeChangeRequestId[i] = Long.toString(dto.getTmdWorkTypeChangeRequestId());
            aryDate[i] = this.getStringDate(dto.getRequestDate());
            aryLblDateAndDay[i] = this.getStringDateAndDay(dto.getRequestDate());
            aryLblWorkType[i] = workType.getWorkTypeAbbrAndTime(dto.getWorkTypeCode(), dto.getRequestDate());
            aryLblRequestReason[i] = dto.getRequestReason();
            aryLblState[i] = this.getStatusStageValueView(dto.getState(), dto.getStage());
            aryStateStyle[i] = this.getStatusColor(dto.getState());
            aryLblApprover[i] = dto.getApproverName();
            aryOnOff[i] = this.getButtonOnOff(dto.getState(), dto.getStage());
            aryWorkflowStatus[i] = dto.getState();
            aryWorkflow[i] = dto.getWorkflow();
        }
        vo.setAryCkbWorkTypeChangeRequestId(aryCkbWorkTypeChangeRequestId);
        vo.setAryDate(aryDate);
        vo.setAryLblDateAndDay(aryLblDateAndDay);
        vo.setAryLblWorkType(aryLblWorkType);
        vo.setAryLblRequestReason(aryLblRequestReason);
        vo.setAryLblState(aryLblState);
        vo.setAryStateStyle(aryStateStyle);
        vo.setAryLblApprover(aryLblApprover);
        vo.setAryOnOff(aryOnOff);
        vo.setAryWorkflowStatus(aryWorkflowStatus);
        vo.setAryWorkflow(aryWorkflow);
    }

    protected void setVoFields(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        String year = Integer.toString(DateUtility.getYear((Date)dto.getRequestDate()));
        String month = DateUtility.getStringMonthM((Date)dto.getRequestDate());
        String day = DateUtility.getStringDayD((Date)dto.getRequestDate());
        vo.setRecordId(dto.getTmdWorkTypeChangeRequestId());
        vo.setPltEditRequestYear(year);
        vo.setPltEditRequestMonth(month);
        vo.setPltEditRequestDay(day);
        vo.setPltEditEndYear(year);
        vo.setPltEditEndMonth(month);
        vo.setPltEditEndDay(day);
        vo.setPltEditWorkType(dto.getWorkTypeCode());
        vo.setTxtEditRequestReason(dto.getRequestReason());
        vo.setCkbEndDate("0");
        vo.setModeCardEdit(this.getApplicationMode(dto.getWorkflow()));
    }

    protected void setDtoFields(WorkTypeChangeRequestDtoInterface dto, Date requestDate) {
        WorkTypeChangeRequestVo vo = (WorkTypeChangeRequestVo)this.mospParams.getVo();
        dto.setTmdWorkTypeChangeRequestId(vo.getRecordId());
        dto.setPersonalId(vo.getPersonalId());
        dto.setRequestDate(requestDate);
        dto.setTimesWork(1);
        dto.setWorkTypeCode(vo.getPltEditWorkType());
        dto.setRequestReason(vo.getTxtEditRequestReason());
    }

    protected void checkPeriod(Date startDate, Date endDate) {
        if (startDate.after(endDate)) {
            PfMessageUtility.addErrorInputValueInvalid((MospParams)this.mospParams, (String)PfNameUtility.term((MospParams)this.mospParams));
        }
    }
}

