/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.input.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.SubHolidayRequestRegistBeanInterface;
import jp.mosp.time.bean.SubHolidayRequestSearchBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.comparator.settings.SubHolidayRequestRequestDateComparator;
import jp.mosp.time.dto.base.HolidayRangeDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestListDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.CutoffEntityInterface;
import jp.mosp.time.entity.TimeSettingEntityInterface;
import jp.mosp.time.input.vo.SubHolidayRequestVo;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeRequestUtility;

public class SubHolidayRequestAction
extends TimeAction {
    public static final String CMD_SHOW = "TM1700";
    public static final String CMD_SELECT_SHOW = "TM1701";
    public static final String CMD_SEARCH = "TM1702";
    public static final String CMD_RE_SHOW = "TM1703";
    public static final String CMD_DRAFT = "TM1704";
    public static final String CMD_APPLI = "TM1705";
    public static final String CMD_TRANSFER = "TM1706";
    public static final String CMD_WITHDRAWN = "TM1707";
    public static final String CMD_SORT = "TM1708";
    public static final String CMD_PAGE = "TM1709";
    public static final String CMD_BATCH_WITHDRAWN = "TM1736";
    public static final String CMD_SET_ACTIVATION_DATE = "TM1790";
    public static final String CMD_INSERT_MODE = "TM1791";
    public static final String CMD_EDIT_MODE = "TM1792";
    public static final String CMD_BATCH_UPDATE = "TM1795";
    protected static final String CODE_FUNCTION = "5";

    public SubHolidayRequestAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new SubHolidayRequestVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_DRAFT)) {
            this.prepareVo();
            this.draft();
        } else if (this.mospParams.getCommand().equals(CMD_APPLI)) {
            this.prepareVo();
            this.appli();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_WITHDRAWN)) {
            this.prepareVo();
            this.withdrawn();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_WITHDRAWN)) {
            this.prepareVo();
            this.batchWithdrawn();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        }
    }

    protected void show() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        String personalId = this.mospParams.getUser().getPersonalId();
        Date targetDate = this.getSystemDate();
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        vo.setComparatorName(SubHolidayRequestRequestDateComparator.class.getName());
        this.search();
        this.isAvailable(this.getEditRequestDate(), CODE_FUNCTION);
    }

    protected void select() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getSystemDate();
        if (personalId == null || personalId.isEmpty()) {
            personalId = this.mospParams.getUser().getPersonalId();
        }
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        vo.setComparatorName(SubHolidayRequestRequestDateComparator.class.getName());
        this.search();
        this.isAvailable(this.getEditRequestDate(), CODE_FUNCTION);
    }

    protected void search() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        SubHolidayRequestSearchBeanInterface search = this.timeReference().subHolidayRequestSearch();
        String personalId = vo.getPersonalId();
        search.setPersonalId(personalId);
        int year = Integer.parseInt(vo.getPltSearchRequestYear());
        int startMonth = this.getInt("1");
        int endMonth = this.getInt("12");
        if (!MospUtility.isEmpty((String[])new String[]{vo.getPltSearchRequestMonth()})) {
            endMonth = startMonth = this.getInt(vo.getPltSearchRequestMonth());
        }
        TimeMasterBeanInterface timeMaster = this.timeReference().master();
        ApplicationEntity applicationFrom = timeMaster.getApplicationEntity(personalId, year, startMonth);
        ApplicationEntity applicationTo = timeMaster.getApplicationEntity(personalId, year, endMonth);
        Date firstDate = applicationFrom.getCutoffEntity().getCutoffFirstDate(year, startMonth, this.mospParams);
        Date lastDate = applicationTo.getCutoffEntity().getCutoffLastDate(year, endMonth, this.mospParams);
        search.setRequestStartDate(firstDate);
        search.setRequestEndDate(lastDate);
        int workYear = Integer.parseInt(vo.getPltSearchWorkYear());
        int startWorkMonth = this.getInt("1");
        int endWorkMonth = this.getInt("12");
        if (!MospUtility.isEmpty((String[])new String[]{vo.getPltSearchWorkMonth()})) {
            endWorkMonth = startWorkMonth = this.getInt(vo.getPltSearchWorkMonth());
        }
        ApplicationEntity appWorkFrom = timeMaster.getApplicationEntity(personalId, workYear, startWorkMonth);
        ApplicationEntity appWorkTo = timeMaster.getApplicationEntity(personalId, workYear, endWorkMonth);
        Date workFirstDate = appWorkFrom.getCutoffEntity().getCutoffFirstDate(workYear, startWorkMonth, this.mospParams);
        Date workLastDate = appWorkTo.getCutoffEntity().getCutoffLastDate(workYear, endWorkMonth, this.mospParams);
        search.setWorkStartDate(workFirstDate);
        search.setWorkEndDate(workLastDate);
        search.setWorkflowStatus(vo.getPltSearchState());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(SubHolidayRequestRequestDateComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty() && this.mospParams.getCommand().equals(CMD_SEARCH)) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void draft() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        SubHolidayRequestRegistBeanInterface regist = this.time().subHolidayRequestRegist();
        SubHolidayRequestDtoInterface dto = this.timeReference().subHolidayRequest().findForKey(vo.getRecordId());
        if (dto == null) {
            dto = regist.getInitDto();
        }
        this.setSubHolidayDtoFields(dto);
        regist.validate(dto);
        regist.checkDraft(dto);
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        if (workflowDto == null) {
            workflowDto = workflowRegist.getInitDto();
            workflowDto.setFunctionCode(CODE_FUNCTION);
        }
        workflowRegist.setDtoApproverIds(workflowDto, this.getSelectApproverIds());
        workflowDto = workflowRegist.draft(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1);
        if (workflowDto != null) {
            this.platform().workflowCommentRegist().addComment(workflowDto, this.mospParams.getUser().getPersonalId(), PfMessageUtility.getDraftSucceed((MospParams)this.mospParams));
            dto.setWorkflow(workflowDto.getWorkflow());
            regist.regist(dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addDraftMessage();
        Date searchRequestDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getRequestDate());
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchRequestDate));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchRequestDate));
        Date searchWorkDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getWorkDate());
        vo.setPltSearchWorkYear(DateUtility.getStringYear((Date)searchWorkDate));
        vo.setPltSearchWorkMonth(DateUtility.getStringMonthM((Date)searchWorkDate));
        this.search();
        this.setEditUpdateMode(dto.getRequestDate(), dto.getHolidayRange());
        vo.setModeCardEdit("draft");
    }

    protected void appli() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        SubHolidayRequestRegistBeanInterface regist = this.time().subHolidayRequestRegist();
        AttendanceTransactionRegistBeanInterface attendanceTransactionRegist = this.time().attendanceTransactionRegist();
        SubHolidayRequestDtoInterface dto = this.timeReference().subHolidayRequest().findForKey(vo.getRecordId());
        if (dto == null) {
            dto = regist.getInitDto();
        }
        this.setSubHolidayDtoFields(dto);
        regist.checkAppli(dto);
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        if (workflowDto == null) {
            workflowDto = workflowRegist.getInitDto();
            workflowDto.setFunctionCode(CODE_FUNCTION);
        }
        workflowRegist.setDtoApproverIds(workflowDto, this.getSelectApproverIds());
        workflowDto = workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1, null);
        if (workflowDto != null) {
            dto.setWorkflow(workflowDto.getWorkflow());
            regist.regist(dto);
            regist.deleteAttendance(dto);
            regist.draftAttendance(dto);
            attendanceTransactionRegist.regist(dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addAppliMessage();
        this.addHalfHolidayRequestMessage(dto);
        if (!this.mospParams.hasErrorMessage()) {
            this.insertMode();
            Date searchRequestDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getRequestDate());
            vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchRequestDate));
            vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchRequestDate));
            Date searchWorkDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getWorkDate());
            vo.setPltSearchWorkYear(DateUtility.getStringYear((Date)searchWorkDate));
            vo.setPltSearchWorkMonth(DateUtility.getStringMonthM((Date)searchWorkDate));
            this.search();
        }
    }

    protected void withdrawn() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        SubHolidayRequestRegistBeanInterface regist = this.time().subHolidayRequestRegist();
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowCommentRegistBeanInterface workflowCommentRegist = this.platform().workflowCommentRegist();
        SubHolidayRequestDtoInterface dto = this.timeReference().subHolidayRequest().findForKey(vo.getRecordId());
        this.checkSelectedDataExist((Object)dto);
        regist.checkWithdrawn(dto);
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        this.checkSelectedDataExist((Object)workflowDto);
        boolean isDraft = "0".equals(workflowDto.getWorkflowStatus());
        if (isDraft) {
            workflowRegist.delete(workflowDto);
            workflowCommentRegist.deleteList(this.reference().workflowComment().getWorkflowCommentList(workflowDto.getWorkflow()));
            regist.delete(dto);
        } else if ((workflowDto = workflowRegist.withdrawn(workflowDto)) != null) {
            workflowCommentRegist.addComment(workflowDto, this.mospParams.getUser().getPersonalId(), PfMessageUtility.getWithdrawSucceed((MospParams)this.mospParams));
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        if (isDraft) {
            PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        } else {
            this.addTakeDownMessage();
        }
        this.insertMode();
        Date searchRequestDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getRequestDate());
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchRequestDate));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchRequestDate));
        Date searchWorkDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getWorkDate());
        vo.setPltSearchWorkYear(DateUtility.getStringYear((Date)searchWorkDate));
        vo.setPltSearchWorkMonth(DateUtility.getStringMonthM((Date)searchWorkDate));
        this.search();
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() {
        this.setVoList(this.pageList());
    }

    protected void batchWithdrawn() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        if (!this.isAvailable(this.getSystemDate(), CODE_FUNCTION)) {
            return;
        }
        this.time().subHolidayRequestRegist().withdrawn(this.getIdArray(vo.getCkbSelect()));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageBatchUpdatetFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addTakeDownMessage();
        String searchRequestYear = vo.getPltSearchRequestYear();
        String searchRequestMonth = vo.getPltSearchRequestMonth();
        String searchWorkYear = vo.getPltSearchWorkYear();
        String searchWorkMonth = vo.getPltSearchWorkMonth();
        this.insertMode();
        vo.setPltSearchRequestYear(searchRequestYear);
        vo.setPltSearchRequestMonth(searchRequestMonth);
        vo.setPltSearchWorkYear(searchWorkYear);
        vo.setPltSearchWorkMonth(searchWorkMonth);
        this.search();
    }

    protected void setActivationDate() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        SubHolidayRequestRegistBeanInterface regist = this.time().subHolidayRequestRegist();
        if (vo.getModeActivateDate().equals("chaning")) {
            if (!this.isAvailable(this.getEditRequestDate(), CODE_FUNCTION)) {
                return;
            }
            SubHolidayRequestDtoInterface dto = this.timeReference().subHolidayRequest().findForKey(vo.getRecordId());
            if (dto == null) {
                dto = regist.getInitDto();
            }
            dto.setPersonalId(vo.getPersonalId());
            dto.setRequestDate(this.getEditRequestDate());
            dto.setHolidayRange(Integer.parseInt(vo.getPltEditHolidayRange()));
            regist.checkSetRequestDate(dto);
            if (this.mospParams.hasErrorMessage()) {
                PfMessageUtility.addMessageDecisiontFailed((MospParams)this.mospParams);
                return;
            }
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        if (!this.setEditPulldown().booleanValue()) {
            vo.setModeActivateDate("chaning");
        }
    }

    protected void insertMode() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.setCompensationDay();
        this.setUnused();
        vo.setModeCardEdit("new");
        this.setPulldown();
        vo.setModeActivateDate("chaning");
        this.timeReference().subHolidayRequest().chkBasicInfo(vo.getPersonalId(), this.getEditRequestDate());
    }

    protected void editMode() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getSystemDate();
        if (personalId != null) {
            this.setEmployeeInfo(personalId, targetDate);
            this.setPageInfo(CMD_PAGE, this.getListLength());
            this.insertMode();
            vo.setComparatorName(SubHolidayRequestRequestDateComparator.class.getName());
            this.search();
        }
        this.setEditUpdateMode(this.getDate(this.getTransferredActivateDate()), Integer.parseInt(this.getTransferredType()));
        vo.setModeActivateDate("chaning");
        this.setActivationDate();
    }

    protected void batchUpdate() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        if (!this.isAvailable(this.getSystemDate(), CODE_FUNCTION)) {
            return;
        }
        boolean containsHalfHoliday = this.time().subHolidayRequestRegist().update(this.getIdArray(vo.getCkbSelect()));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageBatchUpdatetFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageUpdatetSucceed((MospParams)this.mospParams);
        if (containsHalfHoliday) {
            TimeMessageUtility.addHalfHolidayRequestNotice((MospParams)this.mospParams);
        }
        String searchRequestYear = vo.getPltSearchRequestYear();
        String searchRequestMonth = vo.getPltSearchRequestMonth();
        String searchWorkYear = vo.getPltSearchWorkYear();
        String searchWorkMonth = vo.getPltSearchWorkMonth();
        this.insertMode();
        vo.setPltSearchRequestYear(searchRequestYear);
        vo.setPltSearchRequestMonth(searchRequestMonth);
        vo.setPltSearchWorkYear(searchWorkYear);
        vo.setPltSearchWorkMonth(searchWorkMonth);
        this.search();
    }

    protected void transfer() {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        this.setTargetWorkflow(vo.getAryWorkflow(this.getTransferredIndex()));
        this.mospParams.setNextCommand("TM1851");
    }

    public void setDefaultValues() throws MospException {
        Date date;
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        Date targetDate = date = this.getSystemDate();
        if (this.getTargetDate() != null) {
            targetDate = this.getTargetDate();
        }
        vo.setPltEditRequestYear(DateUtility.getStringYear((Date)targetDate));
        vo.setPltEditRequestMonth(DateUtility.getStringMonthM((Date)targetDate));
        vo.setPltEditRequestDay(DateUtility.getStringDayD((Date)targetDate));
        vo.setRecordId(0L);
        vo.setPltEditHolidayRange(String.valueOf(1));
        vo.setPltEditWorkDate("");
        Date searchDate = this.timeReference().cutoffUtil().getCutoffMonth(vo.getPersonalId(), date);
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchDate));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchDate));
        vo.setPltSearchWorkYear(DateUtility.getStringYear((Date)searchDate));
        vo.setPltSearchWorkMonth(DateUtility.getStringMonthM((Date)searchDate));
        vo.setPltSearchState("");
        String[] aryPltLblApproverSetting = new String[]{};
        vo.setAryPltLblApproverSetting(aryPltLblApproverSetting);
        vo.setPltApproverSetting1("");
        vo.setPltApproverSetting2("");
        vo.setPltApproverSetting3("");
        vo.setPltApproverSetting4("");
        vo.setPltApproverSetting5("");
        vo.setPltApproverSetting6("");
        vo.setPltApproverSetting7("");
        vo.setPltApproverSetting8("");
        vo.setPltApproverSetting9("");
        vo.setPltApproverSetting10("");
        vo.setAryLblCompensationWorkDate(new String[0]);
        vo.setAryLblCompensationExpirationDate(new String[0]);
        vo.setAryLblCompensationType(new String[0]);
        vo.setAryLblCompensationRange(new String[0]);
        vo.setAryLblCompensationDayTh(new String[0]);
        vo.setAryLblCompensationDayForWorkOnDayOff(new String[0]);
        vo.setAryLblCompensationDayForNightWork(new String[0]);
    }

    protected void setCompensationDay() throws MospException {
        Date systemDate;
        CutoffEntityInterface cutoff;
        Date cutoffFirstDate;
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        WorkflowIntegrateBeanInterface workflowIntegrate = this.reference().workflowIntegrate();
        TimeMasterBeanInterface timeMaster = this.timeReference().master();
        ApplicationEntity application = timeMaster.getApplicationEntity(personalId, cutoffFirstDate = (cutoff = timeMaster.getCutoffForPersonalId(personalId, systemDate = this.getSystemDate())).getCutoffFirstDate(systemDate, this.mospParams));
        if (!application.isValid()) {
            return;
        }
        ArrayList<SubHolidayDtoInterface> list = new ArrayList<SubHolidayDtoInterface>();
        for (SubHolidayDtoInterface subHolidayDto : this.timeReference().subHoliday().getFindForList(personalId, cutoffFirstDate, systemDate, 0.5)) {
            float useDays = 0.0f;
            for (SubHolidayRequestDtoInterface subHolidayRequestDto : this.timeReference().subHolidayRequest().getSubHolidayRequestList(subHolidayDto.getPersonalId(), subHolidayDto.getWorkDate(), subHolidayDto.getTimesWork(), subHolidayDto.getSubHolidayType())) {
                WorkflowDtoInterface workflowDto = workflowIntegrate.getLatestWorkflowInfo(subHolidayRequestDto.getWorkflow());
                if (!WorkflowUtility.isApplied((WorkflowDtoInterface)workflowDto)) continue;
                useDays += TimeRequestUtility.getDays((HolidayRangeDtoInterface)subHolidayRequestDto);
            }
            if (subHolidayDto.getSubHolidayDays() <= (double)useDays) continue;
            subHolidayDto.setSubHolidayDays(subHolidayDto.getSubHolidayDays() - (double)useDays);
            list.add(subHolidayDto);
        }
        String[] aryLblCompensationWorkDate = new String[list.size()];
        String[] aryLblCompensationExpirationDate = new String[list.size()];
        String[] aryLblCompensationType = new String[list.size()];
        String[] aryLblCompensationRange = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SubHolidayDtoInterface dto = (SubHolidayDtoInterface)list.get(i);
            Date workDate = dto.getWorkDate();
            TimeSettingEntityInterface timeSetting = timeMaster.getTimeSettingForPersonalId(personalId, workDate);
            Date limitDate = timeSetting.getSubHolidayLimitDate(dto);
            String subHolidayName = TimeRequestUtility.getSubHolidayTypeName((int)dto.getSubHolidayType(), (MospParams)this.mospParams);
            String subHolidayRange = TimeRequestUtility.getSubHolidayDaysAbbr((double)dto.getSubHolidayDays(), (MospParams)this.mospParams);
            aryLblCompensationWorkDate[i] = this.getStringDateAndDay(dto.getWorkDate());
            aryLblCompensationExpirationDate[i] = this.getStringDateAndDay(limitDate);
            aryLblCompensationType[i] = subHolidayName;
            aryLblCompensationRange[i] = subHolidayRange;
        }
        vo.setAryLblCompensationWorkDate(aryLblCompensationWorkDate);
        vo.setAryLblCompensationExpirationDate(aryLblCompensationExpirationDate);
        vo.setAryLblCompensationType(aryLblCompensationType);
        vo.setAryLblCompensationRange(aryLblCompensationRange);
    }

    protected void setUnused() throws MospException {
    }

    private void setPulldown() {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        int editRequestYear = DateUtility.getYear((Date)date);
        vo.setAryPltEditRequestYear(this.getYearArray(editRequestYear));
        vo.setAryPltEditRequestMonth(this.getMonthArray());
        vo.setAryPltEditRequestDay(this.getDayArray());
        vo.setAryPltSearchRequestYear(this.getYearArray(editRequestYear));
        vo.setAryPltSearchRequestMonth(this.getMonthArray(true));
        vo.setAryPltSearchWorkYear(this.getYearArray(editRequestYear));
        vo.setAryPltSearchWorkMonth(this.getMonthArray(true));
        vo.setAryPltEditWorkDate(this.getInputActivateDateCompensatoryLeavePulldown());
        vo.setAryPltEditHolidayType(this.mospParams.getProperties().getCodeArray("Substitute1Range", false));
        vo.setAryPltSearchState(this.mospParams.getProperties().getCodeArray("ApprovalState", true));
    }

    protected void setSubHolidayDtoFields(SubHolidayRequestDtoInterface dto) throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        String[] aryWorkDate = vo.getPltEditWorkDate().split(",");
        dto.setTmdSubHolidayRequestId(vo.getRecordId());
        dto.setPersonalId(vo.getPersonalId());
        dto.setRequestDate(DateUtility.getDate((String)vo.getPltEditRequestYear(), (String)vo.getPltEditRequestMonth(), (String)vo.getPltEditRequestDay()));
        dto.setHolidayRange(Integer.parseInt(vo.getPltEditHolidayRange()));
        dto.setWorkDate(DateUtility.getDate((String)aryWorkDate[0]));
        dto.setTimesWork(1);
        dto.setWorkDateSubHolidayType(Integer.parseInt(aryWorkDate[1]));
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        String[] aryCkbRecordId = new String[list.size()];
        String[] aryLblRequestDate = new String[list.size()];
        String[] aryLblWorkDate = new String[list.size()];
        String[] aryLblWorkflowStatus = new String[list.size()];
        String[] aryStatusStyle = new String[list.size()];
        String[] aryLblApproverName = new String[list.size()];
        String[] aryLblDate = new String[list.size()];
        String[] aryLblRange = new String[list.size()];
        String[] aryLblWorkflow = new String[list.size()];
        String[] aryLblOnOff = new String[list.size()];
        String[] aryWorkflowStatus = new String[list.size()];
        long[] aryWorkflow = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SubHolidayRequestListDtoInterface dto = (SubHolidayRequestListDtoInterface)list.get(i);
            aryCkbRecordId[i] = String.valueOf(dto.getTmdSubHolidayRequestId());
            aryLblRequestDate[i] = DateUtility.getStringDateAndDay((Date)dto.getRequestDate()) + " " + this.getHolidayRange(this.getInt(dto.getSubHolidayRange()));
            aryLblWorkDate[i] = this.setWorkDateSubHolidayType(dto.getWorkDateHolidayType()) + " " + DateUtility.getStringDateAndDay((Date)dto.getWorkDate());
            aryLblWorkflowStatus[i] = this.getStatusStageValueView(dto.getState(), dto.getStage());
            aryStatusStyle[i] = this.getStatusColor(dto.getState());
            aryLblApproverName[i] = dto.getApproverName();
            aryLblDate[i] = DateUtility.getStringDate((Date)dto.getRequestDate());
            aryLblRange[i] = dto.getSubHolidayRange();
            aryLblWorkflow[i] = String.valueOf(dto.getWorkflow());
            aryLblOnOff[i] = this.getButtonOnOff(dto.getState(), dto.getStage());
            aryWorkflowStatus[i] = dto.getState();
            aryWorkflow[i] = dto.getWorkflow();
        }
        vo.setAryCkbSubHolidayRequestListId(aryCkbRecordId);
        vo.setAryLblRequestDate(aryLblRequestDate);
        vo.setAryLblWorkDate(aryLblWorkDate);
        vo.setAryLblState(aryLblWorkflowStatus);
        vo.setAryStateStyle(aryStatusStyle);
        vo.setAryLblApprover(aryLblApproverName);
        vo.setAryLblDate(aryLblDate);
        vo.setAryLblRange(aryLblRange);
        vo.setAryLblWorkflow(aryLblWorkflow);
        vo.setAryLblOnOff(aryLblOnOff);
        vo.setAryWorkflowStatus(aryWorkflowStatus);
        vo.setAryWorkflow(aryWorkflow);
    }

    protected void setEditUpdateMode(Date requestDate, int holidayRange) throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        SubHolidayRequestDtoInterface dto = this.timeReference().subHolidayRequest().findForKeyOnWorkflow(vo.getPersonalId(), requestDate, holidayRange);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
    }

    protected void setVoFields(SubHolidayRequestDtoInterface dto) throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        vo.setRecordId(dto.getTmdSubHolidayRequestId());
        vo.setPltEditRequestYear(DateUtility.getStringYear((Date)dto.getRequestDate()));
        vo.setPltEditRequestMonth(DateUtility.getStringMonthM((Date)dto.getRequestDate()));
        vo.setPltEditRequestDay(DateUtility.getStringDayD((Date)dto.getRequestDate()));
        vo.setPltEditHolidayRange(String.valueOf(dto.getHolidayRange()));
        vo.setPltEditWorkDate(DateUtility.getStringDate((Date)dto.getWorkDate()) + "," + dto.getWorkDateSubHolidayType());
        vo.setModeCardEdit(this.getApplicationMode(dto.getWorkflow()));
    }

    protected Boolean setEditPulldown() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("fixed")) {
            Date targetDate = this.getEditRequestDate();
            SubHolidayRequestDtoInterface dto = this.timeReference().subHolidayRequest().findForKey(vo.getRecordId());
            vo.setAryPltEditWorkDate(this.timeReference().subHoliday().getSelectArray(vo.getPersonalId(), targetDate, vo.getPltEditHolidayRange(), dto));
            if (vo.getAryPltEditWorkDate().length == 0) {
                vo.setAryPltEditWorkDate(this.getInputActivateNoDataLeavePulldown());
                this.mospParams.addErrorMessage("TMW0261", new String[]{this.mospParams.getName("CompensatoryHoliday", new String[]{"Day"}), this.mospParams.getName("Target", new String[]{"GoingWork", "Day"})});
                return false;
            }
            if (!this.setApproverPullDown(vo.getPersonalId(), DateUtility.getDate((String)vo.getPltEditRequestYear(), (String)vo.getPltEditRequestMonth(), (String)vo.getPltEditRequestDay()), 1)) {
                vo.setAryPltEditWorkDate(this.getInputActivateNoDataLeavePulldown());
                return false;
            }
            this.getDifferenceRequest1(vo.getPersonalId(), targetDate);
            return true;
        }
        vo.setAryPltEditWorkDate(this.getInputActivateDateCompensatoryLeavePulldown());
        String[] aryPltLblApproverSetting = new String[]{};
        vo.setAryPltLblApproverSetting(aryPltLblApproverSetting);
        return false;
    }

    protected String[][] getInputActivateDateCompensatoryLeavePulldown() {
        String[][] aryPulldown = new String[][]{{"", this.mospParams.getName("InputCompensatoryLeave")}};
        return aryPulldown;
    }

    protected String[][] getInputActivateNoDataLeavePulldown() {
        String[][] aryPulldown = new String[][]{{"", this.mospParams.getName("InputActivateNoDataLeave")}};
        return aryPulldown;
    }

    protected Date getEditRequestDate() {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        return this.getDate(vo.getPltEditRequestYear(), vo.getPltEditRequestMonth(), vo.getPltEditRequestDay());
    }

    protected void addHalfHolidayRequestMessage(SubHolidayRequestDtoInterface dto) throws MospException {
        if (TimeRequestUtility.isHolidayRangeHalf((HolidayRangeDtoInterface)dto)) {
            TimeMessageUtility.addHalfHolidayRequestNotice((MospParams)this.mospParams);
        }
    }
}

