/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.input.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.base.AttendanceListBaseAction;
import jp.mosp.time.bean.AttendanceListReferenceBeanInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;
import jp.mosp.time.input.vo.ScheduleReferenceVo;

public class ScheduleReferenceAction
extends AttendanceListBaseAction {
    public static final String CMD_SHOW = "TM1300";
    public static final String CMD_SELECT_SHOW = "TM1301";
    public static final String CMD_SEARCH = "TM1302";
    public static final String CMD_OUTPUT = "TM1396";

    protected BaseVo getSpecificVo() {
        return new ScheduleReferenceVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_OUTPUT)) {
            this.prepareVo(true, false);
            this.output();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected void show() throws MospException {
        String personalId = this.mospParams.getUser().getPersonalId();
        Date targetDate = this.getSystemDate();
        this.initVoFields(personalId, DateUtility.getYear((Date)targetDate), DateUtility.getMonth((Date)targetDate));
        AttendanceListReferenceBeanInterface attendanceListReference = this.timeReference().attendanceList();
        List list = attendanceListReference.getScheduleList(personalId, targetDate);
        this.setVoList(list);
        this.setVoFields(list);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void select() throws MospException {
        String personalId = this.getTargetPersonalId();
        int targetYear = this.getTargetYear();
        int targetMonth = this.getTargetMonth();
        this.initVoFields(personalId, targetYear, targetMonth);
        AttendanceListReferenceBeanInterface attendanceListReference = this.timeReference().attendanceList();
        List list = attendanceListReference.getScheduleList(personalId, targetYear, targetMonth);
        this.setVoList(list);
        this.setVoFields(list);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void search() throws MospException {
        ScheduleReferenceVo vo = (ScheduleReferenceVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        String year = this.getTransferredYear();
        String month = this.getTransferredMonth();
        if (year == null || month == null) {
            year = vo.getPltSelectYear();
            month = vo.getPltSelectMonth();
        }
        int targetYear = this.getInt(year);
        int targetMonth = this.getInt(month);
        int cutoffDate = vo.getCutoffDate();
        this.initVoFields(personalId, targetYear, targetMonth);
        AttendanceListReferenceBeanInterface bean = this.timeReference().attendanceList();
        List list = bean.getScheduleList(personalId, targetYear, targetMonth, cutoffDate);
        this.setVoList(list);
        this.setVoFields(list);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void output() throws MospException {
        ScheduleReferenceVo vo = (ScheduleReferenceVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        int year = this.getInt(vo.getPltSelectYear());
        int month = this.getInt(vo.getPltSelectMonth());
        this.timeReference().scheduleBook().makeScheduleBook(personalId, year, month);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void setVoFields(List<AttendanceListDto> list) throws MospException {
        super.setVoFields(list);
        ScheduleReferenceVo vo = (ScheduleReferenceVo)this.mospParams.getVo();
        vo.setLblEndRecordTime(false);
        vo.setLblStartRecordTime(false);
        AttendanceListDto dto = (AttendanceListDto)MospUtility.getLastValue(list);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return;
        }
        String scheduleCode = dto.getScheduleCode();
        Date lastDate = dto.getWorkDate();
        String scheculeName = this.timeReference().scheduleUtil().getScheduleName(scheduleCode, lastDate);
        vo.setLblApplicationSchedule(scheculeName);
    }
}

