/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.input.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.OvertimeInfoReferenceBeanInterface;
import jp.mosp.time.bean.OvertimeRequestRegistBeanInterface;
import jp.mosp.time.bean.OvertimeRequestSearchBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.comparator.settings.OvertimeRequestRequestDateComparator;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestListDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.input.vo.OvertimeRequestVo;
import jp.mosp.time.utils.TimeUtility;

public class OvertimeRequestAction
extends TimeAction {
    public static final String CMD_SHOW = "TM1400";
    public static final String CMD_SELECT_SHOW = "TM1401";
    public static final String CMD_SEARCH = "TM1402";
    public static final String CMD_RE_SHOW = "TM1403";
    public static final String CMD_DRAFT = "TM1404";
    public static final String CMD_APPLI = "TM1405";
    public static final String CMD_TRANSFER = "TM1406";
    public static final String CMD_WITHDRAWN = "TM1407";
    public static final String CMD_SORT = "TM1408";
    public static final String CMD_PAGE = "TM1409";
    public static final String CMD_BATCH_WITHDRAWN = "TM1436";
    public static final String CMD_SET_OVERTIME_DATE = "TM1490";
    public static final String CMD_INSERT_MODE = "TM1491";
    public static final String CMD_EDIT_MODE = "TM1492";
    public static final String CMD_BATCH_UPDATE = "TM1495";
    public static final String CMD_SELECT_OVERTIME_DATE = "TM1498";
    protected static final String CODE_FUNCTION = "2";

    public OvertimeRequestAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new OvertimeRequestVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_DRAFT)) {
            this.prepareVo();
            this.draft();
        } else if (this.mospParams.getCommand().equals(CMD_APPLI)) {
            this.prepareVo();
            this.appli();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_WITHDRAWN)) {
            this.prepareVo();
            this.withdrawn();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_WITHDRAWN)) {
            this.prepareVo();
            this.batchWithdrawn();
        } else if (this.mospParams.getCommand().equals(CMD_SET_OVERTIME_DATE)) {
            this.prepareVo();
            this.setOvertimeDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_OVERTIME_DATE)) {
            this.prepareVo(false, false);
            this.selectOvertimeDate();
        }
    }

    protected void show() throws MospException {
        String personalId = this.mospParams.getUser().getPersonalId();
        Date targetDate = this.getSystemDate();
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        this.search();
        this.isAvailable(this.getEditRequestDate(), CODE_FUNCTION);
    }

    protected void select() throws MospException {
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getSystemDate();
        if (personalId == null || personalId.isEmpty()) {
            personalId = this.mospParams.getUser().getPersonalId();
        }
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        this.search();
        this.isAvailable(this.getEditRequestDate(), CODE_FUNCTION);
    }

    protected void search() throws MospException {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        OvertimeRequestSearchBeanInterface search = this.timeReference().overtimeRequestSearch();
        String personalId = vo.getPersonalId();
        search.setPersonalId(personalId);
        search.setWorkflowStatus(vo.getPltSearchState());
        search.setScheduleOver(vo.getPltSearchScheduleOver());
        search.setOvertimeType(vo.getPltSearchOverTimeType());
        int year = Integer.parseInt(vo.getPltSearchRequestYear());
        int startMonth = this.getInt("1");
        int endMonth = this.getInt("12");
        if (!MospUtility.isEmpty((String[])new String[]{vo.getPltSearchRequestMonth()})) {
            endMonth = startMonth = this.getInt(vo.getPltSearchRequestMonth());
        }
        TimeMasterBeanInterface timeMaster = this.timeReference().master();
        ApplicationEntity applicationFrom = timeMaster.getApplicationEntity(personalId, year, startMonth);
        ApplicationEntity applicationTo = timeMaster.getApplicationEntity(personalId, year, endMonth);
        Date firstDate = applicationFrom.getCutoffEntity().getCutoffFirstDate(year, startMonth, this.mospParams);
        Date lastDate = applicationTo.getCutoffEntity().getCutoffLastDate(year, endMonth, this.mospParams);
        search.setRequestStartDate(firstDate);
        search.setRequestEndDate(lastDate);
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(OvertimeRequestRequestDateComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty() && this.mospParams.getCommand().equals(CMD_SEARCH)) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void draft() throws MospException {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        OvertimeRequestDtoInterface dto = this.timeReference().overtimeRequest().findForKey(vo.getRecordId());
        if (dto == null) {
            dto = this.time().overtimeRequestRegist().getInitDto();
        }
        this.setOvertimeDtoFields(dto);
        this.time().overtimeRequestRegist().validate(dto);
        this.time().overtimeRequestRegist().checkDraft(dto);
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        if (workflowDto == null) {
            workflowDto = workflowRegist.getInitDto();
            workflowDto.setFunctionCode(CODE_FUNCTION);
        }
        workflowRegist.setDtoApproverIds(workflowDto, this.getSelectApproverIds());
        workflowDto = workflowRegist.draft(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1);
        if (workflowDto != null) {
            this.platform().workflowCommentRegist().addComment(workflowDto, this.mospParams.getUser().getPersonalId(), PfMessageUtility.getDraftSucceed((MospParams)this.mospParams));
            dto.setWorkflow(workflowDto.getWorkflow());
            this.time().overtimeRequestRegist().regist(dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addDraftMessage();
        Date searchDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getRequestDate());
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchDate));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchDate));
        this.search();
        this.setEditUpdateMode(dto.getRequestDate(), dto.getOvertimeType());
        vo.setModeCardEdit("draft");
    }

    protected void appli() throws MospException {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        OvertimeRequestDtoInterface dto = this.timeReference().overtimeRequest().findForKey(vo.getRecordId());
        if (dto == null) {
            dto = this.time().overtimeRequestRegist().getInitDto();
        }
        this.setOvertimeDtoFields(dto);
        this.time().overtimeRequestRegist().checkAppli(dto);
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        if (workflowDto == null) {
            workflowDto = workflowRegist.getInitDto();
            workflowDto.setFunctionCode(CODE_FUNCTION);
        }
        workflowRegist.setDtoApproverIds(workflowDto, this.getSelectApproverIds());
        workflowDto = workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1, null);
        if (workflowDto != null) {
            dto.setWorkflow(workflowDto.getWorkflow());
            this.time().overtimeRequestRegist().regist(dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addAppliMessage();
        if (!this.mospParams.hasErrorMessage()) {
            this.insertMode();
            Date searchDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getRequestDate());
            vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchDate));
            vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchDate));
            this.search();
        }
    }

    protected void withdrawn() throws MospException {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        OvertimeRequestRegistBeanInterface regist = this.time().overtimeRequestRegist();
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowCommentRegistBeanInterface workflowCommentRegist = this.platform().workflowCommentRegist();
        OvertimeRequestDtoInterface dto = this.timeReference().overtimeRequest().findForKey(vo.getRecordId());
        this.checkSelectedDataExist((Object)dto);
        regist.checkWithdrawn(dto);
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        this.checkSelectedDataExist((Object)workflowDto);
        boolean isDraft = "0".equals(workflowDto.getWorkflowStatus());
        if (isDraft) {
            workflowRegist.delete(workflowDto);
            workflowCommentRegist.deleteList(this.reference().workflowComment().getWorkflowCommentList(workflowDto.getWorkflow()));
            regist.delete(dto);
        } else if ((workflowDto = workflowRegist.withdrawn(workflowDto)) != null) {
            workflowCommentRegist.addComment(workflowDto, this.mospParams.getUser().getPersonalId(), PfMessageUtility.getWithdrawSucceed((MospParams)this.mospParams));
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        if (isDraft) {
            PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        } else {
            this.addTakeDownMessage();
        }
        this.insertMode();
        Date searchDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getRequestDate());
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchDate));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchDate));
        this.search();
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void batchWithdrawn() throws MospException {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        if (!this.isAvailable(this.getSystemDate(), CODE_FUNCTION)) {
            return;
        }
        this.time().overtimeRequestRegist().withdrawn(this.getIdArray(vo.getCkbSelect()));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageBatchUpdatetFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addTakeDownMessage();
        String searchYear = vo.getPltSearchRequestYear();
        String searchMonth = vo.getPltSearchRequestMonth();
        this.insertMode();
        this.setSearchRequestDate(searchYear, searchMonth);
        this.search();
    }

    protected void setOvertimeDate() throws MospException {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        OvertimeRequestRegistBeanInterface regist = this.time().overtimeRequestRegist();
        if (vo.getModeActivateDate().equals("fixed")) {
            vo.setAryPltLblApproverSetting(new String[0]);
            vo.setModeActivateDate("chaning");
            return;
        }
        this.isAvailable(this.getEditRequestDate(), CODE_FUNCTION);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        OvertimeRequestDtoInterface dto = this.timeReference().overtimeRequest().findForKey(vo.getRecordId());
        if (dto == null) {
            dto = regist.getInitDto();
        }
        dto.setPersonalId(vo.getPersonalId());
        dto.setRequestDate(this.getEditRequestDate());
        dto.setOvertimeType(this.getInt(vo.getPltEditOverTimeType()));
        regist.checkSetRequestDate(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDecisiontFailed((MospParams)this.mospParams);
            return;
        }
        if (!this.setApproverPullDown(vo.getPersonalId(), this.getEditRequestDate(), 1)) {
            PfMessageUtility.addMessageDecisiontFailed((MospParams)this.mospParams);
            return;
        }
        vo.setModeActivateDate("fixed");
    }

    protected void insertMode() throws MospException {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.setPulldown();
        vo.setModeCardEdit("new");
        vo.setComparatorName(OvertimeRequestRequestDateComparator.class.getName());
    }

    protected void editMode() throws MospException {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getSystemDate();
        if (personalId != null) {
            this.setEmployeeInfo(personalId, targetDate);
            this.setPageInfo(CMD_PAGE, this.getListLength());
            this.insertMode();
            this.search();
        }
        this.isAvailable(this.getDate(this.getTransferredActivateDate()), CODE_FUNCTION);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.setEditUpdateMode(this.getDate(this.getTransferredActivateDate()), Integer.parseInt(this.getTransferredType()));
        vo.setModeActivateDate("chaning");
        this.setOvertimeDate();
    }

    protected void batchUpdate() throws MospException {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        if (!this.isAvailable(this.getSystemDate(), CODE_FUNCTION)) {
            return;
        }
        this.time().overtimeRequestRegist().update(this.getIdArray(vo.getCkbSelect()));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageBatchUpdatetFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageUpdatetSucceed((MospParams)this.mospParams);
        String searchYear = vo.getPltSearchRequestYear();
        String searchMonth = vo.getPltSearchRequestMonth();
        this.insertMode();
        this.setSearchRequestDate(searchYear, searchMonth);
        this.search();
    }

    protected void selectOvertimeDate() throws MospException {
        String transferredMinute;
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        this.select();
        String transferredHour = this.getTransferredHour();
        if (transferredHour != null) {
            vo.setPltEditRequestHour(transferredHour);
        }
        if ((transferredMinute = this.getTransferredMinute()) != null) {
            vo.setPltEditRequestMinute(transferredMinute);
        }
        this.setOvertimeDate();
    }

    protected void transfer() throws MospException {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        this.setTargetWorkflow(vo.getAryWorkflow(this.getTransferredIndex()));
        this.mospParams.setNextCommand("TM1821");
    }

    public void setDefaultValues() throws MospException {
        Date date;
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        OvertimeInfoReferenceBeanInterface overtimeInfo = this.timeReference().overtimeInfo();
        Date targetDate = date = this.getSystemDate();
        if (this.getTargetDate() != null) {
            targetDate = this.getTargetDate();
        }
        vo.setRecordId(0L);
        vo.setPltEditRequestYear(String.valueOf(DateUtility.getYear((Date)targetDate)));
        vo.setPltEditRequestMonth(String.valueOf(DateUtility.getMonth((Date)targetDate)));
        vo.setPltEditRequestDay(String.valueOf(DateUtility.getDay((Date)targetDate)));
        vo.setPltEditRequestHour("0");
        vo.setPltEditRequestMinute("0");
        if (this.getTransferredHour() != null) {
            vo.setPltEditRequestHour(this.getTransferredHour());
            vo.setPltEditRequestMinute(this.getTransferredMinute());
        }
        vo.setPltEditOverTimeType(Integer.toString(2));
        vo.setTxtEditRequestReason("");
        vo.setPltSearchState("");
        vo.setPltSearchScheduleOver("");
        vo.setPltSearchOverTimeType("");
        Date searchDate = this.timeReference().cutoffUtil().getCutoffMonth(personalId, date);
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchDate));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchDate));
        String[] aryPltLblApproverSetting = new String[]{};
        vo.setAryPltLblApproverSetting(aryPltLblApproverSetting);
        vo.setPltApproverSetting1("");
        vo.setPltApproverSetting2("");
        vo.setPltApproverSetting3("");
        vo.setPltApproverSetting4("");
        vo.setPltApproverSetting5("");
        vo.setPltApproverSetting6("");
        vo.setPltApproverSetting7("");
        vo.setPltApproverSetting8("");
        vo.setPltApproverSetting9("");
        vo.setPltApproverSetting10("");
        vo.setModeActivateDate("chaning");
        vo.setJsBeforeOvertimeFlag("0");
        vo.setLblRemainderWeek(overtimeInfo.getStringPossibleTime1Week(personalId));
        vo.setLblRemainderMonth(overtimeInfo.getStringPossibleTime1Month(personalId));
        Integer beforeOvertimeFlag = this.timeReference().timeSetting().getBeforeOvertimeFlag(vo.getPersonalId(), targetDate);
        if (null != beforeOvertimeFlag && 1 == beforeOvertimeFlag) {
            vo.setJsBeforeOvertimeFlag("1");
        }
    }

    protected void setSearchRequestDate(String year, String month) {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        vo.setPltSearchRequestYear(year);
        vo.setPltSearchRequestMonth(month);
    }

    protected void setPulldown() {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        int editRequestYear = DateUtility.getYear((Date)this.getSystemDate());
        vo.setAryPltEditRequestYear(this.getYearArray(editRequestYear));
        vo.setAryPltEditRequestMonth(this.getMonthArray());
        vo.setAryPltEditRequestDay(this.getDayArray());
        vo.setAryPltEditRequestHour(this.getHourArray());
        vo.setAryPltEditRequestMinute(this.getMinuteArray(15));
        vo.setAryPltEditOverTimeType(this.mospParams.getProperties().getCodeArray("OverTimeType", false));
        vo.setAryPltSearchState(this.mospParams.getProperties().getCodeArray("ApprovalState", true));
        vo.setAryPltSearchScheduleOver(this.mospParams.getProperties().getCodeArray("ScheduleOver", true));
        vo.setAryPltSearchOverTimeType(this.mospParams.getProperties().getCodeArray("OverTimeType", true));
        vo.setAryPltSearchRequestYear(this.getYearArray(editRequestYear));
        vo.setAryPltSearchRequestMonth(this.getMonthArray(true));
    }

    protected void setEditUpdateMode(Date requestDate, int overTimeType) throws MospException {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        OvertimeRequestDtoInterface dto = this.timeReference().overtimeRequest().findForKeyOnWorkflow(vo.getPersonalId(), requestDate, overTimeType);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
    }

    protected void setVoFields(OvertimeRequestDtoInterface dto) throws MospException {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        vo.setRecordId(dto.getTmdOvertimeRequestId());
        vo.setTmdOvertimeRequestId(dto.getTmdOvertimeRequestId());
        vo.setPltEditRequestYear(String.valueOf(DateUtility.getYear((Date)dto.getRequestDate())));
        vo.setPltEditRequestMonth(String.valueOf(DateUtility.getMonth((Date)dto.getRequestDate())));
        vo.setPltEditRequestDay(String.valueOf(DateUtility.getDay((Date)dto.getRequestDate())));
        vo.setPltEditRequestHour(this.convIntegerTimeToStringHour(dto.getRequestTime()));
        vo.setPltEditRequestMinute(this.convIntegerTimeToStringMinutes(dto.getRequestTime()));
        vo.setPltEditOverTimeType(String.valueOf(dto.getOvertimeType()));
        vo.setTxtEditRequestReason(dto.getRequestReason());
        vo.setModeCardEdit(this.getApplicationMode(dto.getWorkflow()));
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        String[] aryCkbRecordId = new String[list.size()];
        String[] aryLblRequestDate = new String[list.size()];
        String[] aryLblOvertimeTypeName = new String[list.size()];
        String[] aryLblOvertimeTypeCode = new String[list.size()];
        String[] aryLblRequestTime = new String[list.size()];
        String[] aryLblResultTime = new String[list.size()];
        String[] aryLblRequestReason = new String[list.size()];
        String[] aryLblWorkflowStatus = new String[list.size()];
        String[] aryStatusStyle = new String[list.size()];
        String[] aryLblApproverName = new String[list.size()];
        String[] aryLblOnOff = new String[list.size()];
        String[] aryWorkflowStatus = new String[list.size()];
        long[] aryWorkflow = new long[list.size()];
        int i = 0;
        for (BaseDtoInterface baseDtoInterface : list) {
            OvertimeRequestListDtoInterface dto = (OvertimeRequestListDtoInterface)baseDtoInterface;
            aryCkbRecordId[i] = String.valueOf(dto.getTmdOvertimeRequestId());
            aryLblRequestDate[i] = DateUtility.getStringDateAndDay((Date)dto.getRequestDate());
            aryLblOvertimeTypeName[i] = this.getOvertimeTypeName(dto.getOvertimeType());
            aryLblOvertimeTypeCode[i] = String.valueOf(dto.getOvertimeType());
            aryLblRequestTime[i] = TimeUtility.getStringPeriodTime((MospParams)this.mospParams, (int)dto.getRequestTime());
            aryLblResultTime[i] = dto.getResultsTime();
            aryLblRequestReason[i] = dto.getRequestReason();
            aryLblWorkflowStatus[i] = this.getStatusStageValueView(dto.getState(), dto.getStage());
            aryStatusStyle[i] = this.getStatusColor(dto.getState());
            aryLblApproverName[i] = dto.getApproverName();
            aryLblOnOff[i] = this.getButtonOnOff(dto.getState(), dto.getStage());
            aryWorkflowStatus[i] = dto.getState();
            aryWorkflow[i] = dto.getWorkflow();
            ++i;
        }
        vo.setAryCkbOvertimeRequestListId(aryCkbRecordId);
        vo.setAryLblDate(aryLblRequestDate);
        vo.setAryLblOverTimeTypeName(aryLblOvertimeTypeName);
        vo.setAryLblOverTimeTypeCode(aryLblOvertimeTypeCode);
        vo.setAryLblScheduleTime(aryLblRequestTime);
        vo.setAryLblResultTime(aryLblResultTime);
        vo.setAryLblRequestReason(aryLblRequestReason);
        vo.setAryLblState(aryLblWorkflowStatus);
        vo.setAryStateStyle(aryStatusStyle);
        vo.setAryLblApprover(aryLblApproverName);
        vo.setAryLblOnOff(aryLblOnOff);
        vo.setAryWorkflowStatus(aryWorkflowStatus);
        vo.setAryWorkflow(aryWorkflow);
    }

    protected void setOvertimeDtoFields(OvertimeRequestDtoInterface dto) throws MospException {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        dto.setTmdOvertimeRequestId(vo.getRecordId());
        dto.setPersonalId(vo.getPersonalId());
        dto.setRequestDate(this.getEditRequestDate());
        int workRequestTime = this.getInt(vo.getPltEditRequestHour()) * 60 + this.getInt(vo.getPltEditRequestMinute());
        dto.setRequestTime(workRequestTime);
        dto.setOvertimeType(Integer.parseInt(vo.getPltEditOverTimeType()));
        dto.setRequestReason(vo.getTxtEditRequestReason());
    }

    protected Date getEditRequestDate() {
        OvertimeRequestVo vo = (OvertimeRequestVo)this.mospParams.getVo();
        return this.getDate(vo.getPltEditRequestYear(), vo.getPltEditRequestMonth(), vo.getPltEditRequestDay());
    }
}

