/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.input.action;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.platform.utils.TransStringUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.HolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.HolidayReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestExecuteBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestRegistBeanInterface;
import jp.mosp.time.bean.HolidayRequestSearchBeanInterface;
import jp.mosp.time.bean.PaidHolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayRemainBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.comparator.settings.HolidayRequestRequestDateComparator;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestListDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.impl.HolidayRemainDto;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.input.vo.HolidayRequestVo;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeUtility;

public class HolidayRequestAction
extends TimeAction {
    public static final String CMD_SHOW = "TM1500";
    public static final String CMD_SELECT_SHOW = "TM1501";
    public static final String CMD_SEARCH = "TM1502";
    public static final String CMD_RE_SHOW = "TM1503";
    public static final String CMD_DRAFT = "TM1504";
    public static final String CMD_APPLI = "TM1505";
    public static final String CMD_TRANSFER = "TM1506";
    public static final String CMD_WITHDRAWN = "TM1507";
    public static final String CMD_SORT = "TM1508";
    public static final String CMD_PAGE = "TM1509";
    public static final String CMD_BATCH_WITHDRAWN = "TM1536";
    public static final String CMD_SET_ACTIVATION_DATE = "TM1590";
    public static final String CMD_INSERT_MODE = "TM1591";
    public static final String CMD_EDIT_MODE = "TM1592";
    public static final String CMD_BATCH_UPDATE = "TM1595";
    public static final String CMD_SET_VIEW_PERIOD = "TM1597";
    public static final String CMD_SET_TRANSFER_HOLIDAY = "TM1598";
    public static final String CMD_SELECT_ACTIVATION_DATE = "TM1599";
    protected static final String CODE_FUNCTION = "3";

    public HolidayRequestAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new HolidayRequestVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_DRAFT)) {
            this.prepareVo();
            this.draft();
        } else if (this.mospParams.getCommand().equals(CMD_APPLI)) {
            this.prepareVo();
            this.appli();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_WITHDRAWN)) {
            this.prepareVo();
            this.withdrawn();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_WITHDRAWN)) {
            this.prepareVo();
            this.batchWithdrawn();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setEditActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        } else if (this.mospParams.getCommand().equals(CMD_SET_VIEW_PERIOD)) {
            this.prepareVo();
            this.setSearchActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_SET_TRANSFER_HOLIDAY)) {
            this.prepareVo();
            this.setHolidayContinue();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_ACTIVATION_DATE)) {
            this.prepareVo(false, false);
            this.selectActivationDate();
        }
    }

    protected void show() throws MospException {
        String personalId = this.mospParams.getUser().getPersonalId();
        Date targetDate = this.getSystemDate();
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        this.search();
        this.isAvailable(this.getEditStartDate(), CODE_FUNCTION);
    }

    protected void select() throws MospException {
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getSystemDate();
        if (personalId == null || personalId.isEmpty()) {
            personalId = this.mospParams.getUser().getPersonalId();
        }
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        this.search();
        this.isAvailable(this.getEditStartDate(), CODE_FUNCTION);
    }

    protected void search() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestSearchBeanInterface search = this.timeReference().holidayRequestSearch();
        String personalId = vo.getPersonalId();
        search.setPersonalId(personalId);
        String holidayType1 = vo.getPltSearchHolidayType();
        search.setHolidayType1(holidayType1);
        search.setHolidayType2("");
        search.setHolidayLength("");
        if (holidayType1 != null && !holidayType1.isEmpty()) {
            int holidayType = Integer.parseInt(holidayType1);
            String holidayType2 = "";
            String holidayLength = vo.getPltSearchHolidayRange1();
            if (1 == holidayType) {
                holidayType2 = vo.getPltSearchStatusWithPay();
            } else if (2 == holidayType) {
                holidayType2 = vo.getPltSearchStatusSpecial();
            } else if (3 == holidayType) {
                holidayType2 = vo.getPltSearchSpecialOther();
            } else if (4 == holidayType) {
                holidayType2 = vo.getPltSearchSpecialAbsence();
            }
            search.setHolidayType2(holidayType2);
            search.setHolidayLength(holidayLength);
        }
        int year = Integer.parseInt(vo.getPltSearchYear());
        int startMonth = this.getInt("1");
        int endMonth = this.getInt("12");
        if (!MospUtility.isEmpty((String[])new String[]{vo.getPltSearchMonth()})) {
            endMonth = startMonth = this.getInt(vo.getPltSearchMonth());
        }
        TimeMasterBeanInterface timeMaster = this.timeReference().master();
        ApplicationEntity applicationFrom = timeMaster.getApplicationEntity(personalId, year, startMonth);
        ApplicationEntity applicationTo = timeMaster.getApplicationEntity(personalId, year, endMonth);
        Date firstDate = applicationFrom.getCutoffEntity().getCutoffFirstDate(year, startMonth, this.mospParams);
        Date lastDate = applicationTo.getCutoffEntity().getCutoffLastDate(year, endMonth, this.mospParams);
        search.setRequestStartDate(firstDate);
        search.setRequestEndDate(lastDate);
        search.setWorkflowStatus(vo.getPltSearchState());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(HolidayRequestRequestDateComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty() && this.mospParams.getCommand().equals(CMD_SEARCH)) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    public void setDefaultValues() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestReferenceBeanInterface holidayRequest = this.timeReference().holidayRequest();
        Date date = this.getSystemDate();
        String personalId = vo.getPersonalId();
        String nameNoLimit = this.mospParams.getName("NoLimit");
        PaidHolidayInfoReferenceBeanInterface paidHolidayInfo = this.timeReference().paidHolidayInfo();
        HolidayInfoReferenceBeanInterface holidayInfo = this.timeReference().holidayInfo();
        PaidHolidayRemainBeanInterface paidHolidayRemain = this.timeReference().paidHolidayRemain();
        vo.setJsPaidHolidayReasonRequired(holidayRequest.isPaidHolidayReasonRequired());
        Set remains = holidayInfo.getRemainHolidays(personalId, date);
        String[] aryGivingDate = new String[remains.size()];
        String[] arySpecialHolidayType = new String[remains.size()];
        String[] arySpecialHolidayName = new String[remains.size()];
        String[] aryRemainder = new String[remains.size()];
        String[] aryLimit = new String[remains.size()];
        int cnt = 0;
        for (HolidayRemainDto dto : remains) {
            double remainDays = dto.getRemainDays();
            int remainHours = dto.getRemainHours();
            int remainMinutes = dto.getRemainMinutes();
            aryGivingDate[cnt] = DateUtility.getStringDateAndDay((Date)dto.getAcquisitionDate());
            aryRemainder[cnt] = this.getFormatDaysHoursMinutes(remainDays, remainHours, remainMinutes, false);
            aryLimit[cnt] = DateUtility.getStringDateAndDay((Date)dto.getHolidayLimitDate());
            if (TimeUtility.isUnlimited((Date)dto.getHolidayLimitDate())) {
                aryRemainder[cnt] = nameNoLimit;
                aryLimit[cnt] = nameNoLimit;
            }
            arySpecialHolidayType[cnt] = this.getCodeName(dto.getHolidayType(), "HolidayType");
            arySpecialHolidayName[cnt++] = dto.getHolidayName();
        }
        vo.setRecordId(0L);
        vo.setAryLblGivingDate(aryGivingDate);
        vo.setAryLblSpecialHolidayType(arySpecialHolidayType);
        vo.setAryLblSpecialHolidayName(arySpecialHolidayName);
        vo.setAryLblRemainder(aryRemainder);
        vo.setAryLblLimit(aryLimit);
        if (this.getTargetDate() == null) {
            vo.setPltEditStartYear(DateUtility.getStringYear((Date)date));
            vo.setPltEditStartMonth(DateUtility.getStringMonthM((Date)date));
            vo.setPltEditStartDay(DateUtility.getStringDayD((Date)date));
            vo.setPltEditEndYear(DateUtility.getStringYear((Date)date));
            vo.setPltEditEndMonth(DateUtility.getStringMonthM((Date)date));
            vo.setPltEditEndDay(DateUtility.getStringDayD((Date)date));
        } else {
            vo.setPltEditStartYear(DateUtility.getStringYear((Date)this.getTargetDate()));
            vo.setPltEditStartMonth(DateUtility.getStringMonthM((Date)this.getTargetDate()));
            vo.setPltEditStartDay(DateUtility.getStringDayD((Date)this.getTargetDate()));
            vo.setPltEditEndYear(DateUtility.getStringYear((Date)this.getTargetDate()));
            vo.setPltEditEndMonth(DateUtility.getStringMonthM((Date)this.getTargetDate()));
            vo.setPltEditEndDay(DateUtility.getStringDayD((Date)this.getTargetDate()));
        }
        int[] timeUnitLimit = paidHolidayInfo.getHolidayTimeUnitLimit(personalId, date, false, null);
        vo.setLblHolidayTimeUnitLimit(this.getNumberOfDayAndHour(timeUnitLimit[0], timeUnitLimit[1]));
        this.initVo();
        this.setPaidLeaveByHour();
        double stock = paidHolidayRemain.getStockHolidayRemainDaysForView(personalId, date);
        vo.setLblPaidHolidayStock(TransStringUtility.getDoubleTimes((MospParams)this.mospParams, (Double)stock, (boolean)false, (boolean)true));
        this.setPaidLeave();
        Map nextYearMap = paidHolidayInfo.getNextGivingInfo(personalId);
        if (nextYearMap == null) {
            return;
        }
        double nextYearDay = (Double)nextYearMap.get("NextPlantYearDay");
        if (nextYearDay == -1.0) {
            nextYearDay = 0.0;
        }
        int nextYearTime = (Integer)nextYearMap.get("NextPlanTime");
        Date nextYearGivingDate = (Date)nextYearMap.get("NextPlanGivingDate");
        Date nextYearrLimitDate = (Date)nextYearMap.get("NextPlanLimitDate");
        vo.setLblNextGivingDate(DateUtility.getStringDateAndDay((Date)nextYearGivingDate));
        vo.setLblNextGivingAmount(this.getFormatDaysHoursMinutes(nextYearDay, nextYearTime, 0, false));
        vo.setLblNextLimitDate(DateUtility.getStringDateAndDay((Date)nextYearrLimitDate));
        Date nextManualGivingDate = paidHolidayInfo.getNextManualGivingDate(personalId);
        if (null == nextManualGivingDate) {
            return;
        }
        vo.setLblNextManualGivingDate(DateUtility.getStringDateAndDay((Date)nextManualGivingDate));
        vo.setLblNextManualGivingAmount(paidHolidayInfo.getNextManualGivingDaysAndHours(vo.getPersonalId()));
    }

    protected void setPaidLeave() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        PaidHolidayInfoReferenceBeanInterface paidHolidayInfo = this.timeReference().paidHolidayInfo();
        Date date = this.getSystemDate();
        List list = paidHolidayInfo.getPaidHolidayDataListForView(vo.getPersonalId(), date);
        String[] aryLblPaidLeaveFiscalYear = new String[list.size()];
        String[] aryLblStyle = new String[list.size()];
        String[] aryLblPaidLeaveGrantDate = new String[list.size()];
        String[] aryLblPaidLeaveExpirationDate = new String[list.size()];
        String[] aryLblPaidLeaveRemainDays = new String[list.size()];
        String[] aryLblPaidLeaveGrantDays = new String[list.size()];
        double totalRemainDays = 0.0;
        int totalRemainHours = 0;
        for (int i = 0; i < list.size(); ++i) {
            Map m = (Map)list.get(i);
            aryLblStyle[i] = "";
            aryLblPaidLeaveGrantDate[i] = "";
            Object grantDate = m.get("PaidLeaveGrantDate");
            if (grantDate != null) {
                aryLblPaidLeaveGrantDate[i] = DateUtility.getStringDateAndDay((Date)((Date)grantDate));
                if (this.getSystemDate().compareTo((Date)grantDate) < 0) {
                    aryLblStyle[i] = "style=\"color: gray\"";
                }
            }
            String fiscalYearString = "";
            Object fiscalYear = m.get("PaidLeaveFiscalYear");
            if (fiscalYear != null) {
                fiscalYearString = fiscalYear.toString();
            }
            aryLblPaidLeaveFiscalYear[i] = fiscalYearString;
            aryLblPaidLeaveExpirationDate[i] = "";
            Object expirationDate = m.get("PaidLeaveExpirationDate");
            if (expirationDate != null) {
                aryLblPaidLeaveExpirationDate[i] = DateUtility.getStringDateAndDay((Date)((Date)expirationDate));
            }
            double remainDaysDouble = 0.0;
            Object remainDays = m.get("PaidLeaveRemainDays");
            if (remainDays != null) {
                remainDaysDouble = (Double)remainDays;
            }
            int remainHoursInt = 0;
            Object remainHours = m.get("PaidLeaveRemainHours");
            if (remainHours != null) {
                remainHoursInt = (Integer)remainHours;
            }
            double grantDaysDouble = 0.0;
            Object grantDays = m.get("PaidLeaveGrantDays");
            if (grantDays != null) {
                grantDaysDouble = (Double)grantDays;
            }
            int grantHoursInt = 0;
            Object grantHours = m.get("PaidLeaveGrantHours");
            if (grantHours != null) {
                grantHoursInt = (Integer)grantHours;
            }
            aryLblPaidLeaveRemainDays[i] = this.getFormatDaysHoursMinutes(remainDaysDouble, remainHoursInt, 0, false);
            aryLblPaidLeaveGrantDays[i] = this.getFormatDaysHoursMinutes(grantDaysDouble, grantHoursInt, 0, false);
            if (!this.mospParams.getName("PreviousYear", new String[]{"Times"}).equals(fiscalYearString) && !this.mospParams.getName("ThisYear", new String[]{"Times"}).equals(fiscalYearString)) continue;
            totalRemainDays += remainDaysDouble;
            totalRemainHours += remainHoursInt;
        }
        vo.setAryLblPaidLeaveFiscalYear(aryLblPaidLeaveFiscalYear);
        vo.setAryLblStyle(aryLblStyle);
        vo.setAryLblPaidLeaveGrantDate(aryLblPaidLeaveGrantDate);
        vo.setAryLblPaidLeaveExpirationDate(aryLblPaidLeaveExpirationDate);
        vo.setAryLblPaidLeaveRemainDays(aryLblPaidLeaveRemainDays);
        vo.setAryLblPaidLeaveGrantDays(aryLblPaidLeaveGrantDays);
        vo.setLblTotalDay(Double.toString(totalRemainDays));
        vo.setLblTotalTime(Integer.toString(totalRemainHours));
    }

    protected void setPaidLeaveByHour() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        ApplicationReferenceBeanInterface applicationReference = this.timeReference().application();
        PaidHolidayReferenceBeanInterface paidHolidayReference = this.timeReference().paidHoliday();
        vo.setPaidLeaveByHour(false);
        Date date = this.getSystemDate();
        ApplicationDtoInterface applicationDto = applicationReference.findForPerson(vo.getPersonalId(), date);
        if (applicationDto == null) {
            return;
        }
        PaidHolidayDtoInterface paidHolidayDto = paidHolidayReference.getPaidHolidayInfo(applicationDto.getPaidHolidayCode(), date);
        if (paidHolidayDto == null) {
            return;
        }
        vo.setPaidLeaveByHour(paidHolidayDto.getTimelyPaidHolidayFlag() == 0);
    }

    protected String getNumberOfDayAndHour(int day, int hour) {
        return TransStringUtility.getJapaneaseDaysAndHours((MospParams)this.mospParams, (int)day, (int)hour);
    }

    protected void setSearchRequestDate(String year, String month) {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        vo.setPltSearchYear(year);
        vo.setPltSearchMonth(month);
    }

    protected void initVo() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        vo.setPltEditHolidayType1(String.valueOf(1));
        vo.setPltEditStatusWithPay("");
        vo.setPltEditStatusSpecial("");
        vo.setPltEditSpecialOther("");
        vo.setPltEditSpecialAbsence("");
        vo.setPltEditHolidayRange("");
        vo.setPltEditHolidayRangePaidHoliday("");
        vo.setPltEditStartHour("0");
        vo.setPltEditStartMinute("0");
        vo.setPltEditEndTime("1");
        vo.setTxtEditRequestReason("");
        vo.setPltSearchHolidayType("");
        vo.setPltSearchHolidayType1("");
        vo.setPltSearchHolidayType2("");
        vo.setPltSearchHolidayType3("");
        vo.setPltSearchState("");
        Date searchDate = this.timeReference().cutoffUtil().getCutoffMonth(vo.getPersonalId(), date);
        vo.setPltSearchYear(DateUtility.getStringYear((Date)searchDate));
        vo.setPltSearchMonth(DateUtility.getStringMonthM((Date)searchDate));
        String[] aryPltLblApproverSetting = new String[]{};
        vo.setAryPltLblApproverSetting(aryPltLblApproverSetting);
        vo.setPltApproverSetting1("");
        vo.setPltApproverSetting2("");
        vo.setPltApproverSetting3("");
        vo.setPltApproverSetting4("");
        vo.setPltApproverSetting5("");
        vo.setPltApproverSetting6("");
        vo.setPltApproverSetting7("");
        vo.setPltApproverSetting8("");
        vo.setPltApproverSetting9("");
        vo.setPltApproverSetting10("");
        vo.setTxtEditRequestReason("");
        vo.setLblTotalDay("0");
        vo.setLblTotalTime("0");
        vo.setLblNextGivingDate("0");
        vo.setLblNextGivingAmount("0");
        String hyphen = PfNameUtility.hyphen((MospParams)this.mospParams);
        vo.setLblNextManualGivingDate(hyphen);
        vo.setLblNextManualGivingAmount(hyphen);
    }

    protected void draft() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestExecuteBeanInterface bean = this.time().holidayRequestExecute();
        String personalId = vo.getPersonalId();
        Date startDate = this.getEditStartDate();
        Date endDate = this.getEditEndDate();
        int type1 = this.getInt(vo.getPltEditHolidayType1());
        String type2 = this.getHolidayType2(type1);
        int range = this.getHolidayRange(type1, type2);
        Date startTime = this.getEditStartTime();
        int hours = MospUtility.getInt((Object)vo.getPltEditEndTime());
        String reason = vo.getTxtEditRequestReason();
        long recordId = vo.getRecordId();
        String[] approvers = this.getSelectApproverIds();
        bean.draft(personalId, startDate, endDate, type1, type2, range, startTime, hours, reason, recordId, approvers);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addDraftMessage();
        vo.setPltSearchYear(DateUtility.getStringYear((Date)startDate));
        vo.setPltSearchMonth(DateUtility.getStringMonthM((Date)startDate));
        this.setSearchPulldown();
        this.search();
        this.setEditUpdateMode(personalId, startDate, type1, type2, range, startTime);
    }

    protected void appli() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestExecuteBeanInterface bean = this.time().holidayRequestExecute();
        String personalId = vo.getPersonalId();
        Date startDate = this.getEditStartDate();
        Date endDate = this.getEditEndDate();
        int type1 = this.getInt(vo.getPltEditHolidayType1());
        String type2 = this.getHolidayType2(type1);
        int range = this.getHolidayRange(type1, type2);
        Date startTime = this.getEditStartTime();
        int hours = MospUtility.getInt((Object)vo.getPltEditEndTime());
        String reason = vo.getTxtEditRequestReason();
        long recordId = vo.getRecordId();
        String[] approvers = this.getSelectApproverIds();
        bean.apply(personalId, startDate, endDate, type1, type2, range, startTime, hours, reason, recordId, approvers);
        this.doAdditionalLogic("Add_HolidayRequestAction_Appli");
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addAppliMessage();
        if (range == 2 || range == 3) {
            TimeMessageUtility.addHalfHolidayRequestNotice((MospParams)this.mospParams);
        }
        this.insertMode();
        vo.setPltSearchYear(DateUtility.getStringYear((Date)startDate));
        vo.setPltSearchMonth(DateUtility.getStringMonthM((Date)startDate));
        this.setSearchPulldown();
        this.search();
    }

    protected void batchUpdate() throws MospException {
        if (!this.isAvailable(this.getSystemDate(), CODE_FUNCTION)) {
            return;
        }
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestExecuteBeanInterface bean = this.time().holidayRequestExecute();
        String personalId = vo.getPersonalId();
        long[] idArray = this.getIdArray(vo.getCkbSelect());
        boolean isHalfHolidayContained = bean.batchUpdate(personalId, idArray);
        this.doAdditionalLogic("Add_HolidayRequestAction_Appli", new Object[]{idArray});
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageBatchUpdatetFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageUpdatetSucceed((MospParams)this.mospParams);
        if (isHalfHolidayContained) {
            TimeMessageUtility.addHalfHolidayRequestNotice((MospParams)this.mospParams);
        }
        String searchYear = vo.getPltSearchYear();
        String searchMonth = vo.getPltSearchMonth();
        this.insertMode();
        vo.setPltSearchYear(searchYear);
        vo.setPltSearchMonth(searchMonth);
        this.setSearchPulldown();
        this.search();
    }

    protected void withdrawn() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestRegistBeanInterface regist = this.time().holidayRequestRegist();
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowCommentRegistBeanInterface workflowCommentRegist = this.platform().workflowCommentRegist();
        HolidayRequestDtoInterface dto = this.timeReference().holidayRequest().findForKey(vo.getRecordId());
        this.checkSelectedDataExist((Object)dto);
        regist.checkWithdrawn(dto);
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        this.checkSelectedDataExist((Object)workflowDto);
        boolean isDraft = "0".equals(workflowDto.getWorkflowStatus());
        if (isDraft) {
            workflowRegist.delete(workflowDto);
            workflowCommentRegist.deleteList(this.reference().workflowComment().getWorkflowCommentList(workflowDto.getWorkflow()));
            regist.delete(dto);
        } else if ((workflowDto = workflowRegist.withdrawn(workflowDto)) != null) {
            workflowCommentRegist.addComment(workflowDto, this.mospParams.getUser().getPersonalId(), PfMessageUtility.getWithdrawSucceed((MospParams)this.mospParams));
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        if (isDraft) {
            PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        } else {
            this.addTakeDownMessage();
        }
        String searchYear = vo.getPltEditStartYear();
        String searchMonth = vo.getPltEditStartMonth();
        this.insertMode();
        vo.setPltSearchYear(searchYear);
        vo.setPltSearchMonth(searchMonth);
        this.setSearchPulldown();
        this.search();
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void batchWithdrawn() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        if (!this.isAvailable(this.getSystemDate(), CODE_FUNCTION)) {
            return;
        }
        this.time().holidayRequestRegist().withdrawn(this.getIdArray(vo.getCkbSelect()));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageBatchUpdatetFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addTakeDownMessage();
        String searchYear = vo.getPltSearchYear();
        String searchMonth = vo.getPltSearchMonth();
        this.insertMode();
        this.setSearchRequestDate(searchYear, searchMonth);
        this.search();
    }

    protected void setPulldown() throws MospException {
        PaidHolidayDtoInterface paidHolidayDto;
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        Date date = this.getEditStartDate();
        int editRequestYear = DateUtility.getYear((Date)date);
        vo.setAryPltEditStartYear(this.getYearArray(editRequestYear));
        vo.setAryPltEditStartMonth(this.getMonthArray());
        vo.setAryPltEditStartDay(this.getDayArray());
        vo.setAryPltEditEndYear(this.getYearArray(editRequestYear));
        vo.setAryPltEditEndMonth(this.getMonthArray());
        vo.setAryPltEditEndDay(this.getDayArray());
        vo.setAryPltEditHolidayType1(this.mospParams.getProperties().getCodeArray("HolidayType", false));
        vo.setAryPltEditHolidayType2WithPay(this.mospParams.getProperties().getCodeArray("HolidayType2WithPay", false));
        vo.setAryPltEditStartHour(this.getHourArray());
        String[][] aryRange = MospUtility.getCodeArray((MospParams)this.mospParams, (String)"HolidayType3Range2", (boolean)false);
        String[][] aryHourlyRange = MospUtility.getCodeArray((MospParams)this.mospParams, (String)"HolidayType3Range1", (boolean)false);
        vo.setAryPltEditHolidayRangePaidHoliday(aryRange);
        vo.setAryPltEditHolidayRange(aryRange);
        ApplicationEntity entity = this.timeReference().master().getApplicationEntity(personalId, date);
        TimeSettingDtoInterface timeSettingDto = entity.getTimeSettingDto();
        if (timeSettingDto != null) {
            vo.setAryPltEditStartHour(this.getHourArray(DateUtility.getHour((Date)timeSettingDto.getStartDayTime()) + 23, true));
            vo.setAryPltEditEndTime(this.getHourArray(DateUtility.getHour((Date)timeSettingDto.getGeneralWorkTime()), false));
        }
        if ((paidHolidayDto = entity.getPaidHolidayDto()) != null) {
            vo.setAryPltEditStartMinute(this.getMinuteArray(paidHolidayDto.getAppliTimeInterval()));
            if (PlatformUtility.isActivate((int)paidHolidayDto.getTimelyPaidHolidayFlag())) {
                vo.setAryPltEditHolidayRangePaidHoliday(aryHourlyRange);
            }
        }
        if (this.timeReference().holiday().isTimelyHoliday(date)) {
            vo.setAryPltEditHolidayRange(aryHourlyRange);
        }
        vo.setAryPltSearchYear(this.getYearArray(editRequestYear));
        vo.setAryPltSearchMonth(this.getMonthArray(true));
    }

    protected void setEditActivationDate() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestRegistBeanInterface regist = this.time().holidayRequestRegist();
        this.setPulldown();
        if (vo.getModeActivateDate().equals("chaning")) {
            if (this.chkActivationDateValidate()) {
                return;
            }
            if (!this.isAvailable(this.getEditStartDate(), CODE_FUNCTION) || !this.isAvailable(this.getEditEndDate(), CODE_FUNCTION)) {
                return;
            }
            if (!this.setApproverPullDown(vo.getPersonalId(), this.getEditStartDate(), 1)) {
                return;
            }
            HolidayRequestDtoInterface dto = this.timeReference().holidayRequest().findForKey(vo.getRecordId());
            if (dto == null) {
                dto = regist.getInitDto();
            }
            dto.setPersonalId(vo.getPersonalId());
            dto.setRequestStartDate(this.getEditStartDate());
            dto.setRequestEndDate(this.getEditEndDate());
            regist.checkSetRequestDate(dto);
            if (this.mospParams.hasErrorMessage()) {
                PfMessageUtility.addMessageDecisiontFailed((MospParams)this.mospParams);
                return;
            }
            if (!this.getEditStartDate().equals(this.getEditEndDate())) {
                vo.setPltEditHolidayRange(String.valueOf(1));
                vo.setPltEditHolidayRangePaidHoliday(String.valueOf(1));
            }
            this.setHolidayContinue();
            vo.setModeActivateDate("fixed");
        } else {
            String[] aryPltLblApproverSetting = new String[]{};
            vo.setAryPltLblApproverSetting(aryPltLblApproverSetting);
            vo.setModeActivateDate("chaning");
        }
        this.setEditPulldown();
    }

    protected void setEditPulldown() throws MospException {
        String[][] holidayArray;
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayReferenceBeanInterface holidayReference = this.timeReference().holiday();
        HolidayInfoReferenceBeanInterface holidayInfo = this.timeReference().holidayInfo();
        if (!vo.getModeActivateDate().equals("fixed")) {
            return;
        }
        String personalId = vo.getPersonalId();
        Date startDate = this.getEditStartDate();
        boolean paidLeave = this.isPaidLeaveHoliday(vo.getPersonalId(), startDate);
        boolean stockLeave = this.isStockLeaveHoliday(vo.getPersonalId(), startDate);
        String[][] paidArray = this.getAryPltEditHolidayType2Paid(paidLeave, stockLeave);
        String[][] specialArray = holidayInfo.getRemainArray(personalId, startDate, 2);
        String[][] otherArray = holidayInfo.getRemainArray(personalId, startDate, 3);
        String[][] absenceArray = holidayReference.getSelectArray(this.getEditStartDate(), 4, false);
        String noTargetData = PfNameUtility.noTargetData((MospParams)this.mospParams);
        boolean paidStockDeleteFlag = !paidLeave && !stockLeave;
        boolean specialDeleteFlag = noTargetData.equals(specialArray[0][1]);
        boolean otherDeleteFlag = noTargetData.equals(otherArray[0][1]);
        boolean absenceDeleteFlag = noTargetData.equals(absenceArray[0][1]);
        String[][] newHolidayArray = holidayArray = this.mospParams.getProperties().getCodeArray("HolidayType", false);
        int minus = 0;
        if (paidStockDeleteFlag) {
            ++minus;
        }
        if (specialDeleteFlag) {
            ++minus;
        }
        if (otherDeleteFlag) {
            ++minus;
        }
        if (absenceDeleteFlag) {
            ++minus;
        }
        if (minus > 0) {
            newHolidayArray = new String[holidayArray.length - minus][2];
            int i = 0;
            for (String[] holiday : holidayArray) {
                if (paidStockDeleteFlag && Integer.toString(1).equals(holiday[0]) || specialDeleteFlag && Integer.toString(2).equals(holiday[0]) || otherDeleteFlag && Integer.toString(3).equals(holiday[0]) || absenceDeleteFlag && Integer.toString(4).equals(holiday[0])) continue;
                newHolidayArray[i][0] = holiday[0];
                newHolidayArray[i][1] = holiday[1];
                ++i;
            }
        }
        if (newHolidayArray.length == 0) {
            vo.setModeActivateDate("chaning");
            PfMessageUtility.addMessageDecisiontFailed((MospParams)this.mospParams);
            PfMessageUtility.addErrorValidDataNotExist((MospParams)this.mospParams, (String)TimeNamingUtility.holiday((MospParams)this.mospParams));
            return;
        }
        vo.setAryPltEditHolidayType1(newHolidayArray);
        vo.setAryPltEditHolidayType2WithPay(paidArray);
        vo.setAryPltEditHolidayType2Special(specialArray);
        vo.setAryPltEditHolidayType2Other(otherArray);
        vo.setAryPltEditHolidayType2Absence(absenceArray);
        Date endDate = this.getEditEndDate();
        if (startDate.compareTo(endDate) == 0) {
            this.getDifferenceRequest1(vo.getPersonalId(), startDate);
        }
    }

    protected void setSearchActivationDate() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        if (vo.getJsSearchModeActivateDate().equals("chaning")) {
            vo.setJsSearchModeActivateDate("fixed");
        } else {
            vo.setJsSearchModeActivateDate("chaning");
        }
        this.setSearchPulldown();
    }

    protected void setHolidayContinue() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        TimeMasterBeanInterface timeMaster = this.timeReference().master();
        HolidayRequestExecuteBeanInterface holidayRequestExecute = this.time().holidayRequestExecute();
        HolidayInfoReferenceBeanInterface holidayInfoRefer = this.timeReference().holidayInfo();
        holidayRequestExecute.setTimeMaster(timeMaster);
        holidayInfoRefer.setTimeMaster(timeMaster);
        vo.setJsHolidayTerm(Integer.toString(0));
        vo.setJsHolidayContinue(Integer.toString(2));
        vo.setJsHolidayRemainDay(Integer.toString(0));
        String personalId = vo.getPersonalId();
        int holidayType = this.getInt(vo.getPltEditHolidayType1());
        if (1 == holidayType || 4 == holidayType) {
            return;
        }
        String holidayCode = this.getHolidayType2(holidayType);
        Date startDate = this.getEditStartDate();
        Date endDate = this.getEditEndDate();
        HolidayDtoInterface holidayDto = timeMaster.getHoliday(holidayCode, holidayType, startDate);
        if (!PlatformUtility.isDtoActivate((PlatformDtoInterface)holidayDto)) {
            return;
        }
        int useDays = holidayRequestExecute.getConsecutiveHolidayDates(personalId, startDate, endDate).size();
        HolidayRemainDto remain = holidayInfoRefer.getAppliableHoliday(personalId, startDate, holidayCode, holidayType);
        if (MospUtility.isEmpty((Object[])new Object[]{remain})) {
            return;
        }
        vo.setJsHolidayContinue(Integer.toString(holidayDto.getContinuousAcquisition()));
        vo.setJsHolidayTerm(Integer.toString(useDays));
        vo.setJsHolidayRemainDay(Double.toString(remain.getRemainDays()));
    }

    protected void selectActivationDate() throws MospException {
        String transferredHolidayRange;
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        this.select();
        String transferredHolidayType1 = this.getTransferredHolidayType1();
        if (transferredHolidayType1 != null) {
            vo.setPltEditHolidayType1(transferredHolidayType1);
        }
        boolean isPaid = 1 == this.getInt(vo.getPltEditHolidayType1());
        boolean isSpecial = 2 == this.getInt(vo.getPltEditHolidayType1());
        boolean isOther = 3 == this.getInt(vo.getPltEditHolidayType1());
        boolean isAbsence = 4 == this.getInt(vo.getPltEditHolidayType1());
        String transferredHolidayType2 = this.getTransferredHolidayType2();
        if (transferredHolidayType2 != null) {
            if (isPaid) {
                vo.setPltEditStatusWithPay(transferredHolidayType2);
            } else if (isSpecial) {
                vo.setPltEditStatusSpecial(transferredHolidayType2);
            } else if (isOther) {
                vo.setPltEditSpecialOther(transferredHolidayType2);
            } else if (isAbsence) {
                vo.setPltEditSpecialAbsence(transferredHolidayType2);
            }
        }
        if ((transferredHolidayRange = this.getTransferredHolidayRange()) != null) {
            if (isPaid) {
                vo.setPltEditHolidayRangePaidHoliday(transferredHolidayRange);
            } else if (isSpecial || isOther || isAbsence) {
                vo.setPltEditHolidayRange(transferredHolidayRange);
            }
        }
        this.setEditActivationDate();
    }

    protected void setSearchPulldown() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayReferenceBeanInterface holidayRefer = this.timeReference().holiday();
        ApplicationReferenceBeanInterface appRefer = this.timeReference().application();
        PaidHolidayReferenceBeanInterface paidHolidayRefer = this.timeReference().paidHoliday();
        if (vo.getJsSearchModeActivateDate().equals("fixed")) {
            ApplicationDtoInterface applicationDto;
            Date date = vo.getPltSearchMonth().isEmpty() ? MonthUtility.getYearMonthTargetDate((int)this.getInt(vo.getPltSearchYear()), (int)1, (MospParams)this.mospParams) : MonthUtility.getYearMonthTargetDate((int)this.getInt(vo.getPltSearchYear()), (int)this.getInt(vo.getPltSearchMonth()), (MospParams)this.mospParams);
            vo.setAryPltSearchHolidayType2Special(holidayRefer.getSelectArray(date, 2, true));
            vo.setAryPltSearchHolidayType2Other(holidayRefer.getSelectArray(date, 3, true));
            vo.setAryPltSearchHolidayType2Absence(holidayRefer.getSelectArray(date, 4, true));
            vo.setAryPltSearchHolidayRangePaidHoliday(this.mospParams.getProperties().getCodeArray("HolidayType3Range2", true));
            if (holidayRefer.isTimelyHoliday(date)) {
                vo.setAryPltSearchHolidayRangePaidHoliday(this.mospParams.getProperties().getCodeArray("HolidayType3Range1", true));
            }
            if ((applicationDto = appRefer.findForPerson(vo.getPersonalId(), date)) == null) {
                return;
            }
            PaidHolidayDtoInterface paidHolidayDto = paidHolidayRefer.getPaidHolidayInfo(applicationDto.getPaidHolidayCode(), date);
            if (paidHolidayDto == null) {
                return;
            }
            if (paidHolidayDto.getTimelyPaidHolidayFlag() == 0) {
                vo.setAryPltSearchHolidayRangePaidHoliday(this.mospParams.getProperties().getCodeArray("HolidayType3Range1", true));
            }
        }
    }

    protected void insertMode() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.setPulldown();
        vo.setModeCardEdit("new");
        vo.setModeActivateDate("chaning");
        vo.setJsSearchModeActivateDate("fixed");
        vo.setComparatorName(HolidayRequestRequestDateComparator.class.getName());
        vo.setJsModeDifferenceRequest1("");
        this.setEditPulldown();
        this.setSearchPulldown();
        this.timeReference().holidayRequest().chkBasicInfo(vo.getPersonalId(), this.getEditStartDate());
    }

    protected void editMode() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getSystemDate();
        if (personalId != null) {
            this.setEmployeeInfo(personalId, targetDate);
            this.setPageInfo(CMD_PAGE, this.getListLength());
            this.insertMode();
            this.search();
        }
        personalId = vo.getPersonalId();
        Date requestStartDate = this.getDate(this.getTransferredActivateDate());
        int holidayType1 = this.getInt(this.getTransferredHolidayType1());
        String holidayType2 = this.getTransferredHolidayType2();
        int holidayRange = this.getInt(this.getTransferredHolidayRange());
        Date startTime = DateUtility.getTime((String)this.getTransferredStartTime(), (Date)requestStartDate);
        this.setEditUpdateMode(personalId, requestStartDate, holidayType1, holidayType2, holidayRange, startTime);
        vo.setModeActivateDate("chaning");
        this.setEditActivationDate();
    }

    protected void setEditUpdateMode(String personalId, Date requestStartDate, int holidayType1, String holidayType2, int holidayRange, Date startTime) throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        HolidayRequestDtoInterface dto = this.timeReference().holidayRequest().findForKeyOnWorkflow(personalId, requestStartDate, holidayType1, holidayType2, holidayRange, startTime);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        vo.setModeActivateDate("fixed");
    }

    protected void transfer() {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        this.setTargetWorkflow(vo.getAryWorkflow(this.getTransferredIndex()));
        this.mospParams.setNextCommand("TM1831");
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        String[] aryCkbRecordId = new String[list.size()];
        String[] aryLblRequestDate = new String[list.size()];
        String[] aryLblHolidayType1 = new String[list.size()];
        String[] aryLblHolidayType2 = new String[list.size()];
        String[] aryLblHolidayRange = new String[list.size()];
        String[] aryLblRequestReason = new String[list.size()];
        String[] aryLblWorkflowStatus = new String[list.size()];
        String[] aryLblApproverName = new String[list.size()];
        String[] aryLblWorkflow = new String[list.size()];
        String[] aryStatusStyle = new String[list.size()];
        String[] aryHolidayType1 = new String[list.size()];
        String[] aryHolidayType2 = new String[list.size()];
        String[] aryHolidayRange = new String[list.size()];
        String[] aryStartTime = new String[list.size()];
        String[] aryLblOnOff = new String[list.size()];
        String[] aryWorkflowStatus = new String[list.size()];
        long[] aryWorkflow = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            HolidayRequestListDtoInterface dto = (HolidayRequestListDtoInterface)list.get(i);
            aryCkbRecordId[i] = String.valueOf(dto.getTmdHolidayRequestId());
            aryLblRequestDate[i] = DateUtility.getStringDateAndDay((Date)dto.getRequestStartDate()) + this.mospParams.getName("Wave") + DateUtility.getStringDateAndDay((Date)dto.getRequestEndDate());
            aryLblHolidayType1[i] = this.timeReference().holiday().getHolidayType1NameForHolidayRequest(dto.getHolidayType1(), dto.getHolidayType2());
            aryLblHolidayType2[i] = this.getHolidayType2Abbr(dto.getHolidayType1(), dto.getHolidayType2(), dto.getRequestStartDate());
            aryLblHolidayRange[i] = this.getHolidayRange(dto);
            aryHolidayType1[i] = String.valueOf(dto.getHolidayType1());
            aryHolidayType2[i] = dto.getHolidayType2();
            aryHolidayRange[i] = String.valueOf(dto.getHolidayRange());
            aryStartTime[i] = DateUtility.getStringTime((Date)dto.getStartTime(), (Date)dto.getRequestStartDate());
            aryLblRequestReason[i] = dto.getRequestReason();
            aryLblWorkflowStatus[i] = this.getStatusStageValueView(dto.getState(), dto.getStage());
            aryStatusStyle[i] = this.getStatusColor(dto.getState());
            aryLblApproverName[i] = dto.getApproverName();
            aryLblWorkflow[i] = String.valueOf(dto.getWorkflow());
            aryLblOnOff[i] = this.getButtonOnOff(dto.getState(), dto.getStage());
            aryWorkflowStatus[i] = dto.getState();
            aryWorkflow[i] = dto.getWorkflow();
        }
        vo.setAryCkbHolidayRequestListId(aryCkbRecordId);
        vo.setAryLblDate(aryLblRequestDate);
        vo.setAryLblHolidayType1(aryLblHolidayType1);
        vo.setAryLblHolidayType2(aryLblHolidayType2);
        vo.setAryLblHolidayType3(aryLblHolidayRange);
        vo.setAryLblRequestReason(aryLblRequestReason);
        vo.setAryLblState(aryLblWorkflowStatus);
        vo.setAryStateStyle(aryStatusStyle);
        vo.setAryLblApprover(aryLblApproverName);
        vo.setAryLblWorkflow(aryLblWorkflow);
        vo.setAryHolidayType1(aryHolidayType1);
        vo.setAryHolidayType2(aryHolidayType2);
        vo.setAryHolidayType3(aryHolidayRange);
        vo.setAryStartTime(aryStartTime);
        vo.setAryLblOnOff(aryLblOnOff);
        vo.setAryWorkflowStatus(aryWorkflowStatus);
        vo.setAryWorkflow(aryWorkflow);
    }

    protected String getHolidayType2(int holidayType1) {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        switch (holidayType1) {
            case 1: {
                return vo.getPltEditStatusWithPay();
            }
            case 2: {
                return vo.getPltEditStatusSpecial();
            }
            case 3: {
                return vo.getPltEditSpecialOther();
            }
            case 4: {
                return vo.getPltEditSpecialAbsence();
            }
        }
        return "";
    }

    protected int getHolidayRange(int holidayType1, String holidayType2) {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        if (holidayType1 == 1 && MospUtility.isEqual((Object)holidayType2, (Object)"1")) {
            return this.getInt(vo.getPltEditHolidayRangePaidHoliday());
        }
        return this.getInt(vo.getPltEditHolidayRange());
    }

    protected String getHolidayRange(HolidayRequestListDtoInterface dto) {
        int holidayRange = dto.getHolidayRange();
        if (holidayRange == 4) {
            return this.getTimeWaveFormat(dto.getStartTime(), dto.getEndTime(), dto.getRequestStartDate());
        }
        return TimeUtility.getHolidayRangeAbbr((MospParams)this.mospParams, (int)holidayRange);
    }

    protected Date getEditStartDate() {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        return this.getDate(vo.getPltEditStartYear(), vo.getPltEditStartMonth(), vo.getPltEditStartDay());
    }

    protected Date getEditEndDate() {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        return this.getDate(vo.getPltEditEndYear(), vo.getPltEditEndMonth(), vo.getPltEditEndDay());
    }

    protected Date getEditStartTime() throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        return DateUtility.addMinute((Date)DateUtility.addHour((Date)this.getEditStartDate(), (int)MospUtility.getInt((Object)vo.getPltEditStartHour())), (int)MospUtility.getInt((Object)vo.getPltEditStartMinute()));
    }

    protected void setVoFields(HolidayRequestDtoInterface dto) throws MospException {
        HolidayRequestVo vo = (HolidayRequestVo)this.mospParams.getVo();
        vo.setRecordId(dto.getTmdHolidayRequestId());
        vo.setPltEditStartYear(DateUtility.getStringYear((Date)dto.getRequestStartDate()));
        vo.setPltEditStartMonth(DateUtility.getStringMonthM((Date)dto.getRequestStartDate()));
        vo.setPltEditStartDay(DateUtility.getStringDayD((Date)dto.getRequestStartDate()));
        vo.setPltEditEndYear(DateUtility.getStringYear((Date)dto.getRequestEndDate()));
        vo.setPltEditEndMonth(DateUtility.getStringMonthM((Date)dto.getRequestEndDate()));
        vo.setPltEditEndDay(DateUtility.getStringDayD((Date)dto.getRequestEndDate()));
        vo.setPltEditHolidayType1(String.valueOf(dto.getHolidayType1()));
        if (dto.getHolidayType1() == 1) {
            vo.setPltEditStatusWithPay(dto.getHolidayType2());
        } else if (dto.getHolidayType1() == 2) {
            vo.setPltEditStatusSpecial(dto.getHolidayType2());
        } else if (dto.getHolidayType1() == 3) {
            vo.setPltEditSpecialOther(dto.getHolidayType2());
        } else {
            vo.setPltEditSpecialAbsence(dto.getHolidayType2());
        }
        if (dto.getHolidayType1() == 1 && 1 == this.getInt(dto.getHolidayType2())) {
            vo.setPltEditHolidayRangePaidHoliday(String.valueOf(dto.getHolidayRange()));
        } else {
            vo.setPltEditHolidayRange(String.valueOf(dto.getHolidayRange()));
        }
        vo.setPltEditStartHour(String.valueOf(DateUtility.getHour((Date)dto.getStartTime(), (Date)dto.getRequestStartDate())));
        vo.setPltEditStartMinute(DateUtility.getStringMinuteM((Date)dto.getStartTime()));
        vo.setPltEditEndTime(String.valueOf(dto.getUseHour()));
        vo.setTxtEditRequestReason(dto.getRequestReason());
        vo.setModeCardEdit(this.getApplicationMode(dto.getWorkflow()));
    }

    protected boolean chkActivationDateValidate() throws MospException {
        if (this.getEditStartDate().after(this.getEditEndDate())) {
            TimeMessageUtility.addErrorHolidayOrderInvalid((MospParams)this.mospParams, null);
            return true;
        }
        return false;
    }

    protected boolean isPaidLeaveHoliday(String personalId, Date startDate) throws MospException {
        List remains = this.timeReference().paidHolidayRemain().getPaidHolidayRemainsForRequest(personalId, startDate);
        for (HolidayRemainDto remain : remains) {
            if (!(remain.getRemainDays() > 0.0) && remain.getRemainHours() <= 0) continue;
            return true;
        }
        return false;
    }

    protected boolean isStockLeaveHoliday(String personalId, Date startDate) throws MospException {
        return this.timeReference().paidHolidayRemain().getStockHolidayRemainDaysForView(personalId, startDate) > 0.0;
    }

    protected String[][] getAryPltEditHolidayType2Paid(boolean paidLeave, boolean stockLeave) {
        String[][] array = this.mospParams.getProperties().getCodeArray("HolidayType2WithPay", false);
        int minus = 0;
        if (!paidLeave) {
            ++minus;
        }
        if (!stockLeave) {
            ++minus;
        }
        if (minus == 0) {
            return array;
        }
        String[][] paidArray = new String[array.length - minus][2];
        int i = 0;
        for (String[] holiday : array) {
            if (!paidLeave && Integer.toString(1).equals(holiday[0]) || !stockLeave && Integer.toString(2).equals(holiday[0])) continue;
            paidArray[i][0] = holiday[0];
            paidArray[i][1] = holiday[1];
            ++i;
        }
        return paidArray;
    }
}

