/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.input.action;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.TransStringUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.DifferenceRequestReferenceBeanInterface;
import jp.mosp.time.bean.DifferenceRequestRegistBeanInterface;
import jp.mosp.time.bean.DifferenceRequestSearchBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.comparator.settings.DifferenceRequestRequestDateComparator;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestListDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.input.vo.DifferenceRequestVo;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeRequestUtility;

public class DifferenceRequestAction
extends TimeAction {
    public static final String CMD_SHOW = "TM1000";
    public static final String CMD_SELECT_SHOW = "TM1001";
    public static final String CMD_SEARCH = "TM1002";
    public static final String CMD_RE_SEARCH = "TM1003";
    public static final String CMD_DRAFT = "TM1004";
    public static final String CMD_APPLI = "TM1005";
    public static final String CMD_WORKTIME_CALC = "TM1006";
    public static final String CMD_WITHDRAWN = "TM1007";
    public static final String CMD_SORT = "TM1008";
    public static final String CMD_PAGE = "TM1009";
    public static final String CMD_BATCH_WITHDRAWN = "TM1036";
    public static final String CMD_SET_ACTIVATION_DATE = "TM1090";
    public static final String CMD_INSERT_MODE = "TM1091";
    public static final String CMD_EDIT_MODE = "TM1092";
    public static final String CMD_BATCH_UPDATE = "TM1095";
    public static final String CMD_TRANSFER = "TM1096";
    public static final String CMD_SET_VIEW_PERIOD = "TM1097";
    public static final String CMD_SELECT_ACTIVATION_DATE = "TM1098";
    protected static final String CODE_FUNCTION = "6";

    public DifferenceRequestAction() {
        this.topicPathCommand = CMD_RE_SEARCH;
    }

    protected BaseVo getSpecificVo() {
        return new DifferenceRequestVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_DRAFT)) {
            this.prepareVo();
            this.draft();
        } else if (this.mospParams.getCommand().equals(CMD_APPLI)) {
            this.prepareVo();
            this.appli();
        } else if (this.mospParams.getCommand().equals(CMD_WORKTIME_CALC)) {
            this.prepareVo();
            this.workTimeCalc();
        } else if (this.mospParams.getCommand().equals(CMD_WITHDRAWN)) {
            this.prepareVo();
            this.withdrawn();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_WITHDRAWN)) {
            this.prepareVo();
            this.batchWithdrawn();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_SET_VIEW_PERIOD)) {
            this.prepareVo();
            this.setViewPeriod();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_ACTIVATION_DATE)) {
            this.prepareVo(false, false);
            this.selectActivationDate();
        }
    }

    protected void show() throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        String personalId = this.mospParams.getUser().getPersonalId();
        Date targetDate = this.getSystemDate();
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        vo.setComparatorName(DifferenceRequestRequestDateComparator.class.getName());
        this.search();
        this.isAvailable(this.getEditRequestDate(), CODE_FUNCTION);
    }

    protected void select() throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getSystemDate();
        if (personalId == null || personalId.isEmpty()) {
            personalId = this.mospParams.getUser().getPersonalId();
        }
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        vo.setComparatorName(DifferenceRequestRequestDateComparator.class.getName());
        this.search();
        this.isAvailable(this.getEditRequestDate(), CODE_FUNCTION);
    }

    protected void draft() throws MospException {
        Date startDate;
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        DifferenceRequestRegistBeanInterface regist = this.time().differenceRequestRegist();
        Date endDate = startDate = DateUtility.getDate((String)vo.getPltEditRequestYear(), (String)vo.getPltEditRequestMonth(), (String)vo.getPltEditRequestDay());
        if ("1".equals(vo.getCkbEndDate())) {
            endDate = DateUtility.getDate((String)vo.getPltEditEndYear(), (String)vo.getPltEditEndMonth(), (String)vo.getPltEditEndDay());
        }
        if (endDate.before(startDate)) {
            PfMessageUtility.addErrorInputValueInvalid((MospParams)this.mospParams, (String)PfNameUtility.term((MospParams)this.mospParams));
            return;
        }
        Date targetDate = startDate;
        while (!targetDate.after(endDate)) {
            if (this.reference().retirement().isRetired(vo.getPersonalId(), targetDate)) {
                this.addEmployeeRetiredMessage();
                return;
            }
            if (this.reference().suspension().isSuspended(vo.getPersonalId(), targetDate)) {
                this.addEmployeeSuspendedMessage();
                return;
            }
            DifferenceRequestDtoInterface dto = this.timeReference().differenceRequest().findForKey(vo.getRecordId());
            if (dto == null) {
                dto = regist.getInitDto();
            }
            if (targetDate.compareTo(startDate) != 0) {
                dto = regist.getInitDto();
            }
            this.setDtoFields(dto, targetDate);
            if (targetDate.compareTo(startDate) != 0) {
                dto.setTmdDifferenceRequestId(0L);
            }
            regist.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            regist.checkRequest(dto);
            if (this.mospParams.hasErrorMessage()) {
                this.mospParams.getErrorMessageList().clear();
                targetDate = DateUtility.addDay((Date)targetDate, (int)1);
                continue;
            }
            regist.checkDraft(dto);
            WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
            WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
            if (workflowDto == null) {
                workflowDto = workflowRegist.getInitDto();
                workflowDto.setFunctionCode(CODE_FUNCTION);
            }
            workflowRegist.setDtoApproverIds(workflowDto, this.getSelectApproverIds());
            workflowDto = workflowRegist.draft(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1);
            if (workflowDto != null) {
                this.platform().workflowCommentRegist().addComment(workflowDto, this.mospParams.getUser().getPersonalId(), PfMessageUtility.getDraftSucceed((MospParams)this.mospParams));
                dto.setWorkflow(workflowDto.getWorkflow());
                regist.regist(dto);
            }
            targetDate = DateUtility.addDay((Date)targetDate, (int)1);
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addDraftMessage();
        vo.setPltSearchRequestYear(vo.getPltEditRequestYear());
        vo.setPltSearchRequestMonth(vo.getPltEditRequestMonth());
        this.search();
        this.setEditUpdateMode(startDate);
        vo.setModeCardEdit("draft");
    }

    protected void appli() throws MospException {
        Date startDate;
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        DifferenceRequestRegistBeanInterface regist = this.time().differenceRequestRegist();
        Date endDate = startDate = DateUtility.getDate((String)vo.getPltEditRequestYear(), (String)vo.getPltEditRequestMonth(), (String)vo.getPltEditRequestDay());
        if ("1".equals(vo.getCkbEndDate())) {
            endDate = DateUtility.getDate((String)vo.getPltEditEndYear(), (String)vo.getPltEditEndMonth(), (String)vo.getPltEditEndDay());
        }
        if (endDate.before(startDate)) {
            PfMessageUtility.addErrorInputValueInvalid((MospParams)this.mospParams, (String)PfNameUtility.term((MospParams)this.mospParams));
            return;
        }
        Date targetDate = startDate;
        while (!targetDate.after(endDate)) {
            if (this.reference().retirement().isRetired(vo.getPersonalId(), targetDate)) {
                this.addEmployeeRetiredMessage();
                return;
            }
            if (this.reference().suspension().isSuspended(vo.getPersonalId(), targetDate)) {
                this.addEmployeeSuspendedMessage();
                return;
            }
            if (!this.isAvailable(targetDate, CODE_FUNCTION)) {
                return;
            }
            DifferenceRequestDtoInterface dto = this.timeReference().differenceRequest().findForKey(vo.getRecordId());
            if (dto == null) {
                dto = regist.getInitDto();
            }
            if (targetDate.compareTo(startDate) != 0) {
                dto = regist.getInitDto();
            }
            this.setDtoFields(dto, targetDate);
            if (targetDate.compareTo(startDate) != 0) {
                dto.setTmdDifferenceRequestId(0L);
            }
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            regist.checkRequest(dto);
            if (this.mospParams.hasErrorMessage()) {
                this.mospParams.getErrorMessageList().clear();
                targetDate = DateUtility.addDay((Date)targetDate, (int)1);
                continue;
            }
            regist.checkAppli(dto);
            WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
            WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
            if (workflowDto == null) {
                workflowDto = workflowRegist.getInitDto();
                workflowDto.setFunctionCode(CODE_FUNCTION);
            }
            workflowRegist.setDtoApproverIds(workflowDto, this.getSelectApproverIds());
            workflowDto = workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1, null);
            if (workflowDto != null) {
                dto.setWorkflow(workflowDto.getWorkflow());
                regist.regist(dto);
                regist.draftAttendance(dto);
            }
            targetDate = DateUtility.addDay((Date)targetDate, (int)1);
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addAppliMessage();
        this.setEditUpdateMode(startDate);
        if (!this.mospParams.hasErrorMessage()) {
            String searchYear = vo.getPltEditRequestYear();
            String searchMonth = vo.getPltEditRequestMonth();
            this.insertMode();
            vo.setPltSearchRequestYear(searchYear);
            vo.setPltSearchRequestMonth(searchMonth);
            this.search();
        }
    }

    protected void workTimeCalc() throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        Date editRequestDate = this.getEditRequestDate();
        DifferenceRequestReferenceBeanInterface differenceRequest = this.timeReference().differenceRequest(editRequestDate);
        if ("a".equals(vo.getPltEditDifferenceType())) {
            Date startTime = differenceRequest.getDifferenceStartTimeTypeA(editRequestDate);
            Date endTime = differenceRequest.getDifferenceEndTimeTypeA(editRequestDate);
            vo.setPltEditRequestHour(Integer.toString(DateUtility.getHour((Date)startTime)));
            vo.setPltEditRequestMinute(Integer.toString(DateUtility.getMinute((Date)startTime)));
            vo.setLblEndTimeHour(Integer.toString(DateUtility.getHour((Date)endTime, (Date)editRequestDate)));
            vo.setLblEndTimeMinute(Integer.toString(DateUtility.getMinute((Date)endTime)));
            vo.setJsEditDifferenceTypeMode("chaning");
            return;
        }
        if ("b".equals(vo.getPltEditDifferenceType())) {
            Date startTime = differenceRequest.getDifferenceStartTimeTypeB(editRequestDate);
            Date endTime = differenceRequest.getDifferenceEndTimeTypeB(editRequestDate);
            vo.setPltEditRequestHour(Integer.toString(DateUtility.getHour((Date)startTime)));
            vo.setPltEditRequestMinute(Integer.toString(DateUtility.getMinute((Date)startTime)));
            vo.setLblEndTimeHour(Integer.toString(DateUtility.getHour((Date)endTime, (Date)editRequestDate)));
            vo.setLblEndTimeMinute(Integer.toString(DateUtility.getMinute((Date)endTime)));
            vo.setJsEditDifferenceTypeMode("chaning");
            return;
        }
        if ("c".equals(vo.getPltEditDifferenceType())) {
            Date startTime = differenceRequest.getDifferenceStartTimeTypeC(editRequestDate);
            Date endTime = differenceRequest.getDifferenceEndTimeTypeC(editRequestDate);
            vo.setPltEditRequestHour(Integer.toString(DateUtility.getHour((Date)startTime)));
            vo.setPltEditRequestMinute(Integer.toString(DateUtility.getMinute((Date)startTime)));
            vo.setLblEndTimeHour(Integer.toString(DateUtility.getHour((Date)endTime, (Date)editRequestDate)));
            vo.setLblEndTimeMinute(Integer.toString(DateUtility.getMinute((Date)endTime)));
            vo.setJsEditDifferenceTypeMode("chaning");
            return;
        }
        if ("d".equals(vo.getPltEditDifferenceType())) {
            Date startTime = differenceRequest.getDifferenceStartTimeTypeD(editRequestDate);
            Date endTime = differenceRequest.getDifferenceEndTimeTypeD(editRequestDate);
            vo.setPltEditRequestHour(Integer.toString(DateUtility.getHour((Date)startTime)));
            vo.setPltEditRequestMinute(Integer.toString(DateUtility.getMinute((Date)startTime)));
            vo.setLblEndTimeHour(Integer.toString(DateUtility.getHour((Date)endTime, (Date)editRequestDate)));
            vo.setLblEndTimeMinute(Integer.toString(DateUtility.getMinute((Date)endTime)));
            vo.setJsEditDifferenceTypeMode("chaning");
            return;
        }
        if ("s".equals(vo.getPltEditDifferenceType())) {
            Date endTime = null;
            if (vo.getJsEditDifferenceTypeMode().equals("chaning")) {
                WorkTypeItemDtoInterface workStartDto = this.timeReference().workTypeItem().getWorkTypeItemInfo(vo.getLblWorkType(), this.getEditRequestDate(), "WorkStart");
                if (workStartDto == null) {
                    PfMessageUtility.addErrorNoItem((MospParams)this.mospParams, (String)TimeNamingUtility.workType((MospParams)this.mospParams));
                    vo.setModeActivateDate("chaning");
                    return;
                }
                endTime = differenceRequest.getDifferenceEndTimeTypeS(workStartDto.getWorkTypeItemValue());
                vo.setPltEditRequestHour(String.valueOf(DateUtility.getHour((Date)workStartDto.getWorkTypeItemValue())));
                vo.setPltEditRequestMinute(String.valueOf(DateUtility.getMinute((Date)workStartDto.getWorkTypeItemValue())));
            } else {
                Date startTime = DateUtility.getTime((int)Integer.parseInt(vo.getPltEditRequestHour()), (int)Integer.parseInt(vo.getPltEditRequestMinute()));
                endTime = differenceRequest.getDifferenceEndTimeTypeS(startTime);
            }
            vo.setLblEndTimeHour(Integer.toString(DateUtility.getHour((Date)endTime, (Date)DateUtility.getDefaultTime())));
            vo.setLblEndTimeMinute(Integer.toString(DateUtility.getMinute((Date)endTime)));
            vo.setJsEditDifferenceTypeMode("fixed");
        }
    }

    protected void withdrawn() throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        DifferenceRequestRegistBeanInterface regist = this.time().differenceRequestRegist();
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowCommentRegistBeanInterface workflowCommentRegist = this.platform().workflowCommentRegist();
        DifferenceRequestDtoInterface dto = this.timeReference().differenceRequest().findForKey(vo.getRecordId());
        this.checkSelectedDataExist((Object)dto);
        regist.checkWithdrawn(dto);
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        this.checkSelectedDataExist((Object)workflowDto);
        boolean isDraft = "0".equals(workflowDto.getWorkflowStatus());
        if (isDraft) {
            workflowRegist.delete(workflowDto);
            workflowCommentRegist.deleteList(this.reference().workflowComment().getWorkflowCommentList(workflowDto.getWorkflow()));
            regist.delete(dto);
        } else if ((workflowDto = workflowRegist.withdrawn(workflowDto)) != null) {
            workflowCommentRegist.addComment(workflowDto, this.mospParams.getUser().getPersonalId(), PfMessageUtility.getWithdrawSucceed((MospParams)this.mospParams));
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        if (isDraft) {
            PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        } else {
            this.addTakeDownMessage();
        }
        String searchYear = vo.getPltEditRequestYear();
        String searchMonth = vo.getPltEditRequestMonth();
        this.insertMode();
        vo.setPltSearchRequestYear(searchYear);
        vo.setPltSearchRequestMonth(searchMonth);
        this.search();
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void batchWithdrawn() throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        if (!this.isAvailable(this.getSystemDate(), CODE_FUNCTION)) {
            return;
        }
        this.time().differenceRequestRegist().withdrawn(this.getIdArray(vo.getCkbSelect()));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageBatchUpdatetFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addTakeDownMessage();
        String searchYear = vo.getPltSearchRequestYear();
        String searchMonth = vo.getPltSearchRequestMonth();
        this.insertMode();
        this.setSearchRequestDate(searchYear, searchMonth);
        this.search();
    }

    protected void setActivationDate() throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            if (this.reference().retirement().isRetired(vo.getPersonalId(), this.getEditRequestDate())) {
                this.addEmployeeRetiredMessage();
                return;
            }
            if (this.reference().suspension().isSuspended(vo.getPersonalId(), this.getEditRequestDate())) {
                this.addEmployeeSuspendedMessage();
                return;
            }
            if (!this.isAvailable(this.getEditRequestDate(), CODE_FUNCTION)) {
                return;
            }
            if (!this.setApproverPullDown(vo.getPersonalId(), this.getEditRequestDate(), 1)) {
                return;
            }
            DifferenceRequestRegistBeanInterface regist = this.time().differenceRequestRegist();
            DifferenceRequestDtoInterface dto = this.timeReference().differenceRequest().findForKey(vo.getRecordId());
            if (dto == null) {
                dto = regist.getInitDto();
            }
            dto.setPersonalId(vo.getPersonalId());
            dto.setRequestDate(this.getEditRequestDate());
            regist.checkTemporaryClosingFinal(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            regist.checkRequest(dto);
            regist.checkDifferenceOverlap(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            vo.setModeActivateDate("fixed");
            vo.setJsEditDifferenceTypeMode("fixed");
            this.setEditEndDate();
        } else {
            String[] aryPltLblApproverSetting = new String[]{};
            vo.setAryPltLblApproverSetting(aryPltLblApproverSetting);
            vo.setPltEditDifferenceType("a");
            vo.setPltEditRequestHour("8");
            vo.setPltEditRequestMinute("0");
            vo.setLblEndTimeHour("16");
            vo.setLblEndTimeMinute("00");
            vo.setCkbEndDate("0");
            vo.setModeActivateDate("chaning");
            vo.setJsEditDifferenceTypeMode("chaning");
        }
        this.getEditItems();
        this.setDifferenceTypePulldown();
    }

    protected void getEditItems() throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("fixed")) {
            WorkflowDtoInterface workflowDto;
            Date date = this.getEditRequestDate();
            SubstituteDtoInterface substituteDto = this.timeReference().substitute().getSubstituteDto(vo.getPersonalId(), this.getEditRequestDate());
            if (substituteDto != null && WorkflowUtility.isCompleted((WorkflowDtoInterface)(workflowDto = this.reference().workflow().getLatestWorkflowInfo(substituteDto.getWorkflow())))) {
                date = substituteDto.getSubstituteDate();
            }
            String workTypeCode = this.timeReference().scheduleUtil().getScheduledWorkTypeCode(vo.getPersonalId(), date);
            if (this.mospParams.hasErrorMessage()) {
                vo.setModeActivateDate("chaning");
                return;
            }
            WorkTypeDtoInterface workTypeDto = this.timeReference().workType().getWorkTypeInfo(workTypeCode, date);
            if (workTypeDto == null) {
                PfMessageUtility.addErrorNoItem((MospParams)this.mospParams, (String)TimeNamingUtility.workType((MospParams)this.mospParams));
                vo.setModeActivateDate("chaning");
                return;
            }
            vo.setLblWorkType(workTypeDto.getWorkTypeCode());
            vo.setLblWorkTypeName(this.timeReference().workType().getWorkTypeAbbrAndTime(workTypeDto.getWorkTypeCode(), date));
            this.workTimeCalc();
            return;
        }
        vo.setLblWorkType("");
        vo.setLblWorkTypeName("");
        vo.setPltEditRequestHour("");
        vo.setPltEditRequestMinute("");
        vo.setLblEndTimeHour("");
        vo.setLblEndTimeMinute("");
    }

    public void setDefaultValues() {
        Date date;
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        Date targetDate = date = this.getSystemDate();
        if (this.getTargetDate() != null) {
            targetDate = this.getTargetDate();
        }
        String targetYear = String.valueOf(DateUtility.getYear((Date)targetDate));
        String targetMonth = String.valueOf(DateUtility.getMonth((Date)targetDate));
        String targetDay = String.valueOf(DateUtility.getDay((Date)targetDate));
        vo.setRecordId(0L);
        vo.setPltEditRequestYear(targetYear);
        vo.setPltEditRequestMonth(targetMonth);
        vo.setPltEditRequestDay(targetDay);
        vo.setPltEditEndYear(targetYear);
        vo.setPltEditEndMonth(targetMonth);
        vo.setPltEditEndDay(targetDay);
        vo.setPltEditRequestType("");
        vo.setPltEditDifferenceType("a");
        vo.setPltEditRequestHour("0");
        vo.setPltEditRequestMinute("0");
        vo.setLblEndTimeHour("");
        vo.setLblEndTimeMinute("");
        vo.setTxtEditRequestReason("");
        vo.setLblWorkType("");
        vo.setLblWorkTypeName("");
        vo.setLblEndTimeHour("");
        vo.setLblEndTimeMinute("");
        vo.setPltSearchState("");
        vo.setPltSearchRequestHour("");
        vo.setPltSearchRequestMinute("");
        vo.setPltSearchRequestYear(String.valueOf(DateUtility.getYear((Date)date)));
        vo.setPltSearchRequestMonth(String.valueOf(DateUtility.getMonth((Date)date)));
        vo.setCkbEndDate("");
        String[] aryPltLblApproverSetting = new String[]{};
        vo.setAryPltLblApproverSetting(aryPltLblApproverSetting);
        vo.setPltApproverSetting1("");
        vo.setPltApproverSetting2("");
        vo.setPltApproverSetting3("");
        vo.setPltApproverSetting4("");
        vo.setPltApproverSetting5("");
        vo.setPltApproverSetting6("");
        vo.setPltApproverSetting7("");
        vo.setPltApproverSetting8("");
        vo.setPltApproverSetting9("");
        vo.setPltApproverSetting10("");
        vo.setJsEditDifferenceTypeMode("chaning");
    }

    protected void setSearchRequestDate(String year, String month) {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        vo.setPltSearchRequestYear(year);
        vo.setPltSearchRequestMonth(month);
    }

    private void setPulldown() {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        vo.setAryPltEditRequestYear(this.getYearArray(DateUtility.getYear((Date)date)));
        vo.setAryPltEditRequestMonth(this.getMonthArray());
        vo.setAryPltEditRequestDay(this.getDayArray());
        vo.setAryPltEditRequestHour(this.getHourArray());
        vo.setAryPltEditRequestMinute(this.getMinuteArray(15));
        vo.setAryPltEditEndYear(this.getYearArray(DateUtility.getYear((Date)date)));
        vo.setAryPltEditEndMonth(this.getMonthArray());
        vo.setAryPltEditEndDay(this.getDayArray());
        vo.setAryPltSearchState(this.mospParams.getProperties().getCodeArray("ApprovalState", true));
        vo.setAryPltSearchRequestYear(this.getYearArray(DateUtility.getYear((Date)date)));
        vo.setAryPltSearchRequestMonth(this.getMonthArray(true));
    }

    protected void setDifferenceTypePulldown() throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        vo.setAryPltEditDifferenceType(this.timeReference().differenceRequest(this.getEditRequestDate()).getSelectArray());
    }

    protected void insertMode() throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        this.setDefaultValues();
        vo.setModeCardEdit("new");
        this.setPulldown();
        this.setDifferenceTypePulldown();
        vo.setModeActivateDate("chaning");
        vo.setJsSearchActivateDateMode("fixed");
        this.setSearchPulldown();
        this.timeReference().differenceRequest().chkBasicInfo(vo.getPersonalId(), this.getEditRequestDate());
    }

    protected void search() throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        DifferenceRequestSearchBeanInterface search = this.timeReference().differenceRequestSearch();
        String personalId = vo.getPersonalId();
        search.setPersonalId(personalId);
        search.setWorkflowStatus(vo.getPltSearchState());
        search.setWorkTypeCode(vo.getPltSearchWorkType());
        if (vo.getPltSearchWorkType() == null) {
            search.setWorkTypeCode(vo.getAryPltSearchWorkType()[0][0]);
        }
        int year = Integer.parseInt(vo.getPltSearchRequestYear());
        int startMonth = this.getInt("1");
        int endMonth = this.getInt("12");
        if (!MospUtility.isEmpty((String[])new String[]{vo.getPltSearchRequestMonth()})) {
            endMonth = startMonth = this.getInt(vo.getPltSearchRequestMonth());
        }
        TimeMasterBeanInterface timeMaster = this.timeReference().master();
        ApplicationEntity applicationFrom = timeMaster.getApplicationEntity(personalId, year, startMonth);
        ApplicationEntity applicationTo = timeMaster.getApplicationEntity(personalId, year, endMonth);
        Date firstDate = applicationFrom.getCutoffEntity().getCutoffFirstDate(year, startMonth, this.mospParams);
        Date lastDate = applicationTo.getCutoffEntity().getCutoffLastDate(year, endMonth, this.mospParams);
        search.setRequestStartDate(firstDate);
        search.setRequestEndDate(lastDate);
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(DifferenceRequestRequestDateComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty() && this.mospParams.getCommand().equals(CMD_SEARCH)) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected Date getEditRequestDate() {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        return this.getDate(vo.getPltEditRequestYear(), vo.getPltEditRequestMonth(), vo.getPltEditRequestDay());
    }

    protected Date getSearchRequestDate() {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        Date date = vo.getPltSearchRequestMonth().isEmpty() ? this.getDate(vo.getPltSearchRequestYear(), "1", "1") : this.getDate(vo.getPltSearchRequestYear(), vo.getPltSearchRequestMonth(), "1");
        return date;
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        String[] aryCkbRecordId = new String[list.size()];
        String[] aryLblDate = new String[list.size()];
        String[] aryLblRequestType = new String[list.size()];
        String[] aryLblWorkTime = new String[list.size()];
        String[] aryLblRequestReason = new String[list.size()];
        String[] aryLblState = new String[list.size()];
        String[] aryStateStyle = new String[list.size()];
        String[] aryLblApprover = new String[list.size()];
        String[] aryLblOnOff = new String[list.size()];
        String[] aryWorkflowStatus = new String[list.size()];
        long[] aryWorkflow = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            DifferenceRequestListDtoInterface dto = (DifferenceRequestListDtoInterface)list.get(i);
            aryCkbRecordId[i] = String.valueOf(dto.getTmdDifferenceRequestId());
            aryLblDate[i] = DateUtility.getStringDateAndDay((Date)dto.getRequestDate());
            aryLblRequestType[i] = TimeRequestUtility.getDifferenceTypeAbbr((String)dto.getAroundType(), (MospParams)this.mospParams);
            aryLblWorkTime[i] = TransStringUtility.getHourColonMinuteTerm((MospParams)this.mospParams, (Date)dto.getStartTime(), (Date)dto.getEndTime(), (Date)dto.getRequestDate());
            aryLblRequestReason[i] = dto.getRequestReason();
            aryLblState[i] = this.getStatusStageValueView(dto.getState(), dto.getStage());
            aryStateStyle[i] = this.getStatusColor(dto.getState());
            aryLblOnOff[i] = this.getButtonOnOff(dto.getState(), dto.getStage());
            aryLblApprover[i] = dto.getApproverName();
            aryWorkflowStatus[i] = dto.getState();
            aryWorkflow[i] = dto.getWorkflow();
        }
        vo.setAryCkbDifferenceRequestListId(aryCkbRecordId);
        vo.setAryLblDate(aryLblDate);
        vo.setAryLblRequestType(aryLblRequestType);
        vo.setAryLblWorkTime(aryLblWorkTime);
        vo.setAryLblRequestReason(aryLblRequestReason);
        vo.setAryLblState(aryLblState);
        vo.setAryStateStyle(aryStateStyle);
        vo.setAryLblApprover(aryLblApprover);
        vo.setAryLblOnOff(aryLblOnOff);
        vo.setAryWorkflowStatus(aryWorkflowStatus);
        vo.setAryWorkflow(aryWorkflow);
    }

    protected void batchUpdate() throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        if (!this.isAvailable(this.getSystemDate(), CODE_FUNCTION)) {
            return;
        }
        this.time().differenceRequestRegist().update(this.getIdArray(vo.getCkbSelect()));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageBatchUpdatetFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageUpdatetSucceed((MospParams)this.mospParams);
        this.insertMode();
        this.search();
    }

    protected void transfer() throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        this.setTargetWorkflow(vo.getAryWorkflow(this.getTransferredIndex()));
        this.mospParams.setNextCommand("TM1861");
    }

    protected void setViewPeriod() throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        if (vo.getJsSearchActivateDateMode().equals("chaning")) {
            vo.setJsSearchActivateDateMode("fixed");
        } else {
            vo.setJsSearchActivateDateMode("chaning");
        }
        this.setSearchPulldown();
    }

    protected void selectActivationDate() throws MospException {
        String transferredEndMinute;
        String transferredEndHour;
        String transferredStartMinute;
        String transferredStartHour;
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        this.select();
        this.setActivationDate();
        String transferredType = this.getTransferredType();
        if (transferredType != null) {
            vo.setPltEditDifferenceType(transferredType);
        }
        if ((transferredStartHour = this.getTransferredStartHour()) != null) {
            vo.setPltEditRequestHour(transferredStartHour);
        }
        if ((transferredStartMinute = this.getTransferredStartMinute()) != null) {
            vo.setPltEditRequestMinute(transferredStartMinute);
        }
        if ((transferredEndHour = this.getTransferredEndHour()) != null) {
            vo.setLblEndTimeHour(transferredEndHour);
        }
        if ((transferredEndMinute = this.getTransferredEndMinute()) != null) {
            vo.setLblEndTimeMinute(transferredEndMinute);
        }
    }

    private void setSearchPulldown() throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        if (vo.getJsSearchActivateDateMode().equals("fixed")) {
            vo.setAryPltSearchWorkType(this.timeReference().workType().getTimeSelectArray(this.getSearchRequestDate()));
            this.doAdditionalLogic("ChangeWorkTypePulldown");
            return;
        }
        vo.setAryPltSearchWorkType(new String[0][0]);
    }

    protected void editMode() throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getSystemDate();
        if (personalId != null) {
            this.setEmployeeInfo(personalId, targetDate);
            this.setPageInfo(CMD_PAGE, this.getListLength());
            this.insertMode();
            vo.setComparatorName(DifferenceRequestRequestDateComparator.class.getName());
            this.search();
        }
        this.setEditUpdateMode(this.getDate(this.getTransferredActivateDate()));
        vo.setModeActivateDate("chaning");
        this.setActivationDate();
    }

    protected void setEditUpdateMode(Date requestDate) throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        DifferenceRequestDtoInterface dto = this.timeReference().differenceRequest().findForKeyOnWorkflow(vo.getPersonalId(), requestDate);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
    }

    protected void setEditEndDate() {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        vo.setPltEditEndYear(vo.getPltEditRequestYear());
        vo.setPltEditEndMonth(vo.getPltEditRequestMonth());
        vo.setPltEditEndDay(vo.getPltEditRequestDay());
    }

    protected void setVoFields(DifferenceRequestDtoInterface dto) throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        int year = DateUtility.getYear((Date)dto.getRequestDate());
        int month = DateUtility.getMonth((Date)dto.getRequestDate());
        int day = DateUtility.getDay((Date)dto.getRequestDate());
        vo.setRecordId(dto.getTmdDifferenceRequestId());
        vo.setPltEditRequestYear(String.valueOf(year));
        vo.setPltEditRequestMonth(String.valueOf(month));
        vo.setPltEditRequestDay(String.valueOf(day));
        vo.setPltEditEndYear(String.valueOf(year));
        vo.setPltEditEndMonth(String.valueOf(month));
        vo.setPltEditEndDay(String.valueOf(day));
        vo.setPltEditRequestHour(String.valueOf(DateUtility.getHour((Date)dto.getRequestStart())));
        vo.setPltEditRequestMinute(String.valueOf(DateUtility.getMinute((Date)dto.getRequestStart())));
        vo.setPltEditDifferenceType(dto.getDifferenceType());
        vo.setLblWorkType(dto.getWorkTypeCode());
        vo.setLblEndTimeHour(DateUtility.getStringHour((Date)dto.getRequestEnd(), (Date)dto.getRequestDate()));
        vo.setLblEndTimeMinute(DateUtility.getStringMinute((Date)dto.getRequestEnd()));
        vo.setTxtEditRequestReason(dto.getRequestReason());
        vo.setModeCardEdit(this.getApplicationMode(dto.getWorkflow()));
    }

    protected void setDtoFields(DifferenceRequestDtoInterface dto, Date date) throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        dto.setTmdDifferenceRequestId(vo.getRecordId());
        dto.setPersonalId(vo.getPersonalId());
        dto.setRequestDate(date);
        dto.setTimesWork(1);
        dto.setDifferenceType(vo.getPltEditDifferenceType());
        dto.setWorkTypeCode(this.getWorkTypeCode(date));
        Date startTime = this.getStartTime(date);
        dto.setRequestStart(startTime);
        dto.setRequestEnd(this.getEndTime(date, startTime));
        dto.setRequestReason(vo.getTxtEditRequestReason());
    }

    protected String getWorkTypeCode(Date date) throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        ScheduleUtilBeanInterface scheduleUtil = this.timeReference().scheduleUtil();
        RequestUtilBeanInterface requestUtil = this.timeReference().requestUtil();
        requestUtil.setRequests(vo.getPersonalId(), date);
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = requestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto != null && workOnHolidayRequestDto.getSubstitute() == 1) {
            List list = this.timeReference().substitute().getSubstituteList(workOnHolidayRequestDto.getWorkflow());
            if (list.isEmpty()) {
                return "";
            }
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                SubstituteDtoInterface dto = (SubstituteDtoInterface)iterator.next();
                return scheduleUtil.getScheduledWorkTypeCode(vo.getPersonalId(), dto.getSubstituteDate());
            }
        }
        return scheduleUtil.getScheduledWorkTypeCode(vo.getPersonalId(), date);
    }

    protected Date getStartTime(Date date) throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        DifferenceRequestReferenceBeanInterface differenceRequest = this.timeReference().differenceRequest(date);
        if (differenceRequest.isDifferenceTypeA(vo.getPltEditDifferenceType())) {
            return differenceRequest.getDifferenceStartTimeTypeA(date);
        }
        if (differenceRequest.isDifferenceTypeB(vo.getPltEditDifferenceType())) {
            return differenceRequest.getDifferenceStartTimeTypeB(date);
        }
        if (differenceRequest.isDifferenceTypeC(vo.getPltEditDifferenceType())) {
            return differenceRequest.getDifferenceStartTimeTypeC(date);
        }
        if (differenceRequest.isDifferenceTypeD(vo.getPltEditDifferenceType())) {
            return differenceRequest.getDifferenceStartTimeTypeD(date);
        }
        if (differenceRequest.isDifferenceTypeS(vo.getPltEditDifferenceType())) {
            return DateUtility.getDateTime((int)DateUtility.getYear((Date)date), (int)DateUtility.getMonth((Date)date), (int)DateUtility.getDay((Date)date), (int)Integer.parseInt(vo.getPltEditRequestHour()), (int)Integer.parseInt(vo.getPltEditRequestMinute()));
        }
        return null;
    }

    protected Date getEndTime(Date date, Date startTime) throws MospException {
        DifferenceRequestVo vo = (DifferenceRequestVo)this.mospParams.getVo();
        DifferenceRequestReferenceBeanInterface differenceRequest = this.timeReference().differenceRequest(date);
        if (differenceRequest.isDifferenceTypeA(vo.getPltEditDifferenceType())) {
            return differenceRequest.getDifferenceEndTimeTypeA(date);
        }
        if (differenceRequest.isDifferenceTypeB(vo.getPltEditDifferenceType())) {
            return differenceRequest.getDifferenceEndTimeTypeB(date);
        }
        if (differenceRequest.isDifferenceTypeC(vo.getPltEditDifferenceType())) {
            return differenceRequest.getDifferenceEndTimeTypeC(date);
        }
        if (differenceRequest.isDifferenceTypeD(vo.getPltEditDifferenceType())) {
            return differenceRequest.getDifferenceEndTimeTypeD(date);
        }
        if (differenceRequest.isDifferenceTypeS(vo.getPltEditDifferenceType())) {
            return differenceRequest.getDifferenceEndTimeTypeS(startTime);
        }
        return null;
    }
}

