/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.input.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.instance.InstanceFactory;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.TopicPathUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.base.AttendanceListBaseAction;
import jp.mosp.time.base.AttendanceListBaseVo;
import jp.mosp.time.bean.AttendanceListAddonBeanInterface;
import jp.mosp.time.bean.AttendanceListReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceListRegistBeanInterface;
import jp.mosp.time.comparator.settings.CutoffErrorListDateComparator;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.CutoffErrorListDtoInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.input.action.ApprovalHistoryAction;
import jp.mosp.time.input.action.AttendanceCardAction;
import jp.mosp.time.input.action.AttendanceHistoryAction;
import jp.mosp.time.input.vo.AttendanceListVo;
import jp.mosp.time.management.action.ApprovalCardAction;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeUtility;

public class AttendanceListAction
extends AttendanceListBaseAction {
    public static final String CMD_SHOW = "TM1100";
    public static final String CMD_SELECT_SHOW = "TM1101";
    public static final String CMD_SEARCH = "TM1102";
    public static final String CMD_RE_SHOW = "TM1103";
    public static final String CMD_DRAFT = "TM1104";
    public static final String CMD_APPLI = "TM1105";
    public static final String CMD_TRANSFER = "TM1106";
    public static final String CMD_TOTAL = "TM1107";
    public static final String CMD_OUTPUT = "TM1196";
    public static final String CMD_SHOW_APPROVAL = "TM2421";
    public static final String CMD_APPROVE = "TM2425";

    public AttendanceListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new AttendanceListVo();
    }

    protected BaseVo prepareVo(boolean useStoredVo, boolean useParametersMapper) throws MospException {
        AttendanceListVo vo = (AttendanceListVo)super.prepareVo(useStoredVo, useParametersMapper);
        if (!useParametersMapper) {
            return vo;
        }
        vo.getAddonParameters().putAll(this.mospParams.getRequestParamsMap());
        for (AttendanceListAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.mapping();
        }
        return vo;
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SHOW_APPROVAL)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_DRAFT)) {
            this.prepareVo();
            this.draft();
        } else if (this.mospParams.getCommand().equals(CMD_APPLI)) {
            this.prepareVo();
            this.appli();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_TOTAL)) {
            this.prepareVo(true, false);
            this.total();
        } else if (this.mospParams.getCommand().equals(CMD_APPROVE)) {
            this.prepareVo();
            this.approve();
        } else if (this.mospParams.getCommand().equals(CMD_OUTPUT)) {
            this.prepareVo(true, false);
            this.output();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected void show() throws MospException {
        this.init();
        AttendanceListBaseVo vo = (AttendanceListBaseVo)this.mospParams.getVo();
        vo.setShowCommand(this.mospParams.getCommand());
        String personalId = this.mospParams.getUser().getPersonalId();
        Date targetDate = this.getSystemDate();
        this.initVoFields(personalId, DateUtility.getYear((Date)targetDate), DateUtility.getMonth((Date)targetDate));
        AttendanceListReferenceBeanInterface attendanceListReference = this.timeReference().attendanceList();
        List list = attendanceListReference.getAttendanceList(personalId, targetDate);
        this.setVoList(list);
        this.setVoFields(list);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
            return;
        }
        this.checkCutoffState();
    }

    protected void select() throws MospException {
        this.init();
        AttendanceListBaseVo vo = (AttendanceListBaseVo)this.mospParams.getVo();
        vo.setShowCommand(this.mospParams.getCommand());
        if (vo.getShowCommand().equals(CMD_SHOW_APPROVAL)) {
            TopicPathUtility.setTopicPathName((MospParams)this.mospParams, (String)vo.getClassName(), (String)TimeNamingUtility.attendanceApprovalList((MospParams)this.mospParams));
        }
        String personalId = this.getTargetPersonalId();
        int targetYear = this.getTargetYear();
        int targetMonth = this.getTargetMonth();
        this.initVoFields(personalId, targetYear, targetMonth);
        List list = Collections.emptyList();
        AttendanceListReferenceBeanInterface attendanceListReference = this.timeReference().attendanceList();
        list = MospUtility.isEqual((Object)vo.getShowCommand(), (Object)CMD_SHOW_APPROVAL) ? attendanceListReference.getApprovalAttendanceList(personalId, targetYear, targetMonth) : attendanceListReference.getAttendanceList(personalId, targetYear, targetMonth);
        this.setVoList(list);
        this.setVoFields(list);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
            return;
        }
        this.checkCutoffState();
    }

    protected void search() throws MospException {
        this.init();
        AttendanceListBaseVo vo = (AttendanceListBaseVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        int cutoffDate = vo.getCutoffDate();
        String searchMode = this.mospParams.getRequestParam("transferSearch");
        if (MospUtility.isEqual((Object)searchMode, (Object)"searchBack")) {
            personalId = vo.getPrevPersonalId();
            cutoffDate = 0;
        }
        if (MospUtility.isEqual((Object)searchMode, (Object)"searchNext")) {
            cutoffDate = 0;
            personalId = vo.getNextPersonalId();
        }
        String year = this.getTransferredYear();
        String month = this.getTransferredMonth();
        if (year == null || month == null) {
            year = vo.getPltSelectYear();
            month = vo.getPltSelectMonth();
        }
        int targetYear = this.getInt(year);
        int targetMonth = this.getInt(month);
        this.initVoFields(personalId, targetYear, targetMonth);
        List list = Collections.emptyList();
        AttendanceListReferenceBeanInterface attendanceListReference = this.timeReference().attendanceList();
        list = MospUtility.isEqual((Object)vo.getShowCommand(), (Object)CMD_SHOW_APPROVAL) ? attendanceListReference.getApprovalAttendanceList(personalId, targetYear, targetMonth) : attendanceListReference.getAttendanceList(personalId, targetYear, targetMonth, cutoffDate);
        this.setVoList(list);
        this.setVoFields(list);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
            return;
        }
        this.checkCutoffState();
    }

    protected void output() throws MospException {
        AttendanceListBaseVo vo = (AttendanceListBaseVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        int cutoffDate = vo.getCutoffDate();
        int year = this.getInt(vo.getPltSelectYear());
        int month = this.getInt(vo.getPltSelectMonth());
        this.timeReference().attendanceBook().makeAttendanceBook(personalId, year, month, cutoffDate);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void draft() throws MospException {
        this.setRequestedTimes();
        AttendanceListVo vo = (AttendanceListVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        String[] targetDates = vo.getCkbSelect();
        String[] startTimes = vo.getTxtStartTime();
        String[] endTimes = vo.getTxtEndTime();
        this.time().attendanceListRegist(DateUtility.getDate((String)targetDates[0])).draft(personalId, targetDates, startTimes, endTimes, false, false, false);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageBatchUpdatetFailed((MospParams)this.mospParams);
            return;
        }
        for (AttendanceListAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.draft();
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
        this.commit();
        this.addDraftMessage();
        this.search();
    }

    protected void appli() throws MospException {
        this.setRequestedTimes();
        AttendanceListVo vo = (AttendanceListVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        String[] targetDates = vo.getCkbSelect();
        String[] startTimes = vo.getTxtStartTime();
        String[] endTimes = vo.getTxtEndTime();
        AttendanceListRegistBeanInterface attendanceListRegist = this.time().attendanceListRegist(DateUtility.getDate((String)targetDates[0]));
        attendanceListRegist.apply(personalId, targetDates, startTimes, endTimes);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageBatchUpdatetFailed((MospParams)this.mospParams);
            return;
        }
        for (AttendanceListAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.appli();
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
        this.commit();
        this.addAppliMessage();
        attendanceListRegist.checkOvertime(personalId, targetDates);
        this.search();
    }

    protected void transfer() {
        AttendanceListVo vo = (AttendanceListVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        if (actionName.equals(AttendanceCardAction.class.getName())) {
            this.setTargetPersonalId(vo.getPersonalId());
            this.setTargetDate(this.getDate(vo.getAryDate(this.getTransferredIndex())));
            this.mospParams.setNextCommand("TM1201");
        } else if (actionName.equals(AttendanceHistoryAction.class.getName())) {
            this.setTargetPersonalId(vo.getPersonalId());
            this.setTargetDate(this.getDate(vo.getAryDate(this.getTransferredIndex())));
            this.mospParams.setNextCommand("TM1911");
        } else if (actionName.equals(ApprovalHistoryAction.class.getName())) {
            this.setTargetWorkflow(vo.getAryWorkflow(this.getTransferredIndex()));
            this.mospParams.setNextCommand("TM1811");
        } else if (actionName.equals(ApprovalCardAction.class.getName())) {
            this.setTargetWorkflow(vo.getAryWorkflow(this.getTransferredIndex()));
            this.mospParams.setNextCommand("TM2321");
        }
    }

    protected void total() throws MospException {
        AttendanceListVo vo = (AttendanceListVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        int targetYear = this.getInt(vo.getPltSelectYear());
        int targetMonth = this.getInt(vo.getPltSelectMonth());
        List list = this.time().totalTimeCalc().tightening(personalId, targetYear, targetMonth);
        if (this.mospParams.hasErrorMessage() || !list.isEmpty()) {
            TimeMessageUtility.addMessageTotalFailed((MospParams)this.mospParams);
            Collections.sort(list, InstanceFactory.loadComparator((String)CutoffErrorListDateComparator.class.getName()));
            for (CutoffErrorListDtoInterface dto : list) {
                TimeMessageUtility.addErrorCutoff((MospParams)this.mospParams, (CutoffErrorListDtoInterface)dto);
            }
            return;
        }
        for (AttendanceListAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.total();
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
        this.commit();
        TimeMessageUtility.addMessageTotalSucceed((MospParams)this.mospParams);
        this.search();
    }

    protected void approve() throws MospException {
        AttendanceListVo vo = (AttendanceListVo)this.mospParams.getVo();
        String[] targetDates = vo.getCkbSelect();
        ArrayList<Long> list = new ArrayList<Long>();
        for (String date : targetDates) {
            AttendanceDtoInterface dto = this.timeReference().attendance().findForKey(vo.getPersonalId(), this.getDate(date));
            if (dto == null) continue;
            list.add(dto.getWorkflow());
        }
        long[] aryWorkflow = MospUtility.toArrayLong(list);
        this.time().timeApproval().approve(aryWorkflow, null);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageUpdateFailed((MospParams)this.mospParams);
            return;
        }
        for (AttendanceListAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.approve();
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
        this.commit();
        this.addApprovalMessage();
        this.search();
    }

    protected void init() throws MospException {
        AttendanceListVo vo = (AttendanceListVo)this.mospParams.getVo();
        vo.setAddonJsps(this.getAddonJsps());
        for (AttendanceListAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.init();
        }
    }

    protected void setVoFields(List<AttendanceListDto> list) throws MospException {
        super.setVoFields(list);
        for (AttendanceListAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.setVoFields(list);
        }
    }

    protected void setRequestedTimes() {
        AttendanceListVo vo = (AttendanceListVo)this.mospParams.getVo();
        String[] targetDates = vo.getCkbSelect();
        String[] startTimes = vo.getTxtStartTime();
        String[] endTimes = vo.getTxtEndTime();
        String[] lblDates = vo.getAryDate();
        String[] lblStartTimes = vo.getAryLblStartTime();
        String[] lblEndTimes = vo.getAryLblEndTime();
        for (int i = 0; i < targetDates.length; ++i) {
            for (int j = 0; j < lblDates.length; ++j) {
                if (!targetDates[i].equals(lblDates[j])) continue;
                lblStartTimes[j] = startTimes[i];
                lblEndTimes[j] = endTimes[i];
            }
        }
        vo.setAryLblStartTime(lblStartTimes);
        vo.setAryLblEndTime(lblEndTimes);
    }

    protected void checkCutoffState() throws MospException {
        AttendanceListVo vo = (AttendanceListVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        int targetYear = this.getInt(vo.getPltSelectYear());
        int targetMonth = this.getInt(vo.getPltSelectMonth());
        int cutoffDate = vo.getCutoffDate();
        boolean isNotTighten = this.timeReference().cutoffUtil().isNotTighten(personalId, targetYear, targetMonth);
        if (!isNotTighten) {
            vo.setTotalButtonVisible(false);
            if (!this.mospParams.getCommand().equals(CMD_TOTAL)) {
                TimeMessageUtility.addErrorTheMonthIsTighten((MospParams)this.mospParams, (int)targetYear, (int)targetMonth);
            }
            return;
        }
        Date targetDate = TimeUtility.getCutoffLastDate((int)cutoffDate, (int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        ApplicationEntity application = this.timeReference().application().getApplicationEntity(personalId, targetDate);
        vo.setTotalButtonVisible(application.isSelfTightening());
    }

    protected void setVoList(List<AttendanceListDto> list) {
        super.setVoList(list);
        AttendanceListVo vo = (AttendanceListVo)this.mospParams.getVo();
        String[] aryDate = new String[list.size()];
        String[] aryLblStartRecordTime = new String[list.size()];
        String[] aryLblEndRecordTime = new String[list.size()];
        String[] aryLblPrivateTime = new String[list.size()];
        String[] aryLblLateTime = new String[list.size()];
        String[] aryLblLeaveEarlyTime = new String[list.size()];
        String[] aryLblLateLeaveEarlyTime = new String[list.size()];
        String[] aryLblOverTimeIn = new String[list.size()];
        String[] aryOvertimeStyle = new String[list.size()];
        String[] aryLblOverTimeOut = new String[list.size()];
        String[] aryLblWorkOnHoliday = new String[list.size()];
        String[] aryLblShortUnpaid = new String[list.size()];
        String[] aryLblLateNight = new String[list.size()];
        String[] aryLblState = new String[list.size()];
        String[] aryStateStyle = new String[list.size()];
        boolean[] aryLinkState = new boolean[list.size()];
        boolean[] aryCheckState = new boolean[list.size()];
        String[] aryLblCorrection = new String[list.size()];
        long[] aryWorkflow = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            AttendanceListDto dto = list.get(i);
            aryDate[i] = this.getStringDate(dto.getWorkDate());
            aryLblStartRecordTime[i] = dto.getStartRecordTimeString();
            aryLblEndRecordTime[i] = dto.getEndRecordTimeString();
            aryLblPrivateTime[i] = dto.getPrivateTimeString();
            aryLblLateTime[i] = dto.getLateTimeString();
            aryLblLeaveEarlyTime[i] = dto.getLeaveEarlyTimeString();
            aryLblLateLeaveEarlyTime[i] = dto.getLateLeaveEarlyTimeString();
            aryLblOverTimeIn[i] = dto.getOvertimeInString();
            aryOvertimeStyle[i] = dto.getOvertimeStyle();
            aryLblOverTimeOut[i] = dto.getOvertimeOutString();
            aryLblWorkOnHoliday[i] = dto.getHolidayWorkTimeString();
            aryLblShortUnpaid[i] = dto.getShortUnpaidString();
            aryLblLateNight[i] = dto.getLateNightTimeString();
            aryLblState[i] = dto.getApplicationInfo();
            aryStateStyle[i] = this.getAttendanceStateColor(dto.getApplicationInfo());
            aryLinkState[i] = dto.isNeedStatusLink();
            aryCheckState[i] = dto.isNeedCheckbox();
            aryLblCorrection[i] = dto.getCorrectionInfo();
            aryWorkflow[i] = dto.getWorkflow();
        }
        vo.setAryDate(aryDate);
        vo.setAryLblStartRecordTime(aryLblStartRecordTime);
        vo.setAryLblEndRecordTime(aryLblEndRecordTime);
        vo.setAryLblPrivateTime(aryLblPrivateTime);
        vo.setAryLblLateTime(aryLblLateTime);
        vo.setAryLblLeaveEarlyTime(aryLblLeaveEarlyTime);
        vo.setAryLblLateLeaveEarlyTime(aryLblLateLeaveEarlyTime);
        vo.setAryLblOverTimeIn(aryLblOverTimeIn);
        vo.setAryOvertimeStyle(aryOvertimeStyle);
        vo.setAryLblOverTimeOut(aryLblOverTimeOut);
        vo.setAryLblWorkOnHoliday(aryLblWorkOnHoliday);
        vo.setAryLblLateNight(aryLblLateNight);
        vo.setAryLblShortUnpaid(aryLblShortUnpaid);
        vo.setAryLblState(aryLblState);
        vo.setAryStateStyle(aryStateStyle);
        vo.setAryLinkState(aryLinkState);
        vo.setAryCheckState(aryCheckState);
        vo.setAryLblCorrection(aryLblCorrection);
        vo.setAryWorkflow(aryWorkflow);
        if (list.isEmpty()) {
            return;
        }
        AttendanceListDto dto = list.get(list.size() - 1);
        vo.setLblTotalPrivate(dto.getPrivateTimeTotalString());
        vo.setLblTotalLate(dto.getLateTimeTotalString());
        vo.setLblTotalLeaveEarly(dto.getLeaveEarlyTimeTotalString());
        vo.setLblTotalLateLeaveEarly(dto.getLateLeaveEarlyTimeTotalString());
        vo.setLblTotalOverTimeIn(dto.getOvertimeInTotalString());
        vo.setLblTotalOverTimeOut(dto.getOvertimeOutTotalString());
        vo.setLblTotalWorkOnHoliday(dto.getHolidayWorkTimeTotalString());
        vo.setLblTotalLateNight(dto.getLateNightTimeTotalString());
        vo.setLblShortUnpaidTotal(dto.getShortUnpaidTotalString());
        vo.setLblTimesLate(dto.getLateDaysString());
        vo.setLblTimesLeaveEarly(dto.getLeaveEarlyDaysString());
        vo.setLblTimesOverTimeWork(dto.getOvertimeDaysString());
        vo.setLblTimesWorkOnHoliday(dto.getHolidayWorkDaysString());
        vo.setLblTimesBirthPrescribedSubHolidayday(dto.getBirthPrescribedSubHolidayString());
        vo.setLblTimesBirthLegalSubHolidayday(dto.getBirthLegalSubHolidayString());
        vo.setLblTimesHoliday(dto.getHolidayString());
        if (dto.getBirthMidnightSubHolidayString().equals("0.0")) {
            vo.setLblTimesBirthMidnightSubHolidayday(null);
        } else {
            vo.setLblTimesBirthMidnightSubHolidayday(dto.getBirthMidnightSubHolidayString());
        }
        vo.setLblTimesSubstitute(dto.getSubstituteHolidaysString());
        vo.setLblTimesPaidHoliday(dto.getPaidHolidaysString());
        vo.setLblTimesPaidHolidayTime(dto.getPaidHolidayTimeString());
        vo.setLblTimesSpecialHoloiday(dto.getSpecialHolidaysString());
        vo.setLblTimesOtherHoloiday(dto.getOtherHolidaysString());
        vo.setLblTimesSubHoliday(dto.getSubHolidaysString());
        vo.setLblTimesAbsence(dto.getAbsenceDaysString());
        vo.setLblStartRecordTime(false);
        vo.setLblEndRecordTime(false);
    }

    protected List<AttendanceListAddonBeanInterface> getAddonBeans() throws MospException {
        ArrayList<AttendanceListAddonBeanInterface> addonBeans = new ArrayList<AttendanceListAddonBeanInterface>();
        for (String[] addon : this.getCodeArray("AttedanceListAddons", false)) {
            String addonBean = addon[0];
            if (MospUtility.isEmpty((String[])new String[]{addonBean})) continue;
            AttendanceListAddonBeanInterface bean = (AttendanceListAddonBeanInterface)this.platform().createBean(addonBean);
            addonBeans.add(bean);
        }
        return addonBeans;
    }

    protected String[] getAddonJsps() {
        ArrayList<String> addonJsps = new ArrayList<String>();
        for (String[] addon : this.getCodeArray("AttedanceListAddons", false)) {
            String addonJsp = addon[1];
            if (MospUtility.isEmpty((String[])new String[]{addonJsp})) continue;
            addonJsps.add(addonJsp);
        }
        return addonJsps.toArray(new String[addonJsps.size()]);
    }
}

